#
# TABLE STRUCTURE FOR: tb_aplikasi
#

DROP TABLE IF EXISTS `tb_aplikasi`;

CREATE TABLE `tb_aplikasi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(256) NOT NULL,
  `telp` varchar(16) NOT NULL,
  `email` varchar(256) NOT NULL,
  `alamat` text NOT NULL,
  `logo` varchar(128) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_aplikasi` (`id`, `nama`, `telp`, `email`, `alamat`, `logo`) VALUES (1, 'Bank Mini | Oscar Store', '62895371333113', 'maulanakios@gmail.com', 'Caruban', '');


#
# TABLE STRUCTURE FOR: tb_backupdb
#

DROP TABLE IF EXISTS `tb_backupdb`;

CREATE TABLE `tb_backupdb` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idUser` int(11) NOT NULL,
  `database` varchar(256) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_backupdb` (`id`, `idUser`, `database`, `terdaftar`) VALUES (1, 1, 'Oscar Store - Backup Database - 16 May 2024 12:01:20.zip', '2024-05-16 12:01:20');
INSERT INTO `tb_backupdb` (`id`, `idUser`, `database`, `terdaftar`) VALUES (2, 1, 'Oscar Store - Backup Database - 16 May 2024 12:01:31.zip', '2024-05-16 12:01:31');
INSERT INTO `tb_backupdb` (`id`, `idUser`, `database`, `terdaftar`) VALUES (3, 1, 'Oscar Store - Backup Database - 01 February 2025 08:07:14.zip', '2025-02-01 08:07:14');
INSERT INTO `tb_backupdb` (`id`, `idUser`, `database`, `terdaftar`) VALUES (4, 1, 'Oscar Store - Backup Database - 17 March 2025 21:30:08.zip', '2025-03-17 21:30:08');
INSERT INTO `tb_backupdb` (`id`, `idUser`, `database`, `terdaftar`) VALUES (5, 1, 'Oscar Store - Backup Database - 20 March 2025 03:40:35.zip', '2025-03-20 03:40:35');
INSERT INTO `tb_backupdb` (`id`, `idUser`, `database`, `terdaftar`) VALUES (6, 1, 'Oscar Store - Backup Database - 17 May 2025 18:09:11.zip', '2025-05-17 18:09:11');
INSERT INTO `tb_backupdb` (`id`, `idUser`, `database`, `terdaftar`) VALUES (7, 1, 'Oscar Store - Backup Database - 13 August 2025 17:02:21.zip', '2025-08-13 17:02:21');
INSERT INTO `tb_backupdb` (`id`, `idUser`, `database`, `terdaftar`) VALUES (8, 1, 'Oscar Store - Backup Database - 22 October 2025 11:58:01.zip', '2025-10-22 11:58:01');


#
# TABLE STRUCTURE FOR: tb_log
#

DROP TABLE IF EXISTS `tb_log`;

CREATE TABLE `tb_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idUser` int(11) NOT NULL,
  `ipAddress` varchar(32) NOT NULL,
  `device` text NOT NULL,
  `status` varchar(16) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1103 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1, 1, '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:125.0) Gecko/20100101 Firefox/125.0', 'Login', '2024-05-14 18:14:48');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (2, 1, '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:125.0) Gecko/20100101 Firefox/125.0', 'Login', '2024-05-14 21:33:12');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (3, 1, '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:125.0) Gecko/20100101 Firefox/125.0', 'Logout', '2024-05-14 21:59:56');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4, 1, '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:125.0) Gecko/20100101 Firefox/125.0', 'Login', '2024-05-14 22:00:31');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (5, 1, '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:125.0) Gecko/20100101 Firefox/125.0', 'Logout', '2024-05-14 22:11:46');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (6, 2, '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:125.0) Gecko/20100101 Firefox/125.0', 'Login', '2024-05-14 22:12:04');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (7, 2, '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:125.0) Gecko/20100101 Firefox/125.0', 'Logout', '2024-05-14 22:16:49');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (8, 1, '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:125.0) Gecko/20100101 Firefox/125.0', 'Login', '2024-05-14 22:16:57');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (9, 1, '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:125.0) Gecko/20100101 Firefox/125.0', 'Login', '2024-05-15 12:34:59');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (10, 1, '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:125.0) Gecko/20100101 Firefox/125.0', 'Login', '2024-05-15 16:41:55');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (11, 1, '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:125.0) Gecko/20100101 Firefox/125.0', 'Login', '2024-05-16 13:31:30');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (12, 1, '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:125.0) Gecko/20100101 Firefox/125.0', 'Login', '2024-05-16 20:52:12');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (13, 1, '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:126.0) Gecko/20100101 Firefox/126.0', 'Login', '2024-05-17 15:12:24');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (14, 1, '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:126.0) Gecko/20100101 Firefox/126.0', 'Login', '2024-05-18 15:18:48');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (15, 1, '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:126.0) Gecko/20100101 Firefox/126.0', 'Login', '2024-05-19 07:40:53');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (16, 1, '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:126.0) Gecko/20100101 Firefox/126.0', 'Login', '2024-05-19 16:05:01');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (17, 1, '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:126.0) Gecko/20100101 Firefox/126.0', 'Login', '2024-05-19 18:47:10');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (18, 1, '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:126.0) Gecko/20100101 Firefox/126.0', 'Login', '2024-05-20 06:58:51');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (19, 1, '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:126.0) Gecko/20100101 Firefox/126.0', 'Login', '2024-05-20 16:15:12');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (20, 1, '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:126.0) Gecko/20100101 Firefox/126.0', 'Login', '2024-05-21 05:15:56');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (21, 1, '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:126.0) Gecko/20100101 Firefox/126.0', 'Login', '2024-05-21 18:26:47');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (22, 1, '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:126.0) Gecko/20100101 Firefox/126.0', 'Login', '2024-05-22 06:27:28');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (23, 1, '36.72.215.206', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-05-22 17:00:40');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (24, 1, '114.10.22.18', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/124.0.0.0 Mobile Safari/537.36', 'Login', '2024-05-22 18:19:04');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (25, 1, '182.2.39.212', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-05-23 06:33:46');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (26, 1, '182.2.39.212', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-05-23 10:32:15');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (27, 1, '182.2.39.64', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-05-23 14:04:15');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (28, 1, '36.72.215.206', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Logout', '2024-05-23 15:45:14');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (29, 1, '36.72.215.206', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-05-23 15:45:30');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (30, 1, '36.72.215.206', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36 Edg/125.0.0.0', 'Login', '2024-05-23 18:26:02');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (31, 1, '36.72.215.206', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-05-24 05:17:36');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (32, 1, '36.72.215.206', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-05-24 16:32:23');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (33, 1, '182.2.73.147', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-05-25 06:38:41');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (34, 1, '36.72.215.206', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-05-25 18:16:21');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (35, 4, '36.72.215.206', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36 Edg/125.0.0.0', 'Login', '2024-05-25 18:53:26');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (36, 1, '36.72.215.206', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-05-26 00:17:38');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (37, 1, '182.2.68.189', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-05-26 09:01:33');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (38, 141, '36.72.215.206', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-05-26 17:01:00');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (39, 141, '36.72.215.206', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Logout', '2024-05-26 17:02:51');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (40, 1, '36.72.215.206', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-05-26 17:03:05');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (41, 1, '36.72.215.206', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Logout', '2024-05-26 17:03:52');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (42, 86, '36.72.215.206', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-05-26 17:04:28');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (43, 86, '36.72.215.206', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Logout', '2024-05-26 17:05:20');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (44, 1, '36.72.215.206', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-05-26 17:05:32');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (45, 1, '36.72.215.206', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Logout', '2024-05-26 19:34:23');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (46, 1, '36.72.215.206', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-05-26 19:41:04');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (47, 1, '182.2.37.204', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-05-27 06:18:15');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (48, 1, '182.2.37.204', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Logout', '2024-05-27 06:27:54');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (49, 1, '182.2.37.204', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-05-27 06:45:03');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (50, 1, '36.72.215.206', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36 Edg/125.0.0.0', 'Login', '2024-05-27 16:55:35');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (51, 1, '36.72.215.206', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-05-27 17:19:50');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (52, 1, '182.2.84.165', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-05-28 06:27:02');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (53, 1, '182.2.84.165', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-05-28 09:15:08');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (54, 1, '182.2.47.222', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-05-29 06:04:29');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (55, 1, '36.72.215.88', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36 Edg/125.0.0.0', 'Login', '2024-05-29 18:20:25');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (56, 1, '36.72.215.88', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36 Edg/125.0.0.0', 'Logout', '2024-05-29 19:53:11');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (57, 1, '36.72.215.88', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36 Edg/125.0.0.0', 'Login', '2024-05-29 19:53:55');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (58, 1, '182.2.37.238', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-05-30 06:44:49');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (59, 1, '182.2.69.255', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-05-31 06:15:24');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (60, 1, '182.2.69.89', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-05-31 14:21:41');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (61, 1, '36.72.215.88', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36 Edg/125.0.0.0', 'Login', '2024-05-31 16:48:39');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (62, 1, '182.2.47.72', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-01 07:26:54');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (63, 1, '182.2.47.72', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Logout', '2024-06-01 09:02:09');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (64, 156, '182.2.47.72', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-01 09:02:28');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (65, 156, '182.2.47.72', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Logout', '2024-06-01 09:05:06');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (66, 68, '182.2.47.72', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-01 09:05:33');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (67, 68, '182.2.47.72', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Logout', '2024-06-01 09:06:38');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (68, 1, '182.2.47.72', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-01 09:07:08');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (69, 1, '182.2.47.72', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Logout', '2024-06-01 09:14:59');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (70, 156, '182.2.47.72', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-01 09:15:14');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (71, 156, '182.2.47.72', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Logout', '2024-06-01 09:16:11');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (72, 1, '182.2.47.72', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-01 09:16:21');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (73, 1, '36.72.213.90', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-01 14:44:37');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (74, 1, '36.72.213.90', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36 Edg/125.0.0.0', 'Login', '2024-06-01 16:08:28');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (75, 1, '36.72.213.90', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-01 17:16:18');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (76, 1, '182.2.83.219', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-02 07:48:26');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (77, 1, '182.2.83.195', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-02 13:41:57');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (78, 1, '182.2.41.230', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-03 08:36:03');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (79, 1, '182.2.47.63', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-03 13:43:12');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (80, 1, '36.72.213.90', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-03 17:26:20');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (81, 1, '182.2.73.18', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-04 07:25:23');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (82, 1, '182.2.42.98', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-04 14:09:47');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (83, 1, '36.72.214.153', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-04 17:09:54');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (84, 1, '36.72.214.153', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-04 17:43:12');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (85, 1, '36.72.214.153', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Logout', '2024-06-04 18:14:55');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (86, 1, '36.72.214.153', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-04 18:15:10');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (87, 1, '36.72.214.153', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Logout', '2024-06-04 18:15:51');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (88, 1, '36.72.214.153', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-04 18:18:36');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (89, 1, '36.72.214.153', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-04 20:26:30');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (90, 1, '182.2.53.154', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-05 06:59:10');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (91, 1, '182.2.52.218', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-05 11:21:42');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (92, 1, '182.2.69.26', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-06 09:38:49');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (93, 1, '182.2.69.2', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-06 13:49:41');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (94, 1, '182.2.46.15', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-07 07:20:05');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (95, 1, '182.2.53.94', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-07 13:42:51');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (96, 1, '182.2.47.106', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-08 09:15:48');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (97, 1, '36.72.213.251', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-08 19:49:48');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (98, 1, '182.2.43.145', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-09 06:25:37');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (99, 1, '36.72.213.251', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36 Edg/125.0.0.0', 'Login', '2024-06-09 11:21:52');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (100, 1, '36.72.213.251', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-09 12:36:52');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (101, 1, '36.72.214.15', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-09 16:06:14');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (102, 1, '36.72.214.15', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36 Edg/125.0.0.0', 'Login', '2024-06-09 17:30:38');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (103, 1, '36.72.214.15', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-09 18:32:45');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (104, 1, '36.72.214.15', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-09 21:37:24');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (105, 1, '36.72.214.15', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-09 21:40:48');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (106, 1, '182.2.83.145', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-10 06:10:10');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (107, 1, '182.2.83.145', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-10 10:54:52');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (108, 1, '182.2.83.145', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-10 11:23:13');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (109, 1, '36.72.214.15', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:126.0) Gecko/20100101 Firefox/126.0', 'Login', '2024-06-10 15:09:18');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (110, 1, '36.72.214.15', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36 Edg/125.0.0.0', 'Login', '2024-06-10 15:15:57');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (111, 1, '182.2.44.208', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-10 21:25:32');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (112, 1, '36.72.214.15', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36 Edg/125.0.0.0', 'Login', '2024-06-11 16:11:17');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (113, 1, '36.72.214.15', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-11 19:19:39');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (114, 1, '182.2.85.58', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-12 07:26:17');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (115, 1, '182.2.85.34', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-12 14:15:07');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (116, 1, '125.160.96.37', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36 Edg/125.0.0.0', 'Login', '2024-06-12 16:35:30');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (117, 1, '125.160.96.37', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36 Edg/125.0.0.0', 'Login', '2024-06-13 15:53:23');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (118, 1, '182.2.40.148', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-14 09:18:00');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (119, 1, '125.160.96.37', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36 Edg/125.0.0.0', 'Login', '2024-06-14 15:55:23');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (120, 1, '125.160.98.129', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-06-15 15:43:59');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (121, 1, '182.2.39.207', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-16 06:03:45');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (122, 1, '125.160.102.244', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-06-16 17:27:57');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (123, 1, '125.160.110.216', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-06-18 16:39:24');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (124, 1, '125.160.110.216', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-06-19 17:09:57');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (125, 1, '182.2.50.9', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-21 08:37:54');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (126, 1, '125.160.104.81', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-06-21 12:34:34');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (127, 1, '125.160.111.190', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-06-21 16:34:17');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (128, 1, '125.160.111.190', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-06-22 18:42:13');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (129, 1, '125.160.111.190', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-06-23 16:17:57');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (130, 1, '125.160.111.190', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-06-24 13:10:39');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (131, 1, '125.160.111.190', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-06-24 16:24:24');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (132, 1, '182.2.76.115', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-25 10:33:48');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (133, 1, '158.140.169.12', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Mobile Safari/537.36', 'Login', '2024-06-25 10:48:09');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (134, 1, '36.72.212.231', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-06-25 15:52:27');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (135, 1, '36.72.212.231', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-06-26 12:43:21');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (136, 1, '36.72.212.231', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-06-26 15:25:12');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (137, 1, '36.72.212.231', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-06-27 04:02:04');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (138, 1, '36.72.212.231', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-06-27 10:52:33');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (139, 1, '182.2.74.175', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-06-27 15:29:48');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (140, 1, '36.72.214.178', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-06-28 17:26:48');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (141, 1, '36.72.214.178', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-06-29 20:00:38');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (142, 1, '36.72.214.178', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-06-30 05:05:47');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (143, 1, '36.72.214.178', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-06-30 12:45:22');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (144, 1, '36.72.214.178', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-06-30 15:40:04');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (145, 1, '36.72.212.175', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-07-01 12:33:03');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (146, 1, '36.72.212.175', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-07-01 15:37:59');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (147, 1, '36.72.212.175', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-07-01 20:43:56');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (148, 1, '36.72.212.175', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-07-02 12:24:39');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (149, 1, '125.160.110.164', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-07-02 16:29:56');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (150, 1, '125.160.110.164', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-07-03 12:20:42');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (151, 1, '125.160.110.164', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-07-03 16:01:40');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (152, 1, '125.160.110.164', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-07-04 12:11:04');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (153, 1, '125.160.110.164', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-07-04 15:08:18');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (154, 1, '125.160.110.164', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-07-05 12:35:51');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (155, 1, '125.160.110.164', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-07-05 15:09:57');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (156, 1, '125.160.110.164', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-07-05 18:32:46');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (157, 1, '125.160.110.164', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-07-06 12:41:11');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (158, 1, '125.160.111.148', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-07-06 19:21:23');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (159, 1, '125.160.105.91', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-07-08 13:35:55');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (160, 1, '125.160.106.88', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-07-09 16:05:05');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (161, 1, '125.160.106.88', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-07-10 16:34:15');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (162, 1, '182.2.45.207', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Mobile Safari/537.36', 'Login', '2024-07-11 10:57:27');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (163, 1, '125.160.106.88', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-07-11 12:45:21');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (164, 1, '125.160.106.88', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-07-11 19:32:46');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (165, 1, '125.160.106.88', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-07-12 05:36:19');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (166, 1, '36.72.212.103', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-07-12 19:27:15');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (167, 1, '36.72.212.103', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-07-13 21:13:45');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (168, 1, '36.72.212.103', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-07-13 21:13:45');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (169, 1, '36.72.212.103', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-07-14 15:20:24');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (170, 1, '36.72.215.223', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-07-15 12:14:24');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (171, 1, '36.72.215.223', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-07-15 15:43:38');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (172, 1, '36.72.215.223', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-07-16 15:57:01');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (173, 1, '36.72.215.223', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-07-17 15:22:10');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (174, 1, '36.72.215.223', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-07-18 16:53:53');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (175, 1, '36.72.215.223', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-07-19 16:30:27');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (176, 1, '36.72.215.223', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-07-20 13:06:40');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (177, 1, '36.72.215.223', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-07-20 15:42:07');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (178, 1, '36.72.216.236', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-07-21 13:35:17');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (179, 1, '36.72.216.236', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-07-22 12:28:31');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (180, 1, '36.72.216.236', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-07-22 15:16:35');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (181, 1, '36.72.216.236', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-07-22 18:50:34');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (182, 1, '182.2.77.199', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Mobile Safari/537.36', 'Login', '2024-07-23 11:32:50');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (183, 1, '36.72.216.236', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-07-23 15:14:52');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (184, 1, '36.72.216.236', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-07-24 16:04:45');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (185, 1, '125.160.97.90', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-07-25 15:55:43');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (186, 1, '36.72.213.10', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-07-26 15:05:29');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (187, 1, '36.72.213.10', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36 Edg/126.0.0.0', 'Login', '2024-07-27 16:48:31');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (188, 1, '36.72.213.10', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36 Edg/127.0.0.0', 'Login', '2024-07-28 17:12:55');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (189, 1, '36.72.213.10', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36 Edg/127.0.0.0', 'Login', '2024-07-29 12:42:46');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (190, 1, '36.72.213.10', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36 Edg/127.0.0.0', 'Login', '2024-07-29 16:07:42');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (191, 1, '36.72.213.10', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36 Edg/127.0.0.0', 'Login', '2024-07-30 11:26:28');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (192, 1, '36.72.213.10', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36 Edg/127.0.0.0', 'Login', '2024-07-30 15:07:50');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (193, 1, '36.72.213.10', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36 Edg/127.0.0.0', 'Login', '2024-07-31 15:13:59');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (194, 1, '36.72.212.234', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36 Edg/127.0.0.0', 'Login', '2024-08-01 15:39:11');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (195, 1, '36.72.212.234', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36 Edg/127.0.0.0', 'Login', '2024-08-02 16:07:29');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (196, 1, '36.72.212.234', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36 Edg/127.0.0.0', 'Login', '2024-08-03 12:32:45');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (197, 1, '36.72.212.234', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36 Edg/127.0.0.0', 'Login', '2024-08-03 14:57:10');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (198, 1, '182.2.82.32', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36 Edg/127.0.0.0', 'Login', '2024-08-04 12:45:09');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (199, 1, '36.72.212.234', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36 Edg/127.0.0.0', 'Login', '2024-08-04 15:34:48');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (200, 1, '36.72.212.234', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36 Edg/127.0.0.0', 'Login', '2024-08-05 15:23:39');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (201, 1, '36.72.212.234', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36 Edg/127.0.0.0', 'Login', '2024-08-06 16:28:01');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (202, 1, '125.160.106.105', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36 Edg/127.0.0.0', 'Login', '2024-08-07 15:52:49');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (203, 1, '125.160.106.105', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36 Edg/127.0.0.0', 'Login', '2024-08-08 14:51:34');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (204, 1, '36.72.214.11', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36 Edg/127.0.0.0', 'Login', '2024-08-09 16:26:53');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (205, 1, '36.72.214.11', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36 Edg/127.0.0.0', 'Login', '2024-08-10 16:13:10');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (206, 1, '36.72.214.11', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36 Edg/127.0.0.0', 'Login', '2024-08-11 15:38:55');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (207, 1, '36.72.214.11', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36 Edg/127.0.0.0', 'Login', '2024-08-12 16:00:34');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (208, 1, '125.160.104.43', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36 Edg/127.0.0.0', 'Login', '2024-08-13 16:50:55');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (209, 1, '125.160.104.43', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36 Edg/127.0.0.0', 'Login', '2024-08-14 15:20:26');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (210, 1, '125.160.104.43', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36 Edg/127.0.0.0', 'Login', '2024-08-15 12:43:30');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (211, 1, '125.160.104.43', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36 Edg/127.0.0.0', 'Login', '2024-08-15 14:50:10');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (212, 1, '125.160.104.43', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36 Edg/127.0.0.0', 'Login', '2024-08-16 14:31:40');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (213, 1, '125.160.104.43', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36 Edg/127.0.0.0', 'Login', '2024-08-17 16:04:22');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (214, 1, '125.160.104.43', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36 Edg/127.0.0.0', 'Login', '2024-08-17 18:45:44');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (215, 1, '125.160.104.43', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36 Edg/127.0.0.0', 'Login', '2024-08-18 16:43:14');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (216, 1, '125.160.104.43', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36 Edg/127.0.0.0', 'Login', '2024-08-19 16:22:06');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (217, 1, '125.160.104.43', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36 Edg/127.0.0.0', 'Login', '2024-08-19 18:43:18');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (218, 1, '125.160.99.150', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36 Edg/127.0.0.0', 'Login', '2024-08-20 15:44:18');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (219, 1, '125.160.106.43', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36 Edg/127.0.0.0', 'Login', '2024-08-21 12:51:21');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (220, 1, '125.160.106.43', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36 Edg/127.0.0.0', 'Login', '2024-08-21 15:03:27');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (221, 1, '125.160.106.43', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36 Edg/127.0.0.0', 'Login', '2024-08-22 19:19:06');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (222, 1, '125.160.106.43', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36 Edg/127.0.0.0', 'Login', '2024-08-23 16:07:37');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (223, 1, '125.160.106.43', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36 Edg/127.0.0.0', 'Login', '2024-08-24 15:59:04');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (224, 1, '125.160.106.43', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 Edg/128.0.0.0', 'Login', '2024-08-25 15:45:39');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (225, 1, '125.160.106.43', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 Edg/128.0.0.0', 'Login', '2024-08-26 15:49:47');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (226, 1, '36.72.212.130', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 Edg/128.0.0.0', 'Login', '2024-08-27 16:17:26');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (227, 1, '36.72.212.130', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 Edg/128.0.0.0', 'Login', '2024-08-28 16:29:35');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (228, 1, '36.72.212.130', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 Edg/128.0.0.0', 'Login', '2024-08-29 16:00:27');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (229, 1, '36.72.213.206', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 Edg/128.0.0.0', 'Login', '2024-08-30 16:20:11');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (230, 1, '36.72.213.206', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 Edg/128.0.0.0', 'Login', '2024-08-31 16:39:14');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (231, 1, '36.72.215.42', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 Edg/128.0.0.0', 'Login', '2024-09-01 17:36:46');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (232, 1, '36.72.215.36', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 Edg/128.0.0.0', 'Login', '2024-09-02 15:48:12');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (233, 1, '36.72.215.36', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 Edg/128.0.0.0', 'Login', '2024-09-03 15:45:16');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (234, 1, '36.72.215.36', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 Edg/128.0.0.0', 'Login', '2024-09-04 15:57:18');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (235, 1, '36.72.215.36', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 Edg/128.0.0.0', 'Login', '2024-09-04 18:31:23');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (236, 1, '36.72.215.36', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 Edg/128.0.0.0', 'Login', '2024-09-05 16:02:47');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (237, 1, '36.72.215.36', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 Edg/128.0.0.0', 'Login', '2024-09-06 19:24:50');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (238, 1, '36.72.215.36', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 Edg/128.0.0.0', 'Login', '2024-09-07 17:26:54');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (239, 1, '36.72.215.36', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 Edg/128.0.0.0', 'Login', '2024-09-08 17:04:40');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (240, 1, '125.160.102.39', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 Edg/128.0.0.0', 'Login', '2024-09-09 16:06:11');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (241, 1, '125.160.102.39', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 Edg/128.0.0.0', 'Login', '2024-09-10 17:09:38');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (242, 1, '125.160.102.39', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 Edg/128.0.0.0', 'Login', '2024-09-11 15:59:59');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (243, 1, '125.160.102.39', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 Edg/128.0.0.0', 'Login', '2024-09-12 10:27:16');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (244, 1, '125.160.102.39', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 Edg/128.0.0.0', 'Login', '2024-09-12 12:44:53');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (245, 1, '125.160.104.61', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 Edg/128.0.0.0', 'Login', '2024-09-12 15:42:30');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (246, 1, '125.160.110.58', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 Edg/128.0.0.0', 'Login', '2024-09-13 15:10:26');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (247, 1, '125.160.110.58', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 Edg/128.0.0.0', 'Login', '2024-09-14 16:10:28');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (248, 1, '182.2.40.238', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Mobile Safari/537.36', 'Login', '2024-09-15 08:26:59');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (249, 1, '182.2.41.247', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Mobile Safari/537.36', 'Login', '2024-09-15 13:35:51');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (250, 1, '125.160.110.58', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Mobile Safari/537.36', 'Login', '2024-09-15 18:27:59');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (251, 1, '182.2.52.16', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Mobile Safari/537.36', 'Login', '2024-09-16 06:51:48');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (252, 1, '182.2.69.200', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Mobile Safari/537.36', 'Login', '2024-09-17 05:52:13');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (253, 1, '182.2.69.212', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Mobile Safari/537.36', 'Login', '2024-09-17 11:24:39');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (254, 1, '36.72.214.157', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Mobile Safari/537.36', 'Login', '2024-09-17 16:32:01');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (255, 1, '182.2.41.132', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Mobile Safari/537.36', 'Login', '2024-09-18 07:00:15');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (256, 1, '182.2.50.152', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Mobile Safari/537.36', 'Login', '2024-09-18 12:01:10');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (257, 1, '36.72.214.157', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 Edg/128.0.0.0', 'Login', '2024-09-18 16:12:03');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (258, 1, '36.72.214.157', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Mobile Safari/537.36', 'Login', '2024-09-18 17:30:33');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (259, 1, '36.72.214.157', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Mobile Safari/537.36', 'Login', '2024-09-18 23:05:04');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (260, 1, '182.2.41.103', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Mobile Safari/537.36', 'Login', '2024-09-19 07:08:37');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (261, 1, '182.2.41.103', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Mobile Safari/537.36', 'Login', '2024-09-19 10:55:04');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (262, 1, '36.72.214.157', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Mobile Safari/537.36', 'Login', '2024-09-19 16:13:54');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (263, 1, '36.72.214.157', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Mobile Safari/537.36', 'Login', '2024-09-19 16:13:54');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (264, 1, '182.2.42.231', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Mobile Safari/537.36', 'Login', '2024-09-20 06:46:56');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (265, 1, '182.2.45.22', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Mobile Safari/537.36', 'Login', '2024-09-20 13:07:11');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (266, 1, '36.72.214.157', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 Edg/128.0.0.0', 'Login', '2024-09-20 17:25:10');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (267, 1, '182.2.45.26', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Mobile Safari/537.36', 'Login', '2024-09-21 06:40:58');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (268, 1, '182.2.45.26', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Mobile Safari/537.36', 'Login', '2024-09-21 13:57:28');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (269, 1, '36.72.214.157', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36 Edg/128.0.0.0', 'Login', '2024-09-21 21:28:43');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (270, 1, '182.2.51.196', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Mobile Safari/537.36', 'Login', '2024-09-22 07:16:33');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (271, 1, '36.72.213.132', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36 Edg/129.0.0.0', 'Login', '2024-09-22 17:11:13');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (272, 1, '182.2.36.188', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Mobile Safari/537.36', 'Login', '2024-09-23 05:52:58');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (273, 1, '182.2.36.188', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Mobile Safari/537.36', 'Login', '2024-09-23 11:34:11');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (274, 1, '182.2.36.164', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Mobile Safari/537.36', 'Login', '2024-09-23 14:15:41');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (275, 1, '36.72.213.132', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36 Edg/129.0.0.0', 'Login', '2024-09-23 16:21:54');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (276, 1, '182.2.72.20', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Mobile Safari/537.36', 'Login', '2024-09-24 07:14:30');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (277, 1, '182.2.72.8', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Mobile Safari/537.36', 'Login', '2024-09-24 11:11:31');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (278, 1, '36.72.213.132', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36 Edg/129.0.0.0', 'Login', '2024-09-24 15:49:48');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (279, 1, '182.2.83.71', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Mobile Safari/537.36', 'Login', '2024-09-25 08:05:30');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (280, 1, '182.2.83.71', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Mobile Safari/537.36', 'Login', '2024-09-25 10:47:20');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (281, 1, '182.2.68.133', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Mobile Safari/537.36', 'Login', '2024-09-25 13:50:39');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (282, 1, '36.72.216.136', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36 Edg/129.0.0.0', 'Login', '2024-09-26 04:59:17');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (283, 1, '182.2.85.153', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Mobile Safari/537.36', 'Login', '2024-09-26 06:58:32');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (284, 1, '182.2.85.153', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Mobile Safari/537.36', 'Login', '2024-09-26 09:32:45');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (285, 1, '182.2.50.85', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Mobile Safari/537.36', 'Login', '2024-09-27 05:49:06');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (286, 1, '182.2.69.152', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-09-27 13:49:32');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (287, 1, '182.2.36.20', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-09-28 06:17:25');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (288, 1, '182.2.44.72', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-09-28 13:22:28');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (289, 1, '125.160.103.242', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-09-28 23:16:14');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (290, 1, '182.2.83.23', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-09-29 06:58:52');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (291, 1, '125.160.103.242', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36 Edg/129.0.0.0', 'Login', '2024-09-29 18:20:03');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (292, 1, '182.2.39.127', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-09-30 07:17:41');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (293, 1, '182.2.45.5', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-09-30 13:47:53');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (294, 1, '182.2.39.84', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-01 05:51:20');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (295, 1, '182.2.39.72', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-01 11:14:06');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (296, 1, '182.2.38.76', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-01 14:03:32');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (297, 1, '182.2.46.44', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-02 07:41:49');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (298, 1, '182.2.46.44', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-02 07:41:51');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (299, 1, '125.160.101.119', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36 Edg/129.0.0.0', 'Login', '2024-10-02 19:22:52');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (300, 1, '182.2.45.172', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-03 06:25:26');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (301, 1, '125.160.101.119', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36 Edg/129.0.0.0', 'Login', '2024-10-03 16:15:39');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (302, 1, '182.2.79.112', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-04 06:46:24');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (303, 1, '182.2.78.176', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-04 13:39:45');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (304, 1, '182.2.78.176', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-04 13:39:45');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (305, 1, '125.160.101.119', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36 Edg/129.0.0.0', 'Login', '2024-10-04 22:41:11');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (306, 1, '125.160.101.119', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36 Edg/129.0.0.0', 'Login', '2024-10-04 22:41:11');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (307, 1, '125.160.101.119', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36 Edg/129.0.0.0', 'Login', '2024-10-05 04:54:13');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (308, 1, '182.2.82.116', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-05 06:34:57');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (309, 1, '182.2.82.116', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-05 10:41:45');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (310, 1, '125.160.101.119', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36 Edg/129.0.0.0', 'Login', '2024-10-05 16:26:04');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (311, 1, '182.2.69.250', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-06 07:08:36');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (312, 1, '182.2.84.22', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-06 10:07:30');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (313, 1, '125.160.107.56', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36 Edg/129.0.0.0', 'Login', '2024-10-06 17:04:08');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (314, 1, '182.2.68.55', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-07 06:27:05');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (315, 1, '182.2.69.59', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-07 10:20:20');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (316, 1, '36.72.212.202', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36 Edg/129.0.0.0', 'Login', '2024-10-07 16:15:43');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (317, 1, '36.72.212.202', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-07 16:39:06');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (318, 1, '182.2.42.74', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-08 06:31:45');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (319, 1, '182.2.36.2', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-08 14:23:06');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (320, 1, '125.160.111.89', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-08 17:43:15');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (321, 1, '182.2.68.153', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-09 08:18:32');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (322, 1, '182.2.85.137', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-09 10:56:38');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (323, 1, '182.2.79.128', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-10 06:03:42');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (324, 1, '125.160.104.121', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36 Edg/129.0.0.0', 'Login', '2024-10-10 16:00:42');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (325, 1, '125.160.104.121', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-10 17:29:10');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (326, 1, '182.2.43.42', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-11 07:52:49');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (327, 1, '125.160.104.121', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-11 15:05:50');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (328, 1, '125.160.104.121', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36 Edg/129.0.0.0', 'Login', '2024-10-11 16:30:39');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (329, 1, '182.2.52.94', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-12 06:15:33');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (330, 1, '182.2.52.94', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-12 08:43:39');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (331, 1, '182.2.53.138', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-12 13:24:53');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (332, 1, '182.2.82.71', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-13 05:44:51');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (333, 1, '36.72.214.83', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36 Edg/129.0.0.0', 'Login', '2024-10-13 17:00:01');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (334, 1, '182.2.46.125', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-14 06:34:57');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (335, 1, '182.2.46.125', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-14 09:34:33');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (336, 1, '182.2.71.105', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-15 08:00:40');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (337, 1, '36.72.213.192', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36 Edg/129.0.0.0', 'Login', '2024-10-15 15:57:34');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (338, 1, '36.72.213.192', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36 Edg/129.0.0.0', 'Login', '2024-10-15 18:44:20');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (339, 1, '36.72.213.192', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-15 20:01:17');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (340, 1, '182.2.42.45', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-16 06:56:09');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (341, 1, '182.2.45.225', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-16 13:15:15');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (342, 1, '36.72.213.192', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36 Edg/129.0.0.0', 'Login', '2024-10-16 16:21:18');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (343, 1, '182.2.38.254', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-17 06:58:19');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (344, 1, '182.2.45.71', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-18 07:16:12');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (345, 1, '182.2.45.71', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-18 10:47:37');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (346, 1, '182.2.75.50', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-18 13:40:06');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (347, 1, '36.72.213.192', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36 Edg/129.0.0.0', 'Login', '2024-10-18 15:56:36');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (348, 1, '182.2.50.179', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-19 06:34:07');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (349, 1, '125.160.110.34', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 Edg/130.0.0.0', 'Login', '2024-10-20 03:58:22');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (350, 1, '182.2.40.232', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-20 06:11:00');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (351, 1, '182.2.40.232', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-20 10:56:34');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (352, 1, '182.2.46.179', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-21 06:05:11');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (353, 1, '182.2.46.179', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-21 08:23:34');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (354, 1, '182.2.69.59', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-21 13:57:01');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (355, 1, '125.160.110.34', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 Edg/130.0.0.0', 'Login', '2024-10-21 16:11:40');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (356, 1, '182.2.82.231', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-22 08:06:42');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (357, 1, '182.2.71.75', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-22 13:23:21');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (358, 1, '125.160.110.139', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 Edg/130.0.0.0', 'Login', '2024-10-23 04:44:59');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (359, 1, '182.2.71.250', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-23 07:10:03');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (360, 1, '125.160.110.139', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 Edg/130.0.0.0', 'Login', '2024-10-23 16:45:53');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (361, 1, '182.2.74.214', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-24 06:18:58');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (362, 1, '182.2.53.56', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-24 13:53:20');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (363, 1, '182.2.38.83', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-25 06:44:13');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (364, 1, '182.2.38.83', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-25 10:40:23');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (365, 1, '182.2.69.43', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-25 13:47:20');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (366, 1, '125.160.107.23', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 Edg/130.0.0.0', 'Login', '2024-10-25 16:16:18');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (367, 1, '182.2.44.168', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-26 06:50:56');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (368, 1, '182.2.52.95', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-27 07:06:59');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (369, 1, '182.2.76.186', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-28 06:05:14');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (370, 1, '182.2.76.186', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-28 09:36:36');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (371, 1, '182.2.75.166', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-28 13:06:49');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (372, 1, '36.72.216.165', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 Edg/130.0.0.0', 'Login', '2024-10-28 16:16:50');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (373, 1, '182.2.47.189', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-29 08:05:49');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (374, 1, '182.2.38.137', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-29 14:27:14');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (375, 1, '36.72.212.113', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-29 19:03:55');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (376, 1, '182.2.37.50', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-30 06:54:00');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (377, 1, '182.2.45.10', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-30 11:37:25');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (378, 1, '36.72.212.113', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 Edg/130.0.0.0', 'Login', '2024-10-30 15:38:16');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (379, 1, '182.2.78.125', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-31 07:53:15');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (380, 1, '182.2.78.125', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-31 10:08:24');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (381, 1, '36.72.212.113', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 Edg/130.0.0.0', 'Login', '2024-10-31 16:51:44');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (382, 1, '36.72.212.113', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-10-31 17:41:26');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (383, 1, '182.2.51.219', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-01 06:26:21');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (384, 1, '36.72.215.110', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 Edg/130.0.0.0', 'Login', '2024-11-01 15:44:37');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (385, 1, '36.72.215.110', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-01 16:06:54');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (386, 1, '182.2.78.48', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-02 08:38:43');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (387, 1, '182.2.78.104', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-02 13:08:21');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (388, 1, '125.160.103.51', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 Edg/130.0.0.0', 'Login', '2024-11-02 18:35:21');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (389, 1, '182.2.46.116', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-03 07:04:11');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (390, 1, '182.2.39.96', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-03 13:25:50');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (391, 1, '182.2.39.108', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-04 09:01:59');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (392, 1, '182.2.46.104', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-04 14:01:42');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (393, 1, '182.2.39.244', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-05 05:54:40');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (394, 1, '182.2.39.244', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-05 10:19:45');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (395, 1, '36.72.214.10', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36 Edg/130.0.0.0', 'Login', '2024-11-06 04:48:33');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (396, 1, '182.2.46.2', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-06 07:10:10');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (397, 1, '182.2.69.19', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-06 13:12:48');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (398, 1, '182.2.72.188', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-07 06:05:44');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (399, 1, '182.2.72.188', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-07 06:37:04');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (400, 1, '182.2.72.188', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-07 06:48:44');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (401, 1, '36.72.214.10', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-07 16:40:08');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (402, 1, '182.2.39.239', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-08 07:06:40');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (403, 1, '182.2.39.251', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-08 10:16:46');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (404, 1, '182.2.43.134', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-08 13:48:31');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (405, 1, '125.160.103.66', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-08 17:15:02');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (406, 1, '182.2.41.204', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-09 07:03:26');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (407, 1, '182.2.82.52', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-10 07:50:48');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (408, 1, '182.2.77.35', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-11 08:19:14');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (409, 1, '182.2.77.35', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-11 10:48:12');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (410, 1, '36.72.217.33', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-11 16:12:12');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (411, 1, '182.2.53.69', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-12 05:57:48');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (412, 1, '182.2.85.154', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-13 07:12:33');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (413, 1, '182.2.42.106', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-13 14:18:36');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (414, 1, '182.2.53.62', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-14 06:07:01');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (415, 1, '182.2.53.62', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-14 09:09:49');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (416, 1, '182.2.53.50', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-14 12:55:58');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (417, 1, '182.2.39.96', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-14 17:20:43');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (418, 1, '182.2.53.181', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-15 07:13:37');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (419, 1, '182.2.36.99', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-16 06:24:14');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (420, 1, '182.2.36.99', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-16 10:32:01');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (421, 1, '182.2.70.150', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-17 06:35:01');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (422, 1, '182.2.70.150', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-17 10:20:12');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (423, 1, '125.160.96.97', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-17 19:06:32');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (424, 1, '182.2.51.182', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-18 06:17:40');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (425, 1, '36.72.215.73', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-18 18:55:55');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (426, 1, '182.2.78.37', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-19 05:56:27');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (427, 1, '36.72.216.132', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-19 19:00:54');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (428, 1, '182.2.38.160', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-20 07:26:40');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (429, 1, '125.160.103.219', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-20 14:06:46');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (430, 1, '182.2.38.30', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-21 06:14:36');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (431, 1, '36.72.215.9', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-21 13:12:54');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (432, 1, '182.2.36.180', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-22 06:20:25');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (433, 1, '36.72.215.9', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-22 10:10:03');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (434, 1, '182.2.52.188', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-23 06:06:09');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (435, 1, '182.2.51.86', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-24 06:16:07');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (436, 1, '182.2.40.66', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-24 10:25:01');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (437, 1, '182.2.71.15', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-25 06:31:57');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (438, 1, '182.2.44.41', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-25 14:23:09');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (439, 1, '36.72.214.16', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-25 18:46:45');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (440, 1, '182.2.44.160', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-26 06:18:15');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (441, 1, '182.2.44.160', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-26 14:50:17');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (442, 1, '182.2.44.160', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-26 14:50:17');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (443, 1, '182.2.44.143', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-27 06:14:13');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (444, 1, '36.72.214.16', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-27 17:32:20');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (445, 1, '182.2.39.119', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-28 08:30:39');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (446, 1, '182.2.85.93', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-29 06:32:38');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (447, 1, '182.2.85.157', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-29 13:21:19');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (448, 1, '182.2.41.141', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-30 05:46:15');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (449, 1, '182.2.41.113', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-30 09:22:33');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (450, 1, '36.72.214.16', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-11-30 15:04:00');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (451, 1, '182.2.52.74', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-01 06:00:42');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (452, 1, '182.2.52.74', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-01 09:26:00');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (453, 1, '125.160.109.20', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-01 17:33:08');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (454, 1, '125.160.109.20', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-02 04:53:21');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (455, 1, '182.2.53.125', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-02 08:48:24');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (456, 1, '182.2.46.69', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-02 13:32:56');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (457, 1, '182.2.71.236', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-03 07:51:23');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (458, 1, '182.2.75.162', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-03 10:40:25');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (459, 1, '182.2.77.10', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-03 13:45:36');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (460, 1, '182.2.72.200', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-04 08:25:43');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (461, 1, '182.2.39.45', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-04 13:48:58');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (462, 1, '36.72.216.217', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-04 17:01:45');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (463, 1, '182.2.53.57', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-05 07:09:37');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (464, 1, '182.2.40.144', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-06 06:24:52');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (465, 1, '182.2.84.143', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-06 13:39:16');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (466, 1, '182.2.83.47', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-07 06:53:44');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (467, 1, '36.72.216.217', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-07 15:29:12');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (468, 1, '182.2.37.193', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-08 07:08:30');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (469, 1, '182.2.37.193', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-08 11:03:03');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (470, 1, '182.2.38.126', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-09 05:43:33');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (471, 1, '182.2.37.189', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-09 13:28:30');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (472, 1, '182.2.82.162', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-10 06:37:11');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (473, 1, '182.2.82.162', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-10 08:50:24');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (474, 1, '182.2.74.159', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-11 07:07:00');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (475, 1, '182.2.39.227', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-12 07:11:17');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (476, 1, '182.2.84.191', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-12 11:24:36');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (477, 1, '182.2.71.178', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-13 06:59:00');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (478, 1, '182.2.42.193', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-13 13:13:34');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (479, 1, '182.2.40.133', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-14 05:55:37');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (480, 1, '182.2.40.133', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-14 09:07:57');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (481, 1, '182.2.50.57', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-14 11:10:39');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (482, 1, '182.2.42.95', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-15 10:32:00');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (483, 1, '125.160.97.127', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-15 16:49:47');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (484, 1, '125.160.97.127', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Edg/131.0.0.0', 'Login', '2024-12-15 16:50:38');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (485, 1, '182.2.82.226', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-16 07:56:15');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (486, 1, '125.160.97.127', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Edg/131.0.0.0', 'Login', '2024-12-16 15:59:02');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (487, 1, '182.2.70.249', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-17 07:13:48');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (488, 1, '182.2.70.249', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-17 09:45:30');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (489, 1, '182.2.40.135', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-17 14:15:52');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (490, 1, '182.4.102.178', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-17 21:02:04');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (491, 1, '182.2.85.221', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-18 08:40:06');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (492, 1, '182.2.72.191', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-19 07:10:40');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (493, 1, '182.2.71.57', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-20 07:46:57');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (494, 1, '182.2.73.209', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-21 05:43:47');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (495, 1, '182.2.36.229', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-22 06:11:06');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (496, 1, '182.2.36.229', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-22 11:07:52');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (497, 1, '36.72.213.107', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Edg/131.0.0.0', 'Login', '2024-12-22 17:23:04');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (498, 1, '182.2.70.119', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-23 07:07:06');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (499, 1, '36.72.213.107', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Edg/131.0.0.0', 'Login', '2024-12-23 10:47:08');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (500, 1, '182.2.36.119', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-23 14:08:25');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (501, 1, '182.2.41.192', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-24 06:37:12');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (502, 1, '182.2.41.192', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-24 10:42:16');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (503, 1, '182.2.38.89', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-25 06:20:32');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (504, 1, '182.2.38.213', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-25 09:50:56');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (505, 1, '182.2.73.236', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-26 06:26:16');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (506, 1, '182.2.73.236', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-26 08:55:12');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (507, 1, '182.2.37.165', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-26 14:51:58');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (508, 1, '36.72.212.129', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36 Edg/131.0.0.0', 'Login', '2024-12-26 18:43:47');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (509, 1, '182.2.42.71', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-27 05:57:45');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (510, 1, '36.72.212.129', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-27 14:56:35');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (511, 1, '36.72.212.129', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-27 20:12:02');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (512, 1, '182.2.51.116', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-28 06:26:02');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (513, 1, '36.72.212.129', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-29 05:03:23');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (514, 1, '182.2.79.245', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-29 09:36:09');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (515, 234, '182.2.78.183', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-29 14:55:59');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (516, 234, '182.2.78.183', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Logout', '2024-12-29 15:13:02');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (517, 1, '182.2.78.183', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-29 15:13:15');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (518, 1, '182.2.37.48', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-30 06:38:46');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (519, 1, '182.2.37.48', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-30 09:53:19');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (520, 1, '36.72.212.129', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-30 19:11:32');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (521, 1, '182.2.72.162', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-31 06:30:26');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (522, 1, '182.2.72.162', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2024-12-31 09:50:48');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (523, 1, '182.2.79.83', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-01 06:03:46');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (524, 1, '182.2.79.83', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-01 10:17:40');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (525, 1, '125.160.105.209', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-01 18:26:17');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (526, 1, '182.2.45.86', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-02 07:01:27');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (527, 1, '182.2.45.166', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-02 10:14:17');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (528, 1, '182.2.73.36', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-03 06:10:29');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (529, 1, '125.160.105.209', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-03 20:16:17');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (530, 1, '182.2.47.158', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-04 09:59:19');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (531, 1, '182.2.83.22', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-05 07:13:44');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (532, 1, '125.160.105.209', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-05 17:16:06');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (533, 1, '182.2.44.156', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-06 07:01:54');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (534, 1, '125.160.105.209', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-06 13:25:28');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (535, 1, '182.2.79.135', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-07 06:03:29');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (536, 1, '36.72.212.177', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-07 14:44:29');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (537, 1, '36.72.212.177', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-07 19:43:26');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (538, 1, '182.2.72.68', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-08 07:23:43');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (539, 1, '182.2.44.93', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-08 14:12:36');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (540, 1, '182.2.51.248', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-09 06:33:28');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (541, 1, '182.2.73.59', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-09 14:41:32');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (542, 1, '182.2.69.249', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-10 06:35:57');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (543, 1, '36.72.212.177', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-10 12:55:46');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (544, 1, '182.2.70.30', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-11 06:17:55');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (545, 1, '36.72.212.177', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-11 15:31:19');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (546, 1, '36.72.212.177', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-11 17:47:28');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (547, 1, '182.2.44.36', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-12 07:26:28');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (548, 1, '182.2.53.252', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-14 07:48:23');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (549, 1, '125.160.102.13', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-14 18:18:22');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (550, 1, '182.2.69.206', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-15 08:43:12');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (551, 1, '36.72.213.45', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-15 14:25:13');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (552, 1, '182.2.36.123', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-16 07:57:03');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (553, 1, '36.72.213.45', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-16 14:25:24');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (554, 1, '36.72.213.45', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-16 14:25:26');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (555, 1, '36.72.213.45', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-16 18:32:51');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (556, 1, '182.2.41.9', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-17 06:33:09');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (557, 1, '125.160.110.92', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-17 17:17:01');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (558, 1, '182.2.85.191', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-18 08:46:07');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (559, 1, '182.2.45.160', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-19 07:36:51');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (560, 1, '182.2.45.92', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-19 11:18:33');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (561, 1, '125.160.110.92', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-19 15:32:46');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (562, 1, '182.2.39.237', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-20 08:08:11');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (563, 1, '182.2.47.193', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-20 13:49:20');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (564, 1, '182.2.78.0', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-21 07:25:12');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (565, 1, '36.72.213.30', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-21 17:07:05');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (566, 1, '182.2.44.172', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-22 07:28:39');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (567, 1, '36.72.213.30', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-23 05:02:18');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (568, 1, '182.2.71.1', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-23 08:30:43');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (569, 1, '182.2.44.170', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-24 06:58:09');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (570, 1, '182.2.85.102', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-25 06:39:01');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (571, 1, '36.72.213.30', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-25 16:57:55');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (572, 1, '182.2.41.95', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-26 06:38:59');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (573, 1, '36.72.213.30', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-26 17:41:57');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (574, 1, '182.2.38.226', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-27 06:45:00');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (575, 1, '182.2.39.115', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-27 13:51:56');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (576, 1, '125.160.96.79', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Safari/537.36 Edg/132.0.0.0', 'Login', '2025-01-27 16:37:02');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (577, 1, '182.2.40.140', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-28 06:08:58');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (578, 1, '182.2.73.251', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-29 07:58:04');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (579, 1, '125.160.96.79', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-29 16:54:26');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (580, 1, '182.2.47.218', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-30 07:24:21');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (581, 1, '182.2.83.112', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-31 06:17:13');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (582, 1, '182.2.50.236', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Login', '2025-01-31 13:28:32');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (583, 1, '182.2.42.83', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-01 06:52:33');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (584, 1, '182.2.42.83', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Logout', '2025-02-01 07:51:10');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (585, 1, '182.2.42.83', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-01 07:51:49');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (586, 1, '110.138.243.109', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Safari/537.36 Edg/132.0.0.0', 'Login', '2025-02-01 07:53:37');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (587, 1, '110.138.243.109', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Safari/537.36 Edg/132.0.0.0', 'Login', '2025-02-01 14:40:15');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (588, 1, '182.2.52.157', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-01 14:58:35');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (589, 1, '182.2.37.86', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-02 06:45:43');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (590, 1, '182.2.45.182', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-02 11:48:49');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (591, 1, '182.2.47.2', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-02 16:29:42');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (592, 1, '182.2.84.123', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-03 06:32:26');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (593, 1, '182.2.84.123', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Logout', '2025-02-03 06:37:42');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (594, 1, '182.2.84.123', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Logout', '2025-02-03 06:37:42');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (595, 1, '182.2.84.123', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-03 06:45:55');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (596, 1, '182.2.36.125', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-03 14:08:44');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (597, 1, '182.2.84.163', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-04 09:41:39');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (598, 1, '182.2.69.191', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-05 06:31:48');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (599, 1, '182.2.69.167', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-05 08:49:20');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (600, 1, '182.2.78.77', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-06 07:10:02');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (601, 1, '36.72.214.81', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-06 15:08:50');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (602, 1, '36.72.214.81', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-07 05:21:37');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (603, 1, '182.2.38.192', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-07 13:47:18');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (604, 1, '182.2.47.199', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-08 08:18:51');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (605, 1, '182.2.71.171', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-09 06:10:51');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (606, 1, '36.72.215.229', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-09 19:00:47');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (607, 1, '182.2.37.146', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-10 07:21:48');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (608, 1, '182.2.37.146', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-10 10:10:11');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (609, 1, '36.72.213.169', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-10 17:17:02');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (610, 1, '182.2.50.8', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-11 08:34:58');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (611, 1, '182.2.73.206', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-12 06:46:45');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (612, 1, '182.2.73.206', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-12 11:11:45');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (613, 1, '182.2.39.151', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-13 06:03:06');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (614, 1, '182.2.47.103', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-13 13:38:46');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (615, 1, '182.2.53.60', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-14 07:00:50');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (616, 1, '182.2.36.110', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-14 13:44:48');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (617, 1, '36.72.213.22', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-14 16:38:37');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (618, 1, '182.2.79.36', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-15 06:52:26');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (619, 1, '182.2.79.251', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-15 14:25:13');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (620, 1, '182.2.45.32', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-16 06:56:37');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (621, 1, '182.2.85.147', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-16 14:01:05');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (622, 1, '182.2.52.93', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-17 06:39:55');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (623, 1, '36.72.212.156', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-17 17:13:41');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (624, 1, '182.2.43.67', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-18 07:38:59');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (625, 1, '182.2.82.241', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-19 07:19:51');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (626, 1, '182.2.82.241', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-19 09:26:35');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (627, 1, '36.72.212.198', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-19 17:46:13');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (628, 1, '182.2.53.43', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-20 07:26:40');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (629, 1, '36.72.212.198', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-20 17:41:31');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (630, 1, '182.2.69.194', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-21 07:43:36');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (631, 1, '125.160.97.172', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-21 15:05:14');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (632, 1, '182.2.50.0', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-22 11:04:16');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (633, 1, '125.160.97.172', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-22 16:21:21');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (634, 1, '182.2.39.235', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-23 07:19:38');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (635, 1, '125.160.97.172', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-23 15:26:00');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (636, 1, '125.160.97.172', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-23 19:03:20');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (637, 1, '182.2.39.96', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-24 07:03:25');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (638, 1, '182.2.72.58', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-25 07:25:41');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (639, 1, '182.2.45.159', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-25 14:10:34');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (640, 1, '182.2.73.139', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-25 22:09:12');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (641, 1, '182.2.51.210', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-26 06:54:29');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (642, 1, '182.2.78.39', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-26 13:55:23');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (643, 1, '125.160.101.42', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-26 16:38:41');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (644, 1, '125.160.101.42', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-26 19:08:23');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (645, 1, '182.2.42.73', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-27 07:10:18');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (646, 1, '182.2.39.33', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-28 07:41:43');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (647, 1, '182.2.40.28', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-02-28 13:38:55');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (648, 1, '180.247.172.67', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Safari/537.36 Edg/133.0.0.0', 'Login', '2025-03-01 02:05:14');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (649, 1, '182.2.73.215', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-01 06:16:06');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (650, 1, '182.2.73.215', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-01 08:45:14');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (651, 1, '182.2.82.155', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-01 13:31:28');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (652, 1, '125.160.103.172', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-01 19:07:05');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (653, 1, '182.2.50.18', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-02 06:37:52');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (654, 1, '182.2.38.8', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-03 07:06:13');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (655, 1, '182.2.53.131', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-03 14:08:54');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (656, 1, '182.2.51.129', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-04 06:57:18');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (657, 1, '182.2.69.242', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-05 06:05:10');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (658, 1, '182.2.69.242', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-05 10:51:41');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (659, 1, '182.2.50.236', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-05 13:47:11');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (660, 1, '182.2.50.118', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-06 07:55:28');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (661, 1, '182.2.79.213', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-07 07:34:53');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (662, 1, '182.2.45.152', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-07 13:45:48');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (663, 1, '182.2.84.251', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-08 07:02:03');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (664, 1, '182.2.41.181', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-09 06:41:36');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (665, 1, '182.2.41.169', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-09 13:16:58');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (666, 1, '182.2.72.70', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-10 06:00:31');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (667, 1, '182.2.45.223', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-11 06:28:37');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (668, 1, '182.2.41.72', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-11 13:54:09');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (669, 1, '125.160.100.151', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-11 16:49:41');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (670, 1, '182.2.85.227', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-12 07:07:17');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (671, 1, '182.2.68.243', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-12 14:05:46');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (672, 1, '36.72.213.202', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-12 19:55:14');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (673, 1, '182.2.36.225', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-13 07:14:58');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (674, 1, '182.2.46.220', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-13 13:58:43');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (675, 1, '182.2.77.187', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-14 07:29:14');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (676, 1, '182.2.79.138', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-15 06:37:41');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (677, 1, '182.2.47.129', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-16 06:24:26');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (678, 1, '182.2.39.59', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-16 14:18:10');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (679, 1, '182.2.42.91', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-17 07:18:55');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (680, 1, '110.139.93.227', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36 Edg/134.0.0.0', 'Login', '2025-03-17 21:29:49');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (681, 1, '182.2.85.29', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-18 06:58:04');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (682, 1, '182.2.85.29', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-18 09:47:37');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (683, 1, '182.2.46.34', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-18 14:13:27');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (684, 1, '182.2.70.65', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-19 07:06:07');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (685, 1, '110.139.93.227', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36 Edg/134.0.0.0', 'Login', '2025-03-20 03:40:25');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (686, 1, '182.2.41.73', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-20 06:20:34');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (687, 1, '182.2.39.184', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-20 13:58:51');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (688, 1, '182.2.83.127', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-21 08:05:41');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (689, 1, '182.2.83.163', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-21 10:28:21');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (690, 1, '36.72.216.108', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-21 20:11:45');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (691, 1, '36.72.216.108', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-22 04:08:12');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (692, 1, '182.2.40.91', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-22 09:21:51');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (693, 1, '182.2.72.96', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-22 13:56:07');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (694, 1, '182.2.73.123', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-23 07:21:00');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (695, 1, '182.2.76.108', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-24 07:20:46');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (696, 1, '182.2.74.22', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-25 07:36:34');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (697, 1, '36.72.216.108', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36 Edg/134.0.0.0', 'Login', '2025-03-25 15:29:30');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (698, 1, '36.72.216.108', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-25 17:31:24');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (699, 1, '182.2.83.50', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-26 06:30:15');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (700, 1, '182.2.83.50', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-26 09:53:46');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (701, 1, '182.2.71.46', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-26 13:47:30');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (702, 1, '36.72.213.139', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-26 16:39:13');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (703, 1, '36.72.213.139', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-26 22:02:44');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (704, 1, '182.2.71.245', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-27 10:15:59');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (705, 1, '182.2.82.241', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-27 14:00:32');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (706, 1, '36.72.214.13', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-27 17:23:57');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (707, 1, '182.2.43.1', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-28 08:34:46');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (708, 1, '182.2.85.107', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-28 12:58:31');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (709, 1, '182.2.82.200', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-29 08:38:51');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (710, 1, '36.72.213.129', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-29 20:01:28');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (711, 1, '182.2.69.171', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-30 08:41:33');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (712, 1, '36.72.213.129', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-30 16:22:49');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (713, 1, '125.160.99.22', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36 Edg/134.0.0.0', 'Login', '2025-03-31 17:13:35');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (714, 1, '125.160.99.22', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36 Edg/134.0.0.0', 'Logout', '2025-03-31 17:19:28');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (715, 1, '125.160.99.22', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36 Edg/134.0.0.0', 'Login', '2025-03-31 17:20:56');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (716, 1, '125.160.99.22', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-03-31 20:37:59');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (717, 1, '125.160.99.225', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-02 05:08:48');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (718, 1, '182.2.79.245', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-02 08:03:16');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (719, 1, '125.160.99.225', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-03 16:33:07');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (720, 1, '182.2.51.198', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-04 07:03:49');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (721, 1, '36.72.214.35', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-05 15:24:26');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (722, 1, '182.2.45.151', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-06 08:23:25');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (723, 1, '36.72.214.35', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-06 19:09:24');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (724, 1, '182.2.51.223', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-07 07:37:06');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (725, 1, '182.2.51.223', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-07 13:45:23');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (726, 1, '182.2.74.57', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-08 06:17:19');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (727, 1, '182.2.74.57', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-08 10:34:19');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (728, 1, '182.2.68.96', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-09 06:12:28');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (729, 1, '182.2.68.96', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-09 09:42:31');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (730, 1, '182.2.85.108', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-09 14:48:03');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (731, 1, '36.72.216.239', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-09 17:19:57');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (732, 1, '182.2.76.182', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-10 07:03:47');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (733, 1, '182.2.76.182', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-10 11:33:30');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (734, 1, '36.72.216.239', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-10 16:23:55');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (735, 1, '182.2.37.160', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-11 08:32:50');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (736, 1, '182.2.36.194', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-12 06:13:32');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (737, 1, '182.2.40.59', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-12 10:11:19');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (738, 1, '182.2.40.59', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-12 13:57:26');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (739, 1, '182.2.75.162', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-13 06:22:21');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (740, 1, '182.2.75.162', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-13 10:50:50');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (741, 1, '36.72.216.239', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-13 16:09:50');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (742, 1, '182.2.76.138', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-14 07:31:20');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (743, 1, '182.2.77.54', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-14 11:57:39');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (744, 1, '36.72.215.177', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-14 17:16:56');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (745, 1, '182.2.47.228', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-15 06:38:41');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (746, 1, '182.2.73.133', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-15 13:46:32');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (747, 1, '125.160.109.148', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-15 17:14:47');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (748, 1, '182.2.40.1', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-16 06:56:04');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (749, 1, '182.2.40.1', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-16 14:28:51');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (750, 1, '182.2.69.20', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-17 07:12:33');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (751, 1, '125.160.109.148', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-17 16:04:19');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (752, 1, '182.2.85.108', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-18 07:18:06');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (753, 1, '182.2.72.121', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-19 07:01:36');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (754, 1, '182.2.72.121', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-19 11:10:00');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (755, 1, '125.160.109.148', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-19 18:48:42');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (756, 1, '182.2.52.251', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-20 06:23:29');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (757, 1, '182.2.52.251', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-20 09:15:10');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (758, 1, '182.2.51.32', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-21 06:13:23');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (759, 1, '182.2.40.164', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-21 13:57:02');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (760, 1, '182.2.51.37', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-22 06:23:27');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (761, 1, '182.2.41.180', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-22 14:24:26');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (762, 1, '182.2.50.174', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-23 06:39:30');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (763, 1, '182.2.77.138', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-24 07:42:00');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (764, 1, '182.2.50.22', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-25 06:34:39');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (765, 1, '182.2.40.26', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-25 13:01:05');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (766, 1, '182.2.38.219', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-26 06:55:01');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (767, 1, '182.2.38.71', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-26 13:39:10');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (768, 1, '182.2.72.37', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-27 08:39:13');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (769, 1, '36.72.212.198', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-27 15:41:15');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (770, 1, '182.2.47.162', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-28 06:20:34');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (771, 1, '182.2.47.162', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-28 12:53:28');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (772, 1, '182.2.53.209', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-29 06:41:24');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (773, 1, '182.2.84.220', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-30 06:33:46');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (774, 1, '182.2.52.166', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-04-30 13:37:32');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (775, 1, '182.2.41.14', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-01 06:28:16');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (776, 1, '182.2.51.94', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-01 09:28:40');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (777, 1, '182.2.84.167', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-01 14:39:27');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (778, 1, '182.2.39.22', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-02 07:07:19');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (779, 1, '182.2.39.3', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-02 13:43:18');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (780, 1, '182.4.102.140', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-02 18:41:43');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (781, 1, '182.2.44.95', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-03 07:12:52');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (782, 1, '182.2.41.18', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-04 06:01:26');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (783, 1, '182.2.41.18', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-04 08:13:08');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (784, 1, '182.2.39.215', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-05 06:35:10');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (785, 1, '182.2.39.179', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-05 10:31:23');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (786, 1, '182.2.83.151', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-06 07:44:21');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (787, 1, '36.72.215.122', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-06 14:53:24');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (788, 1, '182.2.50.131', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-07 06:16:04');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (789, 1, '182.2.53.160', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-07 13:43:59');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (790, 1, '36.72.215.122', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-07 16:29:47');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (791, 1, '36.72.215.122', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-07 19:26:17');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (792, 1, '182.2.38.195', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-08 06:36:54');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (793, 1, '182.2.46.113', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-08 13:46:21');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (794, 1, '182.2.46.166', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-09 06:57:17');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (795, 1, '182.2.45.36', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-09 13:01:45');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (796, 1, '36.72.215.140', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-09 21:14:08');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (797, 1, '182.2.71.211', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-10 06:36:05');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (798, 1, '182.2.51.201', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-10 13:24:08');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (799, 1, '182.2.83.101', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-11 05:59:01');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (800, 1, '182.2.69.12', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-11 13:49:34');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (801, 1, '182.2.69.129', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-12 08:44:14');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (802, 1, '182.2.36.245', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-13 06:41:10');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (803, 1, '182.2.36.245', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-13 11:09:46');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (804, 1, '182.2.37.252', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-14 07:58:45');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (805, 1, '182.2.73.141', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-14 11:08:50');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (806, 1, '182.2.79.177', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-14 13:31:54');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (807, 1, '182.2.45.102', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-15 06:38:30');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (808, 1, '182.2.45.102', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-15 09:15:25');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (809, 1, '182.2.45.126', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-15 14:05:05');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (810, 1, '182.2.72.126', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-16 06:24:35');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (811, 1, '182.2.78.42', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-16 10:16:34');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (812, 1, '182.2.71.226', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-16 13:09:29');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (813, 1, '182.2.50.192', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-17 08:00:07');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (814, 1, '180.247.218.95', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36 Edg/136.0.0.0', 'Login', '2025-05-17 17:08:52');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (815, 1, '180.246.15.196', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36 Edg/136.0.0.0', 'Login', '2025-05-18 01:10:06');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (816, 1, '182.2.44.219', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-18 06:33:18');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (817, 1, '125.160.107.218', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-18 18:02:38');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (818, 1, '182.2.77.211', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-19 07:20:46');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (819, 1, '182.2.77.211', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-19 11:21:52');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (820, 1, '182.2.69.165', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-20 06:01:39');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (821, 1, '182.2.84.189', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-20 13:07:54');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (822, 1, '125.160.105.37', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-20 19:28:06');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (823, 1, '182.2.74.103', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-21 06:41:33');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (824, 1, '125.160.105.37', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-21 17:46:24');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (825, 1, '182.2.78.211', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-22 06:50:59');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (826, 1, '182.2.78.211', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-22 13:29:37');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (827, 1, '182.2.85.176', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-23 06:58:58');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (828, 1, '182.2.77.143', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-23 13:12:02');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (829, 1, '182.2.75.129', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-24 08:57:24');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (830, 1, '182.2.74.98', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-24 14:42:50');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (831, 1, '182.2.37.99', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-25 06:19:08');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (832, 1, '36.72.217.194', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-25 18:22:34');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (833, 1, '182.2.75.222', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-26 06:50:51');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (834, 1, '182.2.43.29', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-27 07:33:37');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (835, 1, '182.2.69.182', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-27 13:36:41');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (836, 1, '182.2.77.91', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-28 07:08:39');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (837, 1, '182.2.46.36', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-29 06:52:26');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (838, 1, '182.2.46.36', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-29 13:59:44');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (839, 1, '182.2.40.249', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-30 06:10:28');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (840, 1, '182.2.72.18', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-30 13:23:44');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (841, 1, '182.2.38.233', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-05-31 06:19:03');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (842, 1, '182.2.44.70', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-01 06:20:52');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (843, 1, '182.2.83.33', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-02 06:01:52');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (844, 1, '182.2.83.57', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-02 11:09:30');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (845, 1, '36.72.214.126', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-02 19:17:45');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (846, 1, '182.2.51.232', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-03 06:02:49');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (847, 1, '125.160.109.119', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-04 05:06:44');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (848, 1, '182.2.83.111', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-04 14:12:43');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (849, 1, '182.2.52.128', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-05 06:08:45');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (850, 1, '182.2.52.128', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-05 11:25:43');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (851, 1, '182.2.52.128', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-05 14:24:23');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (852, 1, '182.2.71.151', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-07 06:14:41');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (853, 1, '182.2.71.151', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-07 09:56:19');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (854, 1, '182.2.75.6', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-08 06:40:22');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (855, 1, '125.160.103.201', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-08 14:54:13');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (856, 1, '182.2.46.81', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-09 06:35:54');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (857, 1, '182.2.46.65', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-10 06:07:29');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (858, 1, '182.2.39.139', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-10 13:42:03');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (859, 1, '182.2.46.91', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-11 06:05:12');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (860, 1, '182.2.46.91', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-11 10:13:13');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (861, 1, '182.2.42.164', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-12 06:57:38');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (862, 1, '182.2.82.77', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-13 06:16:21');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (863, 1, '182.2.70.165', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-13 13:07:22');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (864, 1, '36.72.212.10', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-13 15:18:09');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (865, 1, '182.2.70.13', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-14 07:04:12');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (866, 1, '182.2.69.23', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-15 06:22:12');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (867, 1, '182.2.70.33', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-16 07:54:51');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (868, 1, '182.2.37.194', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-17 06:22:41');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (869, 1, '182.2.77.59', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-18 05:58:51');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (870, 1, '182.2.77.59', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-18 11:16:38');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (871, 1, '182.2.76.143', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-18 14:18:18');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (872, 1, '182.2.53.141', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-19 07:34:47');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (873, 1, '125.160.96.121', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-19 19:08:52');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (874, 1, '182.2.78.214', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-20 06:09:04');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (875, 1, '182.2.78.214', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-20 08:13:51');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (876, 1, '125.160.96.121', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-20 12:35:27');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (877, 1, '182.2.83.248', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-21 06:24:25');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (878, 1, '125.160.99.6', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-21 16:25:05');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (879, 1, '182.2.47.23', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-22 06:04:52');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (880, 1, '182.2.39.27', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-22 11:03:46');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (881, 1, '182.2.68.101', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-23 06:39:51');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (882, 1, '125.160.99.6', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-23 13:29:32');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (883, 1, '182.2.39.173', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-24 06:40:22');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (884, 1, '182.2.46.137', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-24 13:39:42');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (885, 1, '182.2.37.43', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-25 06:40:19');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (886, 1, '182.2.37.115', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-25 09:55:21');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (887, 1, '182.4.103.251', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-25 13:05:09');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (888, 1, '182.2.74.108', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-26 05:56:38');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (889, 1, '182.2.74.108', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-26 08:24:47');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (890, 1, '182.2.77.200', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-26 14:17:34');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (891, 1, '182.2.70.252', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-27 06:04:33');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (892, 1, '182.2.39.106', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-28 06:05:47');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (893, 1, '182.2.52.234', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-29 06:04:47');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (894, 1, '182.2.44.166', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-30 06:28:50');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (895, 1, '125.160.110.67', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-06-30 13:28:29');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (896, 1, '182.2.69.222', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-01 06:06:57');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (897, 1, '182.2.38.122', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-02 07:10:31');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (898, 1, '182.2.38.122', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-02 09:22:29');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (899, 1, '182.2.45.60', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-03 06:23:42');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (900, 1, '182.2.36.32', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-03 11:07:17');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (901, 1, '182.2.74.90', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-04 06:55:29');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (902, 1, '182.2.82.192', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-05 06:20:58');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (903, 1, '182.2.50.36', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-06 06:06:11');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (904, 1, '182.2.50.36', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-06 10:44:10');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (905, 1, '182.2.40.148', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-06 13:53:52');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (906, 1, '182.2.45.147', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-07 06:35:56');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (907, 1, '182.2.69.114', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-08 06:10:46');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (908, 1, '182.2.38.1', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/137.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-08 14:35:06');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (909, 1, '182.2.68.215', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-09 06:03:53');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (910, 1, '182.2.43.198', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-10 06:11:37');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (911, 1, '36.72.214.240', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-10 17:09:03');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (912, 1, '182.2.50.13', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-11 06:08:35');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (913, 1, '182.2.71.37', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-11 13:35:48');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (914, 1, '182.2.53.210', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-12 06:23:43');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (915, 1, '182.2.40.181', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-13 07:46:08');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (916, 1, '36.72.212.173', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-14 05:42:19');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (917, 1, '182.2.36.206', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-15 06:29:15');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (918, 1, '182.2.46.205', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-16 06:35:20');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (919, 1, '182.2.44.41', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-17 06:15:08');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (920, 1, '182.2.40.43', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-18 06:17:32');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (921, 1, '182.2.40.43', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-18 09:29:32');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (922, 1, '182.2.70.171', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-19 06:06:16');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (923, 1, '182.2.47.222', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-20 06:07:36');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (924, 1, '182.2.37.66', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-21 05:55:44');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (925, 1, '182.2.53.157', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-22 06:11:24');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (926, 1, '182.2.43.187', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-23 07:08:21');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (927, 1, '182.2.75.174', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-24 06:01:08');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (928, 1, '182.2.40.251', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-25 06:07:05');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (929, 1, '182.2.40.251', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-25 09:44:28');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (930, 1, '182.2.52.61', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-25 13:30:51');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (931, 1, '182.2.36.23', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-26 07:15:41');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (932, 1, '182.2.36.23', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-26 09:22:46');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (933, 1, '182.2.53.18', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-27 07:00:37');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (934, 1, '182.8.225.47', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-27 15:49:43');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (935, 1, '182.2.51.240', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-28 06:14:12');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (936, 1, '182.2.47.121', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-29 06:41:12');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (937, 1, '182.8.225.47', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-29 14:56:17');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (938, 1, '182.2.44.229', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-30 06:55:02');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (939, 1, '182.2.44.229', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-30 09:12:49');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (940, 1, '182.2.84.99', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-07-31 06:41:46');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (941, 1, '182.2.51.8', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-01 06:25:42');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (942, 1, '182.2.46.56', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-01 13:20:43');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (943, 1, '182.2.68.211', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-01 20:32:33');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (944, 1, '182.2.69.3', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-02 06:37:30');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (945, 1, '182.2.69.3', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-02 09:02:12');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (946, 1, '182.2.69.27', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-02 14:22:20');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (947, 1, '182.2.83.170', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-03 06:19:32');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (948, 1, '182.2.42.248', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-04 06:06:05');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (949, 1, '182.8.226.10', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-04 17:11:30');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (950, 1, '182.2.47.247', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-05 06:30:03');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (951, 1, '182.2.45.97', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-06 06:25:30');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (952, 1, '182.2.69.9', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-07 06:49:43');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (953, 1, '182.2.69.9', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-07 09:06:30');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (954, 1, '182.2.53.233', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-08 06:44:11');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (955, 1, '182.2.51.70', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-08 14:43:39');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (956, 1, '182.2.77.219', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-09 06:05:00');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (957, 1, '182.2.77.219', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-09 09:46:27');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (958, 1, '182.2.71.193', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-09 13:44:55');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (959, 1, '182.2.51.158', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-10 06:25:07');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (960, 1, '182.2.51.158', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-10 09:59:41');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (961, 1, '182.2.42.202', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-10 13:31:06');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (962, 1, '182.8.225.135', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-10 19:18:29');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (963, 1, '182.2.71.34', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-11 06:26:17');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (964, 1, '182.2.45.197', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-12 07:01:54');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (965, 1, '182.2.71.254', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-12 13:35:24');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (966, 1, '182.2.52.222', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-13 06:05:39');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (967, 1, '182.2.47.174', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-13 14:01:22');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (968, 1, '182.1.119.55', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36 Edg/139.0.0.0', 'Login', '2025-08-13 16:02:02');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (969, 1, '182.8.227.48', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-13 16:25:03');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (970, 1, '182.2.47.104', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-14 06:52:56');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (971, 1, '182.2.77.169', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-15 07:14:30');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (972, 1, '182.2.70.5', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-15 13:49:37');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (973, 1, '182.2.76.104', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-16 06:10:09');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (974, 1, '182.2.51.241', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-16 14:09:56');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (975, 1, '182.2.71.203', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-17 07:01:04');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (976, 1, '182.2.43.141', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-18 06:00:23');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (977, 1, '182.2.43.141', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-18 08:01:43');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (978, 1, '182.8.227.165', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-18 17:13:54');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (979, 1, '182.2.75.134', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-19 05:58:54');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (980, 1, '182.2.83.250', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-20 06:05:38');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (981, 1, '182.2.42.125', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-21 06:49:09');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (982, 1, '182.2.47.32', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-22 06:26:34');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (983, 1, '182.2.37.191', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-23 08:37:53');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (984, 1, '182.2.37.231', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-24 06:01:16');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (985, 1, '182.2.37.231', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-24 09:22:00');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (986, 1, '182.2.53.218', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-25 06:35:09');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (987, 1, '182.5.200.241', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36 Edg/139.0.0.0', 'Login', '2025-08-25 11:19:01');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (988, 1, '182.2.38.56', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-26 06:29:45');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (989, 1, '182.2.43.33', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-27 06:19:32');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (990, 1, '182.2.39.202', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-28 06:04:53');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (991, 1, '182.2.53.249', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-29 06:53:16');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (992, 1, '182.2.36.92', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-30 06:13:37');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (993, 1, '182.8.226.96', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-30 16:14:18');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (994, 1, '182.2.51.144', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-31 06:13:34');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (995, 1, '182.2.51.144', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-31 08:47:49');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (996, 1, '125.163.153.132', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-08-31 19:44:19');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (997, 1, '182.2.68.216', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-01 06:37:37');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (998, 1, '182.2.37.197', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-02 06:35:42');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (999, 1, '182.2.42.199', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-03 06:29:46');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1000, 1, '182.2.42.199', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-03 09:41:27');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1001, 1, '182.2.75.95', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-03 13:38:41');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1002, 1, '182.2.85.202', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-04 06:41:12');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1003, 1, '182.2.78.33', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-04 14:17:51');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1004, 1, '182.2.50.17', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-05 06:58:43');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1005, 1, '182.2.50.5', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-05 14:25:04');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1006, 1, '182.2.69.25', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-05 20:27:31');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1007, 1, '182.2.42.254', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-06 06:36:26');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1008, 1, '182.2.39.66', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-07 06:49:52');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1009, 1, '182.2.47.70', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-07 10:35:09');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1010, 1, '182.2.47.109', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-08 06:38:22');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1011, 1, '182.2.38.97', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-08 13:43:12');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1012, 1, '182.2.74.203', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-09 05:53:56');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1013, 1, '182.2.40.9', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-09 13:41:13');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1014, 1, '182.2.47.3', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-10 06:56:38');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1015, 1, '182.8.225.78', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-10 17:34:05');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1016, 1, '182.2.42.149', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-11 06:08:52');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1017, 1, '182.2.42.149', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-11 09:42:32');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1018, 1, '182.2.74.113', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-11 14:45:30');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1019, 1, '182.2.72.37', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-12 06:28:36');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1020, 1, '182.2.72.37', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-12 08:51:35');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1021, 1, '182.8.225.251', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-12 18:36:06');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1022, 1, '182.2.75.132', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-13 06:28:26');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1023, 1, '182.2.83.182', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-14 06:45:24');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1024, 1, '182.2.78.163', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-15 06:29:56');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1025, 1, '182.2.72.191', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-15 08:54:38');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1026, 1, '182.2.77.1', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-15 13:35:32');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1027, 1, '182.2.73.155', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-16 05:50:17');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1028, 1, '182.2.68.253', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-16 13:16:21');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1029, 1, '180.246.242.24', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36 Edg/140.0.0.0', 'Login', '2025-09-16 21:39:11');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1030, 1, '182.5.200.154', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36 Edg/140.0.0.0', 'Login', '2025-09-19 14:16:35');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1031, 1, '182.8.226.95', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-19 15:58:48');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1032, 1, '114.5.103.94', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/28.0 Chrome/130.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-19 17:06:38');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1033, 1, '182.2.77.112', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-20 06:03:41');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1034, 1, '182.2.77.132', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-20 10:12:05');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1035, 1, '182.2.76.227', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-20 14:05:06');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1036, 1, '182.2.83.54', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-21 06:26:01');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1037, 1, '182.2.83.54', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-21 11:05:15');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1038, 1, '182.2.77.221', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-22 06:05:55');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1039, 1, '182.2.75.16', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-22 13:43:13');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1040, 1, '182.2.72.49', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-23 09:59:55');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1041, 1, '182.8.227.222', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-23 19:30:57');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1042, 1, '182.2.75.202', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-24 05:53:13');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1043, 1, '182.2.77.136', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-25 06:28:30');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1044, 1, '182.2.77.139', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-25 13:45:32');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1045, 1, '182.2.77.211', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-26 07:08:56');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1046, 1, '182.2.75.207', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-27 06:55:59');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1047, 1, '182.2.68.194', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-28 06:12:56');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1048, 1, '182.2.85.214', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-28 14:35:49');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1049, 1, '182.2.68.87', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-29 05:44:06');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1050, 1, '182.2.68.87', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-29 09:07:37');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1051, 1, '182.2.84.188', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-09-30 07:02:34');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1052, 1, '182.2.83.231', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-01 06:14:59');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1053, 1, '182.2.78.64', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-01 13:22:09');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1054, 1, '182.2.77.186', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-02 05:49:55');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1055, 1, '182.2.69.205', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-03 06:05:19');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1056, 1, '182.2.77.208', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-04 05:47:24');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1057, 1, '182.2.77.53', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-05 05:55:02');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1058, 1, '182.8.225.135', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-05 15:35:52');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1059, 1, '182.2.69.79', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-06 06:55:49');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1060, 1, '182.2.68.225', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-06 13:59:04');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1061, 1, '182.2.71.63', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-07 07:05:12');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1062, 1, '182.2.82.5', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-08 05:45:34');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1063, 1, '182.2.77.142', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-08 13:05:17');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1064, 1, '182.2.74.165', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-09 05:52:00');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1065, 1, '182.2.74.165', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-09 12:53:21');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1066, 1, '182.4.101.141', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-10 06:37:15');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1067, 1, '182.4.101.141', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-10 13:24:13');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1068, 1, '182.2.78.41', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-11 06:17:05');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1069, 1, '182.2.70.161', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-12 06:08:37');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1070, 1, '182.8.226.88', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-12 18:13:18');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1071, 1, '182.2.70.76', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-13 06:39:10');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1072, 1, '182.2.70.76', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-13 09:16:34');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1073, 1, '182.2.74.251', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-14 05:47:44');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1074, 1, '182.8.227.1', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-14 15:47:38');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1075, 1, '182.2.82.186', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-15 06:01:11');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1076, 1, '182.2.73.198', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-15 13:29:44');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1077, 1, '182.2.77.197', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-16 07:14:20');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1078, 1, '182.2.73.242', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-16 13:12:03');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1079, 1, '182.2.84.228', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-17 06:22:02');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1080, 1, '182.2.85.10', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-18 06:03:01');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1081, 1, '182.2.75.23', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-18 13:29:23');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1082, 1, '182.2.72.11', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-19 06:15:55');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1083, 1, '182.8.226.167', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-19 16:28:59');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1084, 1, '182.2.78.176', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-20 05:50:02');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1085, 1, '182.2.73.245', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-20 13:27:14');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1086, 1, '182.2.74.157', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-21 06:14:32');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1087, 1, '182.2.68.218', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-21 13:27:13');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1088, 1, '182.8.227.85', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36 Edg/141.0.0.0', 'Login', '2025-10-22 18:57:51');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1089, 1, '182.8.227.85', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-22 19:17:29');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1090, 1, '182.2.76.140', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-23 05:42:12');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1091, 1, '182.2.77.82', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-24 06:08:45');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1092, 1, '182.2.76.151', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-25 05:47:28');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1093, 1, '182.2.70.85', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-26 06:46:14');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1094, 1, '182.2.70.85', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-26 10:27:26');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1095, 1, '182.2.78.126', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-26 13:32:25');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1096, 1, '182.2.69.173', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-27 06:52:57');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1097, 1, '182.2.70.243', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-28 06:40:26');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1098, 1, '182.2.72.220', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-29 06:04:52');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1099, 1, '182.2.78.243', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-29 14:05:11');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1100, 1, '182.2.82.144', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-30 05:54:24');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1101, 1, '182.2.76.43', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Mobile Safari/537.36', 'Login', '2025-10-30 13:27:49');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (1102, 1, '182.3.51.179', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36 Edg/141.0.0.0', 'Login', '2025-10-31 06:21:01');


#
# TABLE STRUCTURE FOR: tb_potongan
#

DROP TABLE IF EXISTS `tb_potongan`;

CREATE TABLE `tb_potongan` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idAdmin` int(11) NOT NULL,
  `nominal` varchar(16) NOT NULL,
  `keterangan` text NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

#
# TABLE STRUCTURE FOR: tb_transaksi
#

DROP TABLE IF EXISTS `tb_transaksi`;

CREATE TABLE `tb_transaksi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idAdmin` int(11) NOT NULL,
  `idNasabah` int(11) NOT NULL,
  `idPotongan` int(11) NOT NULL,
  `tanggal` date NOT NULL,
  `nominal` int(11) NOT NULL,
  `jenis` varchar(32) NOT NULL,
  `keterangan` text NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=43649 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3, 1, 4, 0, '2024-04-06', 4800000, 'Masuk', 'tabungan', '2024-05-15 16:48:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (4, 1, 4, 0, '2024-04-23', 100000, 'Keluar', 'pengambilan', '2024-05-15 16:50:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (5, 1, 4, 0, '2024-04-24', 500000, 'Keluar', 'ambil tabungan', '2024-05-15 16:51:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (6, 1, 4, 0, '2024-05-01', 2000000, 'Keluar', 'ambil tabungan', '2024-05-15 16:53:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (7, 1, 5, 0, '2024-04-04', 10731000, 'Masuk', 'tabungan masuk', '2024-05-16 13:36:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (8, 1, 5, 0, '2024-04-06', 50000, 'Masuk', 'tabungan masuk', '2024-05-16 13:37:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (9, 1, 5, 0, '2024-05-03', 1000000, 'Masuk', 'tabungan masuk', '2024-05-16 13:38:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (10, 1, 6, 0, '2024-05-06', 335000, 'Masuk', 'tabungan masuk', '2024-05-16 13:50:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (11, 1, 7, 0, '2024-05-16', 150000, 'Masuk', 'tabungan masuk', '2024-05-16 15:15:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (12, 1, 8, 0, '2024-04-28', 80000, 'Masuk', 'tabungan masuk', '2024-05-16 15:38:43');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (13, 1, 8, 0, '2024-05-12', 125000, 'Masuk', 'tabungan masuk', '2024-05-16 15:39:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (14, 1, 9, 0, '2024-04-30', 220000, 'Masuk', 'tabungan masuk', '2024-05-16 15:51:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (15, 1, 9, 0, '2024-05-08', 160000, 'Masuk', 'tabungan masuk', '2024-05-16 15:52:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (16, 1, 10, 0, '2024-05-09', 1320000, 'Masuk', 'tabungan masuk', '2024-05-16 15:55:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (17, 1, 10, 0, '2024-05-16', 120000, 'Masuk', 'tabungan masuk', '2024-05-16 15:56:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (18, 1, 11, 0, '2024-05-13', 1300000, 'Masuk', 'tabungan masuk', '2024-05-16 16:00:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (19, 1, 11, 0, '2024-05-16', 300000, 'Masuk', 'tabungan masuk', '2024-05-16 16:00:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (20, 1, 12, 0, '2024-05-16', 540000, 'Masuk', 'tabungan masuk', '2024-05-16 16:05:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (21, 1, 13, 0, '2024-05-16', 14860000, 'Masuk', 'tabungan masuk', '2024-05-16 16:10:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (22, 1, 14, 0, '2024-05-16', 1380000, 'Masuk', 'tabungan masuk', '2024-05-16 16:55:21');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (23, 1, 15, 0, '2024-05-16', 1825000, 'Masuk', 'tabungan masuk', '2024-05-16 17:00:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (24, 1, 16, 0, '2024-05-16', 1960000, 'Masuk', 'tabungan masuk', '2024-05-16 17:08:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (25, 1, 17, 0, '2024-05-16', 440000, 'Masuk', 'tabungan masuk', '2024-05-16 17:22:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (26, 1, 18, 0, '2024-05-16', 3310000, 'Masuk', 'tabungan masuk', '2024-05-16 17:26:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (27, 1, 19, 0, '2024-05-16', 780000, 'Masuk', 'tabungan masuk', '2024-05-16 17:31:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (28, 1, 20, 0, '2024-05-16', 2650000, 'Masuk', 'tabungan masuk', '2024-05-16 17:36:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (29, 1, 21, 0, '2024-05-16', 1800000, 'Masuk', 'tabungan masuk', '2024-05-16 18:17:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (30, 1, 22, 0, '2024-05-16', 32000000, 'Masuk', 'tabungan masuk', '2024-05-16 18:24:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (31, 1, 23, 0, '2024-05-17', 1120000, 'Masuk', 'tabungan masuk', '2024-05-17 15:17:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (32, 1, 24, 0, '2024-05-17', 290000, 'Masuk', 't', '2024-05-17 15:20:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (33, 1, 25, 0, '2024-05-17', 505000, 'Masuk', 'tabungan masuk', '2024-05-17 15:23:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (34, 1, 26, 0, '2024-05-17', 4535000, 'Masuk', 'tabungan masuk', '2024-05-17 15:28:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (35, 1, 27, 0, '2024-05-17', 1232000, 'Masuk', 'tabungan masuk', '2024-05-17 15:54:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (36, 1, 28, 0, '2024-05-17', 1470000, 'Masuk', 'tabungan masuk', '2024-05-17 15:57:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (37, 1, 29, 0, '2024-05-17', 705000, 'Masuk', 'tabungan masuk', '2024-05-17 16:01:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (38, 1, 30, 0, '2024-05-17', 10271000, 'Masuk', 'tabungan masuk', '2024-05-17 16:06:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (39, 1, 31, 0, '2024-05-17', 5625000, 'Masuk', 'tabungan masuk', '2024-05-17 16:12:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (40, 1, 32, 0, '2024-05-17', 1060000, 'Masuk', 'tabungan masuk', '2024-05-17 16:20:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (41, 1, 33, 0, '2024-05-17', 683000, 'Masuk', 'tabungan masuk', '2024-05-17 16:32:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (42, 1, 34, 0, '2024-05-17', 145000, 'Masuk', 'tabungan masuk', '2024-05-17 16:36:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (43, 1, 35, 0, '2024-05-17', 18700000, 'Masuk', 'tabungan masuk', '2024-05-17 16:41:21');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (44, 1, 36, 0, '2024-05-14', 3640000, 'Masuk', 'tabungan masuk', '2024-05-17 16:52:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (45, 1, 37, 0, '2024-05-17', 4350000, 'Masuk', 'tabungan masuk', '2024-05-17 16:54:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (46, 1, 38, 0, '2024-05-17', 395000, 'Masuk', 'tabungan masuk', '2024-05-17 16:57:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (47, 1, 39, 0, '2024-05-17', 4725000, 'Masuk', 'tabungan masuk', '2024-05-17 17:02:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (48, 1, 40, 0, '2024-05-17', 630000, 'Masuk', 'tabungan masuk', '2024-05-17 17:09:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (49, 1, 6, 0, '2024-05-17', 10000, 'Masuk', 'tabungan masuk', '2024-05-17 17:11:43');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (50, 1, 7, 0, '2024-05-17', 10000, 'Masuk', 'tabungan masuk', '2024-05-17 17:12:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (51, 1, 9, 0, '2024-05-17', 60000, 'Masuk', 'tabungan masuk', '2024-05-17 17:14:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (52, 1, 10, 0, '2024-05-17', 20000, 'Masuk', 'tabungan masuk', '2024-05-17 17:15:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (53, 1, 11, 0, '2024-05-17', 100000, 'Masuk', 'tabungan masuk', '2024-05-17 17:17:20');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (54, 1, 14, 0, '0024-05-17', 30000, 'Masuk', 'tabungan masuk', '2024-05-17 17:18:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (55, 1, 22, 0, '2024-05-17', 100000, 'Masuk', 'tabungan masuk', '2024-05-17 17:29:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (56, 1, 16, 0, '2024-05-17', 70000, 'Masuk', 'tabungan masuk', '2024-05-17 17:34:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (57, 1, 17, 0, '2024-05-17', 10000, 'Masuk', 'tabungan masuk', '2024-05-17 17:36:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (58, 1, 18, 0, '2024-05-17', 10000, 'Masuk', 'tabungan masuk', '2024-05-17 17:37:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (59, 1, 13, 0, '2024-05-17', 140000, 'Masuk', 'tabungan masuk', '2024-05-17 17:38:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (60, 1, 21, 0, '2024-05-17', 100000, 'Masuk', 'tabungan masuk', '2024-05-17 17:39:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (61, 1, 19, 0, '2024-05-17', 20000, 'Masuk', 'tabungan masuk', '2024-05-17 17:41:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (62, 1, 20, 0, '2024-05-17', 20000, 'Masuk', 'tabungan masuk', '2024-05-17 17:42:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (63, 1, 15, 0, '2024-05-17', 20000, 'Masuk', 'tabungan masuk', '2024-05-17 17:43:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (64, 1, 41, 0, '2024-05-17', 48000, 'Masuk', 'tabungan masuk', '2024-05-17 18:24:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (66, 1, 12, 0, '2024-05-17', 30000, 'Masuk', 'tabungan masuk', '2024-05-17 18:32:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (67, 1, 11, 0, '2024-05-17', 100000, 'Masuk', 'tabungan masuk', '2024-05-17 18:34:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (69, 1, 42, 0, '2024-05-18', 275000, 'Masuk', 'tabungan masuk', '2024-05-18 15:23:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (70, 1, 43, 0, '2024-05-01', 1210000, 'Masuk', 'tabungan masuk', '2024-05-18 15:25:52');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (71, 1, 44, 0, '2024-05-17', 650000, 'Masuk', 'tabungan masuk', '2024-05-18 15:28:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (72, 1, 45, 0, '2024-05-18', 130000, 'Masuk', 'tabungan masuk', '2024-05-18 15:30:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (73, 1, 46, 0, '2024-05-18', 810000, 'Masuk', 'tabungan masuk', '2024-05-18 15:34:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (74, 1, 47, 0, '2024-05-18', 3550000, 'Masuk', 'tabungan masuk', '2024-05-18 15:38:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (75, 1, 48, 0, '2024-05-18', 2130000, 'Masuk', 'tabungan masuk', '2024-05-18 15:40:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (76, 1, 49, 0, '2024-05-16', 751000, 'Masuk', 'tabungan masuk', '2024-05-18 15:44:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (77, 1, 50, 0, '2024-05-18', 150000, 'Masuk', 'tabungan masuk', '2024-05-18 17:04:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (78, 1, 51, 0, '2024-05-12', 13550000, 'Masuk', 'tabungan masuk', '2024-05-18 17:08:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (79, 1, 52, 0, '2024-05-12', 22135000, 'Masuk', 'tabungan masuk', '2024-05-18 17:14:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (80, 1, 53, 0, '2024-04-30', 2695000, 'Masuk', 'tabungan masuk', '2024-05-18 17:21:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (81, 1, 54, 0, '2024-05-18', 450000, 'Masuk', 'tabungan masuk', '2024-05-18 17:27:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (82, 1, 55, 0, '2024-05-18', 310000, 'Masuk', 'tabungan masuk', '2024-05-18 17:33:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (83, 1, 56, 0, '2024-05-18', 62000, 'Masuk', 'tabungan masuk', '2024-05-18 17:36:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (84, 1, 57, 0, '2024-05-18', 620000, 'Masuk', 'tabungan masuk', '2024-05-18 18:07:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (85, 1, 58, 0, '2024-05-18', 1000000, 'Masuk', 'tabungan masuk', '2024-05-18 18:11:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (86, 1, 59, 0, '2024-05-18', 180000, 'Masuk', 'tabungan masuk', '2024-05-18 18:13:56');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (87, 1, 60, 0, '2024-05-18', 7400000, 'Masuk', 'tabungan masuk', '2024-05-18 18:18:58');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (88, 1, 61, 0, '2024-05-18', 200000, 'Masuk', 'tabungan masuk', '2024-05-18 18:21:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (89, 1, 62, 0, '2024-05-18', 8050000, 'Masuk', 'tabungan masuk', '2024-05-18 18:26:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (90, 1, 63, 0, '2024-05-18', 3800000, 'Masuk', 'tabungan masuk', '2024-05-18 18:31:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (91, 1, 6, 0, '2024-05-18', 10000, 'Masuk', 'tabungan masuk', '2024-05-18 19:43:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (92, 1, 7, 0, '2024-05-18', 10000, 'Masuk', 'tabungan masuk', '2024-05-18 19:43:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (93, 1, 9, 0, '2024-05-18', 60000, 'Masuk', 'tabungan masuk', '2024-05-18 19:45:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (94, 1, 64, 0, '2024-05-18', 111000, 'Masuk', 'tabungan masuk', '2024-05-18 20:00:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (95, 1, 33, 0, '2024-05-18', 10000, 'Masuk', 'tabungan masuk', '2024-05-18 20:07:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (96, 1, 23, 0, '2024-05-18', 20000, 'Masuk', 'tabungan masuk', '2024-05-18 20:08:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (98, 1, 35, 0, '2024-05-18', 200000, 'Masuk', 'tabungan masuk', '2024-05-18 20:09:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (99, 1, 27, 0, '2024-05-18', 30000, 'Masuk', 'tabungan masuk', '2024-05-18 20:10:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (100, 1, 29, 0, '2024-05-18', 10000, 'Masuk', 'tabungan masuk', '2024-05-18 20:11:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (101, 1, 30, 0, '2024-05-18', 20000, 'Masuk', 'tabungan masuk', '2024-05-18 20:12:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (102, 1, 37, 0, '2024-05-18', 10000, 'Masuk', 'tabungan masuk', '2024-05-18 20:13:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (103, 1, 28, 0, '2024-05-18', 30000, 'Masuk', 'tabungan masuk', '2024-05-18 20:15:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (104, 1, 39, 0, '2024-05-18', 20000, 'Masuk', 'tabungan masuk', '2024-05-18 20:16:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (105, 1, 31, 0, '2024-05-18', 50000, 'Masuk', 'tabungan masuk', '2024-05-18 20:17:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (107, 1, 16, 0, '2024-05-18', 70000, 'Masuk', 'tabungan masuk', '2024-05-18 20:18:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (108, 1, 17, 0, '2024-05-18', 10000, 'Masuk', 'tabungan masuk', '2024-05-18 20:19:56');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (109, 1, 18, 0, '2024-05-18', 10000, 'Masuk', 'tabungan masuk', '2024-05-18 20:20:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (110, 1, 24, 0, '2024-05-18', 10000, 'Masuk', 'tabungan masuk', '2024-05-18 20:21:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (111, 1, 41, 0, '0024-05-18', 2000, 'Masuk', 'tabungan masuk', '2024-05-18 20:22:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (112, 1, 11, 0, '2024-05-18', 100000, 'Masuk', 'tabungan masuk', '2024-05-18 20:23:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (113, 1, 15, 0, '2024-05-18', 20000, 'Masuk', 'tabungan masuk', '2024-05-18 20:24:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (114, 1, 40, 0, '2024-05-19', 20000, 'Masuk', 'tabungan masuk', '2024-05-19 07:41:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (115, 1, 65, 0, '2024-05-19', 17100000, 'Masuk', 'tabungan masuk', '2024-05-19 07:44:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (116, 1, 66, 0, '2024-05-19', 23000, 'Masuk', 'tabungan masuk', '2024-05-19 07:47:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (117, 1, 63, 0, '2024-05-19', 200000, 'Masuk', 'tabungan masuk', '2024-05-19 08:20:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (118, 1, 67, 0, '2024-05-19', 23000, 'Masuk', 'tabungan masuk', '2024-05-19 08:29:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (119, 1, 6, 0, '2024-05-19', 10000, 'Masuk', 'tabungan masuk', '2024-05-19 08:34:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (120, 1, 7, 0, '2024-05-19', 10000, 'Masuk', 'tabungan masuk', '2024-05-19 08:35:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (121, 1, 68, 0, '2024-05-19', 6550000, 'Masuk', 'tabungan masuk', '2024-05-19 09:46:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (122, 1, 69, 0, '2024-05-19', 170000, 'Masuk', 'tabungan masuk', '2024-05-19 09:49:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (123, 1, 12, 0, '2024-05-19', 30000, 'Masuk', 'tabungan masuk', '2024-05-19 10:09:26');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (124, 1, 45, 0, '2024-05-19', 10000, 'Masuk', 'tabungan masuk', '2024-05-19 10:10:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (125, 1, 10, 0, '2024-05-19', 20000, 'Masuk', 'tabungan masuk', '2024-05-19 10:11:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (126, 1, 33, 0, '2024-05-19', 10000, 'Masuk', 'tabungan masuk', '2024-05-19 10:11:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (127, 1, 23, 0, '2024-05-19', 20000, 'Masuk', 'tabungan masuk', '2024-05-19 10:13:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (128, 1, 46, 0, '2024-05-19', 10000, 'Masuk', 'tabungan masuk', '2024-05-19 10:14:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (129, 1, 47, 0, '2024-05-19', 50000, 'Masuk', 'tabungan masuk', '2024-05-19 10:15:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (130, 1, 35, 0, '2024-05-19', 300000, 'Masuk', 'tabungan masuk', '2024-05-19 10:16:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (131, 1, 34, 0, '2024-05-19', 10000, 'Masuk', 'tabungan masuk', '2024-05-19 11:09:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (132, 1, 38, 0, '2024-05-19', 10000, 'Masuk', 'tabungan masuk', '2024-05-19 11:10:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (133, 1, 25, 0, '2024-05-19', 20000, 'Masuk', 'tabungan masuk', '2024-05-19 11:11:43');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (134, 1, 48, 0, '2024-05-19', 10000, 'Masuk', 'tabungan masuk', '2024-05-19 11:12:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (135, 1, 29, 0, '2024-05-19', 10000, 'Masuk', 'tabungan masuk', '2024-05-19 11:13:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (136, 1, 30, 0, '2024-05-19', 20000, 'Masuk', 'tabungan masuk', '2024-05-19 11:14:20');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (137, 1, 37, 0, '2024-05-19', 10000, 'Masuk', 'tabungan masuk', '2024-05-19 11:15:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (138, 1, 28, 0, '2024-05-19', 30000, 'Masuk', 'tabungan masuk', '2024-05-19 11:20:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (139, 1, 26, 0, '2024-05-19', 50000, 'Masuk', 'tabungan masuk', '2024-05-19 11:39:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (140, 1, 70, 0, '0024-06-05', 1200000, 'Masuk', 'tabungan masuk', '2024-05-19 11:49:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (141, 1, 31, 0, '2024-05-19', 50000, 'Masuk', 'tabungan masuk', '2024-05-19 11:51:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (142, 1, 32, 0, '2024-05-19', 10000, 'Masuk', 'tabungan masuk', '2024-05-19 11:52:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (143, 1, 9, 0, '0024-05-19', 60000, 'Masuk', 'tabungan masuk', '2024-05-19 11:53:26');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (144, 1, 60, 0, '2024-05-19', 150000, 'Masuk', 'tabungan masuk', '2024-05-19 11:54:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (145, 1, 16, 0, '2024-05-19', 70000, 'Masuk', 'tabungan masuk', '2024-05-19 11:54:52');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (146, 1, 17, 0, '2024-05-19', 10000, 'Masuk', 'tabungan masuk', '2024-05-19 11:55:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (147, 1, 18, 0, '2024-05-19', 10000, 'Masuk', 'tabungan masuk', '2024-05-19 11:56:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (148, 1, 69, 0, '2024-05-19', 10000, 'Masuk', 'tabungan masuk', '2024-05-19 12:01:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (149, 1, 24, 0, '2024-05-19', 10000, 'Masuk', 'tabungan masuk', '2024-05-19 12:02:21');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (150, 1, 41, 0, '2024-05-19', 2000, 'Masuk', 'tabungan masuk', '2024-05-19 12:02:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (151, 1, 54, 0, '2024-05-19', 30000, 'Masuk', 'tabungan masuk', '2024-05-19 12:03:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (152, 1, 11, 0, '2024-05-19', 100000, 'Masuk', 'tabungan masuk', '2024-05-19 12:04:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (153, 1, 14, 0, '2024-05-19', 30000, 'Masuk', 'tabungan masuk', '2024-05-19 16:06:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (154, 1, 15, 0, '2024-05-19', 30000, 'Masuk', 'tabungan masuk', '2024-05-19 16:07:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (155, 1, 14, 0, '2024-05-18', 30000, 'Masuk', 'tabungan masuk', '2024-05-19 16:08:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (156, 1, 12, 0, '2024-05-18', 30000, 'Masuk', 'tabungan masuk', '2024-05-19 16:10:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (157, 1, 10, 0, '2024-05-18', 20000, 'Masuk', 'tabungan masuk', '2024-05-19 16:11:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (158, 1, 21, 0, '2024-05-18', 100000, 'Masuk', 'tabungan masuk', '2024-05-19 16:12:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (159, 1, 22, 0, '2024-05-18', 100000, 'Masuk', 'tabungan masuk', '2024-05-19 16:13:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (160, 1, 21, 0, '2024-05-19', 400000, 'Masuk', 'tabungan masuk', '2024-05-19 16:17:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (161, 1, 22, 0, '2024-05-19', 100000, 'Masuk', 'tabungan masuk', '2024-05-19 16:18:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (162, 1, 19, 0, '2024-05-19', 40000, 'Masuk', 'tabungan masuk', '2024-05-19 16:19:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (163, 1, 20, 0, '2024-05-19', 20000, 'Masuk', 'tabungan masuk', '2024-05-19 16:20:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (164, 1, 58, 0, '2024-05-19', 20000, 'Masuk', 'tabungan masuk', '2024-05-19 16:21:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (165, 1, 64, 0, '2024-05-19', 5000, 'Masuk', 'tabungan masuk', '2024-05-19 16:22:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (166, 1, 57, 0, '2024-05-19', 20000, 'Masuk', 'tabungan masuk', '2024-05-19 16:24:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (168, 1, 40, 0, '2024-05-20', 20000, 'Masuk', 'tabungan masuk', '2024-05-20 07:10:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (169, 1, 90, 0, '2024-05-18', 130000, 'Masuk', 'tabungan masuk', '2024-05-20 10:06:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (170, 1, 89, 0, '2024-05-19', 125000, 'Masuk', 'tabungan masuk', '2024-05-20 10:07:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (171, 1, 88, 0, '2024-05-20', 280000, 'Masuk', 'tabungan masuk', '2024-05-20 10:09:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (172, 1, 87, 0, '2024-05-20', 130000, 'Masuk', 'tabungan masuk', '2024-05-20 10:10:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (173, 1, 86, 0, '2024-05-20', 140000, 'Masuk', 'tabungan masuk', '2024-05-20 10:12:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (174, 1, 85, 0, '2024-05-20', 140000, 'Masuk', 'tabungan masuk', '2024-05-20 10:13:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (175, 1, 84, 0, '2024-05-20', 170000, 'Masuk', 'tabungan masuk', '2024-05-20 10:18:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (176, 1, 83, 0, '2024-05-01', 30000, 'Masuk', 'tabungan masuk', '2024-05-20 10:19:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (177, 1, 82, 0, '2024-05-04', 5000, 'Masuk', 'tabungan masuk', '2024-05-20 10:19:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (178, 1, 81, 0, '2024-05-08', 10000, 'Masuk', 'tabungan masuk', '2024-05-20 10:20:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (179, 1, 80, 0, '2024-05-11', 65000, 'Masuk', 'tabungan masuk', '2024-05-20 10:21:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (180, 1, 79, 0, '2024-05-15', 290000, 'Masuk', 'tabungan masuk', '2024-05-20 10:22:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (181, 1, 78, 0, '2024-05-15', 80000, 'Masuk', 'tabungan masuk', '2024-05-20 10:24:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (182, 1, 77, 0, '2024-05-15', 35000, 'Masuk', 'tabungan masuk', '2024-05-20 10:26:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (183, 1, 76, 0, '2024-05-15', 120000, 'Masuk', 'tabungan masuk', '2024-05-20 10:28:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (184, 1, 75, 0, '2024-05-15', 20000, 'Masuk', 'tabungan masuk', '2024-05-20 10:29:52');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (185, 1, 74, 0, '2024-05-01', 40000, 'Masuk', 'tabungan masuk', '2024-05-20 10:30:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (186, 1, 73, 0, '2024-04-24', 372000, 'Masuk', 'tabungan masuk', '2024-05-20 10:32:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (187, 1, 72, 0, '2024-05-14', 140000, 'Masuk', 'tabungan masuk', '2024-05-20 10:33:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (188, 1, 71, 0, '2024-04-21', 500000, 'Masuk', 'tabungan masuk', '2024-05-20 10:34:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (189, 1, 91, 0, '2024-05-20', 1780000, 'Masuk', 'tabungan masuk', '2024-05-20 16:26:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (190, 1, 92, 0, '2024-05-20', 500000, 'Masuk', 'tabungan masuk', '2024-05-20 16:31:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (191, 1, 93, 0, '2024-05-20', 4660000, 'Masuk', 'tabungan masuk', '2024-05-20 16:36:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (192, 1, 94, 0, '2024-05-20', 255000, 'Masuk', 'tabungan masuk', '2024-05-20 16:39:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (193, 1, 95, 0, '2024-05-20', 35000, 'Masuk', 'tabungan masuk', '2024-05-20 16:42:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (195, 1, 70, 0, '2024-05-20', 30000, 'Masuk', 'tabungan masuk', '2024-05-20 16:44:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (196, 1, 4, 0, '2024-05-20', 600000, 'Keluar', 'tabungan keluar', '2024-05-20 16:45:26');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (197, 1, 96, 0, '2024-05-20', 380000, 'Masuk', 'tabungan masuk', '2024-05-20 16:52:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (198, 1, 97, 0, '2024-05-20', 240000, 'Masuk', 'tabungan masuk', '2024-05-20 16:59:56');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (199, 1, 98, 0, '2024-04-28', 2170000, 'Masuk', 'tabungan masuk', '2024-05-20 17:01:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (200, 1, 99, 0, '2024-05-20', 200000, 'Masuk', 'tabungan masuk', '2024-05-20 17:05:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (201, 1, 100, 0, '2024-05-19', 400000, 'Masuk', 'tabungan masuk', '2024-05-20 18:26:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (202, 1, 101, 0, '2024-05-20', 7150000, 'Masuk', 'tabungan masuk', '2024-05-20 18:30:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (203, 1, 102, 0, '2024-05-20', 315000, 'Masuk', 'tabungan masuk', '2024-05-20 18:36:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (204, 1, 103, 0, '2024-05-20', 1040000, 'Masuk', 'tabungan masuk', '2024-05-20 18:43:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (205, 1, 104, 0, '2024-04-15', 130000, 'Masuk', 'tabungan masuk', '2024-05-20 18:49:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (206, 1, 105, 0, '2024-05-19', 400000, 'Masuk', 'tabungan masuk', '2024-05-20 18:50:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (207, 1, 106, 0, '2024-05-20', 570000, 'Masuk', 'tabungan masuk', '2024-05-20 18:54:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (208, 1, 107, 0, '2024-05-20', 544000, 'Masuk', 'tabungan masuk', '2024-05-20 18:58:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (209, 1, 108, 0, '2024-05-19', 745000, 'Masuk', 'tabungan masuk', '2024-05-20 19:28:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (210, 1, 109, 0, '2024-05-17', 380000, 'Masuk', 'tabungan masuk', '2024-05-20 19:32:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (211, 1, 110, 0, '2024-05-03', 170000, 'Masuk', 'tabungan masuk', '2024-05-20 19:35:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (212, 1, 111, 0, '2024-05-20', 39140000, 'Masuk', 'tabungan masuk', '2024-05-20 19:49:23');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (213, 1, 112, 0, '2024-05-20', 220000, 'Masuk', 'tabungan masuk', '2024-05-20 19:54:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (214, 1, 113, 0, '2024-05-20', 1500000, 'Masuk', 'tabungan masuk', '2024-05-20 19:58:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (215, 1, 114, 0, '2024-05-20', 40000, 'Masuk', 'tabungan masuk', '2024-05-20 20:02:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (216, 1, 115, 0, '2024-05-20', 2500000, 'Masuk', 'tabungan masuk', '2024-05-20 20:05:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (217, 1, 116, 0, '2024-05-20', 1700000, 'Masuk', 'tabungan masuk', '2024-05-20 20:11:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (218, 1, 117, 0, '2024-05-20', 1450000, 'Masuk', 'tabungan masuk', '2024-05-20 20:15:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (219, 1, 118, 0, '2024-05-20', 1665000, 'Masuk', 'tabungan masuk', '2024-05-21 05:21:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (220, 1, 23, 0, '2024-05-20', 20000, 'Masuk', 'tabungan masuk', '2024-05-21 05:26:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (221, 1, 47, 0, '2024-05-20', 50000, 'Masuk', 'tabungan masuk', '2024-05-21 05:28:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (222, 1, 35, 0, '2024-05-20', 200000, 'Masuk', 'tabungan masuk', '2024-05-21 05:30:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (223, 1, 27, 0, '2024-05-20', 30000, 'Masuk', 'tabungan masuk', '2024-05-21 05:31:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (224, 1, 38, 0, '2024-05-20', 10000, 'Masuk', 'tabungan masuk', '2024-05-21 05:33:20');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (225, 1, 30, 0, '2024-05-20', 20000, 'Masuk', 'tabungan masuk', '2024-05-21 06:14:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (226, 1, 37, 0, '2024-05-20', 10000, 'Masuk', 'tabungan masuk', '2024-05-21 06:16:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (227, 1, 28, 0, '2024-05-20', 30000, 'Masuk', 'tabungan masuk', '2024-05-21 06:18:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (228, 1, 11, 0, '2024-05-20', 100000, 'Masuk', 'tabungan masuk', '2024-05-21 06:21:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (229, 1, 15, 0, '2024-05-20', 20000, 'Masuk', 'tabungan masuk', '2024-05-21 06:57:58');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (230, 1, 14, 0, '2024-05-20', 20000, 'Masuk', 'tabungan masuk', '2024-05-21 07:00:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (231, 1, 54, 0, '2024-05-20', 30000, 'Masuk', 'tabungan masuk', '2024-05-21 07:01:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (232, 1, 32, 0, '2024-05-18', 10000, 'Masuk', 'tabungan masuk', '2024-05-21 07:14:58');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (233, 1, 119, 0, '2024-05-20', 300000, 'Masuk', 'tabungan masuk', '2024-05-21 07:28:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (234, 1, 88, 0, '2024-05-21', 10000, 'Masuk', 'tabungan masuk', '2024-05-21 07:54:58');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (235, 1, 120, 0, '2024-05-21', 1150000, 'Masuk', 'tabungan masuk', '2024-05-21 08:12:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (236, 1, 63, 0, '2024-05-21', 1000000, 'Keluar', 'tabungan keluar', '2024-05-21 09:01:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (237, 1, 121, 0, '2024-05-21', 30000, 'Masuk', 'tabungan masuk', '2024-05-21 09:35:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (238, 1, 122, 0, '2024-05-21', 270000, 'Masuk', 'tabungan masuk', '2024-05-21 18:33:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (239, 1, 123, 0, '2024-05-21', 220000, 'Masuk', 'tabungan masuk', '2024-05-21 18:37:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (240, 1, 124, 0, '2024-05-21', 2000000, 'Masuk', 'tabungan masuk', '2024-05-21 18:41:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (241, 1, 125, 0, '2024-05-21', 1130000, 'Masuk', 'tabungan masuk', '2024-05-21 18:46:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (242, 1, 126, 0, '2024-05-19', 450000, 'Masuk', 'tabungan masuk', '2024-05-21 18:58:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (243, 1, 127, 0, '2024-05-19', 2665000, 'Masuk', 'tabungan masuk', '2024-05-21 19:05:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (244, 1, 128, 0, '2024-05-21', 2830000, 'Masuk', 'tabungan masuk', '2024-05-21 19:09:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (245, 1, 129, 0, '2024-05-21', 1050000, 'Masuk', 'tabungan masuk', '2024-05-21 19:14:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (246, 1, 130, 0, '2024-05-21', 150000, 'Masuk', 'tabungan masuk', '2024-05-21 19:18:20');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (247, 1, 19, 0, '2024-05-21', 20000, 'Masuk', 'tabungan masuk', '2024-05-22 06:28:43');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (248, 1, 31, 0, '2024-05-20', 50000, 'Masuk', 'tabungan masuk', '2024-05-22 06:33:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (250, 1, 131, 0, '2024-05-20', 1630000, 'Masuk', 'tabungan masuk', '2024-05-22 07:26:21');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (251, 1, 120, 0, '2024-05-22', 50000, 'Masuk', 'tabungan masuk', '2024-05-22 08:04:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (252, 1, 40, 0, '2024-05-22', 20000, 'Masuk', 'tabungan masuk', '2024-05-22 08:06:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (253, 1, 134, 0, '2024-05-22', 320000, 'Masuk', 'tabungan masuk', '2024-05-22 08:21:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (254, 1, 135, 0, '2024-05-22', 440000, 'Masuk', 'tabungan masuk', '2024-05-22 09:09:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (255, 1, 136, 0, '2024-05-22', 313000, 'Masuk', 'tabungan masuk', '2024-05-22 09:14:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (256, 1, 106, 0, '0024-05-22', 140000, 'Masuk', 'tabungan masuk', '2024-05-22 09:19:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (259, 1, 133, 0, '2024-05-22', 2300000, 'Masuk', 'tabungan masuk', '2024-05-22 10:13:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (260, 1, 116, 0, '2024-05-22', 100000, 'Masuk', 'tabungan masuk', '2024-05-22 10:14:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (261, 1, 70, 0, '2024-05-22', 30000, 'Masuk', 'tabungan masuk', '2024-05-22 10:31:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (262, 1, 70, 0, '2024-05-21', 30000, 'Masuk', 'tabungan masuk', '2024-05-22 10:39:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (263, 1, 19, 0, '2024-05-22', 20000, 'Masuk', 'tabungan masuk', '2024-05-22 17:25:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (264, 1, 20, 0, '2024-05-21', 20000, 'Masuk', 'Tabungan masuk', '2024-05-22 17:32:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (265, 1, 116, 0, '2024-05-21', 100000, 'Masuk', 'Tabungan masuk', '2024-05-22 17:34:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (266, 1, 121, 0, '2024-05-21', 20000, 'Masuk', 'Tabungan masuk', '2024-05-22 17:35:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (267, 1, 23, 0, '2024-05-21', 20000, 'Masuk', 'Tabungan masuk', '2024-05-22 17:35:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (268, 1, 46, 0, '2024-05-21', 10000, 'Masuk', 'Tab masuk', '2024-05-22 17:36:26');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (269, 1, 35, 0, '2024-05-21', 200000, 'Masuk', 'Tab masuk', '2024-05-22 17:37:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (270, 1, 27, 0, '2024-05-21', 30000, 'Masuk', 'Tab masuk', '2024-05-22 17:38:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (271, 1, 38, 0, '2024-05-21', 10000, 'Masuk', 'Tab masuk', '2024-05-22 17:38:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (272, 1, 68, 0, '2024-05-21', 50000, 'Masuk', 'Tab masuk', '2024-05-22 17:39:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (273, 1, 25, 0, '2024-05-21', 20000, 'Masuk', 'Tab masuk', '2024-05-22 18:25:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (274, 1, 112, 0, '2024-05-21', 10000, 'Masuk', 'Tab masuk', '2024-05-22 18:26:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (275, 1, 113, 0, '2024-05-21', 30000, 'Masuk', 'Tab masuk', '2024-05-22 18:27:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (276, 1, 28, 0, '2024-05-21', 30000, 'Masuk', 'Tab masuk', '2024-05-22 18:28:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (277, 1, 39, 0, '2024-05-19', 30000, 'Masuk', 'Tab masuk', '2024-05-22 18:34:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (278, 1, 39, 0, '2024-05-20', 20000, 'Masuk', 'Tab masuk', '2024-05-22 18:36:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (279, 1, 39, 0, '2024-05-21', 20000, 'Masuk', 'Tab masuk', '2024-05-22 18:36:58');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (280, 1, 39, 0, '2024-05-22', 20000, 'Masuk', 'Tab masuk', '2024-05-22 18:37:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (281, 1, 24, 0, '2024-05-20', 10000, 'Masuk', 'Tab masuk', '2024-05-22 18:38:52');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (282, 1, 24, 0, '2024-05-21', 10000, 'Masuk', 'Tab masuk', '2024-05-22 18:40:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (283, 1, 24, 0, '2024-05-22', 10000, 'Masuk', 'Tab masuk', '2024-05-22 18:40:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (284, 1, 41, 0, '2024-05-22', 6000, 'Masuk', 'Tab masuk', '2024-05-22 18:44:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (285, 1, 128, 0, '2024-05-22', 50000, 'Masuk', 'Tab masuk', '2024-05-22 18:45:52');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (286, 1, 69, 0, '2024-05-22', 30000, 'Masuk', 'Tab tgl 20 sd 22/5/24', '2024-05-22 18:51:21');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (287, 1, 117, 0, '2024-05-21', 50000, 'Masuk', 'Tab masuk', '2024-05-22 18:55:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (288, 1, 117, 0, '2024-05-22', 50000, 'Masuk', 'Tab masuk', '2024-05-22 18:56:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (289, 1, 54, 0, '2024-05-22', 30000, 'Masuk', 'Tab masuk ', '2024-05-22 18:59:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (290, 1, 124, 0, '2024-05-22', 50000, 'Masuk', 'Tab masuk', '2024-05-22 19:33:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (291, 1, 20, 0, '2024-05-22', 20000, 'Masuk', 'Tab masuk', '2024-05-22 19:34:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (292, 1, 22, 0, '2024-05-22', 300000, 'Masuk', 'Tab masuk 20,21,22/5/24', '2024-05-22 19:36:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (293, 1, 107, 0, '2024-05-22', 40000, 'Masuk', 'Tab masuk 21,22/5/24', '2024-05-22 19:40:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (294, 1, 119, 0, '2024-05-22', 20000, 'Masuk', 'Tab masuk 21,22/5/24', '2024-05-22 19:42:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (295, 1, 125, 0, '2024-05-22', 20000, 'Masuk', 'Tab masuk', '2024-05-22 19:44:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (296, 1, 9, 0, '2024-05-22', 40000, 'Masuk', 'Tab masuk 21,22/5/24', '2024-05-22 19:46:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (297, 1, 95, 0, '2024-05-21', 10000, 'Masuk', 'Tab masuk', '2024-05-22 19:49:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (298, 1, 118, 0, '2024-05-22', 10000, 'Masuk', 'Tab masuk 21,22/5/24', '2024-05-22 19:54:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (299, 1, 101, 0, '2024-05-21', 100000, 'Masuk', 'Tab masuk', '2024-05-22 19:57:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (300, 1, 94, 0, '2024-05-21', 10000, 'Masuk', 'Tab masuk', '2024-05-22 20:00:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (301, 1, 21, 0, '2024-05-22', 300000, 'Masuk', 'Tab masuk 20,21,22/5/24', '2024-05-22 20:03:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (302, 1, 58, 0, '2024-05-22', 70000, 'Masuk', 'Tab masuk 20,21,22/5/24', '2024-05-22 20:08:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (303, 1, 57, 0, '2024-05-22', 60000, 'Masuk', 'Tab masuk 20,21,22/5/24', '2024-05-22 20:09:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (304, 1, 12, 0, '2024-05-22', 90000, 'Masuk', 'Tab masuk 20,21,22/5/24', '2024-05-22 20:11:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (305, 1, 10, 0, '2024-05-22', 60000, 'Masuk', 'Tab masuk 20,21,22/5/24', '2024-05-22 20:12:43');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (306, 1, 16, 0, '2024-05-22', 210000, 'Masuk', 'Tab masuk 20,21,22/5/24', '2024-05-22 20:15:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (307, 1, 17, 0, '2024-05-22', 30000, 'Masuk', 'Tab masuk 20,21,22/5/24', '2024-05-22 20:16:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (308, 1, 60, 0, '2024-05-21', 100000, 'Masuk', 'Tab masuk 20,21/5/24', '2024-05-22 20:18:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (309, 1, 6, 0, '2024-05-22', 20000, 'Masuk', 'Tab masuk 21,22/5/24', '2024-05-22 20:25:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (310, 1, 9, 0, '2024-05-20', 60000, 'Masuk', 'Tab masuk', '2024-05-22 20:28:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (311, 1, 7, 0, '2024-05-21', 10000, 'Masuk', 'Tab masuk', '2024-05-22 20:30:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (312, 1, 91, 0, '2024-05-22', 40000, 'Masuk', 'Tab masuk 21,22/5/24', '2024-05-22 20:32:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (313, 1, 31, 0, '2024-05-22', 50000, 'Masuk', 'Tab masuk', '2024-05-22 20:38:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (314, 1, 32, 0, '2024-05-22', 10000, 'Masuk', 'Tab masuk', '2024-05-22 20:38:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (315, 1, 111, 0, '2024-05-22', 50000, 'Masuk', 'Tab masuk', '2024-05-22 20:39:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (316, 1, 45, 0, '2024-05-22', 20000, 'Masuk', 'Tab masuk 21,22/5/24', '2024-05-22 20:42:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (319, 1, 40, 0, '2024-05-23', 20000, 'Masuk', 'Tab masuk', '2024-05-23 07:29:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (320, 1, 100, 0, '2024-05-23', 50000, 'Masuk', 'Tab masuk', '2024-05-23 08:18:20');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (321, 1, 43, 0, '2024-05-23', 50000, 'Masuk', 'Tab masuk', '2024-05-23 08:20:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (322, 1, 55, 0, '2024-05-23', 10000, 'Masuk', 'Tab masuk', '2024-05-23 08:21:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (323, 1, 55, 0, '2024-05-23', 10000, 'Masuk', 'Tab masuk', '2024-05-23 08:21:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (324, 1, 56, 0, '2024-05-23', 2000, 'Masuk', 'Tab masuk', '2024-05-23 08:21:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (325, 1, 63, 0, '2024-05-23', 200000, 'Masuk', 'Tab masuk', '2024-05-23 08:25:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (326, 1, 62, 0, '2024-05-23', 2050000, 'Masuk', 'Tab masuk', '2024-05-23 10:33:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (327, 1, 137, 0, '2024-05-23', 493000, 'Masuk', 'Tab masuk', '2024-05-23 10:44:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (328, 1, 138, 0, '2024-05-23', 3000000, 'Masuk', 'Tab masuk', '2024-05-23 10:51:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (329, 1, 70, 0, '2024-05-23', 30000, 'Masuk', 'Tab masuk', '2024-05-23 11:33:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (330, 1, 12, 0, '2024-05-23', 30000, 'Masuk', 'Tab masuk', '2024-05-23 14:15:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (331, 1, 23, 0, '2024-05-23', 20000, 'Masuk', 'Tab masuk', '2024-05-23 14:16:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (332, 1, 6, 0, '2024-05-23', 10000, 'Masuk', 'Tab masuk', '2024-05-23 14:17:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (333, 1, 46, 0, '2024-05-23', 10000, 'Masuk', 'Tab masuk', '2024-05-23 14:18:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (335, 1, 115, 0, '2024-05-23', 500000, 'Masuk', 'Tab masuk', '2024-05-23 14:21:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (336, 1, 39, 0, '2024-05-23', 20000, 'Masuk', 'Tab masuk', '2024-05-23 14:22:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (337, 1, 35, 0, '2024-05-23', 100000, 'Masuk', 'Tab masuk', '2024-05-23 14:23:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (338, 1, 34, 0, '2024-05-23', 10000, 'Masuk', 'Tab masuk', '2024-05-23 14:23:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (339, 1, 38, 0, '2024-05-23', 10000, 'Masuk', 'Tab masuk', '2024-05-23 14:24:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (340, 1, 25, 0, '2024-05-23', 35000, 'Masuk', 'Tab masuk', '2024-05-23 14:25:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (341, 1, 113, 0, '2024-05-23', 50000, 'Masuk', 'Tab masuk', '2024-05-23 14:25:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (342, 1, 30, 0, '2024-05-23', 20000, 'Masuk', 'Tab masuk', '2024-05-23 14:26:20');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (343, 1, 37, 0, '2024-05-23', 10000, 'Masuk', 'Tab masuk', '2024-05-23 14:27:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (344, 1, 68, 0, '2024-05-23', 100000, 'Masuk', 'Tab masuk', '2024-05-23 14:27:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (345, 1, 28, 0, '2024-05-23', 60000, 'Masuk', 'Tab masuk 22,23/5/24', '2024-05-23 16:25:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (346, 1, 128, 0, '2024-05-23', 50000, 'Masuk', 'Tab masuk', '2024-05-23 16:26:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (347, 1, 31, 0, '2024-05-23', 50000, 'Masuk', 'Tab masuk', '2024-05-23 16:28:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (348, 1, 32, 0, '2024-05-23', 10000, 'Masuk', 'Tab masuk', '2024-05-23 16:28:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (349, 1, 117, 0, '2024-05-23', 50000, 'Masuk', 'Tab masuk', '2024-05-23 16:30:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (350, 1, 133, 0, '2024-05-23', 100000, 'Masuk', 'Tab masuk', '2024-05-23 16:32:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (351, 1, 54, 0, '2024-05-23', 30000, 'Masuk', 'Tab masuk', '2024-05-23 16:32:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (352, 1, 11, 0, '2024-05-23', 200000, 'Masuk', 'Tab masuk', '2024-05-23 16:34:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (353, 1, 15, 0, '2024-05-23', 30000, 'Masuk', 'Tab masuk', '2024-05-23 16:34:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (354, 1, 13, 0, '2024-05-18', 80000, 'Masuk', 'Tab masuk', '2024-05-23 16:45:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (355, 1, 13, 0, '2024-05-21', 180000, 'Masuk', 'Tab masuk', '2024-05-23 16:47:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (356, 1, 13, 0, '2024-05-22', 120000, 'Masuk', 'Tab masuk', '2024-05-23 16:48:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (358, 1, 21, 0, '2024-05-23', 100000, 'Masuk', 'Tab masuk', '2024-05-23 16:55:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (359, 1, 22, 0, '2024-05-23', 100000, 'Masuk', 'Tab masuk', '2024-05-23 16:55:52');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (360, 1, 9, 0, '2024-05-23', 20000, 'Masuk', 'Tab masuk', '2024-05-23 16:56:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (361, 1, 20, 0, '2024-05-23', 20000, 'Masuk', 'Tab masuk', '2024-05-24 05:19:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (362, 1, 19, 0, '2024-05-23', 20000, 'Masuk', 'Tab masuk', '2024-05-24 05:19:43');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (363, 1, 139, 0, '2024-05-23', 110000, 'Masuk', 'Tab masuk', '2024-05-24 05:23:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (364, 1, 91, 0, '2024-05-23', 20000, 'Masuk', 'Tab masuk', '2024-05-24 05:32:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (365, 1, 66, 0, '2024-05-23', 15000, 'Masuk', 'Tab masuk', '2024-05-24 05:32:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (366, 1, 106, 0, '2024-05-23', 100000, 'Masuk', 'Tab masuk', '2024-05-24 06:16:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (367, 1, 131, 0, '2024-05-23', 40000, 'Masuk', 'Tab masuk', '2024-05-24 06:18:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (368, 1, 138, 0, '2024-05-23', 50000, 'Masuk', 'Tab masuk', '2024-05-24 06:19:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (369, 1, 98, 0, '2024-05-23', 10000, 'Masuk', 'Tab masuk', '2024-05-24 06:19:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (370, 1, 79, 0, '2024-05-23', 20000, 'Masuk', 'Tab masuk', '2024-05-24 06:21:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (371, 1, 82, 0, '2024-05-22', 10000, 'Masuk', 'Tab masuk', '2024-05-24 06:22:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (372, 1, 75, 0, '2024-05-22', 10000, 'Masuk', 'Tab masuk', '2024-05-24 06:23:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (373, 1, 80, 0, '2024-05-22', 30000, 'Masuk', 'Tab masuk', '2024-05-24 06:24:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (374, 1, 79, 0, '2024-05-22', 20000, 'Masuk', 'Tab masuk', '2024-05-24 06:24:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (375, 1, 88, 0, '2024-05-22', 10000, 'Masuk', 'Tab masuk', '2024-05-24 06:25:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (376, 1, 87, 0, '2024-05-22', 10000, 'Masuk', 'Tab masuk', '2024-05-24 06:26:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (377, 1, 87, 0, '2024-05-23', 10000, 'Masuk', 'Tab masuk', '2024-05-24 06:28:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (378, 1, 88, 0, '2024-05-23', 10000, 'Masuk', 'Tab masuk', '2024-05-24 06:28:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (379, 1, 135, 0, '2024-05-23', 10000, 'Masuk', 'Tab masuk', '2024-05-24 06:31:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (380, 1, 58, 0, '2024-05-23', 20000, 'Masuk', 'Tab masuk', '2024-05-24 06:32:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (381, 1, 64, 0, '2024-05-23', 2000, 'Masuk', 'Tab masuk', '2024-05-24 06:32:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (382, 1, 57, 0, '2024-05-23', 20000, 'Masuk', 'Tab masuk', '2024-05-24 06:33:23');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (383, 1, 116, 0, '2024-05-23', 50000, 'Masuk', 'Tab masuk', '2024-05-24 06:33:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (384, 1, 108, 0, '2024-05-21', 20000, 'Masuk', 'Tab masuk', '2024-05-24 06:37:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (385, 1, 108, 0, '2024-05-22', 20000, 'Masuk', 'Tab masuk', '2024-05-24 06:37:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (386, 1, 108, 0, '2024-05-23', 20000, 'Masuk', 'Tab masuk', '2024-05-24 06:38:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (387, 1, 107, 0, '2024-05-23', 20000, 'Masuk', 'Tab masuk', '2024-05-24 06:42:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (388, 1, 119, 0, '2024-05-23', 10000, 'Masuk', 'Tab masuk', '2024-05-24 06:42:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (389, 1, 111, 0, '2024-05-23', 50000, 'Masuk', 'Tab masuk', '2024-05-24 06:44:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (390, 1, 126, 0, '2024-05-22', 10000, 'Masuk', 'Tab masuk', '2024-05-24 06:47:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (391, 1, 126, 0, '2024-05-23', 10000, 'Masuk', 'Tab masuk', '2024-05-24 06:49:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (392, 1, 124, 0, '2024-05-23', 50000, 'Masuk', 'Tab masuk', '2024-05-24 06:52:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (393, 1, 125, 0, '2024-05-23', 20000, 'Masuk', 'Tab masuk', '2024-05-24 06:53:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (395, 1, 129, 0, '2024-05-22', 50000, 'Masuk', 'Tab masuk', '2024-05-24 06:57:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (396, 1, 129, 0, '2024-05-23', 50000, 'Masuk', 'Tab masuk', '2024-05-24 06:58:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (398, 1, 40, 0, '2024-05-24', 20000, 'Masuk', 'Tab masuk', '2024-05-24 07:21:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (399, 1, 55, 0, '2024-05-22', 40000, 'Masuk', 'Tab masuk', '2024-05-24 07:42:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (400, 1, 56, 0, '2024-05-22', 8000, 'Masuk', 'Tab masuk', '2024-05-24 07:43:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (401, 1, 63, 0, '2024-05-24', 2000000, 'Keluar', 'Tab keluar', '2024-05-24 09:12:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (402, 1, 116, 0, '2024-05-24', 50000, 'Masuk', 'Tab masuk', '2024-05-24 10:33:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (403, 1, 107, 0, '2024-05-24', 20000, 'Masuk', 'Tab masuk', '2024-05-24 16:33:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (404, 1, 119, 0, '2024-05-24', 10000, 'Masuk', 'Tab masuk', '2024-05-24 16:33:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (405, 1, 45, 0, '2024-05-24', 20000, 'Masuk', 'Tab masuk 23,24/5/24', '2024-05-24 16:35:23');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (406, 1, 121, 0, '2024-05-24', 10000, 'Masuk', 'Tab masuk', '2024-05-24 16:36:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (407, 1, 23, 0, '2024-05-24', 20000, 'Masuk', 'Tab masuk', '2024-05-24 16:36:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (408, 1, 33, 0, '2024-05-24', 10000, 'Masuk', 'Tab masuk', '2024-05-24 16:37:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (409, 1, 46, 0, '2024-05-24', 10000, 'Masuk', 'Tab masuk', '2024-05-24 16:37:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (410, 1, 47, 0, '2024-05-24', 50000, 'Masuk', 'Tab masuk', '2024-05-24 16:38:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (411, 1, 36, 0, '2024-05-24', 5000, 'Masuk', 'Tab masuk', '2024-05-24 16:38:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (412, 1, 27, 0, '2024-05-24', 30000, 'Masuk', 'Tab masuk', '2024-05-24 16:39:21');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (413, 1, 48, 0, '2024-05-24', 10000, 'Masuk', 'Tab masuk', '2024-05-24 16:40:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (414, 1, 38, 0, '2024-05-24', 10000, 'Masuk', 'Tab masuk', '2024-05-24 16:40:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (415, 1, 25, 0, '2024-05-24', 20000, 'Masuk', 'Tab masuk', '2024-05-24 16:41:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (416, 1, 113, 0, '2024-05-24', 50000, 'Masuk', 'Tab masuk', '2024-05-24 16:41:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (417, 1, 30, 0, '2024-05-24', 20000, 'Masuk', 'Tab masuk', '2024-05-24 16:42:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (418, 1, 37, 0, '2024-05-24', 10000, 'Masuk', 'Tab masuk', '2024-05-24 16:42:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (419, 1, 28, 0, '2024-05-24', 30000, 'Masuk', 'Tab masuk', '2024-05-24 16:43:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (420, 1, 39, 0, '2024-05-24', 20000, 'Masuk', 'Tab masuk', '2024-05-24 16:44:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (422, 1, 92, 0, '2024-05-24', 20000, 'Masuk', 'Tab masuk', '2024-05-24 16:48:58');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (423, 1, 98, 0, '2024-05-24', 10000, 'Masuk', 'Tab masuk', '2024-05-24 16:49:26');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (424, 1, 117, 0, '2024-05-24', 50000, 'Masuk', 'Tab masuk', '2024-05-24 16:49:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (425, 1, 24, 0, '2024-05-24', 10000, 'Masuk', 'Tab masuk', '2024-05-24 16:50:23');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (426, 1, 41, 0, '2024-05-24', 2000, 'Masuk', 'Tab masuk', '2024-05-24 16:50:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (427, 1, 133, 0, '2024-05-24', 100000, 'Masuk', 'Tab masuk', '2024-05-24 16:51:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (428, 1, 54, 0, '2024-05-24', 30000, 'Masuk', 'Tab masuk', '2024-05-24 16:52:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (429, 1, 11, 0, '2024-05-24', 100000, 'Masuk', 'Tab masuk', '2024-05-24 16:58:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (430, 1, 15, 0, '2024-05-24', 30000, 'Masuk', 'Tab masuk', '2024-05-24 16:58:56');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (431, 1, 14, 0, '2024-05-24', 30000, 'Masuk', 'Tab masuk', '2024-05-24 16:59:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (432, 1, 20, 0, '2024-05-24', 20000, 'Masuk', 'Tab masuk', '2024-05-24 17:00:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (433, 1, 19, 0, '2024-05-24', 20000, 'Masuk', 'Tab masuk', '2024-05-24 17:00:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (434, 1, 139, 0, '2024-05-24', 50000, 'Masuk', 'Tab masuk', '2024-05-24 17:01:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (435, 1, 21, 0, '2024-05-24', 100000, 'Masuk', 'Tab masuk', '2024-05-24 17:02:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (436, 1, 22, 0, '2024-05-24', 100000, 'Masuk', 'Tab masuk', '2024-05-24 17:03:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (437, 1, 9, 0, '2024-05-24', 20000, 'Masuk', 'Tab masuk', '2024-05-24 17:07:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (438, 1, 138, 0, '2024-05-24', 15000, 'Masuk', 'Tab masuk', '2024-05-24 17:08:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (439, 1, 66, 0, '2024-05-24', 15000, 'Masuk', 'Tab masuk', '2024-05-24 17:09:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (440, 1, 95, 0, '2024-05-24', 10000, 'Masuk', 'Tab masuk', '2024-05-24 17:10:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (441, 1, 95, 0, '2024-05-23', 10000, 'Masuk', 'Tab masuk', '2024-05-24 17:11:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (442, 1, 120, 0, '2024-05-24', 50000, 'Masuk', 'Tab masuk', '2024-05-24 17:15:20');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (443, 1, 94, 0, '2024-05-24', 10000, 'Masuk', 'Tab masuk', '2024-05-24 17:16:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (444, 1, 135, 0, '2024-05-24', 10000, 'Masuk', 'Tab masuk', '2024-05-24 17:16:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (445, 1, 58, 0, '2024-05-24', 20000, 'Masuk', 'Tab masuk', '2024-05-24 17:17:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (446, 1, 57, 0, '2024-05-24', 20000, 'Masuk', 'Tab masuk', '2024-05-24 17:18:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (447, 1, 12, 0, '2024-05-24', 30000, 'Masuk', 'Tab masuk', '2024-05-24 17:18:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (448, 1, 111, 0, '2024-05-24', 50000, 'Masuk', 'Tab masuk', '2024-05-24 17:19:20');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (449, 1, 91, 0, '2024-05-24', 20000, 'Masuk', 'Tab masuk', '2024-05-24 17:19:56');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (450, 1, 126, 0, '2024-05-24', 10000, 'Masuk', 'Tab masuk', '2024-05-24 17:20:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (451, 1, 68, 0, '2024-05-24', 700000, 'Masuk', 'Tab masuk', '2024-05-24 17:21:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (452, 1, 125, 0, '2024-05-24', 20000, 'Masuk', 'Tab masuk', '2024-05-24 17:22:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (453, 1, 137, 0, '2024-05-24', 20000, 'Masuk', 'Tab masuk', '2024-05-24 17:22:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (454, 1, 97, 0, '2024-05-24', 10000, 'Masuk', 'Tab masuk', '2024-05-24 17:23:26');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (455, 1, 97, 0, '2024-05-24', 15000, 'Masuk', 'Tab masuk', '2024-05-24 17:24:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (456, 1, 68, 0, '2024-05-20', 100000, 'Masuk', 'Tab masuk', '2024-05-24 17:26:56');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (457, 1, 129, 0, '2024-05-24', 50000, 'Masuk', 'Tab masuk', '2024-05-24 17:35:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (458, 1, 40, 0, '2024-05-25', 20000, 'Masuk', 'Tab masuk', '2024-05-25 07:43:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (459, 1, 63, 0, '2024-05-25', 200000, 'Masuk', 'Tab masuk', '2024-05-25 08:45:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (460, 1, 135, 0, '2024-05-25', 460000, 'Keluar', 'Tab keluar', '2024-05-25 09:31:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (461, 1, 116, 0, '2024-05-25', 50000, 'Masuk', 'Tab masuk', '2024-05-25 10:14:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (462, 1, 68, 0, '2024-05-25', 500000, 'Masuk', 'Tab masuk', '2024-05-25 10:15:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (463, 1, 119, 0, '2024-05-25', 10000, 'Masuk', 'Tab masuk', '2024-05-25 10:35:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (464, 1, 7, 0, '2024-05-25', 10000, 'Masuk', 'Tab masuk', '2024-05-25 10:36:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (465, 1, 107, 0, '2024-05-25', 20000, 'Masuk', 'Tab masuk', '2024-05-25 10:36:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (466, 1, 6, 0, '2024-05-25', 10000, 'Masuk', 'Tab masuk', '2024-05-25 10:37:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (467, 1, 121, 0, '2024-05-25', 10000, 'Masuk', 'Tab masuk', '2024-05-25 10:37:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (468, 1, 33, 0, '2024-05-25', 20000, 'Masuk', 'Tab masuk', '2024-05-25 10:38:23');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (469, 1, 46, 0, '2024-05-25', 10000, 'Masuk', 'Tab masuk', '2024-05-25 10:39:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (470, 1, 47, 0, '2024-05-25', 50000, 'Masuk', 'Tab masuk', '2024-05-25 10:40:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (471, 1, 36, 0, '2024-05-25', 5000, 'Masuk', 'Tab masuk', '2024-05-25 10:41:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (472, 1, 35, 0, '2024-05-25', 200000, 'Masuk', 'Tab masuk', '2024-05-25 10:41:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (473, 1, 34, 0, '2024-05-25', 10000, 'Masuk', 'Tab masuk', '2024-05-25 10:42:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (474, 1, 27, 0, '2024-05-25', 30000, 'Masuk', 'Tab masuk', '2024-05-25 10:43:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (475, 1, 48, 0, '2024-05-25', 10000, 'Masuk', 'Tab masuk', '2024-05-25 18:17:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (476, 1, 38, 0, '2024-05-25', 10000, 'Masuk', 'Tab masuk', '2024-05-25 18:18:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (477, 1, 25, 0, '2024-05-25', 20000, 'Masuk', 'Tab masuk', '2024-05-25 18:18:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (478, 1, 113, 0, '2024-05-25', 25000, 'Masuk', 'Tab masuk', '2024-05-25 18:19:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (479, 1, 30, 0, '2024-05-25', 20000, 'Masuk', 'Tab masuk', '2024-05-25 18:19:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (480, 1, 37, 0, '2024-05-25', 10000, 'Masuk', 'Tab masuk', '2024-05-25 18:20:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (481, 1, 28, 0, '2024-05-25', 30000, 'Masuk', 'Tab masuk', '2024-05-25 18:21:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (482, 1, 128, 0, '2024-05-25', 50000, 'Masuk', 'Tab masuk', '2024-05-25 18:21:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (483, 1, 39, 0, '2024-05-25', 20000, 'Masuk', 'Tab masuk', '2024-05-25 18:22:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (484, 1, 69, 0, '2024-05-25', 20000, 'Masuk', 'Tab masuk', '2024-05-25 18:23:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (485, 1, 117, 0, '2024-05-25', 50000, 'Masuk', 'Tab masuk', '2024-05-25 18:24:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (486, 1, 133, 0, '2024-05-25', 100000, 'Masuk', 'Tab masuk', '2024-05-25 18:24:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (487, 1, 54, 0, '2024-05-25', 30000, 'Masuk', 'Tab masuk', '2024-05-25 18:25:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (488, 1, 91, 0, '2024-05-25', 20000, 'Masuk', 'Tab masuk', '2024-05-25 18:26:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (489, 1, 106, 0, '2024-05-25', 50000, 'Masuk', 'Tab masuk', '2024-05-25 18:27:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (490, 1, 107, 0, '2024-05-25', 20000, 'Masuk', 'Tab masuk', '2024-05-25 18:29:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (491, 1, 108, 0, '2024-05-25', 20000, 'Masuk', 'Tab masuk', '2024-05-25 18:30:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (492, 1, 92, 0, '2024-05-25', 20000, 'Masuk', 'Tab masuk', '2024-05-25 18:31:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (493, 1, 11, 0, '2024-05-25', 100000, 'Masuk', 'Tab masuk', '2024-05-25 18:31:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (494, 1, 15, 0, '2024-05-25', 30000, 'Masuk', 'Tab masuk', '2024-05-25 18:43:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (495, 1, 14, 0, '2024-05-25', 30000, 'Masuk', 'Tab masuk', '2024-05-25 18:44:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (496, 1, 13, 0, '2024-05-25', 120000, 'Masuk', 'Tab masuk', '2024-05-25 18:44:58');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (497, 1, 21, 0, '2024-05-25', 100000, 'Masuk', 'Tab masuk', '2024-05-25 18:45:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (498, 1, 22, 0, '2024-05-25', 100000, 'Masuk', 'Tab masuk', '2024-05-25 18:46:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (499, 1, 139, 0, '2024-05-25', 100000, 'Masuk', 'Tab masuk', '2024-05-25 18:46:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (500, 1, 20, 0, '2024-05-25', 20000, 'Masuk', 'Tab masuk', '2024-05-25 18:47:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (501, 1, 19, 0, '2024-05-25', 20000, 'Masuk', 'Tab masuk', '2024-05-25 18:48:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (502, 1, 66, 0, '2024-05-25', 15000, 'Masuk', 'Tab masuk', '2024-05-25 18:48:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (503, 1, 58, 0, '2024-05-25', 20000, 'Masuk', 'Tab masuk', '2024-05-26 00:18:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (504, 1, 64, 0, '2024-05-25', 10000, 'Masuk', 'Tab masuk', '2024-05-26 00:19:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (505, 1, 57, 0, '2024-05-25', 20000, 'Masuk', 'Tab masuk', '2024-05-26 00:19:43');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (506, 1, 12, 0, '2024-05-25', 30000, 'Masuk', 'Tab masuk', '2024-05-26 00:20:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (507, 1, 10, 0, '2024-05-25', 20000, 'Masuk', 'Tab masuk', '2024-05-26 00:21:26');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (508, 1, 55, 0, '2024-05-25', 10000, 'Masuk', 'Tab masuk', '2024-05-26 00:22:26');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (509, 1, 111, 0, '2024-05-25', 50000, 'Masuk', 'Tab masuk', '2024-05-26 00:23:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (510, 1, 59, 0, '2024-05-25', 50000, 'Masuk', 'Tab masuk', '2024-05-26 00:23:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (511, 1, 124, 0, '2024-05-25', 50000, 'Masuk', 'Tab masuk', '2024-05-26 00:24:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (512, 1, 125, 0, '2024-05-25', 20000, 'Masuk', 'Tab masuk', '2024-05-26 00:25:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (513, 1, 126, 0, '2024-05-25', 10000, 'Masuk', 'Tab masuk', '2024-05-26 00:25:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (514, 1, 87, 0, '2024-05-25', 10000, 'Masuk', 'Tab masuk', '2024-05-26 00:26:20');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (515, 1, 88, 0, '2024-05-25', 10000, 'Masuk', 'Tab masuk', '2024-05-26 00:26:58');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (516, 1, 137, 0, '2024-05-25', 20000, 'Masuk', 'Tab masuk', '2024-05-26 00:27:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (517, 1, 129, 0, '2024-05-25', 50000, 'Masuk', 'Tab masuk', '2024-05-26 00:28:20');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (518, 1, 97, 0, '2024-05-25', 20000, 'Masuk', 'Tab masuk', '2024-05-26 00:28:56');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (519, 1, 40, 0, '2024-05-26', 20000, 'Masuk', 'Tab masuk', '2024-05-26 09:03:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (520, 1, 65, 0, '2024-05-26', 200000, 'Masuk', 'Tab masuk', '2024-05-26 09:03:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (521, 1, 140, 0, '2024-05-26', 2150000, 'Masuk', 'Tab masuk', '2024-05-26 10:29:21');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (522, 1, 141, 0, '2024-05-26', 739000, 'Masuk', 'Tab masuk', '2024-05-26 10:30:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (523, 1, 127, 0, '2024-05-26', 10000, 'Masuk', 'Tab masuk', '2024-05-26 10:58:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (524, 1, 70, 0, '2024-05-26', 90000, 'Masuk', 'Tab masuk 24,25,26/5/24', '2024-05-26 11:39:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (525, 1, 10, 0, '2024-05-26', 20000, 'Masuk', 'Tab masuk', '2024-05-26 11:40:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (526, 1, 45, 0, '2024-05-26', 10000, 'Masuk', 'Tab masuk', '2024-05-26 11:41:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (527, 1, 23, 0, '2024-05-26', 20000, 'Masuk', 'Tab masuk', '2024-05-26 11:42:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (528, 1, 33, 0, '2024-05-26', 10000, 'Masuk', 'Tab masuk', '2024-05-26 11:42:43');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (529, 1, 47, 0, '2024-05-26', 50000, 'Masuk', 'Tab masuk', '2024-05-26 11:43:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (530, 1, 27, 0, '2024-05-26', 30000, 'Masuk', 'Tab masuk', '2024-05-26 11:44:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (531, 1, 38, 0, '2024-05-26', 10000, 'Masuk', 'Tab masuk', '2024-05-26 11:45:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (532, 1, 113, 0, '2024-05-26', 50000, 'Masuk', 'Tab masuk', '2024-05-26 11:46:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (533, 1, 30, 0, '2024-05-26', 20000, 'Masuk', 'Tab masuk', '2024-05-26 11:49:52');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (534, 1, 112, 0, '2024-05-26', 10000, 'Masuk', 'Tab masuk', '2024-05-26 17:06:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (535, 1, 37, 0, '2024-05-26', 10000, 'Masuk', 'Tab masuk', '2024-05-26 17:07:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (536, 1, 28, 0, '2024-05-26', 30000, 'Masuk', 'Tab masuk', '2024-05-26 17:08:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (537, 1, 39, 0, '2024-05-26', 30000, 'Masuk', 'Tab masuk', '2024-05-26 17:09:20');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (538, 1, 24, 0, '2024-05-26', 10000, 'Masuk', 'Tab masuk', '2024-05-26 17:09:56');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (539, 1, 41, 0, '2024-05-26', 2000, 'Masuk', 'Tab masuk', '2024-05-26 17:10:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (540, 1, 31, 0, '2024-05-26', 50000, 'Masuk', 'Tab masuk', '2024-05-26 17:14:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (541, 1, 32, 0, '2024-05-26', 10000, 'Masuk', 'Tab masuk', '2024-05-26 17:14:58');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (542, 1, 117, 0, '2024-05-26', 50000, 'Masuk', 'Tab masuk', '2024-05-26 17:15:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (543, 1, 133, 0, '2024-05-26', 100000, 'Masuk', 'Tab masuk', '2024-05-26 17:16:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (544, 1, 54, 0, '2024-05-26', 30000, 'Masuk', 'Tab masuk', '2024-05-26 17:16:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (545, 1, 79, 0, '2024-05-26', 15000, 'Masuk', 'Tab masuk', '2024-05-26 17:20:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (546, 1, 90, 0, '2024-05-26', 65000, 'Masuk', 'Tab masuk', '2024-05-26 17:21:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (547, 1, 78, 0, '2024-05-26', 10000, 'Masuk', 'Tab masuk', '2024-05-26 17:21:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (548, 1, 88, 0, '2024-05-26', 10000, 'Masuk', 'Tab masuk', '2024-05-26 17:22:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (549, 1, 11, 0, '2024-05-26', 100000, 'Masuk', 'Tab masuk', '2024-05-26 17:23:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (550, 1, 15, 0, '2024-05-26', 30000, 'Masuk', 'Tab masuk', '2024-05-26 17:23:58');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (551, 1, 14, 0, '2024-05-26', 30000, 'Masuk', 'Tab masuk', '2024-05-26 17:24:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (552, 1, 121, 0, '2024-05-26', 10000, 'Masuk', 'Tab masuk', '2024-05-26 17:25:21');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (553, 1, 92, 0, '2024-05-26', 20000, 'Masuk', 'Tab masuk', '2024-05-26 18:29:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (554, 1, 6, 0, '2024-05-26', 10000, 'Masuk', 'Tab masuk', '2024-05-26 18:29:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (555, 1, 108, 0, '2024-05-26', 20000, 'Masuk', 'Tab masuk', '2024-05-26 18:30:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (556, 1, 107, 0, '2024-05-26', 20000, 'Masuk', 'Tab masuk', '2024-05-26 18:31:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (557, 1, 119, 0, '2024-05-26', 10000, 'Masuk', 'Tab masuk', '2024-05-26 18:32:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (558, 1, 21, 0, '2024-05-26', 100000, 'Masuk', 'Tab masuk', '2024-05-26 18:32:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (559, 1, 22, 0, '2024-05-26', 100000, 'Masuk', 'Tab masuk', '2024-05-26 18:33:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (560, 1, 20, 0, '2024-05-26', 20000, 'Masuk', 'Tab masuk', '2024-05-26 19:29:43');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (561, 1, 19, 0, '2024-05-26', 20000, 'Masuk', 'Tab masuk', '2024-05-26 19:30:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (562, 1, 139, 0, '2024-05-26', 50000, 'Masuk', 'Tab masuk', '2024-05-26 19:30:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (563, 1, 91, 0, '2024-05-26', 20000, 'Masuk', 'Tab masuk', '2024-05-26 19:31:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (564, 1, 106, 0, '2024-05-26', 50000, 'Masuk', 'Tab masuk', '2024-05-26 19:31:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (565, 1, 131, 0, '2024-05-26', 50000, 'Masuk', 'Tab masuk', '2024-05-26 19:41:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (566, 1, 66, 0, '2024-05-26', 15000, 'Masuk', 'Tab masuk', '2024-05-26 19:42:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (567, 1, 95, 0, '2024-05-26', 15000, 'Masuk', 'Tab masuk', '2024-05-26 19:43:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (568, 1, 98, 0, '2024-05-26', 10000, 'Masuk', 'Tab masuk', '2024-05-26 19:43:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (569, 1, 135, 0, '2024-05-26', 10000, 'Masuk', 'Tab masuk', '2024-05-26 19:44:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (570, 1, 58, 0, '2024-05-26', 20000, 'Masuk', 'Tab masuk', '2024-05-26 19:45:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (571, 1, 64, 0, '2024-05-26', 5000, 'Masuk', 'Tab masuk', '2024-05-26 19:45:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (572, 1, 57, 0, '2024-05-26', 20000, 'Masuk', 'Tab masuk', '2024-05-27 06:19:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (573, 1, 55, 0, '2024-05-26', 10000, 'Masuk', 'Tab masuk', '2024-05-27 06:19:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (574, 1, 56, 0, '2024-05-26', 2000, 'Masuk', 'Tab masuk', '2024-05-27 06:20:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (575, 1, 12, 0, '2024-05-26', 30000, 'Masuk', 'Tab masuk', '2024-05-27 06:20:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (576, 1, 7, 0, '2024-05-26', 10000, 'Masuk', 'Tab masuk', '2024-05-27 06:21:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (577, 1, 9, 0, '2024-05-26', 20000, 'Masuk', 'Tab masuk', '2024-05-27 06:21:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (578, 1, 111, 0, '2024-05-26', 50000, 'Masuk', 'Tab masuk', '2024-05-27 06:22:20');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (579, 1, 129, 0, '2024-05-26', 50000, 'Masuk', 'Tab masuk', '2024-05-27 06:22:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (580, 1, 124, 0, '2024-05-26', 100000, 'Masuk', 'Tab masuk', '2024-05-27 06:23:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (581, 1, 137, 0, '2024-05-26', 20000, 'Masuk', 'Tab masuk', '2024-05-27 06:23:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (582, 1, 68, 0, '2024-05-26', 250000, 'Masuk', 'Tab masuk', '2024-05-27 06:24:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (583, 1, 125, 0, '2024-05-26', 20000, 'Masuk', 'Tab masuk', '2024-05-27 06:25:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (584, 1, 126, 0, '2024-05-26', 10000, 'Masuk', 'Tab masuk', '2024-05-27 06:25:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (585, 1, 40, 0, '2024-05-27', 20000, 'Masuk', 'Tab masuk', '2024-05-27 06:45:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (586, 1, 74, 0, '2024-05-27', 25000, 'Masuk', 'Tab masuk', '2024-05-27 07:51:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (587, 1, 142, 0, '2024-05-27', 255000, 'Masuk', 'Tab masuk', '2024-05-27 07:54:26');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (588, 1, 87, 0, '2024-05-27', 10000, 'Masuk', 'Tab masuk', '2024-05-27 08:00:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (589, 1, 88, 0, '2024-05-27', 10000, 'Masuk', 'Tab masuk', '2024-05-27 08:00:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (590, 1, 85, 0, '2024-05-27', 10000, 'Masuk', 'Tab masuk', '2024-05-27 08:02:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (591, 1, 86, 0, '2024-05-27', 10000, 'Masuk', 'Tab masuk', '2024-05-27 08:02:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (592, 1, 84, 0, '2024-05-27', 20000, 'Masuk', 'Tab masuk', '2024-05-27 08:03:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (593, 1, 79, 0, '2024-05-27', 5000, 'Masuk', 'Tab masuk', '2024-05-27 08:04:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (594, 1, 143, 0, '2024-05-27', 50000, 'Masuk', 'Tab masuk', '2024-05-27 08:06:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (595, 1, 143, 0, '2024-05-15', 340000, 'Masuk', 'Tab masuk', '2024-05-27 08:07:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (596, 1, 144, 0, '2024-05-27', 80000, 'Masuk', 'Tab masuk', '2024-05-27 08:18:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (597, 1, 91, 0, '2024-05-27', 1900000, 'Keluar', 'Tab masuk', '2024-05-27 08:25:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (598, 1, 145, 0, '2024-05-27', 670000, 'Masuk', 'Tab masuk', '2024-05-27 09:23:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (599, 1, 124, 0, '2024-05-27', 100000, 'Masuk', 'Tab masuk', '2024-05-27 10:50:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (600, 1, 111, 0, '2024-05-27', 50000, 'Masuk', 'Tab masuk', '2024-05-27 10:51:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (601, 1, 106, 0, '2024-05-27', 50000, 'Masuk', 'Tab masuk', '2024-05-27 10:52:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (602, 1, 131, 0, '2024-05-27', 50000, 'Masuk', 'Tab masuk', '2024-05-27 10:52:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (603, 1, 19, 0, '2024-05-27', 30000, 'Masuk', 'Tab masuk', '2024-05-27 10:53:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (604, 1, 22, 0, '2024-05-27', 100000, 'Masuk', 'Tab masuk', '2024-05-27 10:53:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (605, 1, 133, 0, '2024-05-27', 100000, 'Masuk', 'Tab masuk', '2024-05-27 10:54:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (606, 1, 91, 0, '2024-05-27', 20000, 'Masuk', 'Tab masuk', '2024-05-27 10:54:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (607, 1, 20, 0, '2024-05-27', 220000, 'Masuk', 'Tab masuk', '2024-05-27 10:55:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (608, 1, 139, 0, '2024-05-27', 100000, 'Masuk', 'Tab masuk', '2024-05-27 10:55:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (609, 1, 21, 0, '2024-05-27', 100000, 'Masuk', 'Tab masuk', '2024-05-27 10:56:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (610, 1, 137, 0, '2024-05-27', 20000, 'Masuk', 'Tab masuk', '2024-05-27 10:56:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (611, 1, 129, 0, '2024-05-27', 50000, 'Masuk', 'Tab masuk', '2024-05-27 10:57:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (612, 1, 116, 0, '2024-05-27', 50000, 'Masuk', 'Tab masuk', '2024-05-27 11:12:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (613, 1, 146, 0, '2024-05-27', 200000, 'Masuk', 'Tab masuk', '2024-05-27 11:16:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (614, 1, 70, 0, '2024-05-27', 30000, 'Masuk', 'Tab masuk', '2024-05-27 11:20:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (615, 1, 119, 0, '2024-05-27', 10000, 'Masuk', 'Tab masuk', '2024-05-27 11:55:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (616, 1, 107, 0, '2024-05-27', 20000, 'Masuk', 'Tab masuk', '2024-05-27 11:56:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (617, 1, 108, 0, '2024-05-27', 20000, 'Masuk', 'Tab masuk', '2024-05-27 11:57:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (618, 1, 6, 0, '2024-05-27', 10000, 'Masuk', 'Tab masuk', '2024-05-27 11:57:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (619, 1, 10, 0, '2024-05-27', 20000, 'Masuk', 'Tab masuk', '2024-05-27 11:58:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (620, 1, 12, 0, '2024-05-27', 30000, 'Masuk', 'Tab masuk', '2024-05-27 11:59:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (621, 1, 57, 0, '2024-05-27', 20000, 'Masuk', 'Tab masuk', '2024-05-27 11:59:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (622, 1, 58, 0, '2024-05-27', 20000, 'Masuk', 'Tab masuk', '2024-05-27 12:00:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (623, 1, 64, 0, '2024-05-27', 2000, 'Masuk', 'Tab masuk', '2024-05-27 12:00:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (624, 1, 94, 0, '2024-05-27', 10000, 'Masuk', 'Tab masuk', '2024-05-27 12:11:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (625, 1, 98, 0, '2024-05-27', 10000, 'Masuk', 'Tab masuk', '2024-05-27 12:12:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (626, 1, 66, 0, '2024-05-27', 15000, 'Masuk', 'Tab masuk', '2024-05-27 12:12:43');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (627, 1, 95, 0, '2024-05-27', 10000, 'Masuk', 'Tab masuk', '2024-05-27 12:13:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (628, 1, 14, 0, '2024-05-27', 20000, 'Masuk', 'Tab masuk', '2024-05-27 12:13:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (629, 1, 23, 0, '2024-05-27', 20000, 'Masuk', 'Tab masuk', '2024-05-27 13:52:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (630, 1, 33, 0, '2024-05-27', 10000, 'Masuk', 'Tab masuk', '2024-05-27 13:52:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (631, 1, 47, 0, '2024-05-27', 50000, 'Masuk', 'Tab masuk', '2024-05-27 13:52:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (632, 1, 46, 0, '2024-05-27', 10000, 'Masuk', 'Tab masuk', '2024-05-27 13:53:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (633, 1, 34, 0, '2024-05-27', 10000, 'Masuk', 'Tab masuk', '2024-05-27 13:53:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (634, 1, 100, 0, '2024-05-27', 50000, 'Masuk', 'Tab masuk', '2024-05-27 13:54:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (635, 1, 38, 0, '2024-05-27', 50000, 'Masuk', 'Tab masuk', '2024-05-27 13:55:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (636, 1, 68, 0, '2024-05-27', 350000, 'Masuk', 'Tab masuk', '2024-05-27 13:55:58');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (637, 1, 48, 0, '2024-05-27', 10000, 'Masuk', 'Tab masuk', '2024-05-27 13:56:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (638, 1, 37, 0, '2024-05-27', 10000, 'Masuk', 'Tab masuk', '2024-05-27 13:57:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (639, 1, 112, 0, '2024-05-27', 10000, 'Masuk', 'Tab masuk', '2024-05-27 14:27:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (640, 1, 28, 0, '2024-05-27', 30000, 'Masuk', 'Tab masuk', '2024-05-27 14:29:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (641, 1, 128, 0, '2024-05-27', 50000, 'Masuk', 'Tab masuk', '2024-05-27 14:29:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (642, 1, 39, 0, '2024-05-27', 20000, 'Masuk', 'Tab masuk', '2024-05-27 14:30:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (643, 1, 31, 0, '2024-05-27', 50000, 'Masuk', 'Tab masuk', '2024-05-27 14:30:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (644, 1, 24, 0, '2024-05-27', 10000, 'Masuk', 'Tab masuk', '2024-05-27 14:31:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (645, 1, 41, 0, '2024-05-27', 2000, 'Masuk', 'Tab masuk', '2024-05-27 14:31:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (646, 1, 69, 0, '2024-05-27', 20000, 'Masuk', 'Tab masuk', '2024-05-27 14:32:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (647, 1, 117, 0, '2024-05-27', 50000, 'Masuk', 'Tab masuk', '2024-05-27 14:32:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (648, 1, 54, 0, '2024-05-27', 30000, 'Masuk', 'Tab masuk', '2024-05-27 14:33:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (649, 1, 11, 0, '2024-05-27', 100000, 'Masuk', 'Tab masuk', '2024-05-27 14:34:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (650, 1, 15, 0, '2024-05-27', 20000, 'Masuk', 'Tab masuk', '2024-05-27 14:34:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (651, 1, 40, 0, '2024-05-28', 20000, 'Masuk', 'Tab masuk', '2024-05-28 07:14:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (652, 1, 21, 0, '2024-05-28', 3200000, 'Keluar', 'Tab keluar', '2024-05-28 09:35:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (653, 1, 101, 0, '2024-05-28', 2050000, 'Keluar', 'Tab keluar', '2024-05-28 09:36:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (654, 1, 19, 0, '2024-05-28', 20000, 'Masuk', 'Tab masuk', '2024-05-28 10:44:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (655, 1, 7, 0, '2024-05-28', 10000, 'Masuk', 'Tab masuk', '2024-05-28 10:44:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (656, 1, 108, 0, '2024-05-28', 20000, 'Masuk', 'Tab masuk', '2024-05-28 10:46:21');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (657, 1, 9, 0, '2024-05-28', 60000, 'Masuk', 'Tab masuk', '2024-05-28 10:47:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (658, 1, 23, 0, '2024-05-28', 20000, 'Masuk', 'Tab masuk', '2024-05-28 10:47:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (659, 1, 46, 0, '2024-05-28', 10000, 'Masuk', 'Tab masuk', '2024-05-28 10:48:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (660, 1, 136, 0, '2024-05-28', 121000, 'Masuk', 'Tab masuk', '2024-05-28 10:48:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (661, 1, 87, 0, '2024-05-28', 10000, 'Masuk', 'Tab masuk', '2024-05-28 10:49:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (662, 1, 79, 0, '2024-05-28', 5000, 'Masuk', 'Tab masuk', '2024-05-28 10:50:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (663, 1, 88, 0, '2024-05-28', 10000, 'Masuk', 'Tab masuk', '2024-05-28 10:50:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (664, 1, 38, 0, '2024-05-28', 10000, 'Masuk', 'Tab masuk', '2024-05-28 10:50:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (665, 1, 113, 0, '2024-05-28', 25000, 'Masuk', 'Tab masuk', '2024-05-28 10:51:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (666, 1, 25, 0, '2024-05-28', 20000, 'Masuk', 'Tab masuk', '2024-05-28 10:51:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (667, 1, 30, 0, '2024-05-28', 20000, 'Masuk', 'Tab masuk', '2024-05-28 10:52:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (668, 1, 30, 0, '2024-05-28', 20000, 'Masuk', 'Tab masuk', '2024-05-28 11:23:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (669, 1, 37, 0, '2024-05-28', 10000, 'Masuk', 'Tab masuk', '2024-05-28 11:24:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (670, 1, 28, 0, '2024-05-28', 30000, 'Masuk', 'Tab masuk', '2024-05-28 11:25:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (671, 1, 128, 0, '2024-05-28', 50000, 'Masuk', 'Tab masuk', '2024-05-28 11:25:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (672, 1, 39, 0, '2024-05-28', 30000, 'Masuk', 'Tab masuk', '2024-05-28 11:28:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (673, 1, 13, 0, '2024-05-28', 300000, 'Masuk', 'Tab masuk', '2024-05-28 11:29:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (674, 1, 24, 0, '2024-05-28', 10000, 'Masuk', 'Tab masuk', '2024-05-28 11:29:58');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (675, 1, 41, 0, '2024-05-28', 2000, 'Masuk', 'Tab masuk', '2024-05-28 11:30:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (676, 1, 69, 0, '2024-05-28', 10000, 'Masuk', 'Tab masuk', '2024-05-28 11:30:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (677, 1, 117, 0, '2024-05-28', 50000, 'Masuk', 'Tab masuk', '2024-05-28 11:31:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (678, 1, 106, 0, '2024-05-28', 30000, 'Masuk', 'Tab masuk', '2024-05-28 11:31:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (679, 1, 131, 0, '2024-05-28', 25000, 'Masuk', 'Tab masuk', '2024-05-28 11:31:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (680, 1, 20, 0, '2024-05-28', 20000, 'Masuk', 'Tab masuk', '2024-05-28 11:32:43');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (681, 1, 6, 0, '2024-05-28', 10000, 'Masuk', 'Tab masuk', '2024-05-28 11:40:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (682, 1, 92, 0, '2024-05-28', 20000, 'Masuk', 'Tab masuk', '2024-05-28 11:41:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (683, 1, 119, 0, '2024-05-28', 10000, 'Masuk', 'Tab masuk', '2024-05-28 11:42:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (684, 1, 107, 0, '2024-05-28', 20000, 'Masuk', 'Tab masuk', '2024-05-28 11:42:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (685, 1, 133, 0, '2024-05-28', 100000, 'Masuk', 'Tab masuk', '2024-05-28 11:42:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (686, 1, 54, 0, '2024-05-28', 30000, 'Masuk', 'Tab masuk', '2024-05-28 11:43:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (687, 1, 11, 0, '2024-05-28', 100000, 'Masuk', 'Tab masuk', '2024-05-28 11:43:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (688, 1, 15, 0, '2024-05-28', 30000, 'Masuk', 'Tab masuk', '2024-05-28 11:44:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (689, 1, 14, 0, '2024-05-28', 30000, 'Masuk', 'Tab masuk', '2024-05-28 11:44:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (690, 1, 111, 0, '2024-05-28', 50000, 'Masuk', 'Tab masuk', '2024-05-28 11:45:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (691, 1, 95, 0, '2024-05-28', 15000, 'Masuk', 'Tab masuk', '2024-05-28 11:45:26');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (692, 1, 66, 0, '2024-05-28', 15000, 'Masuk', 'Tab masuk', '2024-05-28 11:45:52');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (693, 1, 94, 0, '2024-05-28', 10000, 'Masuk', 'Tab masuk', '2024-05-28 11:46:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (694, 1, 135, 0, '2024-05-28', 10000, 'Masuk', 'Tab masuk', '2024-05-28 11:46:58');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (695, 1, 58, 0, '2024-05-28', 20000, 'Masuk', 'Tab masuk', '2024-05-28 11:48:20');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (696, 1, 57, 0, '2024-05-28', 20000, 'Masuk', 'Tab masuk', '2024-05-28 11:48:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (697, 1, 55, 0, '2024-05-28', 10000, 'Masuk', 'Tab masuk', '2024-05-28 11:49:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (698, 1, 56, 0, '2024-05-28', 2000, 'Masuk', 'Tab masuk', '2024-05-28 11:50:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (699, 1, 10, 0, '2024-05-28', 20000, 'Masuk', 'Tab masuk', '2024-05-28 11:50:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (700, 1, 12, 0, '2024-05-28', 30000, 'Masuk', 'Tab masuk', '2024-05-28 11:51:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (701, 1, 91, 0, '2024-05-28', 20000, 'Masuk', 'Tab masuk', '2024-05-28 11:52:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (702, 1, 139, 0, '2024-05-28', 50000, 'Masuk', 'Tab masuk', '2024-05-28 11:52:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (703, 1, 22, 0, '2024-05-28', 100000, 'Masuk', 'Tab masuk', '2024-05-28 11:55:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (704, 1, 68, 0, '2024-05-28', 200000, 'Masuk', 'Tab masuk', '2024-05-28 13:52:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (705, 1, 137, 0, '2024-05-28', 20000, 'Masuk', 'Tab masuk', '2024-05-28 13:52:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (706, 1, 125, 0, '2024-05-28', 20000, 'Masuk', 'Tab masuk', '2024-05-28 13:53:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (707, 1, 126, 0, '2024-05-28', 10000, 'Masuk', 'Tab masuk', '2024-05-28 13:53:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (708, 1, 129, 0, '2024-05-28', 50000, 'Masuk', 'Tab masuk', '2024-05-28 13:53:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (709, 1, 130, 0, '2024-05-28', 10000, 'Masuk', 'Tab masuk', '2024-05-28 13:54:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (710, 1, 45, 0, '2024-05-28', 5000, 'Masuk', 'Tab masuk', '2024-05-28 13:55:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (711, 1, 122, 0, '2024-05-28', 270000, 'Keluar', 'Tab keluar', '2024-05-28 14:33:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (712, 1, 112, 0, '2024-05-22', 10000, 'Masuk', 'Tab masuk', '2024-05-29 06:18:58');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (713, 1, 112, 0, '2024-05-24', 10000, 'Masuk', 'Tab masuk', '2024-05-29 06:20:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (714, 1, 112, 0, '2024-05-28', 10000, 'Masuk', 'Tab masuk', '2024-05-29 06:21:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (715, 1, 29, 0, '2024-05-20', 5000, 'Masuk', 'Tab masuk', '2024-05-29 06:26:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (716, 1, 29, 0, '2024-05-24', 5000, 'Masuk', 'Tab masuk', '2024-05-29 06:27:21');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (717, 1, 29, 0, '2024-05-25', 5000, 'Masuk', 'Tab masuk', '2024-05-29 06:27:52');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (718, 1, 29, 0, '2024-05-27', 5000, 'Masuk', 'Tab masuk', '2024-05-29 06:28:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (719, 1, 29, 0, '2024-05-28', 5000, 'Masuk', 'Tab masuk', '2024-05-29 06:29:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (720, 1, 131, 0, '2024-05-29', 545000, 'Keluar', 'Tab keluar', '2024-05-29 07:21:43');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (721, 1, 106, 0, '2024-05-29', 955000, 'Keluar', 'Tab keluar', '2024-05-29 07:22:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (722, 1, 147, 0, '2024-05-28', 10000, 'Masuk', 'Tab masuk', '2024-05-29 07:34:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (723, 1, 145, 0, '2024-05-29', 490000, 'Keluar', 'Tab keluar', '2024-05-29 08:23:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (724, 1, 148, 0, '2024-05-29', 10000, 'Masuk', 'Tab masuk', '2024-05-29 08:47:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (725, 1, 68, 0, '2024-05-29', 200000, 'Masuk', 'Tab masuk', '2024-05-29 08:52:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (726, 1, 33, 0, '2024-05-29', 393000, 'Keluar', 'Tab keluar', '2024-05-29 09:31:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (727, 1, 33, 0, '2024-05-29', 10000, 'Masuk', 'Tab masuk', '2024-05-29 09:36:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (728, 1, 55, 0, '2024-05-29', 10000, 'Masuk', 'Tab masuk', '2024-05-29 10:15:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (729, 1, 56, 0, '2024-05-29', 2000, 'Masuk', 'Tab masuk', '2024-05-29 10:15:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (730, 1, 148, 0, '2024-05-29', 5000, 'Masuk', 'Tab masuk', '2024-05-29 10:16:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (731, 1, 135, 0, '2024-05-29', 10000, 'Masuk', 'Tab masuk', '2024-05-29 10:16:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (732, 1, 98, 0, '2024-05-29', 10000, 'Masuk', 'Tab masuk', '2024-05-29 10:17:26');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (733, 1, 45, 0, '2024-05-29', 5000, 'Masuk', 'Tab masuk', '2024-05-29 10:17:52');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (734, 1, 121, 0, '2024-05-29', 10000, 'Masuk', 'Tab masuk', '2024-05-29 10:18:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (735, 1, 23, 0, '2024-05-29', 20000, 'Masuk', 'Tab masuk', '2024-05-29 10:18:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (736, 1, 116, 0, '2024-05-29', 50000, 'Masuk', 'Tab masuk', '2024-05-29 10:22:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (737, 1, 46, 0, '2024-05-29', 10000, 'Masuk', 'Tab masuk', '2024-05-29 10:27:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (738, 1, 47, 0, '2024-05-29', 50000, 'Masuk', 'Tab masuk', '2024-05-29 10:27:23');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (739, 1, 36, 0, '2024-05-29', 5000, 'Masuk', 'Tab masuk', '2024-05-29 10:28:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (740, 1, 35, 0, '2024-05-29', 200000, 'Masuk', 'Tab masuk', '2024-05-29 10:28:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (741, 1, 27, 0, '2024-05-29', 30000, 'Masuk', 'Tab masuk', '2024-05-29 10:30:23');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (742, 1, 48, 0, '2024-05-29', 10000, 'Masuk', 'Tab masuk', '2024-05-29 10:31:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (743, 1, 38, 0, '2024-05-29', 10000, 'Masuk', 'Tab masuk', '2024-05-29 10:32:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (744, 1, 116, 0, '2024-05-28', 50000, 'Masuk', 'Tab masuk', '2024-05-29 10:32:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (745, 1, 25, 0, '2024-05-29', 20000, 'Masuk', 'Tab masuk', '2024-05-29 10:35:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (746, 1, 113, 0, '2024-05-29', 50000, 'Masuk', 'Tab masuk', '2024-05-29 10:35:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (747, 1, 112, 0, '2024-05-29', 10000, 'Masuk', 'Tab masuk', '2024-05-29 10:46:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (748, 1, 30, 0, '2024-05-29', 20000, 'Masuk', 'Tab masuk', '2024-05-29 10:47:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (749, 1, 37, 0, '2024-05-29', 10000, 'Masuk', 'Tab masuk', '2024-05-29 10:47:58');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (750, 1, 26, 0, '2024-05-29', 50000, 'Masuk', 'Tab masuk', '2024-05-29 10:50:20');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (751, 1, 29, 0, '2024-05-29', 5000, 'Masuk', 'Tab masuk', '2024-05-29 11:33:43');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (752, 1, 39, 0, '2024-05-29', 30000, 'Masuk', 'Tab masuk', '2024-05-29 11:34:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (753, 1, 58, 0, '2024-05-29', 20000, 'Masuk', 'Tab masuk', '2024-05-29 11:34:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (754, 1, 64, 0, '2024-05-29', 5000, 'Masuk', 'Tab masuk', '2024-05-29 11:35:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (755, 1, 13, 0, '2024-05-29', 150000, 'Masuk', 'Tab masuk', '2024-05-29 11:39:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (756, 1, 31, 0, '2024-05-29', 50000, 'Masuk', 'Tab masuk', '2024-05-29 11:41:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (757, 1, 32, 0, '2024-05-29', 10000, 'Masuk', 'Tab masuk', '2024-05-29 11:42:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (758, 1, 69, 0, '2024-05-29', 10000, 'Masuk', 'Tab masuk', '2024-05-29 11:42:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (759, 1, 117, 0, '2024-05-29', 50000, 'Masuk', 'Tab masuk', '2024-05-29 11:43:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (760, 1, 133, 0, '2024-05-29', 100000, 'Masuk', 'Tab masuk', '2024-05-29 11:43:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (761, 1, 147, 0, '2024-05-29', 10000, 'Masuk', 'Tab masuk', '2024-05-29 11:44:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (762, 1, 54, 0, '2024-05-29', 30000, 'Masuk', 'Tab masuk', '2024-05-29 11:48:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (763, 1, 87, 0, '2024-05-29', 10000, 'Masuk', 'Tab masuk', '2024-05-29 11:51:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (764, 1, 73, 0, '2024-05-29', 64000, 'Masuk', 'Tab masuk', '2024-05-29 11:52:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (765, 1, 80, 0, '2024-05-29', 30000, 'Masuk', 'Tab masuk', '2024-05-29 11:52:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (766, 1, 77, 0, '2024-05-29', 15000, 'Masuk', 'Tab masuk', '2024-05-29 11:53:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (767, 1, 85, 0, '2024-05-29', 10000, 'Masuk', 'Tab masuk', '2024-05-29 11:54:21');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (768, 1, 6, 0, '2024-05-29', 20000, 'Masuk', 'Tab masuk', '2024-05-29 11:54:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (769, 1, 76, 0, '2024-05-29', 20000, 'Masuk', 'Tab masuk', '2024-05-29 11:56:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (770, 1, 11, 0, '2024-05-29', 100000, 'Masuk', 'Tab masuk', '2024-05-29 11:56:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (771, 1, 15, 0, '2024-05-29', 20000, 'Masuk', 'Tab masuk', '2024-05-29 11:57:23');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (772, 1, 14, 0, '2024-05-29', 20000, 'Masuk', 'Tab masuk', '2024-05-29 11:57:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (773, 1, 138, 0, '2024-05-29', 30000, 'Masuk', 'Tab masuk', '2024-05-29 11:58:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (774, 1, 66, 0, '2024-05-29', 15000, 'Masuk', 'Tab masuk', '2024-05-29 11:58:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (775, 1, 95, 0, '2024-05-29', 15000, 'Masuk', 'Tab masuk', '2024-05-29 11:58:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (776, 1, 21, 0, '2024-05-29', 100000, 'Masuk', 'Tab masuk', '2024-05-29 13:19:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (777, 1, 22, 0, '2024-05-29', 100000, 'Masuk', 'Tab masuk', '2024-05-29 13:20:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (778, 1, 101, 0, '2024-05-29', 100000, 'Masuk', 'Tab masuk', '2024-05-29 13:21:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (779, 1, 150, 0, '2024-05-29', 50000, 'Masuk', 'Tab masuk', '2024-05-29 13:25:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (780, 1, 99, 0, '2024-05-29', 100000, 'Masuk', 'Tab masuk', '2024-05-29 13:26:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (781, 1, 99, 0, '2024-05-22', 100000, 'Masuk', 'Tab masuk', '2024-05-29 13:27:58');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (782, 1, 102, 0, '2024-05-22', 10000, 'Masuk', 'Tab masuk', '2024-05-29 13:31:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (783, 1, 102, 0, '2024-05-23', 10000, 'Masuk', 'Tab masuk', '2024-05-29 13:31:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (784, 1, 102, 0, '2024-05-25', 10000, 'Masuk', 'Tab masuk', '2024-05-29 13:32:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (785, 1, 102, 0, '2024-05-29', 10000, 'Masuk', 'Tab masuk', '2024-05-29 13:32:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (786, 1, 102, 0, '2024-05-26', 10000, 'Masuk', 'Tab masuk', '2024-05-29 13:33:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (787, 1, 103, 0, '2024-05-21', 5000, 'Masuk', 'Tab masuk', '2024-05-29 13:49:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (788, 1, 103, 0, '2024-05-22', 5000, 'Masuk', 'Tab masuk', '2024-05-29 13:49:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (789, 1, 103, 0, '2024-05-23', 5000, 'Masuk', 'Tab masuk', '2024-05-29 13:50:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (790, 1, 103, 0, '2024-05-24', 5000, 'Masuk', 'Tab masuk', '2024-05-29 13:50:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (791, 1, 103, 0, '2024-05-25', 5000, 'Masuk', 'Tab masuk', '2024-05-29 13:51:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (792, 1, 103, 0, '2024-05-26', 5000, 'Masuk', 'Tab masuk', '2024-05-29 13:51:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (793, 1, 103, 0, '2024-05-29', 5000, 'Masuk', 'Tab masuk', '2024-05-29 13:53:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (794, 1, 118, 0, '2024-05-23', 5000, 'Masuk', 'Tab masuk', '2024-05-29 13:54:23');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (795, 1, 118, 0, '2024-05-26', 5000, 'Masuk', 'Tab masuk', '2024-05-29 14:05:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (796, 1, 118, 0, '2024-05-29', 5000, 'Masuk', 'Tab masuk', '2024-05-29 14:06:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (797, 1, 139, 0, '2024-05-29', 50000, 'Masuk', 'Tab masuk', '2024-05-29 14:06:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (798, 1, 20, 0, '2024-05-29', 20000, 'Masuk', 'Tab masuk', '2024-05-29 14:06:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (799, 1, 19, 0, '2024-05-29', 20000, 'Masuk', 'Tab masuk', '2024-05-29 14:07:20');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (800, 1, 9, 0, '2024-05-29', 200000, 'Masuk', 'Tab masuk', '2024-05-29 14:07:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (801, 1, 12, 0, '2024-05-29', 30000, 'Masuk', 'Tab masuk', '2024-05-29 14:08:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (802, 1, 137, 0, '2024-05-29', 20000, 'Masuk', 'Tab masuk', '2024-05-29 14:08:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (803, 1, 106, 0, '2024-05-29', 30000, 'Masuk', 'Tab masuk', '2024-05-29 14:09:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (804, 1, 91, 0, '2024-05-29', 20000, 'Masuk', 'Tab masuk', '2024-05-29 14:09:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (805, 1, 126, 0, '2024-05-29', 10000, 'Masuk', 'Tab masuk', '2024-05-29 14:10:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (806, 1, 151, 0, '2024-05-29', 70000, 'Masuk', 'Tab masuk', '2024-05-29 14:14:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (807, 1, 125, 0, '2024-05-29', 20000, 'Masuk', 'Tab masuk', '2024-05-29 16:00:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (808, 1, 124, 0, '2024-05-29', 50000, 'Masuk', 'Tab masuk', '2024-05-29 16:00:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (809, 1, 111, 0, '2024-05-29', 50000, 'Masuk', 'Tab masuk', '2024-05-29 16:00:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (810, 1, 107, 0, '2024-05-29', 20000, 'Masuk', 'Tab masuk', '2024-05-29 16:02:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (811, 1, 92, 0, '2024-05-29', 20000, 'Masuk', 'Tab masuk', '2024-05-29 16:03:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (812, 1, 119, 0, '2024-05-29', 10000, 'Masuk', 'Tab masuk', '2024-05-29 16:04:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (813, 1, 16, 0, '2024-05-29', 70000, 'Masuk', 'Tab masuk', '2024-05-29 16:04:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (814, 1, 18, 0, '2024-05-29', 20000, 'Masuk', 'Tab masuk', '2024-05-29 16:05:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (815, 1, 108, 0, '2024-05-29', 20000, 'Masuk', 'Tab masuk', '2024-05-29 16:06:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (816, 1, 10, 0, '2024-05-29', 20000, 'Masuk', 'Tab masuk', '2024-05-29 16:06:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (817, 1, 17, 0, '2024-05-29', 10000, 'Masuk', 'Tab masuk', '2024-05-29 16:43:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (818, 1, 118, 0, '2024-05-24', 5000, 'Masuk', 'tabungan masuk', '2024-05-29 20:17:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (819, 1, 118, 0, '2024-05-25', 5000, 'Masuk', 'tabungan masuk', '2024-05-29 20:18:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (820, 1, 40, 0, '2024-05-30', 20000, 'Masuk', 'Tab masuk', '2024-05-30 07:58:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (821, 1, 152, 0, '2024-05-30', 1500000, 'Masuk', 'Tab masuk', '2024-05-30 08:49:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (822, 1, 111, 0, '2024-05-30', 3000000, 'Keluar', 'Tab keluar', '2024-05-30 08:50:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (823, 1, 88, 0, '2024-05-30', 10000, 'Masuk', 'Tab masuk', '2024-05-30 09:34:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (824, 1, 78, 0, '2024-05-30', 150000, 'Masuk', 'Tab masuk', '2024-05-30 09:34:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (825, 1, 62, 0, '2024-05-30', 2100000, 'Masuk', 'Tab masuk', '2024-05-30 09:56:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (826, 1, 124, 0, '2024-05-30', 30000, 'Masuk', 'Tab masuk', '2024-05-30 10:39:58');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (827, 1, 137, 0, '2024-05-30', 20000, 'Masuk', 'Tab masuk', '2024-05-30 10:40:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (828, 1, 129, 0, '2024-05-30', 50000, 'Masuk', 'Tab masuk', '2024-05-30 10:40:52');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (829, 1, 130, 0, '2024-05-30', 10000, 'Masuk', 'Tab masuk', '2024-05-30 10:41:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (830, 1, 45, 0, '2024-05-30', 5000, 'Masuk', 'Tab masuk', '2024-05-30 10:41:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (831, 1, 70, 0, '2024-05-30', 30000, 'Masuk', 'Tab masuk', '2024-05-30 10:42:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (832, 1, 47, 0, '2024-05-30', 50000, 'Masuk', 'Tab masuk', '2024-05-30 10:42:52');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (833, 1, 35, 0, '2024-05-30', 200000, 'Masuk', 'Tab masuk', '2024-05-30 10:43:23');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (834, 1, 115, 0, '2024-05-30', 500000, 'Masuk', 'Tab masuk', '2024-05-30 10:48:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (835, 1, 114, 0, '2024-05-30', 5000, 'Masuk', 'Tab masuk', '2024-05-30 10:49:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (836, 1, 36, 0, '2024-05-30', 5000, 'Masuk', 'Tab masuk', '2024-05-30 10:50:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (837, 1, 46, 0, '2024-05-30', 10000, 'Masuk', 'Tab masuk', '2024-05-30 10:50:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (838, 1, 27, 0, '2024-05-30', 30000, 'Masuk', 'Tab masuk', '2024-05-30 10:51:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (839, 1, 147, 0, '2024-05-30', 10000, 'Masuk', 'Tab masuk', '2024-05-30 10:51:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (840, 1, 25, 0, '2024-05-30', 20000, 'Masuk', 'Tab masuk', '2024-05-30 11:31:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (841, 1, 113, 0, '2024-05-30', 50000, 'Masuk', 'Tab masuk', '2024-05-30 11:32:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (842, 1, 38, 0, '2024-05-30', 10000, 'Masuk', 'Tab masuk', '2024-05-30 11:32:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (843, 1, 68, 0, '2024-05-30', 200000, 'Masuk', 'Tab masuk', '2024-05-30 11:32:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (844, 1, 112, 0, '2024-05-30', 10000, 'Masuk', 'Tab masuk', '2024-05-30 11:33:21');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (845, 1, 30, 0, '2024-05-30', 20000, 'Masuk', 'Tab masuk', '2024-05-30 11:33:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (846, 1, 37, 0, '2024-05-30', 10000, 'Masuk', 'Tab masuk', '2024-05-30 11:34:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (847, 1, 24, 0, '2024-05-30', 10000, 'Masuk', 'Tab masuk', '2024-05-30 11:34:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (848, 1, 41, 0, '2024-05-30', 2000, 'Masuk', 'Tab masuk', '2024-05-30 11:35:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (849, 1, 31, 0, '2024-05-30', 50000, 'Masuk', 'Tab masuk', '2024-05-30 11:35:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (850, 1, 32, 0, '2024-05-30', 10000, 'Masuk', 'Tab masuk', '2024-05-30 11:36:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (851, 1, 69, 0, '2024-05-30', 10000, 'Masuk', 'Tab masuk', '2024-05-30 11:36:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (852, 1, 117, 0, '2024-05-30', 50000, 'Masuk', 'Tab masuk', '2024-05-30 11:36:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (853, 1, 57, 0, '2024-05-30', 20000, 'Masuk', 'Tab masuk', '2024-05-30 11:37:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (854, 1, 58, 0, '2024-05-30', 20000, 'Masuk', 'Tab masuk', '2024-05-30 11:37:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (855, 1, 64, 0, '2024-05-30', 2000, 'Masuk', 'Tab masuk', '2024-05-30 11:38:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (856, 1, 55, 0, '2024-05-30', 10000, 'Masuk', 'Tab masuk', '2024-05-30 11:39:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (857, 1, 56, 0, '2024-05-30', 2000, 'Masuk', 'Tab masuk', '2024-05-30 11:39:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (858, 1, 12, 0, '2024-05-30', 30000, 'Masuk', 'Tab masuk', '2024-05-30 11:40:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (859, 1, 16, 0, '2024-05-30', 70000, 'Masuk', 'Tab masuk', '2024-05-30 11:41:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (860, 1, 17, 0, '2024-05-30', 10000, 'Masuk', 'Tab masuk', '2024-05-30 11:41:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (861, 1, 18, 0, '2024-05-30', 20000, 'Masuk', 'Tab masuk', '2024-05-30 11:42:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (862, 1, 119, 0, '2024-05-30', 10000, 'Masuk', 'Tab masuk', '2024-05-30 11:42:52');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (863, 1, 92, 0, '2024-05-30', 20000, 'Masuk', 'Tab masuk', '2024-05-30 11:43:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (864, 1, 139, 0, '2024-05-30', 100000, 'Masuk', 'Tab masuk', '2024-05-30 11:43:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (865, 1, 20, 0, '2024-05-30', 20000, 'Masuk', 'Tab masuk', '2024-05-30 11:44:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (866, 1, 19, 0, '2024-05-30', 20000, 'Masuk', 'Tab masuk', '2024-05-30 11:44:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (867, 1, 21, 0, '2024-05-30', 100000, 'Masuk', 'Tab masuk', '2024-05-30 11:46:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (868, 1, 22, 0, '2024-05-30', 100000, 'Masuk', 'Tab masuk', '2024-05-30 11:46:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (869, 1, 29, 0, '2024-05-30', 5000, 'Masuk', 'Tab masuk', '2024-05-30 11:47:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (870, 1, 39, 0, '2024-05-30', 20000, 'Masuk', 'Tab masuk', '2024-05-30 11:47:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (871, 1, 91, 0, '2024-05-30', 20000, 'Masuk', 'Tab masuk', '2024-05-30 13:13:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (872, 1, 106, 0, '2024-05-30', 50000, 'Masuk', 'Tab masuk', '2024-05-30 13:14:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (873, 1, 99, 0, '2024-05-30', 100000, 'Masuk', 'Tab masuk', '2024-05-30 13:14:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (874, 1, 103, 0, '2024-05-30', 5000, 'Masuk', 'Tab masuk', '2024-05-30 13:14:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (875, 1, 118, 0, '2024-05-30', 5000, 'Masuk', 'Tab masuk', '2024-05-30 13:15:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (876, 1, 102, 0, '2024-05-30', 10000, 'Masuk', 'Tab masuk', '2024-05-30 13:15:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (877, 1, 101, 0, '2024-05-30', 100000, 'Masuk', 'Tab masuk', '2024-05-30 13:16:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (878, 1, 150, 0, '2024-05-30', 50000, 'Masuk', 'Tab masuk', '2024-05-30 13:16:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (879, 1, 54, 0, '2024-05-30', 30000, 'Masuk', 'Tab masuk', '2024-05-30 13:17:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (880, 1, 125, 0, '2024-05-30', 20000, 'Masuk', 'Tab masuk', '2024-05-30 13:17:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (881, 1, 126, 0, '2024-05-30', 10000, 'Masuk', 'Tab masuk', '2024-05-30 13:18:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (882, 1, 133, 0, '2024-05-30', 100000, 'Masuk', 'Tab masuk', '2024-05-30 13:18:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (883, 1, 87, 0, '2024-05-30', 10000, 'Masuk', 'Tab masuk', '2024-05-30 14:23:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (884, 1, 87, 0, '2024-05-30', 200000, 'Keluar', 'Tab keluar', '2024-05-30 14:24:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (885, 1, 151, 0, '2024-05-30', 10000, 'Masuk', 'Tab masuk', '2024-05-30 14:51:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (886, 1, 40, 0, '2024-05-31', 20000, 'Masuk', 'Tab masuk', '2024-05-31 07:15:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (887, 1, 55, 0, '2024-05-31', 10000, 'Masuk', 'Tab masuk', '2024-05-31 07:59:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (888, 1, 55, 0, '2024-05-31', 100000, 'Keluar', 'Tab keluar', '2024-05-31 08:00:20');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (889, 1, 56, 0, '2024-05-31', 2000, 'Masuk', 'Tab masuk', '2024-05-31 08:00:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (890, 1, 153, 0, '2024-05-31', 150000, 'Masuk', 'Tab masuk', '2024-05-31 08:58:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (891, 1, 96, 0, '2024-05-31', 380000, 'Keluar', 'Tab keluar', '2024-05-31 09:08:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (892, 1, 18, 0, '2024-05-31', 20000, 'Masuk', 'Tab masuk', '2024-05-31 10:01:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (893, 1, 17, 0, '2024-05-31', 10000, 'Masuk', 'Tab masuk', '2024-05-31 10:01:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (894, 1, 16, 0, '2024-05-31', 70000, 'Masuk', 'Tab masuk', '2024-05-31 10:02:20');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (895, 1, 23, 0, '2024-05-31', 20000, 'Masuk', 'Tab masuk', '2024-05-31 10:02:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (896, 1, 33, 0, '2024-05-31', 10000, 'Masuk', 'Tab masuk', '2024-05-31 10:03:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (897, 1, 46, 0, '2024-05-31', 10000, 'Masuk', 'Tab masuk', '2024-05-31 10:03:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (898, 1, 47, 0, '2024-05-31', 50000, 'Masuk', 'Tab masuk', '2024-05-31 10:03:52');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (899, 1, 34, 0, '2024-05-31', 5000, 'Masuk', 'Tab masuk', '2024-05-31 10:04:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (900, 1, 35, 0, '2024-05-31', 200000, 'Masuk', 'Tab masuk', '2024-05-31 10:04:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (901, 1, 36, 0, '2024-05-31', 5000, 'Masuk', 'Tab masuk', '2024-05-31 10:05:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (902, 1, 114, 0, '2024-05-31', 5000, 'Masuk', 'Tab masuk', '2024-05-31 10:05:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (903, 1, 34, 0, '2024-05-31', 10000, 'Masuk', 'Tab masuk', '2024-05-31 10:06:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (904, 1, 100, 0, '2024-05-31', 50000, 'Masuk', 'Tab masuk', '2024-05-31 10:06:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (905, 1, 38, 0, '2024-05-31', 10000, 'Masuk', 'Tab masuk', '2024-05-31 10:06:52');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (906, 1, 113, 0, '2024-05-31', 50000, 'Masuk', 'Tab masuk', '2024-05-31 10:07:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (907, 1, 145, 0, '2024-05-31', 10000, 'Masuk', 'Tab masuk', '2024-05-31 10:07:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (908, 1, 25, 0, '2024-05-31', 20000, 'Masuk', 'Tab masuk', '2024-05-31 10:07:58');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (909, 1, 30, 0, '2024-05-31', 20000, 'Masuk', 'Tab masuk', '2024-05-31 10:08:43');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (910, 1, 37, 0, '2024-05-31', 10000, 'Masuk', 'Tab masuk', '2024-05-31 10:09:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (911, 1, 28, 0, '2024-05-31', 90000, 'Masuk', 'Tab masuk', '2024-05-31 10:09:21');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (912, 1, 26, 0, '2024-05-31', 50000, 'Masuk', 'Tab masuk', '2024-05-31 10:10:20');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (913, 1, 29, 0, '2024-05-31', 5000, 'Masuk', 'Tab masuk', '2024-05-31 10:10:58');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (914, 1, 39, 0, '2024-05-31', 30000, 'Masuk', 'Tab masuk', '2024-05-31 10:11:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (915, 1, 31, 0, '2024-05-31', 50000, 'Masuk', 'Tab masuk', '2024-05-31 10:11:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (916, 1, 24, 0, '2024-05-31', 10000, 'Masuk', 'Tab masuk', '2024-05-31 10:12:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (917, 1, 41, 0, '2024-05-31', 2000, 'Masuk', 'Tab masuk', '2024-05-31 10:12:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (918, 1, 101, 0, '2024-05-31', 100000, 'Masuk', 'Tab masuk', '2024-05-31 10:12:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (919, 1, 150, 0, '2024-05-31', 50000, 'Masuk', 'Tab masuk', '2024-05-31 10:13:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (920, 1, 99, 0, '2024-05-31', 100000, 'Masuk', 'Tab masuk', '2024-05-31 10:13:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (921, 1, 118, 0, '2024-05-31', 5000, 'Masuk', 'Tab masuk', '2024-05-31 10:13:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (922, 1, 107, 0, '2024-05-31', 20000, 'Masuk', 'Tab masuk', '2024-05-31 10:14:26');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (923, 1, 108, 0, '2024-05-31', 20000, 'Masuk', 'Tab masuk', '2024-05-31 10:14:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (924, 1, 117, 0, '2024-05-31', 50000, 'Masuk', 'Tab masuk', '2024-05-31 10:19:56');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (925, 1, 133, 0, '2024-05-31', 100000, 'Masuk', 'Tab masuk', '2024-05-31 10:20:26');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (926, 1, 147, 0, '2024-05-31', 10000, 'Masuk', 'Tab masuk', '2024-05-31 10:20:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (927, 1, 54, 0, '2024-05-31', 30000, 'Masuk', 'Tab masuk', '2024-05-31 10:21:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (928, 1, 11, 0, '2024-05-31', 100000, 'Masuk', 'Tab masuk', '2024-05-31 10:23:20');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (929, 1, 15, 0, '2024-05-31', 20000, 'Masuk', 'Tab masuk', '2024-05-31 10:23:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (930, 1, 14, 0, '2024-05-31', 40000, 'Masuk', 'Tab masuk', '2024-05-31 10:24:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (931, 1, 111, 0, '2024-05-31', 50000, 'Masuk', 'Tab masuk', '2024-05-31 10:25:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (932, 1, 9, 0, '2024-05-31', 80000, 'Masuk', 'Tab masuk', '2024-05-31 10:26:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (934, 1, 66, 0, '2024-05-31', 15000, 'Masuk', 'Tab masuk', '2024-05-31 10:27:56');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (935, 1, 138, 0, '2024-05-31', 15000, 'Masuk', 'Tab masuk', '2024-05-31 10:28:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (936, 1, 94, 0, '2024-05-31', 10000, 'Masuk', 'Tab masuk', '2024-05-31 10:29:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (937, 1, 149, 0, '2024-05-31', 5000, 'Masuk', 'Tab masuk', '2024-05-31 10:43:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (938, 1, 57, 0, '2024-05-31', 20000, 'Masuk', 'Tab masuk', '2024-05-31 10:43:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (939, 1, 58, 0, '2024-05-31', 20000, 'Masuk', 'Tab masuk', '2024-05-31 10:44:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (940, 1, 64, 0, '2024-05-31', 2000, 'Masuk', 'Tab masuk', '2024-05-31 10:44:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (941, 1, 12, 0, '2024-05-31', 30000, 'Masuk', 'Tab masuk', '2024-05-31 10:45:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (942, 1, 10, 0, '2024-05-31', 20000, 'Masuk', 'Tab masuk', '2024-05-31 10:45:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (943, 1, 103, 0, '2024-05-31', 5000, 'Masuk', 'Tab masuk', '2024-05-31 10:46:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (944, 1, 116, 0, '2024-05-31', 50000, 'Masuk', 'Tab masuk', '2024-05-31 10:46:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (945, 1, 91, 0, '2024-05-31', 20000, 'Masuk', 'Tab masuk', '2024-05-31 10:46:56');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (946, 1, 106, 0, '2024-05-31', 50000, 'Masuk', 'Tab masuk', '2024-05-31 10:47:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (947, 1, 131, 0, '2024-05-31', 50000, 'Masuk', 'Tab masuk', '2024-05-31 10:47:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (948, 1, 119, 0, '2024-05-31', 10000, 'Masuk', 'Tab masuk', '2024-05-31 10:47:52');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (949, 1, 21, 0, '2024-05-31', 100000, 'Masuk', 'Tab masuk', '2024-05-31 10:48:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (950, 1, 22, 0, '2024-05-31', 100000, 'Masuk', 'Tab masuk', '2024-05-31 10:48:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (951, 1, 152, 0, '2024-05-31', 50000, 'Masuk', 'Tab masuk', '2024-05-31 10:49:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (952, 1, 68, 0, '2024-05-31', 150000, 'Masuk', 'Tab masuk', '2024-05-31 10:49:20');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (953, 1, 125, 0, '2024-05-31', 20000, 'Masuk', 'Tab masuk', '2024-05-31 10:49:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (954, 1, 126, 0, '2024-05-31', 10000, 'Masuk', 'Tab masuk', '2024-05-31 10:49:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (955, 1, 122, 0, '2024-05-31', 5000, 'Masuk', 'Tab masuk', '2024-05-31 10:50:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (956, 1, 124, 0, '2024-05-31', 50000, 'Masuk', 'Tab masuk', '2024-05-31 10:50:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (957, 1, 154, 0, '2024-05-31', 10000, 'Masuk', 'Tab masuk', '2024-05-31 10:53:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (958, 1, 20, 0, '2024-05-31', 20000, 'Masuk', 'Tab masuk', '2024-05-31 10:53:58');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (959, 1, 19, 0, '2024-05-31', 20000, 'Masuk', 'Tab masuk', '2024-05-31 10:54:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (960, 1, 92, 0, '2024-05-31', 20000, 'Masuk', 'Tab masuk', '2024-05-31 10:54:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (961, 1, 102, 0, '2024-05-31', 10000, 'Masuk', 'Tab masuk', '2024-06-01 07:27:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (962, 1, 40, 0, '2024-06-01', 20000, 'Masuk', 'Tab masuk', '2024-06-01 07:34:20');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (963, 1, 155, 0, '2024-06-01', 215000, 'Masuk', 'Tab masuk', '2024-06-01 07:58:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (964, 1, 156, 0, '2024-06-01', 20000, 'Masuk', 'Tab masuk', '2024-06-01 08:58:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (965, 1, 144, 0, '2024-06-01', 10000, 'Masuk', 'Tab masuk', '2024-06-01 09:08:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (966, 1, 153, 0, '2024-06-01', 10000, 'Masuk', 'Tab masuk', '2024-06-01 09:38:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (967, 1, 127, 0, '2024-06-01', 10000, 'Masuk', 'Tab masuk', '2024-06-01 11:25:56');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (968, 1, 43, 0, '2024-06-01', 100000, 'Keluar', 'Tab keluar', '2024-06-01 11:26:43');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (969, 1, 57, 0, '2024-06-01', 20000, 'Masuk', 'Tab masuk', '2024-06-01 14:45:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (970, 1, 10, 0, '2024-06-01', 20000, 'Masuk', 'Tab masuk', '2024-06-01 14:45:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (971, 1, 12, 0, '2024-06-01', 30000, 'Masuk', 'Tab masuk', '2024-06-01 14:46:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (972, 1, 33, 0, '2024-06-01', 10000, 'Masuk', 'Tab masuk', '2024-06-01 14:46:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (973, 1, 23, 0, '2024-06-01', 20000, 'Masuk', 'Tab masuk', '2024-06-01 14:46:56');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (974, 1, 46, 0, '2024-06-01', 10000, 'Masuk', 'Tab masuk', '2024-06-01 14:47:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (975, 1, 47, 0, '2024-06-01', 50000, 'Masuk', 'Tab masuk', '2024-06-01 14:48:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (976, 1, 35, 0, '2024-06-01', 100000, 'Masuk', 'Tab masuk', '2024-06-01 14:49:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (977, 1, 105, 0, '2024-06-01', 200000, 'Masuk', 'Tab masuk', '2024-06-01 14:49:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (978, 1, 34, 0, '2024-06-01', 10000, 'Masuk', 'Tab masuk', '2024-06-01 14:50:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (979, 1, 48, 0, '2024-06-01', 10000, 'Masuk', 'Tab masuk', '2024-06-01 14:51:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (980, 1, 79, 0, '2024-06-01', 10000, 'Masuk', 'Tab masuk', '2024-06-01 14:52:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (981, 1, 88, 0, '2024-06-01', 10000, 'Masuk', 'Tab masuk', '2024-06-01 14:55:56');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (982, 1, 38, 0, '2024-06-01', 10000, 'Masuk', 'Tab masuk', '2024-06-01 14:56:23');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (983, 1, 112, 0, '2024-06-01', 10000, 'Masuk', 'Tab masuk', '2024-06-01 14:56:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (984, 1, 113, 0, '2024-06-01', 50000, 'Masuk', 'Tab masuk', '2024-06-01 14:57:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (985, 1, 25, 0, '2024-06-01', 20000, 'Masuk', 'Tab masuk', '2024-06-01 14:57:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (986, 1, 30, 0, '2024-06-01', 20000, 'Masuk', 'Tab masuk', '2024-06-01 14:58:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (987, 1, 37, 0, '2024-06-01', 10000, 'Masuk', 'tabungan masuk', '2024-06-01 16:09:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (988, 1, 28, 0, '2024-06-01', 30000, 'Masuk', 'tabungan masuk', '2024-06-01 16:10:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (989, 1, 29, 0, '2024-06-01', 5000, 'Masuk', 'tabungan masuk', '2024-06-01 16:11:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (990, 1, 39, 0, '2024-06-01', 30000, 'Masuk', 'tabungan masuk', '2024-06-01 16:12:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (991, 1, 24, 0, '2024-06-01', 10000, 'Masuk', 'tabungan masuk', '2024-06-01 16:13:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (992, 1, 41, 0, '2024-06-01', 2000, 'Masuk', 'tabungan masuk', '2024-06-01 16:13:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (993, 1, 69, 0, '2024-06-01', 20000, 'Masuk', 'tabungan masuk', '2024-06-01 16:14:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (994, 1, 117, 0, '2024-06-01', 50000, 'Masuk', 'tabungan masuk', '2024-06-01 16:15:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (995, 1, 133, 0, '2024-06-01', 100000, 'Masuk', 'tabungan masuk', '2024-06-01 16:16:21');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (996, 1, 95, 0, '2024-06-01', 25000, 'Masuk', 'tabungan masuk', '2024-06-01 16:17:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (997, 1, 54, 0, '2024-06-01', 30000, 'Masuk', 'tabungan masuk', '2024-06-01 16:18:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (998, 1, 102, 0, '2024-06-01', 10000, 'Masuk', 'tabungan masuk', '2024-06-01 16:19:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (999, 1, 103, 0, '2024-06-01', 5000, 'Masuk', 'tabungan masuk', '2024-06-01 16:20:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1000, 1, 118, 0, '2024-06-01', 5000, 'Masuk', 'tabungan masuk', '2024-06-01 16:20:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1001, 1, 101, 0, '2024-06-01', 100000, 'Masuk', 'tabungan masuk', '2024-06-01 16:21:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1002, 1, 150, 0, '2024-06-01', 50000, 'Masuk', 'tabungan masuk', '2024-06-01 16:22:23');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1003, 1, 11, 0, '2024-06-01', 100000, 'Masuk', 'tabungan masuk', '2024-06-01 16:23:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1004, 1, 14, 0, '2024-06-01', 40000, 'Masuk', 'tabungan masuk', '2024-06-01 16:24:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1005, 1, 15, 0, '2024-06-01', 30000, 'Masuk', 'tabungan masuk', '2024-06-01 16:26:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1006, 1, 21, 0, '2024-06-01', 100000, 'Masuk', 'tabungan masuk', '2024-06-01 16:27:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1007, 1, 22, 0, '2024-06-01', 100000, 'Masuk', 'tabungan masuk', '2024-06-01 16:29:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1009, 1, 139, 0, '2024-06-01', 10000, 'Masuk', 'tabungan masuk', '2024-06-01 16:31:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1010, 1, 20, 0, '2024-06-01', 20000, 'Masuk', 'tabungan masuk', '2024-06-01 16:34:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1011, 1, 19, 0, '2024-06-01', 20000, 'Masuk', 'tabungan masuk', '2024-06-01 16:35:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1012, 1, 106, 0, '2024-06-01', 50000, 'Masuk', 'tabungan masuk', '2024-06-01 16:36:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1013, 1, 131, 0, '2024-06-01', 50000, 'Masuk', 'tabungan masuk', '2024-06-01 16:37:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1014, 1, 91, 0, '2024-06-01', 20000, 'Masuk', 'Tab masuk', '2024-06-01 17:16:56');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1015, 1, 13, 0, '2024-06-01', 100000, 'Masuk', 'Tab masuk', '2024-06-01 17:17:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1016, 1, 93, 0, '2024-06-01', 200000, 'Masuk', 'Tab masuk', '2024-06-01 17:18:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1017, 1, 66, 0, '2024-06-01', 15000, 'Masuk', 'Tab masuk', '2024-06-01 17:18:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1018, 1, 138, 0, '2024-06-01', 15000, 'Masuk', 'Tab masuk', '2024-06-01 17:19:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1019, 1, 94, 0, '2024-06-01', 10000, 'Masuk', 'Tab masuk', '2024-06-01 17:32:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1020, 1, 135, 0, '2024-06-01', 10000, 'Masuk', 'Tab masuk', '2024-06-01 17:33:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1021, 1, 148, 0, '2024-06-01', 5000, 'Masuk', 'Tab masuk', '2024-06-01 17:33:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1022, 1, 149, 0, '2024-06-01', 5000, 'Masuk', 'Tab masuk', '2024-06-01 17:34:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1023, 1, 58, 0, '2024-06-01', 20000, 'Masuk', 'Tab masuk', '2024-06-01 17:34:23');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1024, 1, 64, 0, '2024-06-01', 5000, 'Masuk', 'Tab masuk', '2024-06-01 17:34:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1025, 1, 16, 0, '2024-06-01', 70000, 'Masuk', 'Tab masuk', '2024-06-01 17:35:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1026, 1, 17, 0, '2024-06-01', 10000, 'Masuk', 'Tab masuk', '2024-06-01 17:35:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1027, 1, 18, 0, '2024-06-01', 20000, 'Masuk', 'Tab masuk', '2024-06-01 17:35:58');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1028, 1, 107, 0, '2024-06-01', 20000, 'Masuk', 'Tab masuk', '2024-06-01 17:36:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1029, 1, 108, 0, '2024-06-01', 20000, 'Masuk', 'Tab masuk', '2024-06-01 17:36:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1030, 1, 119, 0, '2024-06-01', 10000, 'Masuk', 'Tab masuk', '2024-06-01 17:37:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1031, 1, 92, 0, '2024-06-01', 20008, 'Masuk', 'Tab masuk', '2024-06-01 17:37:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1032, 1, 7, 0, '2024-06-01', 10000, 'Masuk', 'Tab masuk', '2024-06-01 17:37:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1033, 1, 6, 0, '2024-06-01', 10000, 'Masuk', 'Tab masuk', '2024-06-01 17:38:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1034, 1, 98, 0, '2024-06-01', 10000, 'Masuk', 'Tab masuk', '2024-06-01 17:38:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1035, 1, 111, 0, '2024-06-01', 50000, 'Masuk', 'Tab masuk', '2024-06-01 17:38:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1036, 1, 68, 0, '2024-06-01', 150000, 'Masuk', 'Tab masuk', '2024-06-01 17:39:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1037, 1, 125, 0, '2024-06-01', 20000, 'Masuk', 'Tab masuk', '2024-06-01 17:40:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1038, 1, 122, 0, '2024-06-01', 10000, 'Masuk', 'Tab masuk', '2024-06-01 17:40:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1039, 1, 126, 0, '2024-06-01', 10000, 'Masuk', 'Tab masuk', '2024-06-01 17:40:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1040, 1, 124, 0, '2024-06-01', 100000, 'Masuk', 'Tab masuk', '2024-06-01 17:41:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1041, 1, 154, 0, '2024-06-01', 10000, 'Masuk', 'Tab masuk', '2024-06-01 17:41:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1042, 1, 137, 0, '2024-06-01', 20000, 'Masuk', 'Tab masuk', '2024-06-01 17:41:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1043, 1, 152, 0, '2024-06-01', 50000, 'Masuk', 'Tab masuk', '2024-06-01 17:42:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1044, 1, 31, 0, '2024-06-01', 50000, 'Masuk', 'Tab masuk', '2024-06-01 17:42:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1045, 1, 32, 0, '2024-06-01', 10000, 'Masuk', 'Tab masuk', '2024-06-01 17:42:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1046, 1, 65, 0, '2024-06-02', 2000000, 'Masuk', 'Tab masuk', '2024-06-02 07:48:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1047, 1, 40, 0, '2024-06-02', 20000, 'Masuk', 'Tab masuk', '2024-06-02 08:26:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1048, 1, 23, 0, '2024-06-02', 20000, 'Masuk', 'Tab masuk', '2024-06-02 09:59:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1049, 1, 121, 0, '2024-06-02', 20000, 'Masuk', 'Tab masuk', '2024-06-02 10:00:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1050, 1, 47, 0, '2024-06-02', 50000, 'Masuk', 'Tab masuk', '2024-06-02 10:01:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1051, 1, 46, 0, '2024-06-02', 10000, 'Masuk', 'Tab masuk', '2024-06-02 10:01:20');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1052, 1, 145, 0, '2024-06-01', 45000, 'Masuk', 'Tab masuk', '2024-06-02 10:15:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1053, 1, 145, 0, '2024-06-02', 15000, 'Masuk', 'Tab masuk', '2024-06-02 10:21:23');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1054, 1, 100, 0, '2024-06-02', 50000, 'Masuk', 'Tab masuk', '2024-06-02 10:24:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1055, 1, 113, 0, '2024-06-02', 50000, 'Masuk', 'Tab masuk', '2024-06-02 10:24:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1056, 1, 25, 0, '2024-06-02', 20000, 'Masuk', 'Tab masuk', '2024-06-02 10:25:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1057, 1, 112, 0, '2024-06-02', 10000, 'Masuk', 'Tab masuk', '2024-06-02 10:25:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1058, 1, 30, 0, '2024-06-02', 20000, 'Masuk', 'Tab masuk', '2024-06-02 10:26:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1059, 1, 37, 0, '2024-06-02', 10000, 'Masuk', 'Tab masuk', '2024-06-02 10:26:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1060, 1, 28, 0, '2024-06-02', 30000, 'Masuk', 'Tab masuk', '2024-06-02 10:27:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1061, 1, 70, 0, '2024-06-02', 30000, 'Masuk', 'Tab masuk', '2024-06-02 10:42:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1062, 1, 70, 0, '2024-06-01', 30000, 'Masuk', 'Tab masuk', '2024-06-02 10:42:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1063, 1, 26, 0, '2024-06-02', 50000, 'Masuk', 'Tab masuk', '2024-06-02 10:43:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1064, 1, 29, 0, '2024-06-02', 5000, 'Masuk', 'Tab masuk', '2024-06-02 10:43:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1065, 1, 39, 0, '2024-06-02', 30000, 'Masuk', 'Tab masuk', '2024-06-02 10:44:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1066, 1, 24, 0, '2024-06-02', 10000, 'Masuk', 'Tab masuk', '2024-06-02 10:44:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1067, 1, 41, 0, '2024-06-02', 2000, 'Masuk', 'Tab masuk', '2024-06-02 10:44:56');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1068, 1, 117, 0, '2024-06-02', 50000, 'Masuk', 'Tab masuk', '2024-06-02 10:45:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1069, 1, 133, 0, '2024-06-02', 100000, 'Masuk', 'Tab masuk', '2024-06-02 10:45:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1070, 1, 38, 0, '2024-06-02', 10000, 'Masuk', 'Tab masuk', '2024-06-02 10:45:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1071, 1, 54, 0, '2024-06-02', 30000, 'Masuk', 'Tab masuk', '2024-06-02 10:46:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1072, 1, 88, 0, '2024-06-02', 10000, 'Masuk', 'Tab masuk', '2024-06-02 10:46:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1073, 1, 11, 0, '2024-06-02', 100000, 'Masuk', 'Tab masuk', '2024-06-02 10:48:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1074, 1, 15, 0, '2024-06-02', 20000, 'Masuk', 'Tab masuk', '2024-06-02 13:42:52');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1075, 1, 14, 0, '2024-06-02', 20000, 'Masuk', 'Tab masuk', '2024-06-02 13:43:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1076, 1, 21, 0, '2024-06-02', 100000, 'Masuk', 'Tab masuk', '2024-06-02 13:43:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1077, 1, 22, 0, '2024-06-02', 100000, 'Masuk', 'Tab masuk', '2024-06-02 13:44:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1078, 1, 102, 0, '2024-06-02', 10000, 'Masuk', 'Tab masuk', '2024-06-02 13:44:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1079, 1, 101, 0, '2024-06-02', 100000, 'Masuk', 'Tab masuk', '2024-06-02 13:44:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1080, 1, 150, 0, '2024-06-02', 50000, 'Masuk', 'Tab masuk', '2024-06-02 13:45:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1081, 1, 103, 0, '2024-06-02', 5000, 'Masuk', 'Tab masuk', '2024-06-02 13:45:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1082, 1, 118, 0, '2024-06-02', 5000, 'Masuk', 'Tab masuk', '2024-06-02 13:45:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1083, 1, 20, 0, '2024-06-02', 20000, 'Masuk', 'Tab masuk', '2024-06-02 13:46:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1084, 1, 138, 0, '2024-06-02', 15000, 'Masuk', 'Tab masuk', '2024-06-02 13:46:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1085, 1, 98, 0, '2024-06-02', 10000, 'Masuk', 'Tab masuk', '2024-06-02 13:46:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1086, 1, 94, 0, '2024-06-02', 10000, 'Masuk', 'Tab masuk', '2024-06-02 13:47:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1087, 1, 148, 0, '2024-06-02', 5000, 'Masuk', 'Tab masuk', '2024-06-02 13:47:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1088, 1, 149, 0, '2024-06-02', 5000, 'Masuk', 'Tab masuk', '2024-06-02 13:47:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1089, 1, 57, 0, '2024-06-02', 20000, 'Masuk', 'Tab masuk', '2024-06-02 13:48:20');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1090, 1, 58, 0, '2024-06-02', 20000, 'Masuk', 'Tab masuk', '2024-06-02 13:49:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1091, 1, 64, 0, '2024-06-02', 5000, 'Masuk', 'Tab masuk', '2024-06-02 13:49:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1092, 1, 55, 0, '2024-06-02', 10000, 'Masuk', 'Tab masuk', '2024-06-02 13:49:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1093, 1, 56, 0, '2024-06-02', 2000, 'Masuk', 'Tab masuk', '2024-06-02 13:50:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1094, 1, 12, 0, '2024-06-02', 30000, 'Masuk', 'Tab masuk', '2024-06-02 13:50:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1095, 1, 16, 0, '2024-06-02', 70000, 'Masuk', 'Tab masuk', '2024-06-02 13:51:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1096, 1, 17, 0, '2024-06-02', 10000, 'Masuk', 'Tab masuk', '2024-06-02 13:51:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1097, 1, 18, 0, '2024-06-02', 20000, 'Masuk', 'Tab masuk', '2024-06-02 13:52:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1098, 1, 60, 0, '2024-06-02', 50000, 'Masuk', 'Tab masuk', '2024-06-02 13:52:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1099, 1, 107, 0, '2024-06-02', 20000, 'Masuk', 'Tab masuk', '2024-06-02 13:52:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1100, 1, 92, 0, '2024-06-02', 20000, 'Masuk', 'Tab masuk', '2024-06-02 13:53:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1101, 1, 152, 0, '2024-06-02', 50000, 'Masuk', 'Tab masuk', '2024-06-02 13:53:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1102, 1, 111, 0, '2024-06-02', 50000, 'Masuk', 'Tab masuk', '2024-06-02 13:53:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1103, 1, 91, 0, '2024-06-02', 20000, 'Masuk', 'Tab masuk', '2024-06-02 13:55:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1104, 1, 31, 0, '2024-06-02', 50000, 'Masuk', 'Tab masuk', '2024-06-02 13:55:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1105, 1, 32, 0, '2024-06-02', 10000, 'Masuk', 'Tab masuk', '2024-06-02 13:56:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1106, 1, 69, 0, '2024-06-02', 10000, 'Masuk', 'Tab masuk', '2024-06-02 13:56:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1107, 1, 125, 0, '2024-06-02', 20000, 'Masuk', 'Tab masuk', '2024-06-02 13:56:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1108, 1, 126, 0, '2024-06-02', 10000, 'Masuk', 'Tab masuk', '2024-06-02 13:57:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1109, 1, 9, 0, '2024-06-02', 20000, 'Masuk', 'Tab masuk', '2024-06-02 13:57:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1110, 1, 7, 0, '2024-06-02', 10000, 'Masuk', 'Tab masuk', '2024-06-02 13:57:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1111, 1, 6, 0, '2024-06-02', 10000, 'Masuk', 'Tab masuk', '2024-06-02 13:58:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1112, 1, 122, 0, '2024-06-02', 5000, 'Masuk', 'Tab masuk', '2024-06-02 13:58:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1113, 1, 124, 0, '2024-06-02', 100000, 'Masuk', 'Tab masuk', '2024-06-02 13:58:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1114, 1, 137, 0, '2024-06-02', 20000, 'Masuk', 'Tab masuk', '2024-06-02 13:59:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1115, 1, 42, 0, '2024-06-02', 10000, 'Masuk', 'Tab masuk', '2024-06-02 13:59:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1116, 1, 106, 0, '2024-06-02', 50000, 'Masuk', 'Tab masuk', '2024-06-02 14:01:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1117, 1, 131, 0, '2024-06-02', 70000, 'Masuk', 'Tab masuk', '2024-06-02 14:02:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1118, 1, 40, 0, '2024-06-03', 20000, 'Masuk', 'Tab masuk', '2024-06-03 08:39:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1119, 1, 63, 0, '2024-06-03', 200000, 'Masuk', 'Tab masuk', '2024-06-03 08:40:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1120, 1, 133, 0, '2024-06-03', 1900000, 'Keluar', 'Tab keluar', '2024-06-03 08:40:26');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1121, 1, 131, 0, '2024-06-03', 1000000, 'Keluar', 'Tab keluar', '2024-06-03 08:41:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1122, 1, 151, 0, '2024-06-03', 10000, 'Masuk', 'Tab masuk', '2024-06-03 13:43:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1123, 1, 23, 0, '2024-06-03', 20000, 'Masuk', 'Tab masuk', '2024-06-03 17:26:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1124, 1, 33, 0, '2024-06-03', 10000, 'Masuk', 'Tab masuk', '2024-06-03 17:27:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1125, 1, 46, 0, '2024-06-03', 10000, 'Masuk', 'Tab masuk', '2024-06-03 17:27:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1126, 1, 47, 0, '2024-06-03', 50000, 'Masuk', 'Tab masuk', '2024-06-03 17:27:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1127, 1, 145, 0, '2024-06-03', 45000, 'Masuk', 'Tab masuk', '2024-06-03 17:28:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1128, 1, 68, 0, '2024-06-03', 500000, 'Masuk', 'Tab masuk', '2024-06-03 17:29:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1129, 1, 113, 0, '2024-06-03', 50000, 'Masuk', 'Tab masuk', '2024-06-03 17:30:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1130, 1, 25, 0, '2024-06-03', 20000, 'Masuk', 'Tab masuk', '2024-06-03 17:30:43');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1131, 1, 112, 0, '2024-06-03', 10000, 'Masuk', 'Tab masuk', '2024-06-03 17:31:26');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1132, 1, 38, 0, '2024-06-03', 10000, 'Masuk', 'Tab masuk', '2024-06-03 17:31:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1133, 1, 30, 0, '2024-06-03', 20000, 'Masuk', 'Tab masuk', '2024-06-03 17:32:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1134, 1, 37, 0, '2024-06-03', 10000, 'Masuk', 'Tab masuk', '2024-06-03 17:32:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1135, 1, 28, 0, '2024-06-03', 30000, 'Masuk', 'Tab masuk', '2024-06-03 17:33:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1136, 1, 26, 0, '2024-06-03', 50000, 'Masuk', 'Tab masuk', '2024-06-03 17:34:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1137, 1, 39, 0, '2024-06-03', 30000, 'Masuk', 'Tab masuk', '2024-06-03 17:35:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1138, 1, 24, 0, '2024-06-03', 10000, 'Masuk', 'Tab masuk', '2024-06-03 17:36:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1139, 1, 41, 0, '2024-06-03', 2000, 'Masuk', 'Tab masuk', '2024-06-03 17:36:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1140, 1, 117, 0, '2024-06-03', 50000, 'Masuk', 'Tab masuk', '2024-06-03 17:36:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1141, 1, 133, 0, '2024-06-03', 100000, 'Masuk', 'Tab masuk', '2024-06-03 17:39:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1142, 1, 54, 0, '2024-06-03', 30000, 'Masuk', 'Tab masuk', '2024-06-03 17:40:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1143, 1, 152, 0, '2024-06-03', 50000, 'Masuk', 'Tab masuk', '2024-06-03 17:41:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1144, 1, 11, 0, '2024-06-03', 100000, 'Masuk', 'Tab masuk', '2024-06-03 17:41:21');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1145, 1, 15, 0, '2024-06-03', 30000, 'Masuk', 'Tab masuk', '2024-06-03 17:41:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1146, 1, 14, 0, '2024-06-03', 30000, 'Masuk', 'Tab masuk', '2024-06-03 17:42:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1147, 1, 138, 0, '2024-06-03', 15000, 'Masuk', 'Tab masuk', '2024-06-03 17:42:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1148, 1, 95, 0, '2024-06-03', 15000, 'Masuk', 'Tab masuk', '2024-06-03 18:11:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1149, 1, 98, 0, '2024-06-03', 10000, 'Masuk', 'Tab masuk', '2024-06-03 18:11:58');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1150, 1, 135, 0, '2024-06-03', 10000, 'Masuk', 'Tab masuk', '2024-06-03 18:12:21');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1151, 1, 55, 0, '2024-06-03', 10000, 'Masuk', 'Tab masuk', '2024-06-03 18:12:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1152, 1, 56, 0, '2024-06-03', 2000, 'Masuk', 'Tab masuk', '2024-06-03 18:13:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1153, 1, 58, 0, '2024-06-03', 20000, 'Masuk', 'Tab masuk', '2024-06-03 18:13:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1154, 1, 64, 0, '2024-06-03', 2000, 'Masuk', 'Tab masuk', '2024-06-03 18:13:58');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1155, 1, 57, 0, '2024-06-03', 20000, 'Masuk', 'Tab masuk', '2024-06-03 18:18:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1156, 1, 12, 0, '2024-06-03', 30000, 'Masuk', 'Tab masuk', '2024-06-03 18:18:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1157, 1, 10, 0, '2024-06-03', 20000, 'Masuk', 'Tab masuk', '2024-06-03 18:19:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1158, 1, 16, 0, '2024-06-03', 70000, 'Masuk', 'Tab masuk', '2024-06-03 18:19:56');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1159, 1, 17, 0, '2024-06-03', 10000, 'Masuk', 'Tab masuk', '2024-06-03 18:20:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1160, 1, 18, 0, '2024-06-03', 20000, 'Masuk', 'Tab masuk', '2024-06-03 18:20:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1161, 1, 60, 0, '2024-06-03', 50000, 'Masuk', 'Tab masuk', '2024-06-03 18:22:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1162, 1, 108, 0, '2024-06-03', 20000, 'Masuk', 'Tab masuk', '2024-06-03 18:22:52');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1163, 1, 107, 0, '2024-06-03', 20000, 'Masuk', 'Tab masuk', '2024-06-03 18:23:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1164, 1, 119, 0, '2024-06-03', 10000, 'Masuk', 'Tab masuk', '2024-06-03 18:23:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1165, 1, 92, 0, '2024-06-03', 20000, 'Masuk', 'Tab masuk', '2024-06-03 18:24:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1166, 1, 102, 0, '2024-06-03', 10000, 'Masuk', 'Tab masuk', '2024-06-03 18:24:23');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1167, 1, 103, 0, '2024-06-03', 5000, 'Masuk', 'Tab masuk', '2024-06-03 18:24:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1168, 1, 118, 0, '2024-06-03', 5000, 'Masuk', 'Tab masuk', '2024-06-03 18:27:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1169, 1, 101, 0, '2024-06-03', 100000, 'Masuk', 'Tab masuk', '2024-06-03 18:28:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1170, 1, 150, 0, '2024-06-03', 50000, 'Masuk', 'Tab masuk', '2024-06-03 18:28:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1171, 1, 20, 0, '2024-06-03', 20000, 'Masuk', 'Tab masuk', '2024-06-03 18:28:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1172, 1, 19, 0, '2024-06-03', 20000, 'Masuk', 'Tab masuk', '2024-06-03 18:29:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1173, 1, 91, 0, '2024-06-03', 20000, 'Masuk', 'Tab masuk', '2024-06-03 18:30:23');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1174, 1, 111, 0, '2024-06-03', 50000, 'Masuk', 'Tab masuk', '2024-06-03 18:30:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1175, 1, 13, 0, '2024-06-03', 130000, 'Masuk', 'Tab masuk', '2024-06-03 18:31:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1176, 1, 125, 0, '2024-06-03', 20000, 'Masuk', 'Tab masuk', '2024-06-03 18:32:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1177, 1, 126, 0, '2024-06-03', 10000, 'Masuk', 'Tab masuk', '2024-06-03 18:32:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1178, 1, 122, 0, '2024-06-03', 5000, 'Masuk', 'Tab masuk', '2024-06-03 18:33:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1179, 1, 124, 0, '2024-06-03', 50000, 'Masuk', 'Tab masuk', '2024-06-03 18:33:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1180, 1, 137, 0, '2024-06-03', 20000, 'Masuk', 'Tab masuk', '2024-06-03 18:34:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1181, 1, 42, 0, '2024-06-03', 10000, 'Masuk', 'Tab masuk', '2024-06-03 18:34:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1182, 1, 40, 0, '2024-06-04', 20000, 'Masuk', 'Tab masuk', '2024-06-04 07:25:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1183, 1, 145, 0, '2024-06-04', 100000, 'Keluar', 'Tab keluar', '2024-06-04 07:26:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1184, 1, 153, 0, '2024-06-04', 30000, 'Masuk', 'Tab masuk', '2024-06-04 09:22:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1185, 1, 11, 0, '2024-06-04', 1000000, 'Keluar', 'Tab keluar', '2024-06-04 09:37:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1186, 1, 157, 0, '2024-06-04', 620000, 'Masuk', 'Tab masuk', '2024-06-04 09:44:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1187, 1, 4, 0, '2024-06-04', 8400000, 'Masuk', 'Tab masuk', '2024-06-04 10:36:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1188, 1, 158, 0, '2024-06-04', 20000, 'Masuk', 'Tab masuk', '2024-06-04 14:12:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1189, 1, 139, 0, '2024-06-04', 50000, 'Masuk', 'Tab masuk', '2024-06-04 14:13:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1190, 1, 45, 0, '2024-06-04', 5000, 'Masuk', 'Tab masuk', '2024-06-04 14:13:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1191, 1, 121, 0, '2024-06-04', 10000, 'Masuk', 'Tab masuk', '2024-06-04 14:13:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1192, 1, 23, 0, '2024-06-04', 20000, 'Masuk', 'Tab masuk', '2024-06-04 14:14:26');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1193, 1, 33, 0, '2024-06-04', 20000, 'Masuk', 'Tab masuk', '2024-06-04 14:14:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1194, 1, 47, 0, '2024-06-04', 50000, 'Masuk', 'Tab masuk', '2024-06-04 14:15:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1195, 1, 36, 0, '2024-06-04', 5000, 'Masuk', 'Tab masuk', '2024-06-04 14:15:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1196, 1, 35, 0, '2024-06-04', 200000, 'Masuk', 'Tab masuk', '2024-06-04 17:10:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1197, 1, 27, 0, '2024-06-04', 30000, 'Masuk', 'Tab masuk', '2024-06-04 17:11:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1198, 1, 25, 0, '2024-06-04', 20000, 'Masuk', 'Tab masuk', '2024-06-04 17:12:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1199, 1, 38, 0, '2024-06-04', 10000, 'Masuk', 'Tab masuk', '2024-06-04 17:12:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1200, 1, 113, 0, '2024-06-04', 50000, 'Masuk', 'Tab masuk', '2024-06-04 17:13:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1201, 1, 30, 0, '2024-06-04', 20000, 'Masuk', 'Tab masuk', '2024-06-04 17:16:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1202, 1, 34, 0, '2024-06-04', 10000, 'Masuk', 'Tab masuk', '2024-06-04 17:17:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1203, 1, 37, 0, '2024-06-04', 10000, 'Masuk', 'Tab masuk', '2024-06-04 17:17:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1204, 1, 31, 0, '2024-06-04', 50000, 'Masuk', 'Tab masuk', '2024-06-04 17:18:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1205, 1, 32, 0, '2024-06-04', 10000, 'Masuk', 'Tab masuk', '2024-06-04 17:18:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1206, 1, 28, 0, '2024-06-04', 30000, 'Masuk', 'Tab masuk', '2024-06-04 17:18:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1207, 1, 128, 0, '2024-06-04', 50000, 'Masuk', 'Tab masuk', '2024-06-04 17:19:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1208, 1, 29, 0, '2024-06-04', 5000, 'Masuk', 'Tab masuk', '2024-06-04 17:19:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1209, 1, 39, 0, '2024-06-04', 30000, 'Masuk', 'Tab masuk', '2024-06-04 17:19:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1210, 1, 152, 0, '2024-06-04', 50000, 'Masuk', 'Tab masuk', '2024-06-04 17:20:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1211, 1, 24, 0, '2024-06-04', 10000, 'Masuk', 'Tab masuk', '2024-06-04 17:20:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1212, 1, 41, 0, '2024-06-04', 2000, 'Masuk', 'Tab masuk', '2024-06-04 17:21:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1213, 1, 69, 0, '2024-06-04', 10000, 'Masuk', 'Tab masuk', '2024-06-04 17:21:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1214, 1, 11, 0, '2024-06-04', 100000, 'Masuk', 'Tab masuk', '2024-06-04 17:22:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1215, 1, 15, 0, '2024-06-04', 30000, 'Masuk', 'Tab masuk', '2024-06-04 17:22:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1216, 1, 14, 0, '2024-06-04', 30000, 'Masuk', 'Tab masuk', '2024-06-04 17:34:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1217, 1, 117, 0, '2024-06-04', 50000, 'Masuk', 'Tab masuk', '2024-06-04 17:35:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1218, 1, 13, 0, '2024-06-04', 150000, 'Masuk', 'Tab masuk', '2024-06-04 17:36:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1219, 1, 95, 0, '2024-06-04', 10000, 'Masuk', 'Tab masuk', '2024-06-04 17:40:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1220, 1, 138, 0, '2024-06-04', 15000, 'Masuk', 'Tab masuk', '2024-06-04 17:41:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1221, 1, 98, 0, '2024-06-04', 10000, 'Masuk', 'Tab masuk', '2024-06-04 17:41:58');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1222, 1, 94, 0, '2024-06-04', 10000, 'Masuk', 'Tab masuk', '2024-06-04 17:44:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1223, 1, 135, 0, '2024-06-04', 10000, 'Masuk', 'Tab masuk', '2024-06-04 17:44:43');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1224, 1, 148, 0, '2024-06-04', 5000, 'Masuk', 'Tab masuk', '2024-06-04 17:45:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1225, 1, 55, 0, '2024-06-04', 10000, 'Masuk', 'Tab masuk', '2024-06-04 17:45:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1226, 1, 56, 0, '2024-06-04', 2000, 'Masuk', 'Tab masuk', '2024-06-04 17:45:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1227, 1, 58, 0, '2024-06-04', 20000, 'Masuk', 'Tab masuk', '2024-06-04 17:46:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1228, 1, 64, 0, '2024-06-04', 2000, 'Masuk', 'Tab masuk', '2024-06-04 17:46:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1229, 1, 57, 0, '2024-06-04', 20000, 'Masuk', 'Tab masuk', '2024-06-04 18:14:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1230, 1, 12, 0, '2024-06-04', 30000, 'Masuk', 'Tab masuk', '2024-06-04 18:14:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1231, 1, 10, 0, '2024-06-04', 20000, 'Masuk', 'Tab masuk', '2024-06-04 18:15:43');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1232, 1, 158, 0, '2024-06-04', 20000, 'Masuk', 'Tab masuk', '2024-06-04 18:19:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1233, 1, 18, 0, '2024-06-04', 10000, 'Masuk', 'Tab masuk', '2024-06-04 18:19:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1234, 1, 16, 0, '2024-06-04', 70000, 'Masuk', 'Tab masuk', '2024-06-04 18:20:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1235, 1, 17, 0, '2024-06-04', 10000, 'Masuk', 'Tab masuk', '2024-06-04 18:20:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1236, 1, 60, 0, '2024-06-04', 50000, 'Masuk', 'Tab masuk', '2024-06-04 18:20:52');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1237, 1, 108, 0, '2024-06-04', 20000, 'Masuk', 'Tab masuk', '2024-06-04 18:21:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1238, 1, 107, 0, '2024-06-04', 20000, 'Masuk', 'Tab masuk', '2024-06-04 18:21:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1239, 1, 119, 0, '2024-06-04', 10000, 'Masuk', 'Tab masuk', '2024-06-04 18:21:56');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1240, 1, 92, 0, '2024-06-04', 20000, 'Masuk', 'Tab masuk', '2024-06-04 18:22:26');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1241, 1, 99, 0, '2024-06-04', 100000, 'Masuk', 'Tab masuk', '2024-06-04 18:22:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1242, 1, 101, 0, '2024-06-04', 100000, 'Masuk', 'Tab masuk', '2024-06-04 18:23:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1243, 1, 150, 0, '2024-06-04', 50000, 'Masuk', 'Tab masuk', '2024-06-04 18:23:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1244, 1, 102, 0, '2024-06-04', 10000, 'Masuk', 'Tab masuk', '2024-06-04 18:23:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1245, 1, 103, 0, '2024-06-04', 5000, 'Masuk', 'Tab masuk', '2024-06-04 18:24:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1246, 1, 118, 0, '2024-06-04', 5000, 'Masuk', 'Tab masuk', '2024-06-04 18:24:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1247, 1, 21, 0, '2024-06-04', 200000, 'Masuk', 'Tab masuk', '2024-06-04 18:24:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1248, 1, 22, 0, '2024-06-04', 200000, 'Masuk', 'Tab masuk', '2024-06-04 18:25:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1249, 1, 91, 0, '2024-06-04', 20000, 'Masuk', 'Tab masuk', '2024-06-04 18:25:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1250, 1, 111, 0, '2024-06-04', 50000, 'Masuk', 'Tab masuk', '2024-06-04 18:25:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1251, 1, 54, 0, '2024-06-04', 30000, 'Masuk', 'Tab masuk', '2024-06-04 18:26:21');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1252, 1, 78, 0, '2024-06-04', 50000, 'Masuk', 'Tab masuk', '2024-06-04 18:26:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1253, 1, 88, 0, '2024-06-04', 10000, 'Masuk', 'Tab masuk', '2024-06-04 18:27:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1254, 1, 79, 0, '2024-06-04', 15000, 'Masuk', 'Tab masuk', '2024-06-04 18:27:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1255, 1, 6, 0, '2024-06-04', 10000, 'Masuk', 'Tab masuk', '2024-06-04 18:27:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1256, 1, 7, 0, '2024-06-04', 10000, 'Masuk', 'Tab masuk', '2024-06-04 18:28:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1257, 1, 42, 0, '2024-06-04', 10000, 'Masuk', 'Tab masuk', '2024-06-04 18:28:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1258, 1, 97, 0, '2024-06-04', 15000, 'Masuk', 'Tab masuk', '2024-06-04 18:29:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1259, 1, 129, 0, '2024-06-04', 50000, 'Masuk', 'Tab masuk', '2024-06-04 18:29:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1260, 1, 130, 0, '2024-06-04', 10000, 'Masuk', 'Tab masuk', '2024-06-04 18:29:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1261, 1, 68, 0, '2024-06-04', 100000, 'Masuk', 'Tab masuk', '2024-06-04 18:30:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1262, 1, 20, 0, '2024-06-04', 20000, 'Masuk', 'Tab masuk', '2024-06-04 20:26:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1263, 1, 19, 0, '2024-06-04', 20000, 'Masuk', 'Tab masuk', '2024-06-04 20:27:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1264, 1, 40, 0, '2024-06-05', 20000, 'Masuk', 'Tab masuk', '2024-06-05 08:47:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1265, 1, 97, 0, '2024-06-05', 20000, 'Masuk', 'Tab masuk', '2024-06-05 11:22:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1266, 1, 42, 0, '2024-06-05', 10000, 'Masuk', 'Tab masuk', '2024-06-05 11:22:23');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1267, 1, 122, 0, '2024-06-05', 5000, 'Masuk', 'Tab masuk', '2024-06-05 11:23:23');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1268, 1, 33, 0, '2024-06-05', 10000, 'Masuk', 'Tab masuk', '2024-06-05 11:24:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1269, 1, 23, 0, '2024-06-05', 20000, 'Masuk', 'Tab masuk', '2024-06-05 11:25:20');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1270, 1, 47, 0, '2024-06-05', 50000, 'Masuk', 'Tab masuk', '2024-06-05 11:25:43');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1271, 1, 46, 0, '2024-06-05', 10000, 'Masuk', 'Tab masuk', '2024-06-05 11:26:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1272, 1, 116, 0, '2024-06-05', 50000, 'Masuk', 'Tab masuk', '2024-06-05 11:26:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1273, 1, 151, 0, '2024-06-05', 10000, 'Masuk', 'Tab masuk', '2024-06-05 11:26:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1274, 1, 36, 0, '2024-06-05', 20000, 'Masuk', 'Tab masuk', '2024-06-05 11:27:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1275, 1, 35, 0, '2024-06-05', 200000, 'Masuk', 'Tab masuk', '2024-06-05 11:27:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1276, 1, 27, 0, '2024-06-05', 30000, 'Masuk', 'Tab masuk', '2024-06-05 11:28:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1277, 1, 145, 0, '2024-06-05', 10000, 'Masuk', 'Tab masuk', '2024-06-05 11:28:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1278, 1, 48, 0, '2024-06-05', 10000, 'Masuk', 'Tab masuk', '2024-06-05 11:29:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1279, 1, 9, 0, '2024-06-05', 60000, 'Masuk', 'Tab masuk', '2024-06-05 11:29:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1280, 1, 6, 0, '2024-06-05', 10000, 'Masuk', 'Tab masuk', '2024-06-05 11:29:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1281, 1, 7, 0, '2024-06-05', 10000, 'Masuk', 'Tab masuk', '2024-06-05 11:30:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1282, 1, 129, 0, '2024-06-05', 50000, 'Masuk', 'Tab masuk', '2024-06-05 11:30:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1283, 1, 130, 0, '2024-06-05', 10000, 'Masuk', 'Tab masuk', '2024-06-05 11:31:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1284, 1, 38, 0, '2024-06-05', 10000, 'Masuk', 'Tab masuk', '2024-06-05 12:54:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1285, 1, 68, 0, '2024-06-05', 100000, 'Masuk', 'Tab masuk', '2024-06-05 12:55:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1286, 1, 25, 0, '2024-06-05', 20000, 'Masuk', 'Tab masuk', '2024-06-05 12:55:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1287, 1, 113, 0, '2024-06-05', 50000, 'Masuk', 'Tab masuk', '2024-06-05 12:55:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1288, 1, 112, 0, '2024-06-05', 10000, 'Masuk', 'Tab masuk', '2024-06-05 12:56:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1289, 1, 30, 0, '2024-06-05', 20000, 'Masuk', 'Tab masuk', '2024-06-05 12:56:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1290, 1, 28, 0, '2024-06-05', 30000, 'Masuk', 'Tab masuk', '2024-06-05 12:57:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1291, 1, 37, 0, '2024-06-05', 10000, 'Masuk', 'Tab masuk', '2024-06-05 12:57:21');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1292, 1, 29, 0, '2024-06-05', 5000, 'Masuk', 'Tab masuk', '2024-06-05 12:57:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1293, 1, 31, 0, '2024-06-05', 50000, 'Masuk', 'Tab masuk', '2024-06-05 12:58:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1294, 1, 32, 0, '2024-06-05', 10000, 'Masuk', 'Tab masuk', '2024-06-05 12:58:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1295, 1, 24, 0, '2024-06-05', 10000, 'Masuk', 'Tab masuk', '2024-06-05 12:59:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1296, 1, 41, 0, '2024-06-05', 2000, 'Masuk', 'Tab masuk', '2024-06-05 12:59:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1297, 1, 69, 0, '2024-06-05', 20000, 'Masuk', 'Tab masuk', '2024-06-05 13:00:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1298, 1, 117, 0, '2024-06-05', 50000, 'Masuk', 'Tab masuk', '2024-06-05 13:00:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1299, 1, 133, 0, '2024-06-05', 200000, 'Masuk', 'Tab masuk', '2024-06-05 13:00:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1300, 1, 147, 0, '2024-06-05', 10000, 'Masuk', 'Tab masuk', '2024-06-05 13:26:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1301, 1, 54, 0, '2024-06-05', 30000, 'Masuk', 'Tab masuk', '2024-06-05 13:26:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1302, 1, 11, 0, '2024-06-05', 100000, 'Masuk', 'Tab masuk', '2024-06-05 13:26:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1303, 1, 14, 0, '2024-06-05', 20000, 'Masuk', 'Tab masuk', '2024-06-05 13:27:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1304, 1, 15, 0, '2024-06-05', 20000, 'Masuk', 'Tab masuk', '2024-06-05 13:27:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1305, 1, 136, 0, '2024-06-05', 306000, 'Masuk', 'Tab masuk', '2024-06-05 13:27:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1306, 1, 115, 0, '2024-06-05', 500000, 'Masuk', 'Tab masuk', '2024-06-05 13:28:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1307, 1, 114, 0, '2024-06-05', 5000, 'Masuk', 'Tab masuk', '2024-06-05 13:28:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1308, 1, 152, 0, '2024-06-05', 50000, 'Masuk', 'Tab masuk', '2024-06-05 13:29:52');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1309, 1, 13, 0, '2024-06-05', 100000, 'Masuk', 'Tab masuk', '2024-06-05 13:30:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1310, 1, 138, 0, '2024-06-05', 15000, 'Masuk', 'Tab masuk', '2024-06-05 13:30:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1311, 1, 95, 0, '2024-06-05', 15000, 'Masuk', 'Tab masuk', '2024-06-05 13:31:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1312, 1, 94, 0, '2024-06-05', 10000, 'Masuk', 'Tab masuk', '2024-06-05 13:31:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1313, 1, 135, 0, '2024-06-05', 10000, 'Masuk', 'Tab masuk', '2024-06-05 13:32:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1314, 1, 57, 0, '2024-06-05', 20000, 'Masuk', 'Tab masuk', '2024-06-05 13:32:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1316, 1, 58, 0, '2024-06-05', 20000, 'Masuk', 'Tab masuk', '2024-06-05 13:34:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1317, 1, 64, 0, '2024-06-05', 2000, 'Masuk', 'Tab masuk', '2024-06-05 13:34:21');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1318, 1, 12, 0, '2024-06-05', 30000, 'Masuk', 'Tab masuk', '2024-06-05 13:34:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1319, 1, 10, 0, '2024-06-05', 20000, 'Masuk', 'Tab masuk', '2024-06-05 13:35:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1320, 1, 158, 0, '2024-06-05', 20000, 'Masuk', 'Tab masuk', '2024-06-05 13:36:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1321, 1, 16, 0, '2024-06-05', 70000, 'Masuk', 'Tab masuk', '2024-06-05 13:36:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1322, 1, 17, 0, '2024-06-05', 10000, 'Masuk', 'Tab masuk', '2024-06-05 13:37:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1323, 1, 18, 0, '2024-06-05', 10000, 'Masuk', 'Tab masuk', '2024-06-05 13:37:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1324, 1, 60, 0, '2024-06-05', 50000, 'Masuk', 'Tab masuk', '2024-06-05 13:38:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1325, 1, 107, 0, '2024-06-05', 20000, 'Masuk', 'Tab masuk', '2024-06-05 13:38:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1326, 1, 119, 0, '2024-06-05', 10000, 'Masuk', 'Tab masuk', '2024-06-05 13:40:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1327, 1, 92, 0, '2024-06-05', 20000, 'Masuk', 'Tab masuk', '2024-06-05 13:40:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1328, 1, 21, 0, '2024-06-05', 100000, 'Masuk', 'Tab masuk', '2024-06-05 13:41:23');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1329, 1, 157, 0, '2024-06-05', 50000, 'Masuk', 'Tab masuk', '2024-06-05 13:41:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1330, 1, 22, 0, '2024-06-05', 100000, 'Masuk', 'Tab masuk', '2024-06-05 13:42:20');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1331, 1, 102, 0, '2024-06-05', 10000, 'Masuk', 'Tab masuk', '2024-06-05 13:42:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1332, 1, 103, 0, '2024-06-05', 5000, 'Masuk', 'Tab masuk', '2024-06-05 13:43:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1333, 1, 118, 0, '2024-06-05', 5000, 'Masuk', 'Tab masuk', '2024-06-05 13:43:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1334, 1, 101, 0, '2024-06-05', 100000, 'Masuk', 'Tab masuk', '2024-06-05 13:44:21');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1335, 1, 150, 0, '2024-06-05', 50000, 'Masuk', 'Tab masuk', '2024-06-05 13:44:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1336, 1, 99, 0, '2024-06-05', 100000, 'Masuk', 'Tab masuk', '2024-06-05 14:17:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1337, 1, 20, 0, '2024-06-05', 20000, 'Masuk', 'Tab masuk', '2024-06-05 14:17:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1338, 1, 19, 0, '2024-06-05', 20000, 'Masuk', 'Tab masuk', '2024-06-05 14:18:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1339, 1, 106, 0, '2024-06-05', 40000, 'Masuk', 'Tab masuk', '2024-06-05 14:18:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1340, 1, 131, 0, '2024-06-05', 35000, 'Masuk', 'Tab masuk', '2024-06-05 14:18:56');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1341, 1, 91, 0, '2024-06-05', 20000, 'Masuk', 'Tab masuk', '2024-06-05 14:19:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1342, 1, 111, 0, '2024-06-05', 50000, 'Masuk', 'Tab masuk', '2024-06-05 14:19:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1343, 1, 159, 0, '2024-06-05', 20000, 'Masuk', 'Tab masuk', '2024-06-05 14:22:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1344, 1, 85, 0, '2024-06-05', 15000, 'Masuk', 'Tab masuk', '2024-06-05 14:23:23');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1345, 1, 86, 0, '2024-06-05', 10000, 'Masuk', 'Tab masuk', '2024-06-05 14:23:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1346, 1, 77, 0, '2024-06-05', 15000, 'Masuk', 'Tab masuk', '2024-06-05 14:24:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1347, 1, 79, 0, '2024-06-05', 25000, 'Masuk', 'Tab masuk', '2024-06-05 14:25:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1348, 1, 76, 0, '2024-06-05', 20000, 'Masuk', 'Tab masuk', '2024-06-05 14:25:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1349, 1, 84, 0, '2024-06-05', 30000, 'Masuk', 'Tab masuk', '2024-06-05 14:25:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1350, 1, 80, 0, '2024-06-05', 30000, 'Masuk', 'Tab masuk', '2024-06-05 14:26:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1351, 1, 83, 0, '2024-06-05', 50000, 'Masuk', 'Tab masuk', '2024-06-05 14:26:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1352, 1, 88, 0, '2024-06-05', 10000, 'Masuk', 'Tab masuk', '2024-06-05 14:29:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1353, 1, 160, 0, '2024-06-05', 40000, 'Masuk', 'Tab masuk', '2024-06-05 14:31:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1354, 1, 125, 0, '2024-06-05', 20000, 'Masuk', 'Tab masuk', '2024-06-05 14:31:56');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1355, 1, 126, 0, '2024-06-05', 10000, 'Masuk', 'Tab masuk', '2024-06-05 14:32:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1356, 1, 124, 0, '2024-06-05', 100000, 'Masuk', 'Tab masuk', '2024-06-05 14:32:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1357, 1, 154, 0, '2024-06-05', 10000, 'Masuk', 'Tab masuk', '2024-06-05 14:33:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1358, 1, 40, 0, '2024-06-06', 20000, 'Masuk', 'Tab masuk', '2024-06-06 10:41:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1359, 1, 116, 0, '2024-06-06', 50000, 'Masuk', 'Tab masuk', '2024-06-06 10:41:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1360, 1, 35, 0, '2024-06-06', 1000000, 'Masuk', 'Tab masuk', '2024-06-06 10:45:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1361, 1, 161, 0, '2024-06-06', 200000, 'Masuk', 'Tab masuk', '2024-06-06 10:45:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1362, 1, 42, 0, '2024-06-06', 10000, 'Masuk', 'Tab masuk', '2024-06-06 10:46:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1363, 1, 121, 0, '2024-06-06', 10000, 'Masuk', 'Tab masuk', '2024-06-06 10:46:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1364, 1, 23, 0, '2024-06-06', 20000, 'Masuk', 'Tab masuk', '2024-06-06 10:47:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1365, 1, 47, 0, '2024-06-06', 50000, 'Masuk', 'Tab masuk', '2024-06-06 10:47:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1366, 1, 97, 0, '2024-06-06', 15000, 'Masuk', 'Tab masuk', '2024-06-06 10:47:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1367, 1, 46, 0, '2024-06-06', 10000, 'Masuk', 'Tab masuk', '2024-06-06 10:48:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1368, 1, 36, 0, '2024-06-06', 20000, 'Masuk', 'Tab masuk', '2024-06-06 11:28:21');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1369, 1, 27, 0, '2024-06-06', 30000, 'Masuk', 'Tab masuk', '2024-06-06 11:29:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1370, 1, 162, 0, '2024-06-06', 15000, 'Masuk', 'Tab masuk', '2024-06-06 11:34:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1371, 1, 145, 0, '2024-06-06', 10000, 'Masuk', 'Tab masuk', '2024-06-06 11:34:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1372, 1, 48, 0, '2024-06-06', 20000, 'Masuk', 'Tab masuk', '2024-06-06 11:35:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1373, 1, 38, 0, '2024-06-06', 10000, 'Masuk', 'Tab masuk', '2024-06-06 11:35:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1374, 1, 25, 0, '2024-06-06', 20000, 'Masuk', 'Tab masuk', '2024-06-06 11:35:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1375, 1, 113, 0, '2024-06-06', 50000, 'Masuk', 'Tab masuk', '2024-06-06 11:36:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1376, 1, 112, 0, '2024-06-06', 10000, 'Masuk', 'Tab masuk', '2024-06-06 11:36:21');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1377, 1, 30, 0, '2024-06-06', 20000, 'Masuk', 'Tab masuk', '2024-06-06 11:36:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1378, 1, 37, 0, '2024-06-06', 10000, 'Masuk', 'Tab masuk', '2024-06-06 11:37:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1379, 1, 28, 0, '2024-06-06', 30000, 'Masuk', 'Tab masuk', '2024-06-06 11:37:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1380, 1, 29, 0, '2024-06-06', 5000, 'Masuk', 'Tab masuk', '2024-06-06 11:38:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1381, 1, 39, 0, '2024-06-06', 20000, 'Masuk', 'Tab masuk', '2024-06-06 11:38:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1382, 1, 31, 0, '2024-06-06', 50000, 'Masuk', 'Tab masuk', '2024-06-06 11:39:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1383, 1, 32, 0, '2024-06-06', 10000, 'Masuk', 'Tab masuk', '2024-06-06 11:39:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1384, 1, 24, 0, '2024-06-06', 10000, 'Masuk', 'Tab masuk', '2024-06-06 11:40:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1385, 1, 41, 0, '2024-06-06', 2000, 'Masuk', 'Tab masuk', '2024-06-06 11:40:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1386, 1, 69, 0, '2024-06-06', 10000, 'Masuk', 'Tab masuk', '2024-06-06 11:40:52');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1387, 1, 117, 0, '2024-06-06', 50000, 'Masuk', 'Tab masuk', '2024-06-06 11:43:23');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1388, 1, 54, 0, '2024-06-06', 30000, 'Masuk', 'Tab masuk', '2024-06-06 11:43:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1389, 1, 90, 0, '2024-06-06', 115000, 'Masuk', 'Tab masuk', '2024-06-06 11:44:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1390, 1, 88, 0, '2024-06-06', 10000, 'Masuk', 'Tab masuk', '2024-06-06 11:44:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1391, 1, 11, 0, '2024-06-06', 100000, 'Masuk', 'Tab masuk', '2024-06-06 11:44:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1392, 1, 15, 0, '2024-06-06', 30000, 'Masuk', 'Tab masuk', '2024-06-06 11:45:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1393, 1, 14, 0, '2024-06-06', 30000, 'Masuk', 'Tab masuk', '2024-06-06 11:45:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1394, 1, 13, 0, '2024-06-06', 220000, 'Masuk', 'Tab masuk', '2024-06-06 11:46:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1395, 1, 138, 0, '2024-06-06', 15000, 'Masuk', 'Tab masuk', '2024-06-06 13:50:21');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1396, 1, 7, 0, '2024-06-06', 10000, 'Masuk', 'Tab masuk', '2024-06-06 13:50:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1397, 1, 6, 0, '2024-06-06', 10000, 'Masuk', 'Tab masuk', '2024-06-06 13:51:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1398, 1, 95, 0, '2024-06-06', 15000, 'Masuk', 'Tab masuk', '2024-06-06 13:51:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1399, 1, 94, 0, '2024-06-06', 10000, 'Masuk', 'Tab masuk', '2024-06-06 13:52:23');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1400, 1, 152, 0, '2024-06-06', 50000, 'Masuk', 'Tab masuk', '2024-06-06 13:53:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1401, 1, 135, 0, '2024-06-06', 10000, 'Masuk', 'Tab masuk', '2024-06-06 13:53:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1402, 1, 149, 0, '2024-06-06', 5000, 'Masuk', 'Tab masuk', '2024-06-06 13:54:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1403, 1, 58, 0, '2024-06-06', 20000, 'Masuk', 'Tab masuk', '2024-06-06 13:54:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1404, 1, 64, 0, '2024-06-06', 2000, 'Masuk', 'Tab masuk', '2024-06-06 13:54:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1405, 1, 57, 0, '2024-06-06', 20000, 'Masuk', 'Tab masuk', '2024-06-06 13:58:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1406, 1, 12, 0, '2024-06-06', 30000, 'Masuk', 'Tab masuk', '2024-06-06 14:00:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1407, 1, 10, 0, '2024-06-06', 20000, 'Masuk', 'Tab masuk', '2024-06-06 14:00:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1408, 1, 158, 0, '2024-06-06', 20000, 'Masuk', 'Tab masuk', '2024-06-06 14:01:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1409, 1, 16, 0, '2024-06-06', 70000, 'Masuk', 'Tab masuk', '2024-06-06 14:01:58');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1410, 1, 17, 0, '2024-06-06', 10000, 'Masuk', 'Tab masuk', '2024-06-06 14:02:23');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1411, 1, 18, 0, '2024-06-06', 10000, 'Masuk', 'Tab masuk', '2024-06-06 14:03:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1412, 1, 153, 0, '2024-06-06', 20000, 'Masuk', 'Tab masuk', '2024-06-06 14:04:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1413, 1, 60, 0, '2024-06-06', 50000, 'Masuk', 'Tab masuk', '2024-06-06 14:04:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1414, 1, 9, 0, '2024-06-06', 40000, 'Masuk', 'Tab masuk', '2024-06-06 14:05:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1415, 1, 107, 0, '2024-06-06', 20000, 'Masuk', 'Tab masuk', '2024-06-06 14:12:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1416, 1, 108, 0, '2024-06-06', 20000, 'Masuk', 'Tab masuk', '2024-06-06 14:13:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1417, 1, 119, 0, '2024-06-06', 10000, 'Masuk', 'Tab masuk', '2024-06-06 14:13:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1418, 1, 92, 0, '2024-06-06', 20000, 'Masuk', 'Tab masuk', '2024-06-06 14:13:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1419, 1, 102, 0, '2024-06-06', 10000, 'Masuk', 'Tab masuk', '2024-06-06 14:14:21');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1420, 1, 103, 0, '2024-06-06', 5000, 'Masuk', 'Tab masuk', '2024-06-06 14:14:43');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1421, 1, 118, 0, '2024-06-06', 5000, 'Masuk', 'Tab masuk', '2024-06-06 14:15:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1422, 1, 101, 0, '2024-06-06', 100000, 'Masuk', 'Tab masuk', '2024-06-06 14:15:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1423, 1, 150, 0, '2024-06-06', 50000, 'Masuk', 'Tab masuk', '2024-06-06 14:15:52');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1424, 1, 91, 0, '2024-06-06', 20000, 'Masuk', 'Tab masuk', '2024-06-06 14:16:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1425, 1, 111, 0, '2024-06-06', 50000, 'Masuk', 'Tab masuk', '2024-06-06 14:16:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1426, 1, 106, 0, '2024-06-06', 30000, 'Masuk', 'Tab masuk', '2024-06-06 14:17:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1427, 1, 133, 0, '2024-06-06', 200000, 'Masuk', 'Tab masuk', '2024-06-06 14:17:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1428, 1, 68, 0, '2024-06-06', 100000, 'Masuk', 'Tab masuk', '2024-06-06 14:17:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1429, 1, 125, 0, '2024-06-06', 20000, 'Masuk', 'Tab masuk', '2024-06-06 14:20:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1430, 1, 126, 0, '2024-06-06', 10000, 'Masuk', 'Tab masuk', '2024-06-06 14:20:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1431, 1, 122, 0, '2024-06-06', 5000, 'Masuk', 'Tab masuk', '2024-06-06 14:20:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1432, 1, 124, 0, '2024-06-06', 50000, 'Masuk', 'Tab masuk', '2024-06-06 14:21:26');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1433, 1, 137, 0, '2024-06-06', 20000, 'Masuk', 'Tab masuk', '2024-06-06 14:21:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1434, 1, 88, 0, '2024-06-07', 200000, 'Keluar', 'Tab keluar', '2024-06-07 07:22:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1435, 1, 60, 0, '2024-06-07', 50000, 'Masuk', 'Tab masuk', '2024-06-07 08:11:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1436, 1, 70, 0, '2024-06-07', 150000, 'Masuk', 'Tab masuk', '2024-06-07 08:12:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1437, 1, 144, 0, '2024-06-07', 20000, 'Masuk', 'Tab masuk', '2024-06-07 08:17:20');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1438, 1, 156, 0, '2024-06-07', 50000, 'Masuk', 'Tab masuk', '2024-06-07 08:17:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1439, 1, 40, 0, '2024-06-07', 20000, 'Masuk', 'Tab masuk', '2024-06-07 08:19:23');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1440, 1, 63, 0, '2024-06-07', 200000, 'Masuk', 'Tab masuk', '2024-06-07 09:09:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1441, 1, 152, 0, '2024-06-07', 50000, 'Masuk', 'Tab masuk', '2024-06-07 09:52:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1442, 1, 152, 0, '2024-06-07', 1000000, 'Keluar', 'Tab keluar', '2024-06-07 09:53:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1443, 1, 116, 0, '2024-06-07', 50000, 'Masuk', 'Tab masuk', '2024-06-07 10:28:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1444, 1, 143, 0, '2024-06-07', 20000, 'Masuk', 'Tab masuk', '2024-06-07 10:35:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1445, 1, 79, 0, '2024-06-07', 20000, 'Masuk', 'Tab masuk', '2024-06-07 10:35:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1446, 1, 84, 0, '2024-06-07', 20000, 'Masuk', 'Tab masuk', '2024-06-07 10:36:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1447, 1, 85, 0, '2024-06-07', 10000, 'Masuk', 'Tab masuk', '2024-06-07 10:36:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1448, 1, 74, 0, '2024-06-07', 25000, 'Masuk', 'Tab masuk', '2024-06-07 10:36:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1449, 1, 142, 0, '2024-06-07', 25000, 'Masuk', 'Tab masuk', '2024-06-07 10:37:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1450, 1, 45, 0, '2024-06-07', 10000, 'Masuk', 'Tab masuk', '2024-06-07 10:37:58');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1451, 1, 121, 0, '2024-06-07', 10000, 'Masuk', 'Tab masuk', '2024-06-07 10:38:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1452, 1, 33, 0, '2024-06-07', 10000, 'Masuk', 'Tab masuk', '2024-06-07 10:38:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1453, 1, 23, 0, '2024-06-07', 20000, 'Masuk', 'Tab masuk', '2024-06-07 10:40:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1454, 1, 46, 0, '2024-06-07', 10000, 'Masuk', 'Tab masuk', '2024-06-07 10:40:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1455, 1, 47, 0, '2024-06-07', 50000, 'Masuk', 'Tab masuk', '2024-06-07 10:40:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1456, 1, 36, 0, '2024-06-07', 20000, 'Masuk', 'Tab masuk', '2024-06-07 10:41:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1457, 1, 38, 0, '2024-06-07', 10000, 'Masuk', 'Tab masuk', '2024-06-07 10:41:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1458, 1, 68, 0, '2024-06-07', 100000, 'Masuk', 'Tab masuk', '2024-06-07 10:42:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1459, 1, 25, 0, '2024-06-07', 20000, 'Masuk', 'Tab masuk', '2024-06-07 10:42:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1460, 1, 113, 0, '2024-06-07', 500000, 'Masuk', 'Tab masuk', '2024-06-07 10:43:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1461, 1, 112, 0, '2024-06-07', 10000, 'Masuk', 'Tab masuk', '2024-06-07 10:43:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1462, 1, 30, 0, '2024-06-07', 20000, 'Masuk', 'Tab masuk', '2024-06-07 10:44:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1463, 1, 37, 0, '2024-06-07', 10000, 'Masuk', 'Tab masuk', '2024-06-07 10:44:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1464, 1, 28, 0, '2024-06-07', 30000, 'Masuk', 'Tab masuk', '2024-06-07 13:43:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1465, 1, 29, 0, '2024-06-07', 5000, 'Masuk', 'Tab masuk', '2024-06-07 13:44:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1466, 1, 31, 0, '2024-06-07', 50000, 'Masuk', 'Tab masuk', '2024-06-07 13:44:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1467, 1, 32, 0, '2024-06-07', 10000, 'Masuk', 'Tab masuk', '2024-06-07 13:44:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1468, 1, 24, 0, '2024-06-07', 10000, 'Masuk', 'Tab masuk', '2024-06-07 13:45:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1469, 1, 41, 0, '2024-06-07', 2000, 'Masuk', 'Tab masuk', '2024-06-07 13:45:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1470, 1, 147, 0, '2024-06-07', 10000, 'Masuk', 'Tab masuk', '2024-06-07 13:47:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1471, 1, 69, 0, '2024-06-07', 10000, 'Masuk', 'Tab masuk', '2024-06-07 13:51:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1472, 1, 117, 0, '2024-06-07', 50000, 'Masuk', 'Tab masuk', '2024-06-07 13:52:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1473, 1, 133, 0, '2024-06-07', 100000, 'Masuk', 'Tab masuk', '2024-06-07 13:52:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1474, 1, 54, 0, '2024-06-07', 30000, 'Masuk', 'Tab masuk', '2024-06-07 13:52:43');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1475, 1, 11, 0, '2024-06-07', 100000, 'Masuk', 'Tab masuk', '2024-06-07 13:53:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1476, 1, 15, 0, '2024-06-07', 30000, 'Masuk', 'Tab masuk', '2024-06-07 13:53:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1477, 1, 14, 0, '2024-06-07', 30000, 'Masuk', 'Tab masuk', '2024-06-07 13:54:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1478, 1, 138, 0, '2024-06-07', 15000, 'Masuk', 'Tab masuk', '2024-06-07 13:54:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1479, 1, 66, 0, '2024-06-07', 15000, 'Masuk', 'Tab masuk', '2024-06-07 13:55:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1480, 1, 95, 0, '2024-06-07', 25000, 'Masuk', 'Tab masuk', '2024-06-07 13:55:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1481, 1, 13, 0, '2024-06-07', 100000, 'Masuk', 'Tab masuk', '2024-06-07 13:59:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1482, 1, 21, 0, '2024-06-07', 100000, 'Masuk', 'Tab masuk', '2024-06-07 14:00:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1483, 1, 157, 0, '2024-06-07', 20000, 'Masuk', 'Tab masuk', '2024-06-07 14:00:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1484, 1, 22, 0, '2024-06-07', 100000, 'Masuk', 'Tab masuk', '2024-06-07 14:01:52');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1485, 1, 102, 0, '2024-06-07', 10000, 'Masuk', 'Tab masuk', '2024-06-07 14:02:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1486, 1, 101, 0, '2024-06-07', 100000, 'Masuk', 'Tab masuk', '2024-06-07 14:02:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1487, 1, 150, 0, '2024-06-07', 50000, 'Masuk', 'Tab masuk', '2024-06-07 14:03:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1488, 1, 103, 0, '2024-06-07', 5000, 'Masuk', 'Tab masuk', '2024-06-07 14:03:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1489, 1, 118, 0, '2024-06-07', 5000, 'Masuk', 'Tab masuk', '2024-06-07 14:03:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1490, 1, 20, 0, '2024-06-07', 20000, 'Masuk', 'Tab masuk', '2024-06-07 14:04:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1491, 1, 19, 0, '2024-06-07', 20000, 'Masuk', 'Tab masuk', '2024-06-07 14:04:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1492, 1, 94, 0, '2024-06-07', 10000, 'Masuk', 'Tab masuk', '2024-06-07 14:04:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1493, 1, 98, 0, '2024-06-07', 10000, 'Masuk', 'Tab masuk', '2024-06-07 14:05:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1494, 1, 148, 0, '2024-06-07', 5000, 'Masuk', 'Tab masuk', '2024-06-07 14:06:43');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1495, 1, 149, 0, '2024-06-07', 5000, 'Masuk', 'Tab masuk', '2024-06-07 14:07:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1496, 1, 57, 0, '2024-06-07', 20000, 'Masuk', 'Tab masuk', '2024-06-07 14:08:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1497, 1, 58, 0, '2024-06-07', 20000, 'Masuk', 'Tab masuk', '2024-06-07 14:08:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1498, 1, 64, 0, '2024-06-07', 2000, 'Masuk', 'Tab masuk', '2024-06-07 14:08:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1499, 1, 12, 0, '2024-06-07', 30000, 'Masuk', 'Tab masuk', '2024-06-07 14:09:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1500, 1, 158, 0, '2024-06-07', 20000, 'Masuk', 'Tab masuk', '2024-06-07 14:09:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1501, 1, 16, 0, '2024-06-07', 70000, 'Masuk', 'Tab masuk', '2024-06-07 14:10:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1502, 1, 17, 0, '2024-06-07', 10000, 'Masuk', 'Tab masuk', '2024-06-07 14:10:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1503, 1, 18, 0, '2024-06-07', 10000, 'Masuk', 'Tab masuk', '2024-06-07 14:11:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1504, 1, 108, 0, '2024-06-07', 20000, 'Masuk', 'Tab masuk', '2024-06-07 14:11:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1505, 1, 119, 0, '2024-06-07', 10000, 'Masuk', 'Tab masuk', '2024-06-07 14:11:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1506, 1, 91, 0, '2024-06-07', 20000, 'Masuk', 'Tab masuk', '2024-06-07 14:12:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1507, 1, 106, 0, '2024-06-07', 50000, 'Masuk', 'Tab masuk', '2024-06-07 14:12:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1508, 1, 111, 0, '2024-06-07', 50000, 'Masuk', 'Tab masuk', '2024-06-07 14:13:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1509, 1, 128, 0, '2024-06-07', 50000, 'Masuk', 'Tab masuk', '2024-06-07 14:13:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1510, 1, 125, 0, '2024-06-07', 20000, 'Masuk', 'Tab masuk', '2024-06-07 14:13:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1511, 1, 126, 0, '2024-06-07', 10000, 'Masuk', 'Tab masuk', '2024-06-07 14:14:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1512, 1, 137, 0, '2024-06-07', 20000, 'Masuk', 'Tab masuk', '2024-06-07 14:14:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1513, 1, 42, 0, '2024-06-07', 10000, 'Masuk', 'Tab masuk', '2024-06-07 14:15:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1514, 1, 97, 0, '2024-06-07', 15000, 'Masuk', 'Tab masuk', '2024-06-07 14:15:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1515, 1, 129, 0, '2024-06-07', 50000, 'Masuk', 'Tab masuk', '2024-06-07 14:15:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1516, 1, 9, 0, '2024-06-07', 20000, 'Masuk', 'Tab masuk', '2024-06-07 14:16:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1517, 1, 6, 0, '2024-06-07', 10000, 'Masuk', 'Tab masuk', '2024-06-07 14:16:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1518, 1, 7, 0, '2024-06-07', 10000, 'Masuk', 'Tab masuk', '2024-06-07 14:17:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1519, 1, 100, 0, '2024-06-08', 50000, 'Masuk', 'Tab masuk', '2024-06-08 09:16:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1520, 1, 40, 0, '2024-06-08', 20000, 'Masuk', 'Tab masuk', '2024-06-08 09:16:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1521, 1, 116, 0, '2024-06-08', 50000, 'Masuk', 'Tab masuk', '2024-06-08 10:41:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1522, 1, 70, 0, '2024-06-08', 30000, 'Masuk', 'Tab masuk', '2024-06-08 11:13:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1523, 1, 23, 0, '2024-06-08', 20000, 'Masuk', 'Tab masuk', '2024-06-08 19:50:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1524, 1, 33, 0, '2024-06-08', 10000, 'Masuk', 'Tab masuk', '2024-06-08 19:51:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1525, 1, 46, 0, '2024-06-08', 10000, 'Masuk', 'Tab masuk', '2024-06-08 19:51:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1526, 1, 47, 0, '2024-06-08', 50000, 'Masuk', 'Tab masuk', '2024-06-08 19:51:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1527, 1, 36, 0, '2024-06-08', 20000, 'Masuk', 'Tab masuk', '2024-06-08 19:52:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1528, 1, 145, 0, '2024-06-08', 45000, 'Masuk', 'Tab masuk', '2024-06-08 19:52:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1529, 1, 25, 0, '2024-06-08', 20000, 'Masuk', 'Tab masuk', '2024-06-08 19:53:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1530, 1, 113, 0, '2024-06-08', 50000, 'Masuk', 'Tab masuk', '2024-06-08 19:53:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1531, 1, 30, 0, '2024-06-08', 20000, 'Masuk', 'Tab masuk', '2024-06-08 19:53:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1532, 1, 37, 0, '2024-06-08', 10000, 'Masuk', 'Tab masuk', '2024-06-08 19:54:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1533, 1, 28, 0, '2024-06-08', 30000, 'Masuk', 'Tab masuk', '2024-06-08 19:54:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1534, 1, 128, 0, '2024-06-08', 50000, 'Masuk', 'Tab masuk', '2024-06-08 19:55:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1535, 1, 39, 0, '2024-06-08', 30000, 'Masuk', 'Tab masuk', '2024-06-08 19:55:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1536, 1, 13, 0, '2024-06-08', 150000, 'Masuk', 'Tab masuk', '2024-06-08 19:56:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1537, 1, 31, 0, '2024-06-08', 50000, 'Masuk', 'Tab masuk', '2024-06-08 19:56:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1538, 1, 32, 0, '2024-06-08', 10000, 'Masuk', 'Tab masuk', '2024-06-08 19:56:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1539, 1, 24, 0, '2024-06-08', 10000, 'Masuk', 'Tab masuk', '2024-06-08 19:57:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1540, 1, 41, 0, '2024-06-08', 2000, 'Masuk', 'Tab masuk', '2024-06-08 19:57:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1541, 1, 51, 0, '2024-06-08', 1000000, 'Masuk', 'Tab masuk', '2024-06-08 19:57:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1542, 1, 52, 0, '2024-06-08', 700000, 'Masuk', 'Tab masuk', '2024-06-08 19:58:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1543, 1, 117, 0, '2024-06-08', 50000, 'Masuk', 'Tab masuk', '2024-06-08 19:58:26');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1544, 1, 133, 0, '2024-06-08', 100000, 'Masuk', 'Tab masuk', '2024-06-08 19:58:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1545, 1, 38, 0, '2024-06-08', 10000, 'Masuk', 'Tab masuk', '2024-06-08 19:59:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1546, 1, 68, 0, '2024-06-08', 150000, 'Masuk', 'Tab masuk', '2024-06-08 19:59:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1547, 1, 78, 0, '2024-06-08', 150000, 'Masuk', 'Tab masuk', '2024-06-08 19:59:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1548, 1, 48, 0, '2024-06-08', 20000, 'Masuk', 'Tab masuk', '2024-06-08 20:00:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1549, 1, 54, 0, '2024-06-08', 30000, 'Masuk', 'Tab masuk', '2024-06-08 20:01:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1550, 1, 11, 0, '2024-06-08', 100000, 'Masuk', 'Tab masuk', '2024-06-08 20:02:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1551, 1, 15, 0, '2024-06-08', 20000, 'Masuk', 'Tab masuk', '2024-06-08 20:08:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1552, 1, 14, 0, '2024-06-08', 30000, 'Masuk', 'Tab masuk', '2024-06-08 20:08:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1553, 1, 66, 0, '2024-06-08', 15000, 'Masuk', 'Tab masuk', '2024-06-08 20:09:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1554, 1, 138, 0, '2024-06-08', 15000, 'Masuk', 'Tab masuk', '2024-06-08 20:09:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1555, 1, 95, 0, '2024-06-08', 15000, 'Masuk', 'Tab masuk', '2024-06-08 20:09:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1556, 1, 94, 0, '2024-06-08', 10000, 'Masuk', 'Tab masuk', '2024-06-08 20:10:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1557, 1, 98, 0, '2024-06-08', 10000, 'Masuk', 'Tab masuk', '2024-06-08 20:10:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1558, 1, 148, 0, '2024-06-08', 5000, 'Masuk', 'Tab masuk', '2024-06-08 20:10:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1559, 1, 149, 0, '2024-06-08', 5000, 'Masuk', 'Tab masuk', '2024-06-08 20:11:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1560, 1, 58, 0, '2024-06-08', 20000, 'Masuk', 'Tab masuk', '2024-06-08 20:11:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1561, 1, 64, 0, '2024-06-08', 2000, 'Masuk', 'Tab masuk', '2024-06-08 20:12:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1562, 1, 57, 0, '2024-06-08', 28008, 'Masuk', 'Tab masuk', '2024-06-08 20:12:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1563, 1, 12, 0, '2024-06-08', 30000, 'Masuk', 'Tab masuk', '2024-06-08 20:13:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1564, 1, 158, 0, '2024-06-08', 20000, 'Masuk', 'Tab masuk', '2024-06-08 20:13:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1565, 1, 163, 0, '2024-06-08', 10000, 'Masuk', 'Tab masuk', '2024-06-08 20:14:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1566, 1, 163, 0, '2024-06-07', 10000, 'Masuk', 'Tab masuk', '2024-06-08 20:15:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1567, 1, 16, 0, '2024-06-07', 70000, 'Masuk', 'Tab masuk', '2024-06-08 20:15:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1568, 1, 17, 0, '2024-06-08', 10000, 'Masuk', 'Tab masuk', '2024-06-08 20:15:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1569, 1, 18, 0, '2024-06-08', 10000, 'Masuk', 'Tab masuk', '2024-06-08 20:16:20');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1570, 1, 60, 0, '2024-06-08', 20000, 'Masuk', 'Tab masuk', '2024-06-08 20:16:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1571, 1, 108, 0, '2024-06-08', 20000, 'Masuk', 'Tab masuk', '2024-06-08 20:17:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1572, 1, 107, 0, '2024-06-08', 20000, 'Masuk', 'Tab masuk', '2024-06-08 20:17:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1573, 1, 119, 0, '2024-06-08', 10000, 'Masuk', 'Tab masuk', '2024-06-08 20:18:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1574, 1, 92, 0, '2024-06-08', 20000, 'Masuk', 'Tab masuk', '2024-06-08 20:18:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1575, 1, 6, 0, '2024-06-08', 10000, 'Masuk', 'Tab masuk', '2024-06-08 20:18:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1576, 1, 7, 0, '2024-06-08', 10000, 'Masuk', 'Tab masuk', '2024-06-08 20:19:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1577, 1, 59, 0, '2024-06-08', 20000, 'Masuk', 'Tab masuk', '2024-06-08 20:19:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1578, 1, 21, 0, '2024-06-08', 100000, 'Masuk', 'Tab masuk', '2024-06-08 20:20:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1579, 1, 157, 0, '2024-06-08', 20000, 'Masuk', 'Tab masuk', '2024-06-08 20:20:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1580, 1, 22, 0, '2024-06-08', 100000, 'Masuk', 'Tab masuk', '2024-06-08 20:20:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1581, 1, 101, 0, '2024-06-08', 100000, 'Masuk', 'Tab masuk', '2024-06-08 20:21:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1582, 1, 150, 0, '2024-06-08', 50000, 'Masuk', 'Tab masuk', '2024-06-08 20:21:26');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1583, 1, 102, 0, '2024-06-08', 10000, 'Masuk', 'Tab masuk', '2024-06-08 20:21:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1584, 1, 103, 0, '2024-06-08', 5000, 'Masuk', 'Tab masuk', '2024-06-08 20:22:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1585, 1, 118, 0, '2024-06-08', 5000, 'Masuk', 'Tab masuk', '2024-06-08 20:22:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1586, 1, 139, 0, '2024-06-08', 50000, 'Masuk', 'Tab masuk', '2024-06-08 20:23:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1587, 1, 19, 0, '2024-06-08', 20000, 'Masuk', 'Tab masuk', '2024-06-08 20:23:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1588, 1, 20, 0, '2024-06-08', 20000, 'Masuk', 'Tab masuk', '2024-06-08 20:24:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1589, 1, 106, 0, '2024-06-08', 20000, 'Masuk', 'Tab masuk', '2024-06-08 20:24:26');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1590, 1, 91, 0, '2024-06-08', 20000, 'Masuk', 'Tab masuk', '2024-06-08 20:24:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1591, 1, 126, 0, '2024-06-08', 10000, 'Masuk', 'Tab masuk', '2024-06-08 20:25:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1592, 1, 125, 0, '2024-06-08', 20000, 'Masuk', 'Tab masuk', '2024-06-08 20:25:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1593, 1, 9, 0, '2024-06-08', 40000, 'Masuk', 'Tab masuk', '2024-06-08 20:25:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1594, 1, 124, 0, '2024-06-08', 100000, 'Masuk', 'Tab masuk', '2024-06-08 20:26:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1595, 1, 122, 0, '2024-06-08', 5000, 'Masuk', 'Tab masuk', '2024-06-08 20:26:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1596, 1, 42, 0, '2024-06-08', 10000, 'Masuk', 'Tab masuk', '2024-06-08 20:26:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1597, 1, 129, 0, '2024-06-08', 50000, 'Masuk', 'Tab masuk', '2024-06-08 20:27:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1598, 1, 130, 0, '2024-06-08', 10000, 'Masuk', 'Tab masuk', '2024-06-08 20:27:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1599, 1, 164, 0, '2024-05-09', 200000, 'Masuk', 'Tab masuk', '2024-06-09 06:49:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1600, 1, 164, 0, '2024-06-09', 200000, 'Masuk', 'Tab masuk', '2024-06-09 06:49:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1601, 1, 13, 0, '2024-05-23', 200000, 'Masuk', 'Tab masuk', '2024-06-09 08:35:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1602, 1, 13, 0, '2024-05-24', 200000, 'Masuk', 'Tab masuk', '2024-06-09 08:36:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1603, 1, 13, 0, '2024-05-31', 200000, 'Masuk', 'Tab masuk', '2024-06-09 08:36:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1604, 1, 45, 0, '2024-06-09', 10000, 'Masuk', 'tabungan masuk', '2024-06-09 17:31:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1605, 1, 23, 0, '2024-06-09', 20000, 'Masuk', 'tabungan masuk', '2024-06-09 17:32:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1606, 1, 33, 0, '2024-06-09', 10000, 'Masuk', 'tabungan masuk', '2024-06-09 17:33:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1607, 1, 115, 0, '2024-06-09', 500000, 'Masuk', 'tabungan masuk', '2024-06-09 17:33:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1608, 1, 46, 0, '2024-06-09', 10000, 'Masuk', 'tabungan masuk', '2024-06-09 17:34:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1609, 1, 47, 0, '2024-06-09', 50000, 'Masuk', 'tabungan masuk', '2024-06-09 17:35:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1610, 1, 35, 0, '2024-06-09', 500000, 'Masuk', 'tabungan masuk', '2024-06-09 17:36:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1611, 1, 36, 0, '2024-06-09', 20000, 'Masuk', 'tabungan masuk', '2024-06-09 17:36:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1612, 1, 162, 0, '2024-06-09', 10000, 'Masuk', 'tabungan masuk', '2024-06-09 17:37:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1613, 1, 38, 0, '2024-06-09', 10000, 'Masuk', 'tabungan masuk', '2024-06-09 17:38:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1614, 1, 25, 0, '2024-06-09', 20000, 'Masuk', 'tabungan masuk', '2024-06-09 17:39:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1615, 1, 68, 0, '2024-06-09', 200000, 'Masuk', 'tabungan masuk', '2024-06-09 17:45:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1616, 1, 28, 0, '2024-06-09', 30000, 'Masuk', 'tabungan masuk', '2024-06-09 17:46:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1617, 1, 37, 0, '2024-06-09', 10000, 'Masuk', 'tabungan masuk', '2024-06-09 18:21:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1618, 1, 128, 0, '2024-06-09', 50000, 'Masuk', 'tabungan masuk', '2024-06-09 18:21:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1619, 1, 39, 0, '2024-06-09', 30000, 'Masuk', 'tabungan masuk', '2024-06-09 18:22:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1620, 1, 163, 0, '2024-06-09', 10000, 'Masuk', 'tabungan masuk', '2024-06-09 18:22:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1621, 1, 31, 0, '2024-06-09', 50000, 'Masuk', 'tabungan masuk', '2024-06-09 18:23:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1622, 1, 32, 0, '2024-06-09', 10000, 'Masuk', 'tabungan masuk', '2024-06-09 18:24:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1623, 1, 117, 0, '2024-06-09', 50000, 'Masuk', 'tabungan masuk', '2024-06-09 18:24:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1624, 1, 54, 0, '2024-06-09', 30000, 'Masuk', 'tabungan masuk', '2024-06-09 18:25:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1625, 1, 88, 0, '2024-06-09', 10000, 'Masuk', 'tabungan masuk', '2024-06-09 18:26:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1626, 1, 11, 0, '2024-06-09', 100000, 'Masuk', 'tabungan masuk', '2024-06-09 18:27:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1627, 1, 14, 0, '2024-06-09', 30000, 'Masuk', 'tabungan masuk', '2024-06-09 18:27:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1628, 1, 15, 0, '2024-06-09', 30000, 'Masuk', 'tabungan masuk', '2024-06-09 18:29:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1629, 1, 66, 0, '2024-06-09', 15000, 'Masuk', 'tabungan masuk', '2024-06-09 18:29:56');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1630, 1, 120, 0, '2024-06-09', 50000, 'Masuk', 'tabungan masuk', '2024-06-09 18:30:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1631, 1, 95, 0, '2024-06-09', 15000, 'Masuk', 'tabungan masuk', '2024-06-09 18:31:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1632, 1, 138, 0, '2024-06-09', 15000, 'Masuk', 'tabungan masuk', '2024-06-09 18:32:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1633, 1, 98, 0, '2024-06-09', 10000, 'Masuk', 'tabungan masuk', '2024-06-09 18:33:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1634, 1, 94, 0, '2024-06-09', 10000, 'Masuk', 'tabungan masuk', '2024-06-09 18:35:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1635, 1, 135, 0, '2024-06-09', 10000, 'Masuk', 'tabungan masuk', '2024-06-09 18:35:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1636, 1, 148, 0, '2024-06-09', 5000, 'Masuk', 'tabungan masuk', '2024-06-09 18:36:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1637, 1, 149, 0, '2024-06-09', 5000, 'Masuk', 'tabungan masuk', '2024-06-09 20:21:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1638, 1, 58, 0, '2024-06-09', 20000, 'Masuk', 'tabungan masuk', '2024-06-09 20:23:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1639, 1, 64, 0, '2024-06-09', 2000, 'Masuk', 'tabungan masuk', '2024-06-09 20:23:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1640, 1, 57, 0, '2024-06-09', 20000, 'Masuk', 'tabungan masuk', '2024-06-09 20:24:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1641, 1, 12, 0, '2024-06-09', 30000, 'Masuk', 'tabungan masuk', '2024-06-09 20:24:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1642, 1, 158, 0, '2024-06-09', 20000, 'Masuk', 'tabungan masuk', '2024-06-09 20:25:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1643, 1, 16, 0, '2024-06-09', 70000, 'Masuk', 'tabungan masuk', '2024-06-09 20:26:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1644, 1, 17, 0, '2024-06-09', 10000, 'Masuk', 'tabungan masuk', '2024-06-09 20:26:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1645, 1, 18, 0, '2024-06-09', 10000, 'Masuk', 'tabungan masuk', '2024-06-09 20:27:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1646, 1, 60, 0, '2024-06-09', 20000, 'Masuk', 'tabungan masuk', '2024-06-09 20:28:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1647, 1, 108, 0, '2024-06-09', 20000, 'Masuk', 'tabungan masuk', '2024-06-09 20:28:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1648, 1, 107, 0, '2024-06-09', 20000, 'Masuk', 'tabungan masuk', '2024-06-09 20:29:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1649, 1, 119, 0, '2024-06-09', 10000, 'Masuk', 'tabungan masuk', '2024-06-09 20:30:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1650, 1, 102, 0, '2024-06-09', 10000, 'Masuk', 'tabungan masuk', '2024-06-09 20:31:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1651, 1, 101, 0, '2024-06-09', 100000, 'Masuk', 'tabungan masuk', '2024-06-09 20:32:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1652, 1, 150, 0, '2024-06-09', 50000, 'Masuk', 'tabungan masuk', '2024-06-09 20:32:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1653, 1, 103, 0, '2024-06-09', 5000, 'Masuk', 'tabungan masuk', '2024-06-09 20:33:26');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1654, 1, 118, 0, '2024-06-09', 5000, 'Masuk', 'tabungan masuk', '2024-06-09 20:33:58');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1655, 1, 21, 0, '2024-06-09', 100000, 'Masuk', 'tabungan masuk', '2024-06-09 20:35:23');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1656, 1, 157, 0, '2024-06-09', 20000, 'Masuk', 'tabungan masuk', '2024-06-09 20:36:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1657, 1, 22, 0, '2024-06-09', 100000, 'Masuk', 'tabungan masuk', '2024-06-09 20:36:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1658, 1, 20, 0, '2024-06-09', 20000, 'Masuk', 'tabungan masuk', '2024-06-09 20:37:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1659, 1, 19, 0, '2024-06-09', 20000, 'Masuk', 'tabungan masuk', '2024-06-09 20:38:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1660, 1, 106, 0, '2024-06-09', 70000, 'Masuk', 'tabungan masuk', '2024-06-09 20:38:56');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1661, 1, 91, 0, '2024-06-09', 20000, 'Masuk', 'tabungan masuk', '2024-06-09 20:39:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1662, 1, 133, 0, '2024-06-09', 100000, 'Masuk', 'tabungan masuk', '2024-06-09 20:40:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1663, 1, 125, 0, '2024-06-09', 20000, 'Masuk', 'tabungan masuk', '2024-06-09 20:40:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1664, 1, 126, 0, '2024-06-09', 10000, 'Masuk', 'tabungan masuk', '2024-06-09 20:41:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1665, 1, 7, 0, '2024-06-09', 10000, 'Masuk', 'tabungan masuk', '2024-06-09 20:41:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1666, 1, 6, 0, '2024-06-09', 10000, 'Masuk', 'tabungan masuk', '2024-06-09 20:42:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1667, 1, 9, 0, '2024-06-09', 20000, 'Masuk', 'tabungan masuk', '2024-06-09 20:43:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1668, 1, 124, 0, '2024-06-09', 100000, 'Masuk', 'tabungan masuk', '2024-06-09 20:51:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1669, 1, 122, 0, '2024-06-09', 10000, 'Masuk', 'tabungan masuk', '2024-06-09 20:53:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1670, 1, 137, 0, '2024-06-09', 20000, 'Masuk', 'tabungan masuk', '2024-06-09 20:54:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1671, 1, 42, 0, '2024-06-09', 10000, 'Masuk', 'tabungan masuk', '2024-06-09 20:54:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1672, 1, 129, 0, '2024-06-09', 50000, 'Masuk', 'tabungan masuk', '2024-06-09 20:55:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1673, 1, 152, 0, '2024-06-09', 50000, 'Masuk', 'tabungan masuk', '2024-06-09 20:55:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1674, 1, 40, 0, '2024-06-10', 20000, 'Masuk', 'tabungan masuk', '2024-06-10 15:10:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1675, 1, 70, 0, '2024-06-10', 60000, 'Masuk', 'tabungan masuk', '2024-06-10 15:11:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1676, 1, 133, 0, '2024-06-10', 1000000, 'Keluar', 'tabungan keluar', '2024-06-10 15:12:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1677, 1, 10, 0, '2024-06-10', 1500000, 'Keluar', 'tabungan keluar', '2024-06-10 15:13:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1678, 1, 13, 0, '2024-06-10', 15000000, 'Keluar', 'tabungan keluar', '2024-06-10 15:13:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1679, 1, 136, 0, '2024-06-10', 292000, 'Masuk', 'tabungan masuk', '2024-06-10 16:25:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1680, 1, 48, 0, '2024-06-10', 20000, 'Masuk', 'tabungan masuk', '2024-06-10 16:26:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1681, 1, 33, 0, '2024-06-10', 10000, 'Masuk', 'tabungan masuk', '2024-06-10 16:26:52');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1682, 1, 23, 0, '2024-06-10', 20000, 'Masuk', 'tabungan masuk', '2024-06-10 16:27:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1683, 1, 47, 0, '2024-06-10', 50000, 'Masuk', 'tabungan masuk', '2024-06-10 16:28:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1684, 1, 35, 0, '2024-06-10', 500000, 'Masuk', 'tabungan masuk', '2024-06-10 16:28:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1685, 1, 36, 0, '2024-06-10', 20000, 'Masuk', 'tabungan masuk', '2024-06-10 16:29:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1686, 1, 162, 0, '2024-06-10', 10000, 'Masuk', 'tabungan masuk', '2024-06-10 16:30:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1687, 1, 38, 0, '2024-06-10', 10000, 'Masuk', 'tabungan masuk', '2024-06-10 16:30:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1688, 1, 25, 0, '2024-06-10', 20000, 'Masuk', 'tabungan masuk', '2024-06-10 16:31:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1689, 1, 112, 0, '2024-06-10', 10000, 'Masuk', 'tabungan masuk', '2024-06-10 16:31:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1690, 1, 30, 0, '2024-06-10', 20000, 'Masuk', 'tabungan masuk', '2024-06-10 16:32:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1691, 1, 28, 0, '2024-06-10', 30000, 'Masuk', 'tabungan masuk', '2024-06-10 16:33:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1692, 1, 128, 0, '2024-06-10', 50000, 'Masuk', 'tabungan masuk', '2024-06-10 16:33:58');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1693, 1, 37, 0, '2024-06-10', 10000, 'Masuk', 'tabungan masuk', '2024-06-10 16:34:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1694, 1, 163, 0, '2024-06-10', 10000, 'Masuk', 'tabungan masuk', '2024-06-10 16:35:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1695, 1, 39, 0, '2024-06-10', 20000, 'Masuk', 'tabungan masuk', '2024-06-10 16:36:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1696, 1, 13, 0, '2024-06-10', 100000, 'Masuk', 'tabungan masuk', '2024-06-10 16:36:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1697, 1, 31, 0, '2024-06-10', 50000, 'Masuk', 'tabungan masuk', '2024-06-10 16:37:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1698, 1, 32, 0, '2024-06-10', 10000, 'Masuk', 'tabungan masuk', '2024-06-10 16:38:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1699, 1, 24, 0, '2024-06-10', 10000, 'Masuk', 'tabungan masuk', '2024-06-10 16:38:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1700, 1, 41, 0, '2024-06-10', 2000, 'Masuk', 'tabungan masuk', '2024-06-10 16:39:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1701, 1, 69, 0, '2024-06-10', 20000, 'Masuk', 'tabungan masuk', '2024-06-10 16:39:43');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1702, 1, 117, 0, '2024-06-10', 50000, 'Masuk', 'tabungan masuk', '2024-06-10 16:40:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1703, 1, 133, 0, '2024-06-10', 100000, 'Masuk', 'tabungan masuk', '2024-06-10 16:40:58');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1704, 1, 88, 0, '2024-06-10', 10000, 'Masuk', 'tabungan masuk', '2024-06-10 16:41:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1705, 1, 85, 0, '2024-06-10', 10000, 'Masuk', 'tabungan masuk', '2024-06-10 16:42:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1706, 1, 89, 0, '2024-06-10', 10000, 'Masuk', 'tabungan masuk', '2024-06-10 16:42:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1707, 1, 84, 0, '2024-06-10', 20000, 'Masuk', 'tabungan masuk', '2024-06-10 16:43:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1708, 1, 68, 0, '2024-06-10', 250000, 'Masuk', 'tabungan masuk', '2024-06-10 16:44:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1709, 1, 11, 0, '2024-06-10', 100000, 'Masuk', 'tabungan masuk', '2024-06-10 16:44:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1710, 1, 111, 0, '2024-06-10', 50000, 'Masuk', 'tabungan masuk', '2024-06-10 16:45:52');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1711, 1, 15, 0, '2024-06-10', 20000, 'Masuk', 'tabungan masuk', '2024-06-10 16:46:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1712, 1, 95, 0, '2024-06-10', 30000, 'Masuk', 'tabungan masuk', '2024-06-10 16:46:58');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1713, 1, 138, 0, '2024-06-10', 15000, 'Masuk', 'tabungan masuk', '2024-06-10 16:47:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1714, 1, 66, 0, '2024-06-10', 15000, 'Masuk', 'tabungan masuk', '2024-06-10 16:48:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1715, 1, 94, 0, '2024-06-10', 10000, 'Masuk', 'tabungan masuk', '2024-06-10 16:48:58');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1716, 1, 148, 0, '2024-06-10', 5000, 'Masuk', 'tabungan masuk', '2024-06-10 16:49:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1717, 1, 116, 0, '2024-06-10', 50000, 'Masuk', 'tabungan masuk', '2024-06-10 16:50:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1718, 1, 58, 0, '2024-06-10', 20000, 'Masuk', 'tabungan masuk', '2024-06-10 16:50:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1719, 1, 64, 0, '2024-06-10', 2000, 'Masuk', 'tabungan masuk', '2024-06-10 16:51:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1720, 1, 57, 0, '2024-06-10', 20000, 'Masuk', 'tabungan masuk', '2024-06-10 16:51:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1721, 1, 158, 0, '2024-06-10', 20000, 'Masuk', 'tabungan masuk', '2024-06-10 16:52:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1722, 1, 60, 0, '2024-06-10', 20000, 'Masuk', 'tabungan masuk', '2024-06-10 16:57:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1723, 1, 108, 0, '2024-06-10', 20000, 'Masuk', 'tabungan masuk', '2024-06-10 16:58:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1724, 1, 107, 0, '2024-06-10', 20000, 'Masuk', 'tabungan masuk', '2024-06-10 16:58:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1725, 1, 119, 0, '2024-06-10', 10000, 'Masuk', 'tabungan masuk', '2024-06-10 16:59:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1726, 1, 92, 0, '2024-06-10', 20000, 'Masuk', 'tabungan masuk', '2024-06-10 16:59:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1727, 1, 139, 0, '2024-06-10', 100000, 'Masuk', 'tabungan masuk', '2024-06-10 17:00:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1728, 1, 21, 0, '2024-06-10', 100000, 'Masuk', 'tabungan masuk', '2024-06-10 17:01:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1729, 1, 157, 0, '2024-06-10', 20000, 'Masuk', 'tabungan masuk', '2024-06-10 17:01:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1730, 1, 22, 0, '2024-06-10', 100000, 'Masuk', 'tabungan masuk', '2024-06-10 17:03:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1731, 1, 102, 0, '2024-06-10', 10000, 'Masuk', 'tabungan masuk', '2024-06-10 17:04:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1732, 1, 101, 0, '2024-06-10', 100000, 'Masuk', 'tabungan masuk', '2024-06-10 17:04:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1733, 1, 150, 0, '2024-06-10', 50000, 'Masuk', 'tabungan masuk', '2024-06-10 17:05:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1734, 1, 103, 0, '2024-06-10', 5000, 'Masuk', 'tabungan masuk', '2024-06-10 17:05:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1735, 1, 118, 0, '2024-06-10', 5000, 'Masuk', 'tabungan masuk', '2024-06-10 17:06:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1736, 1, 19, 0, '2024-06-10', 20000, 'Masuk', 'tabungan masuk', '2024-06-10 17:06:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1737, 1, 20, 0, '2024-06-10', 20000, 'Masuk', 'tabungan masuk', '2024-06-10 17:07:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1738, 1, 91, 0, '2024-06-10', 20000, 'Masuk', 'tabungan masuk', '2024-06-10 17:07:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1739, 1, 106, 0, '2024-06-10', 35000, 'Masuk', 'tabungan masuk', '2024-06-10 17:08:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1740, 1, 152, 0, '2024-06-10', 50000, 'Masuk', 'tabungan masuk', '2024-06-10 17:09:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1741, 1, 137, 0, '2024-06-10', 20000, 'Masuk', 'tabungan masuk', '2024-06-10 17:09:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1742, 1, 124, 0, '2024-06-10', 50000, 'Masuk', 'tabungan masuk', '2024-06-10 17:10:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1743, 1, 122, 0, '2024-06-10', 10000, 'Masuk', 'tabungan masuk', '2024-06-10 17:11:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1744, 1, 42, 0, '2024-06-10', 10000, 'Masuk', 'tabungan masuk', '2024-06-10 17:11:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1745, 1, 6, 0, '2024-06-10', 10000, 'Masuk', 'tabungan masuk', '2024-06-10 17:12:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1746, 1, 7, 0, '2024-06-10', 10000, 'Masuk', 'tabungan masuk', '2024-06-10 17:12:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1747, 1, 129, 0, '2024-06-10', 50000, 'Masuk', 'tabungan masuk', '2024-06-10 17:13:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1748, 1, 40, 0, '2024-06-11', 20000, 'Masuk', 'tabungan masuk', '2024-06-11 16:11:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1749, 1, 70, 0, '2024-06-11', 30000, 'Masuk', 'tabungan masuk', '2024-06-11 16:12:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1750, 1, 121, 0, '2024-06-11', 10000, 'Masuk', 'tabungan masuk', '2024-06-11 16:13:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1751, 1, 33, 0, '2024-06-11', 10000, 'Masuk', 'tabungan masuk', '2024-06-11 16:14:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1753, 1, 46, 0, '2024-06-11', 310000, 'Masuk', 'tabungan masuk', '2024-06-11 16:15:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1754, 1, 47, 0, '2024-06-11', 50000, 'Masuk', 'tabungan masuk', '2024-06-11 16:16:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1755, 1, 35, 0, '2024-06-11', 500000, 'Masuk', 'tabungan masuk', '2024-06-11 16:17:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1756, 1, 34, 0, '2024-06-11', 10000, 'Masuk', 'tabungan masuk', '2024-06-11 16:24:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1757, 1, 145, 0, '2024-06-11', 10000, 'Masuk', 'tabungan masuk', '2024-06-11 16:25:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1758, 1, 48, 0, '2024-06-11', 20000, 'Masuk', 'tabungan masuk', '2024-06-11 16:25:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1759, 1, 38, 0, '2024-06-11', 10000, 'Masuk', 'tabungan masuk', '2024-06-11 16:26:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1760, 1, 113, 0, '2024-06-11', 50000, 'Masuk', 'tabungan masuk', '2024-06-11 16:27:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1761, 1, 25, 0, '2024-06-11', 20000, 'Masuk', 'tabungan masuk', '2024-06-11 16:27:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1762, 1, 112, 0, '2024-06-11', 10000, 'Masuk', 'tabungan masuk', '2024-06-11 16:28:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1763, 1, 30, 0, '2024-06-11', 20000, 'Masuk', 'tabungan masuk', '2024-06-11 16:28:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1764, 1, 37, 0, '2024-06-11', 10000, 'Masuk', 'tabungan masuk', '2024-06-11 16:29:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1765, 1, 28, 0, '2024-06-11', 30000, 'Masuk', 'tabungan masuk', '2024-06-11 16:30:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1766, 1, 29, 0, '2024-06-11', 10000, 'Masuk', 'tabungan masuk', '2024-06-11 16:33:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1767, 1, 39, 0, '2024-06-11', 20000, 'Masuk', 'tabungan masuk', '2024-06-11 16:33:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1768, 1, 163, 0, '2024-06-11', 10000, 'Masuk', 'tabungan masuk', '2024-06-11 16:34:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1769, 1, 31, 0, '2024-06-11', 50000, 'Masuk', 'tabungan masuk', '2024-06-11 16:34:56');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1770, 1, 32, 0, '2024-06-11', 10000, 'Masuk', 'tabungan masuk', '2024-06-11 16:35:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1771, 1, 117, 0, '2024-06-11', 50000, 'Masuk', 'tabungan masuk', '2024-06-11 16:36:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1772, 1, 133, 0, '2024-06-11', 100000, 'Masuk', 'tabungan masuk', '2024-06-11 16:36:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1774, 1, 89, 0, '2024-06-11', 10000, 'Masuk', 'tabungan masuk', '2024-06-11 16:38:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1775, 1, 88, 0, '2024-06-11', 10000, 'Masuk', 'tabungan masuk', '2024-06-11 16:38:43');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1776, 1, 129, 0, '2024-06-11', 50000, 'Masuk', 'tabungan masuk', '2024-06-11 16:40:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1777, 1, 130, 0, '2024-06-11', 10000, 'Masuk', 'tabungan masuk', '2024-06-11 16:41:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1778, 1, 42, 0, '2024-06-11', 10000, 'Masuk', 'tabungan masuk', '2024-06-11 16:45:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1779, 1, 137, 0, '2024-06-11', 20000, 'Masuk', 'tabungan masuk', '2024-06-11 16:45:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1780, 1, 9, 0, '2024-06-11', 40000, 'Masuk', 'tabungan masuk', '2024-06-11 17:06:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1781, 1, 124, 0, '2024-06-11', 50000, 'Masuk', 'tabungan masuk', '2024-06-11 17:07:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1782, 1, 126, 0, '2024-06-11', 10000, 'Masuk', 'tabungan masuk', '2024-06-11 17:08:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1783, 1, 125, 0, '2024-06-11', 20000, 'Masuk', 'tabungan masuk', '2024-06-11 17:09:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1784, 1, 68, 0, '2024-06-11', 250000, 'Masuk', 'tabungan masuk', '2024-06-11 17:10:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1785, 1, 54, 0, '2024-06-11', 30000, 'Masuk', 'tabungan masuk', '2024-06-11 17:10:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1786, 1, 111, 0, '2024-06-11', 50000, 'Masuk', 'tabungan masuk', '2024-06-11 17:11:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1787, 1, 91, 0, '2024-06-11', 20000, 'Masuk', 'tabungan masuk', '2024-06-11 17:12:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1788, 1, 106, 0, '2024-06-11', 60000, 'Masuk', 'tabungan masuk', '2024-06-11 17:12:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1789, 1, 131, 0, '2024-06-11', 10000, 'Masuk', 'tabungan masuk', '2024-06-11 17:13:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1790, 1, 59, 0, '2024-06-11', 20000, 'Masuk', 'tabungan masuk', '2024-06-11 17:14:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1791, 1, 92, 0, '2024-06-11', 20000, 'Masuk', 'tabungan masuk', '2024-06-11 17:14:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1792, 1, 119, 0, '2024-06-11', 10000, 'Masuk', 'tabungan masuk', '2024-06-11 17:15:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1793, 1, 107, 0, '2024-06-11', 20000, 'Masuk', 'tabungan masuk', '2024-06-11 17:16:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1794, 1, 108, 0, '2024-06-11', 20000, 'Masuk', 'tabungan masuk', '2024-06-11 17:16:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1795, 1, 6, 0, '2024-06-11', 10000, 'Masuk', 'tabungan masuk', '2024-06-11 17:17:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1796, 1, 7, 0, '2024-06-11', 10000, 'Masuk', 'tabungan masuk', '2024-06-11 17:17:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1797, 1, 60, 0, '2024-06-11', 20000, 'Masuk', 'tabungan masuk', '2024-06-11 17:18:21');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1798, 1, 152, 0, '2024-06-11', 50000, 'Masuk', 'tabungan masuk', '2024-06-11 17:19:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1799, 1, 102, 0, '2024-06-11', 10000, 'Masuk', 'tabungan masuk', '2024-06-11 17:26:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1800, 1, 101, 0, '2024-06-11', 100000, 'Masuk', 'tabungan masuk', '2024-06-11 17:27:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1801, 1, 150, 0, '2024-06-11', 50000, 'Masuk', 'tabungan masuk', '2024-06-11 17:27:43');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1802, 1, 118, 0, '2024-06-11', 5000, 'Masuk', 'tabungan masuk', '2024-06-11 17:29:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1803, 1, 103, 0, '2024-06-11', 5000, 'Masuk', 'tabungan masuk', '2024-06-11 17:30:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1804, 1, 21, 0, '2024-06-11', 100000, 'Masuk', 'tabungan masuk', '2024-06-11 17:31:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1805, 1, 157, 0, '2024-06-11', 20000, 'Masuk', 'tabungan masuk', '2024-06-11 17:31:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1806, 1, 22, 0, '2024-06-11', 100000, 'Masuk', 'tabungan masuk', '2024-06-11 17:32:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1807, 1, 95, 0, '2024-06-11', 10000, 'Masuk', 'tabungan masuk', '2024-06-11 18:35:23');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1808, 1, 138, 0, '2024-06-11', 15000, 'Masuk', 'tabungan masuk', '2024-06-11 18:36:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1809, 1, 98, 0, '2024-06-11', 10000, 'Masuk', 'tabungan masuk', '2024-06-11 18:37:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1810, 1, 135, 0, '2024-06-11', 10000, 'Masuk', 'tabungan masuk', '2024-06-11 18:37:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1811, 1, 148, 0, '2024-06-11', 5000, 'Masuk', 'tabungan masuk', '2024-06-11 18:38:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1812, 1, 58, 0, '2024-06-11', 20000, 'Masuk', 'tabungan masuk', '2024-06-11 18:38:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1813, 1, 64, 0, '2024-06-11', 2000, 'Masuk', 'tabungan masuk', '2024-06-11 18:39:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1814, 1, 10, 0, '2024-06-11', 20000, 'Masuk', 'tabungan masuk', '2024-06-11 18:39:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1815, 1, 12, 0, '2024-06-11', 30000, 'Masuk', 'tabungan masuk', '2024-06-11 18:40:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1816, 1, 158, 0, '2024-06-11', 20000, 'Masuk', 'tabungan masuk', '2024-06-11 18:41:21');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1817, 1, 40, 0, '2024-06-12', 20000, 'Masuk', 'tabungan masuk', '2024-06-12 16:36:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1818, 1, 70, 0, '2024-06-12', 30000, 'Masuk', 'tabungan masuk', '2024-06-12 16:36:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1819, 1, 151, 0, '2024-06-12', 10000, 'Masuk', 'tabungan masuk', '2024-06-12 16:37:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1820, 1, 151, 0, '2024-06-11', 10000, 'Masuk', 'tabungan masuk', '2024-06-12 16:38:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1821, 1, 45, 0, '2024-06-12', 10000, 'Masuk', 'tabungan masuk', '2024-06-12 16:39:20');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1822, 1, 33, 0, '2024-06-12', 10000, 'Masuk', 'tabungan masuk', '2024-06-12 16:40:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1823, 1, 46, 0, '2024-06-12', 10000, 'Masuk', 'tabungan masuk', '2024-06-12 16:40:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1824, 1, 47, 0, '2024-06-12', 50000, 'Masuk', 'tabungan masuk', '2024-06-12 16:41:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1825, 1, 34, 0, '2024-06-12', 10000, 'Masuk', 'tabungan masuk', '2024-06-12 16:43:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1826, 1, 162, 0, '2024-06-12', 10000, 'Masuk', 'tabungan masuk', '2024-06-12 16:44:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1827, 1, 38, 0, '2024-06-12', 10000, 'Masuk', 'tabungan masuk', '2024-06-12 16:44:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1828, 1, 48, 0, '2024-06-12', 20000, 'Masuk', 'tabungan masuk', '2024-06-12 16:45:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1829, 1, 25, 0, '2024-06-12', 40000, 'Masuk', 'tabungan masuk', '2024-06-12 16:46:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1830, 1, 68, 0, '2024-06-12', 100000, 'Masuk', 'tabungan masuk', '2024-06-12 16:47:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1831, 1, 113, 0, '2024-06-12', 50000, 'Masuk', 'tabungan masuk', '2024-06-12 16:47:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1832, 1, 112, 0, '2024-06-12', 10000, 'Masuk', 'tabungan masuk', '2024-06-12 18:13:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1833, 1, 30, 0, '2024-06-12', 20000, 'Masuk', 'tabungan masuk', '2024-06-12 18:13:56');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1834, 1, 37, 0, '2024-06-12', 10000, 'Masuk', 'tabungan masuk', '2024-06-12 18:14:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1835, 1, 28, 0, '2024-06-12', 30000, 'Masuk', 'tabungan masuk', '2024-06-12 18:15:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1836, 1, 29, 0, '2024-06-12', 5000, 'Masuk', 'tabungan masuk', '2024-06-12 18:15:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1837, 1, 39, 0, '2024-06-12', 20000, 'Masuk', 'tabungan masuk', '2024-06-12 18:16:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1838, 1, 163, 0, '2024-06-12', 10000, 'Masuk', 'tabungan masuk', '2024-06-12 18:16:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1839, 1, 13, 0, '2024-06-12', 150000, 'Masuk', 'tabungan masuk', '2024-06-12 18:17:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1840, 1, 24, 0, '2024-06-12', 10000, 'Masuk', 'tabungan masuk', '2024-06-12 18:18:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1841, 1, 41, 0, '2024-06-12', 2000, 'Masuk', 'tabungan masuk', '2024-06-12 18:18:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1842, 1, 31, 0, '2024-06-12', 50000, 'Masuk', 'tabungan masuk', '2024-06-12 18:19:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1843, 1, 32, 0, '2024-06-12', 10000, 'Masuk', 'tabungan masuk', '2024-06-12 18:19:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1844, 1, 69, 0, '2024-06-12', 20000, 'Masuk', 'tabungan masuk', '2024-06-12 18:20:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1845, 1, 117, 0, '2024-06-12', 50000, 'Masuk', 'tabungan masuk', '2024-06-12 18:21:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1846, 1, 82, 0, '2024-01-12', 10000, 'Masuk', 'tabungan masuk', '2024-06-12 18:24:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1847, 1, 76, 0, '2024-06-12', 20000, 'Masuk', 'tabungan masuk', '2024-06-12 18:25:21');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1848, 1, 75, 0, '2024-06-12', 10000, 'Masuk', 'tabungan masuk', '2024-06-12 18:25:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1849, 1, 79, 0, '2024-06-12', 30000, 'Masuk', 'tabungan masuk', '2024-06-12 18:26:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1850, 1, 77, 0, '2024-06-12', 15000, 'Masuk', 'tabungan masuk', '2024-06-12 18:27:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1851, 1, 160, 0, '2024-06-12', 55000, 'Masuk', 'tabungan masuk', '2024-06-12 18:27:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1852, 1, 88, 0, '2024-06-12', 10000, 'Masuk', 'tabungan masuk', '2024-06-12 18:28:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1853, 1, 165, 0, '2024-06-12', 120000, 'Masuk', 'tabungan masuk', '2024-06-12 18:33:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1854, 1, 11, 0, '2024-06-12', 100000, 'Masuk', 'tabungan masuk', '2024-06-12 18:34:20');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1855, 1, 15, 0, '2024-06-12', 30000, 'Masuk', 'tabungan masuk', '2024-06-12 18:34:52');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1856, 1, 14, 0, '2024-06-12', 30000, 'Masuk', 'tabungan masuk', '2024-06-12 18:35:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1857, 1, 152, 0, '2024-06-12', 50000, 'Masuk', 'tabungan masuk', '2024-06-12 18:36:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1858, 1, 138, 0, '2024-06-12', 15000, 'Masuk', 'tabungan masuk', '2024-06-12 18:36:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1859, 1, 135, 0, '2024-06-12', 10000, 'Masuk', 'tabungan masuk', '2024-06-12 18:37:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1860, 1, 55, 0, '2024-06-12', 10000, 'Masuk', 'tabungan masuk', '2024-06-12 18:38:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1861, 1, 56, 0, '2024-06-12', 2000, 'Masuk', 'tabungan masuk', '2024-06-12 18:38:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1862, 1, 58, 0, '2024-06-12', 30000, 'Masuk', 'tabungan masuk', '2024-06-12 18:39:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1863, 1, 64, 0, '2024-06-12', 2000, 'Masuk', 'tabungan masuk', '2024-06-12 18:39:56');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1864, 1, 57, 0, '2024-06-12', 20000, 'Masuk', 'tabungan masuk', '2024-06-12 18:40:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1865, 1, 12, 0, '2024-06-12', 30000, 'Masuk', 'tabungan masuk', '2024-06-12 18:51:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1866, 1, 158, 0, '2024-06-12', 20000, 'Masuk', 'tabungan masuk', '2024-06-12 18:52:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1867, 1, 108, 0, '2024-06-12', 20000, 'Masuk', 'tabungan masuk', '2024-06-12 18:53:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1868, 1, 107, 0, '2024-06-12', 20000, 'Masuk', 'tabungan masuk', '2024-06-12 18:54:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1869, 1, 119, 0, '2024-06-12', 10000, 'Masuk', 'tabungan masuk', '2024-06-12 18:54:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1870, 1, 92, 0, '2024-06-12', 20000, 'Masuk', 'tabungan masuk', '2024-06-12 18:55:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1871, 1, 99, 0, '2024-06-12', 300000, 'Masuk', 'tabungan masuk', '2024-06-12 18:55:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1872, 1, 102, 0, '2024-06-12', 10000, 'Masuk', 'tabungan masuk', '2024-06-12 18:56:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1873, 1, 101, 0, '2024-06-12', 100000, 'Masuk', 'tabungan masuk', '2024-06-12 19:09:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1874, 1, 150, 0, '2024-06-12', 50000, 'Masuk', 'tabungan masuk', '2024-06-12 19:09:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1875, 1, 103, 0, '2024-06-12', 5000, 'Masuk', 'tabungan masuk', '2024-06-12 19:10:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1876, 1, 118, 0, '2024-06-12', 5000, 'Masuk', 'tabungan masuk', '2024-06-12 19:10:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1877, 1, 19, 0, '2024-06-12', 20000, 'Masuk', 'tabungan masuk', '2024-06-12 19:11:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1878, 1, 20, 0, '2024-06-12', 20000, 'Masuk', 'tabungan masuk', '2024-06-12 19:12:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1879, 1, 21, 0, '2024-06-12', 100000, 'Masuk', 'tabungan masuk', '2024-06-12 19:13:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1880, 1, 157, 0, '2024-06-12', 20000, 'Masuk', 'tabungan masuk', '2024-06-12 19:13:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1881, 1, 22, 0, '2024-06-12', 100000, 'Masuk', 'tabungan masuk', '2024-06-12 19:14:20');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1882, 1, 111, 0, '2024-06-12', 50000, 'Masuk', 'tabungan masuk', '2024-06-12 19:14:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1883, 1, 91, 0, '2024-06-12', 20000, 'Masuk', 'tabungan masuk', '2024-06-12 19:15:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1884, 1, 106, 0, '2024-06-12', 50000, 'Masuk', 'tabungan masuk', '2024-06-12 19:16:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1885, 1, 131, 0, '2024-06-12', 10000, 'Masuk', 'tabungan masuk', '2024-06-12 19:16:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1886, 1, 133, 0, '2024-06-12', 100000, 'Masuk', 'tabungan masuk', '2024-06-12 19:17:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1887, 1, 125, 0, '2024-06-12', 20000, 'Masuk', 'tabungan masuk', '2024-06-12 19:26:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1888, 1, 126, 0, '2024-06-12', 10000, 'Masuk', 'tabungan masuk', '2024-06-12 19:27:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1889, 1, 122, 0, '2024-06-12', 10000, 'Masuk', 'tabungan masuk', '2024-06-12 19:27:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1890, 1, 124, 0, '2024-06-12', 50000, 'Masuk', 'tabungan masuk', '2024-06-12 19:28:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1891, 1, 137, 0, '2024-06-12', 20000, 'Masuk', 'tabungan masuk', '2024-06-12 19:28:58');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1892, 1, 42, 0, '2024-06-12', 5000, 'Masuk', 'tabungan masuk', '2024-06-12 19:29:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1893, 1, 97, 0, '2024-06-12', 20000, 'Masuk', 'tabungan masuk', '2024-06-12 19:30:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1894, 1, 69, 0, '2024-06-12', 20000, 'Masuk', 'tabungan masuk', '2024-06-12 19:31:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1895, 1, 167, 0, '2024-06-13', 50000, 'Masuk', 'tabungan masuk', '2024-06-13 15:57:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1896, 1, 168, 0, '2024-06-13', 100000, 'Masuk', 'tabungan masuk', '2024-06-13 16:09:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1897, 1, 40, 0, '2024-06-13', 20000, 'Masuk', 'tabungan masuk', '2024-06-13 16:18:56');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1898, 1, 70, 0, '2024-06-13', 30000, 'Masuk', 'tabungan masuk', '2024-06-13 16:19:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1899, 1, 23, 0, '2024-06-13', 20000, 'Masuk', 'tabungan masuk', '2024-06-13 16:20:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1900, 1, 33, 0, '2024-06-13', 10000, 'Masuk', 'tabungan masuk', '2024-06-13 16:22:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1901, 1, 46, 0, '2024-06-13', 10000, 'Masuk', 'tabungan masuk', '2024-06-13 16:23:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1902, 1, 35, 0, '2024-06-13', 500000, 'Masuk', 'tabungan masuk', '2024-06-13 16:23:58');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1903, 1, 68, 0, '2024-06-13', 100000, 'Masuk', 'tabungan masuk', '2024-06-13 16:24:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1904, 1, 48, 0, '2024-06-13', 20000, 'Masuk', 'tabungan masuk', '2024-06-13 16:25:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1905, 1, 38, 0, '2024-06-13', 10000, 'Masuk', 'tabungan masuk', '2024-06-13 16:26:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1906, 1, 113, 0, '2024-06-13', 50000, 'Masuk', 'tabungan masuk', '2024-06-13 16:26:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1907, 1, 29, 0, '2024-06-13', 10000, 'Masuk', 'tabungan masuk', '2024-06-13 16:27:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1908, 1, 30, 0, '2024-06-13', 20000, 'Masuk', 'tabungan masuk', '2024-06-13 16:27:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1909, 1, 37, 0, '2024-06-13', 10000, 'Masuk', 'tabungan masuk', '2024-06-13 16:28:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1910, 1, 31, 0, '2024-06-13', 50000, 'Masuk', 'tabungan masuk', '2024-06-13 16:28:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1911, 1, 32, 0, '2024-06-13', 10000, 'Masuk', 'tabungan masuk', '2024-06-13 16:29:20');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1912, 1, 69, 0, '2024-06-13', 10000, 'Masuk', 'tabungan masuk', '2024-06-13 16:29:58');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1913, 1, 117, 0, '2024-06-13', 50000, 'Masuk', 'tabungan masuk', '2024-06-13 16:30:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1914, 1, 28, 0, '2024-06-13', 30000, 'Masuk', 'tabungan masuk', '2024-06-13 16:31:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1915, 1, 128, 0, '2024-06-13', 50000, 'Masuk', 'tabungan masuk', '2024-06-13 16:31:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1916, 1, 148, 0, '2024-06-13', 5000, 'Masuk', 'tabungan masuk', '2024-06-13 16:32:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1917, 1, 58, 0, '2024-06-13', 20000, 'Masuk', 'tabungan masuk', '2024-06-13 16:33:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1918, 1, 64, 0, '2024-06-13', 2000, 'Masuk', 'tabungan masuk', '2024-06-13 16:33:52');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1919, 1, 57, 0, '2024-06-13', 20000, 'Masuk', 'tabungan masuk', '2024-06-13 16:34:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1920, 1, 55, 0, '2024-06-13', 10000, 'Masuk', 'tabungan masuk', '2024-06-13 16:35:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1921, 1, 56, 0, '2024-06-13', 2000, 'Masuk', 'tabungan masuk', '2024-06-13 16:35:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1922, 1, 158, 0, '2024-06-13', 20000, 'Masuk', 'tabungan masuk', '2024-06-13 16:40:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1923, 1, 12, 0, '2024-06-13', 30000, 'Masuk', 'tabungan masuk', '2024-06-13 16:41:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1924, 1, 60, 0, '2024-06-13', 20000, 'Masuk', 'tabungan masuk', '2024-06-13 16:42:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1925, 1, 153, 0, '2024-06-13', 20000, 'Masuk', 'tabungan masuk', '2024-06-13 16:42:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1926, 1, 107, 0, '2024-06-13', 20000, 'Masuk', 'tabungan masuk', '2024-06-13 16:43:20');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1927, 1, 119, 0, '2024-06-13', 10000, 'Masuk', 'tabungan masuk', '2024-06-13 16:44:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1928, 1, 92, 0, '2024-06-13', 20000, 'Masuk', 'tabungan masuk', '2024-06-13 16:44:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1929, 1, 94, 0, '2024-06-13', 10000, 'Masuk', 'tabungan masuk', '2024-06-13 16:45:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1930, 1, 98, 0, '2024-06-13', 10000, 'Masuk', 'tabungan masuk', '2024-06-13 16:46:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1931, 1, 106, 0, '2024-06-13', 70000, 'Masuk', 'tabungan masuk', '2024-06-13 16:46:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1932, 1, 91, 0, '2024-06-13', 20000, 'Masuk', 'tabungan masuk', '2024-06-13 16:47:21');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1933, 1, 20, 0, '2024-06-13', 20000, 'Masuk', 'tabungan masuk', '2024-06-13 16:48:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1934, 1, 19, 0, '2024-06-13', 20000, 'Masuk', 'tabungan masuk', '2024-06-13 16:48:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1935, 1, 21, 0, '2024-06-13', 100000, 'Masuk', 'tabungan masuk', '2024-06-13 16:50:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1936, 1, 157, 0, '2024-06-13', 20000, 'Masuk', 'tabungan masuk', '2024-06-13 16:51:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1937, 1, 22, 0, '2024-06-13', 100000, 'Masuk', 'tabungan masuk', '2024-06-13 16:51:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1938, 1, 39, 0, '2024-06-13', 20000, 'Masuk', 'tabungan masuk', '2024-06-13 16:54:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1939, 1, 163, 0, '2024-06-13', 10000, 'Masuk', 'tabungan masuk', '2024-06-13 16:54:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1940, 1, 111, 0, '2024-06-13', 50000, 'Masuk', 'tabungan masuk', '2024-06-13 16:55:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1941, 1, 152, 0, '2024-06-13', 50000, 'Masuk', 'tabungan masuk', '2024-06-13 16:56:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1942, 1, 102, 0, '2024-06-13', 10000, 'Masuk', 'tabungan masuk', '2024-06-13 16:56:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1943, 1, 101, 0, '2024-06-13', 100000, 'Masuk', 'tabungan masuk', '2024-06-13 16:57:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1944, 1, 150, 0, '2024-06-13', 50000, 'Masuk', 'tabungan masuk', '2024-06-13 16:57:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1945, 1, 118, 0, '2024-06-13', 5000, 'Masuk', 'tabungan masuk', '2024-06-13 16:58:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1946, 1, 103, 0, '2024-06-13', 5000, 'Masuk', 'tabungan masuk', '2024-06-13 16:59:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1947, 1, 133, 0, '2024-06-13', 100000, 'Masuk', 'tabungan masuk', '2024-06-13 16:59:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1948, 1, 54, 0, '2024-06-13', 60000, 'Masuk', 'tabungan masuk', '2024-06-13 17:00:23');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1949, 1, 124, 0, '2024-06-13', 50000, 'Masuk', 'tabungan masuk', '2024-06-13 17:01:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1950, 1, 137, 0, '2024-06-13', 20000, 'Masuk', 'tabungan masuk', '2024-06-13 17:01:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1951, 1, 42, 0, '2024-06-13', 10000, 'Masuk', 'tabungan masuk', '2024-06-13 17:02:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1952, 1, 129, 0, '2024-06-13', 50000, 'Masuk', 'tabungan masuk', '2024-06-13 17:02:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1953, 1, 97, 0, '2024-06-13', 40000, 'Masuk', 'tabungan masuk 12 dan 13 juni 2024', '2024-06-13 17:08:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1954, 1, 120, 0, '2024-06-14', 1200000, 'Keluar', 'tabungan keluar', '2024-06-14 16:02:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1955, 1, 113, 0, '2024-06-14', 300000, 'Keluar', 'tabungan keluar', '2024-06-14 16:04:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1956, 1, 40, 0, '2024-06-14', 20000, 'Masuk', 'tabungan masuk', '2024-06-14 16:04:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1957, 1, 70, 0, '2024-06-14', 30000, 'Masuk', 'tabungan masuk', '2024-06-14 16:05:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1958, 1, 33, 0, '2024-06-14', 10000, 'Masuk', 'tabungan masuk', '2024-06-14 16:05:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1959, 1, 169, 0, '2024-06-14', 400000, 'Masuk', 'tabungan masuk', '2024-06-14 16:12:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1960, 1, 47, 0, '2024-06-14', 50000, 'Masuk', 'tabungan masuk', '2024-06-14 16:12:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1961, 1, 46, 0, '2024-06-14', 10000, 'Masuk', 'tabungan masuk', '2024-06-14 16:13:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1962, 1, 115, 0, '2024-06-14', 500000, 'Masuk', 'tabungan masuk', '2024-06-14 16:18:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1963, 1, 114, 0, '2024-06-14', 5000, 'Masuk', 'tabungan masuk', '2024-06-14 16:18:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1964, 1, 161, 0, '2024-06-14', 300000, 'Masuk', 'tabungan masuk', '2024-06-14 16:19:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1965, 1, 36, 0, '2024-06-14', 20000, 'Masuk', 'tabungan masuk', '2024-06-14 16:20:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1966, 1, 36, 0, '2024-06-13', 20000, 'Masuk', 'tabungan masuk', '2024-06-14 16:20:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1967, 1, 36, 0, '2024-06-12', 20000, 'Masuk', 'tabungan masuk', '2024-06-14 16:21:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1968, 1, 36, 0, '2024-06-11', 20000, 'Masuk', 'tabungan masuk', '2024-06-14 16:22:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1969, 1, 47, 0, '2024-06-13', 50000, 'Masuk', 'tabungan masuk', '2024-06-14 16:23:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1970, 1, 168, 0, '2024-06-14', 100000, 'Masuk', 'tabungan masuk', '2024-06-14 16:24:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1971, 1, 167, 0, '2024-06-14', 50000, 'Masuk', 'tabungan masuk', '2024-06-14 16:24:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1972, 1, 38, 0, '2024-06-14', 10000, 'Masuk', 'tabungan masuk', '2024-06-14 16:25:20');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1973, 1, 68, 0, '2024-06-14', 100000, 'Masuk', 'tabungan masuk', '2024-06-14 16:26:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1974, 1, 25, 0, '2024-06-14', 50000, 'Masuk', 'tabungan masuk', '2024-06-14 16:26:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1975, 1, 28, 0, '2024-06-14', 30000, 'Masuk', 'tabungan masuk', '2024-06-14 16:27:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1976, 1, 37, 0, '2024-06-14', 10000, 'Masuk', 'tabungan masuk', '2024-06-14 16:27:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1977, 1, 30, 0, '2024-06-14', 20000, 'Masuk', 'tabungan masuk', '2024-06-14 16:28:21');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1978, 1, 163, 0, '2024-06-14', 10000, 'Masuk', 'tabungan masuk', '2024-06-14 16:29:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1979, 1, 31, 0, '2024-06-14', 50000, 'Masuk', 'tabungan masuk', '2024-06-14 16:29:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1980, 1, 32, 0, '2024-06-14', 10000, 'Masuk', 'tabungan masuk', '2024-06-14 16:30:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1981, 1, 24, 0, '2024-06-14', 10000, 'Masuk', 'tabungan masuk', '2024-06-14 16:31:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1982, 1, 41, 0, '2024-06-14', 2000, 'Masuk', 'tabungan masuk', '2024-06-14 16:31:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1983, 1, 69, 0, '2024-06-14', 10000, 'Masuk', 'tabungan masuk', '2024-06-14 16:33:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1984, 1, 117, 0, '2024-06-14', 50000, 'Masuk', 'tabungan masuk', '2024-06-14 16:34:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1985, 1, 133, 0, '2024-06-14', 100000, 'Masuk', 'tabungan masuk', '2024-06-14 16:34:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1986, 1, 54, 0, '2024-06-14', 30000, 'Masuk', 'tabungan masuk', '2024-06-14 16:35:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1987, 1, 129, 0, '2024-06-14', 50000, 'Masuk', 'tabungan masuk', '2024-06-14 16:35:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1988, 1, 97, 0, '2024-06-14', 20000, 'Masuk', 'tabungan masuk', '2024-06-14 16:36:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1989, 1, 42, 0, '2024-06-14', 10000, 'Masuk', 'tabungan masuk', '2024-06-14 16:36:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1990, 1, 137, 0, '2024-06-14', 20000, 'Masuk', 'tabungan masuk', '2024-06-14 16:37:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1991, 1, 126, 0, '2024-06-14', 10000, 'Masuk', 'tabungan masuk', '2024-06-14 16:38:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1992, 1, 125, 0, '2024-06-14', 20000, 'Masuk', 'tabungan masuk', '2024-06-14 16:39:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1993, 1, 88, 0, '2024-06-14', 10000, 'Masuk', 'tabungan masuk', '2024-06-14 16:39:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1994, 1, 89, 0, '2024-06-14', 10000, 'Masuk', 'tabungan masuk', '2024-06-14 16:40:21');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1995, 1, 152, 0, '2024-06-14', 50000, 'Masuk', 'tabungan masuk', '2024-06-14 16:40:58');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1996, 1, 111, 0, '2024-06-14', 50000, 'Masuk', 'tabungan masuk', '2024-06-14 16:41:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1997, 1, 91, 0, '2024-06-14', 20000, 'Masuk', 'tabungan masuk', '2024-06-14 16:42:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1998, 1, 106, 0, '2024-06-14', 50000, 'Masuk', 'tabungan masuk', '2024-06-14 16:42:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (1999, 1, 9, 0, '2024-06-14', 40000, 'Masuk', 'tabungan masuk', '2024-06-14 16:44:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2000, 1, 19, 0, '2024-06-14', 20000, 'Masuk', 'tabungan masuk', '2024-06-14 16:44:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2001, 1, 20, 0, '2024-06-14', 20000, 'Masuk', 'tabungan masuk', '2024-06-14 16:45:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2002, 1, 139, 0, '2024-06-14', 100000, 'Masuk', 'tabungan masuk', '2024-06-14 16:46:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2003, 1, 99, 0, '2024-06-14', 100000, 'Masuk', 'tabungan masuk', '2024-06-14 16:46:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2004, 1, 118, 0, '2024-06-14', 5000, 'Masuk', 'tabungan masuk', '2024-06-14 16:47:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2005, 1, 104, 0, '2024-06-14', 5000, 'Masuk', 'tabungan masuk', '2024-06-14 16:48:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2006, 1, 102, 0, '2024-06-14', 10000, 'Masuk', 'tabungan masuk', '2024-06-14 16:48:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2007, 1, 101, 0, '2024-06-14', 100000, 'Masuk', 'tabungan masuk', '2024-06-14 16:49:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2008, 1, 150, 0, '2024-06-14', 50000, 'Masuk', 'tabungan masuk', '2024-06-14 16:50:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2009, 1, 22, 0, '2024-06-14', 100000, 'Masuk', 'tabungan masuk', '2024-06-14 16:50:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2010, 1, 21, 0, '2024-06-14', 100000, 'Masuk', 'tabungan masuk', '2024-06-14 16:51:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2011, 1, 157, 0, '2024-06-14', 20000, 'Masuk', 'tabungan masuk', '2024-06-14 16:52:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2012, 1, 92, 0, '2024-06-14', 20000, 'Masuk', 'tabungan masuk', '2024-06-14 16:52:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2013, 1, 119, 0, '2024-06-14', 10000, 'Masuk', 'tabungan masuk', '2024-06-14 16:53:56');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2014, 1, 107, 0, '2024-06-14', 20000, 'Masuk', 'tabungan masuk', '2024-06-14 16:54:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2015, 1, 60, 0, '2024-06-14', 20000, 'Masuk', 'tabungan masuk', '2024-06-14 16:55:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2016, 1, 158, 0, '2024-06-14', 20000, 'Masuk', 'tabungan masuk', '2024-06-14 16:57:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2017, 1, 12, 0, '2024-06-14', 30000, 'Masuk', 'tabungan masuk', '2024-06-14 16:59:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2018, 1, 55, 0, '2024-06-14', 10000, 'Masuk', 'tabungan masuk', '2024-06-14 17:01:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2019, 1, 56, 0, '2024-06-14', 2000, 'Masuk', 'tabungan masuk', '2024-06-14 17:02:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2020, 1, 170, 0, '2024-06-14', 50000, 'Masuk', 'tabungan masuk', '2024-06-14 17:04:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2021, 1, 61, 0, '2024-06-14', 240000, 'Masuk', 'tabungan masuk', '2024-06-14 17:19:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2022, 1, 57, 0, '2024-06-14', 20000, 'Masuk', 'tabungan masuk', '2024-06-14 17:20:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2023, 1, 58, 0, '2024-06-14', 20000, 'Masuk', 'tabungan masuk', '2024-06-14 17:20:43');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2024, 1, 64, 0, '2024-06-14', 2000, 'Masuk', 'tabungan masuk', '2024-06-14 17:21:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2025, 1, 149, 0, '2024-06-14', 5000, 'Masuk', 'tabungan masuk', '2024-06-14 17:21:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2026, 1, 135, 0, '2024-06-14', 10000, 'Masuk', 'tabungan masuk', '2024-06-14 17:22:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2027, 1, 98, 0, '2024-06-14', 10000, 'Masuk', 'tabungan masuk', '2024-06-14 17:23:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2028, 1, 94, 0, '2024-06-14', 10000, 'Masuk', 'tabungan masuk', '2024-06-14 17:23:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2029, 1, 95, 0, '2024-06-14', 15000, 'Masuk', 'tabungan masuk', '2024-06-14 17:24:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2030, 1, 138, 0, '2024-06-14', 15000, 'Masuk', 'tabungan masuk', '2024-06-14 17:24:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2032, 1, 14, 0, '2024-06-14', 50000, 'Masuk', 'tabungan masuk', '2024-06-14 17:26:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2033, 1, 15, 0, '2024-06-14', 50000, 'Masuk', 'tabungan masuk', '2024-06-14 17:27:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2034, 1, 11, 0, '2024-06-14', 100000, 'Masuk', 'tabungan masuk', '2024-06-14 17:28:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2035, 1, 94, 0, '2024-06-15', 400000, 'Keluar', 'tabungan keluar', '2024-06-15 15:45:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2036, 1, 94, 0, '2024-06-15', 50000, 'Masuk', 'tabungan masuk', '2024-06-15 15:46:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2037, 1, 40, 0, '2024-06-15', 20000, 'Masuk', 'tabungan masuk', '2024-06-15 15:47:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2038, 1, 171, 0, '2024-06-15', 500000, 'Masuk', 'tabungan masuk', '2024-06-15 15:55:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2039, 1, 70, 0, '2024-06-15', 30000, 'Masuk', 'tabungan masuk', '2024-06-15 15:56:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2040, 1, 9, 0, '2024-06-15', 200000, 'Masuk', 'tabungan masuk', '2024-06-15 15:56:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2041, 1, 116, 0, '2024-06-15', 25000, 'Masuk', 'tabungan masuk', '2024-06-15 15:57:26');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2042, 1, 129, 0, '2024-06-15', 50000, 'Masuk', 'tabungan masuk', '2024-06-15 15:58:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2043, 1, 42, 0, '2024-06-15', 10000, 'Masuk', 'tabungan masuk', '2024-06-15 15:58:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2044, 1, 33, 0, '2024-06-15', 10000, 'Masuk', 'tabungan masuk', '2024-06-15 15:59:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2045, 1, 23, 0, '2024-06-15', 20000, 'Masuk', 'tabungan masuk', '2024-06-15 16:00:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2046, 1, 47, 0, '2024-06-15', 50000, 'Masuk', 'tabungan masuk', '2024-06-15 16:02:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2047, 1, 35, 0, '2024-06-15', 500000, 'Masuk', 'tabungan masuk', '2024-06-15 16:04:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2048, 1, 168, 0, '2024-06-15', 100000, 'Masuk', 'tabungan masuk', '2024-06-15 16:05:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2049, 1, 167, 0, '2024-06-15', 50000, 'Masuk', 'tabungan masuk', '2024-06-15 16:05:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2050, 1, 162, 0, '2024-06-15', 10000, 'Masuk', 'tabungan masuk', '2024-06-15 16:06:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2051, 1, 27, 0, '2024-06-15', 30000, 'Masuk', 'tabungan masuk', '2024-06-15 16:07:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2052, 1, 48, 0, '2024-06-15', 10000, 'Masuk', 'tabungan masuk', '2024-06-15 16:19:20');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2053, 1, 38, 0, '2024-06-15', 10000, 'Masuk', 'tabungan masuk', '2024-06-15 16:19:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2054, 1, 68, 0, '2024-06-15', 100000, 'Masuk', 'tabungan masuk', '2024-06-15 16:20:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2055, 1, 25, 0, '2024-06-15', 50000, 'Masuk', 'tabungan masuk', '2024-06-15 16:21:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2056, 1, 30, 0, '2024-06-15', 20000, 'Masuk', 'tabungan masuk', '2024-06-15 16:21:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2057, 1, 37, 0, '2024-06-15', 10000, 'Masuk', 'tabungan masuk', '2024-06-15 16:22:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2058, 1, 28, 0, '2024-06-15', 30000, 'Masuk', 'tabungan masuk', '2024-06-15 16:23:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2059, 1, 39, 0, '2024-06-15', 30000, 'Masuk', 'tabungan masuk', '2024-06-15 16:23:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2060, 1, 163, 0, '2024-06-15', 10000, 'Masuk', 'tabungan masuk', '2024-06-15 16:26:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2061, 1, 31, 0, '2024-06-15', 100000, 'Masuk', 'tabungan masuk', '2024-06-15 16:28:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2062, 1, 32, 0, '2024-06-15', 20000, 'Masuk', 'tabungan masuk', '2024-06-15 16:28:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2063, 1, 117, 0, '2024-06-15', 50000, 'Masuk', 'tabungan masuk', '2024-06-15 16:29:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2064, 1, 54, 0, '2024-06-15', 30000, 'Masuk', 'tabungan masuk', '2024-06-15 16:30:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2065, 1, 11, 0, '2024-06-15', 100000, 'Masuk', 'tabungan masuk', '2024-06-15 16:31:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2066, 1, 15, 0, '2024-06-15', 30000, 'Masuk', 'tabungan masuk', '2024-06-15 16:31:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2067, 1, 14, 0, '2024-06-15', 30000, 'Masuk', 'tabungan masuk', '2024-06-15 16:32:23');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2068, 1, 152, 0, '2024-06-15', 50000, 'Masuk', 'tabungan masuk', '2024-06-15 16:35:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2069, 1, 111, 0, '2024-06-15', 50000, 'Masuk', 'tabungan masuk', '2024-06-15 16:36:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2070, 1, 91, 0, '2024-06-15', 20000, 'Masuk', 'tabungan masuk', '2024-06-15 16:37:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2071, 1, 106, 0, '2024-06-15', 100000, 'Masuk', 'tabungan masuk', '2024-06-15 16:37:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2072, 1, 20, 0, '2024-06-15', 20000, 'Masuk', 'tabungan masuk', '2024-06-15 16:39:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2073, 1, 118, 0, '2024-06-15', 5000, 'Masuk', 'tabungan masuk', '2024-06-15 16:40:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2074, 1, 103, 0, '2024-06-15', 5000, 'Masuk', 'tabungan masuk', '2024-06-15 16:41:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2075, 1, 101, 0, '2024-06-15', 100000, 'Masuk', 'tabungan masuk', '2024-06-15 16:47:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2076, 1, 150, 0, '2024-06-15', 50000, 'Masuk', 'tabungan masuk', '2024-06-15 16:48:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2077, 1, 102, 0, '2024-06-15', 10000, 'Masuk', 'tabungan masuk', '2024-06-15 16:48:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2078, 1, 22, 0, '2024-06-15', 100000, 'Masuk', 'tabungan masuk', '2024-06-15 16:52:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2079, 1, 21, 0, '2024-06-15', 100000, 'Masuk', 'tabungan masuk', '2024-06-15 16:52:58');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2080, 1, 157, 0, '2024-06-15', 25000, 'Masuk', 'tabungan masuk', '2024-06-15 16:53:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2081, 1, 92, 0, '2024-06-15', 20000, 'Masuk', 'tabungan masuk', '2024-06-15 16:54:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2082, 1, 119, 0, '2024-06-15', 10000, 'Masuk', 'tabungan masuk', '2024-06-15 16:54:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2083, 1, 107, 0, '2024-06-15', 20000, 'Masuk', 'tabungan masuk', '2024-06-15 16:56:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2084, 1, 60, 0, '2024-06-15', 20000, 'Masuk', 'tabungan masuk', '2024-06-15 16:58:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2085, 1, 158, 0, '2024-06-15', 20000, 'Masuk', 'tabungan masuk', '2024-06-15 16:58:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2086, 1, 12, 0, '2024-06-15', 30000, 'Masuk', 'tabungan masuk', '2024-06-15 16:59:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2087, 1, 57, 0, '2024-06-15', 20000, 'Masuk', 'tabungan masuk', '2024-06-15 17:00:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2088, 1, 58, 0, '2024-06-15', 20000, 'Masuk', 'tabungan masuk', '2024-06-15 17:01:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2089, 1, 64, 0, '2024-06-15', 2000, 'Masuk', 'tabungan masuk', '2024-06-15 17:02:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2090, 1, 149, 0, '2024-06-15', 5000, 'Masuk', 'tabungan masuk', '2024-06-15 17:06:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2091, 1, 148, 0, '2024-06-15', 5000, 'Masuk', 'tabungan masuk', '2024-06-15 17:06:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2092, 1, 135, 0, '2024-06-15', 10000, 'Masuk', 'tabungan masuk', '2024-06-15 17:07:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2093, 1, 13, 0, '2024-06-15', 100000, 'Masuk', 'tabungan masuk', '2024-06-15 18:16:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2094, 1, 88, 0, '2024-06-15', 10000, 'Masuk', 'tabungan masuk', '2024-06-15 18:16:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2095, 1, 125, 0, '2024-06-15', 20000, 'Masuk', 'tabungan masuk', '2024-06-15 18:17:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2096, 1, 126, 0, '2024-06-15', 10000, 'Masuk', 'tabungan masuk', '2024-06-15 18:18:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2097, 1, 133, 0, '2024-06-15', 100000, 'Masuk', 'tabungan masuk', '2024-06-15 18:18:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2098, 1, 151, 0, '2024-06-15', 10000, 'Masuk', 'tabungan masuk', '2024-06-15 18:18:56');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2099, 1, 6, 0, '2024-06-15', 10000, 'Masuk', 'tabungan masuk', '2024-06-15 18:19:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2100, 1, 7, 0, '2024-06-15', 10000, 'Masuk', 'tabungan masuk', '2024-06-15 18:20:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2101, 1, 124, 0, '2024-06-15', 50000, 'Masuk', 'tabungan masuk', '2024-06-15 18:20:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2102, 1, 122, 0, '2024-06-15', 10000, 'Masuk', 'tabungan masuk', '2024-06-15 18:21:26');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2103, 1, 137, 0, '2024-06-15', 20000, 'Masuk', 'tabungan masuk', '2024-06-15 18:22:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2104, 1, 131, 0, '2024-06-15', 45000, 'Masuk', 'tabungan masuk', '2024-06-15 19:03:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2105, 1, 106, 0, '2024-06-15', 315000, 'Keluar', 'tabungan keluar', '2024-06-15 19:08:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2106, 1, 40, 0, '2024-06-16', 20000, 'Masuk', 'tabungan masuk', '2024-06-16 17:28:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2107, 1, 70, 0, '2024-06-16', 30000, 'Masuk', 'tabungan masuk', '2024-06-16 17:30:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2108, 1, 113, 0, '2024-06-16', 300000, 'Masuk', 'tabungan masuk', '2024-06-16 17:31:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2109, 1, 45, 0, '2024-06-16', 10000, 'Masuk', 'tabungan masuk', '2024-06-16 17:33:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2110, 1, 23, 0, '2024-06-16', 20000, 'Masuk', 'tabungan masuk', '2024-06-16 17:34:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2111, 1, 33, 0, '2024-06-16', 10000, 'Masuk', 'tabungan masuk', '2024-06-16 18:20:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2112, 1, 6, 0, '2024-06-16', 10000, 'Masuk', 'tabungan masuk', '2024-06-16 18:21:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2113, 1, 7, 0, '2024-06-16', 10000, 'Masuk', 'tabungan masuk', '2024-06-16 18:21:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2114, 1, 36, 0, '2024-06-16', 20000, 'Masuk', 'tabungan masuk', '2024-06-16 18:30:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2115, 1, 35, 0, '2024-06-16', 500000, 'Masuk', 'tabungan masuk', '2024-06-16 18:31:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2116, 1, 34, 0, '2024-06-16', 10000, 'Masuk', 'tabungan masuk', '2024-06-16 18:31:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2117, 1, 168, 0, '2024-06-16', 100000, 'Masuk', 'tabungan masuk', '2024-06-16 18:34:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2118, 1, 167, 0, '2024-06-16', 50000, 'Masuk', 'tabungan masuk', '2024-06-16 18:35:23');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2119, 1, 25, 0, '2024-06-16', 50000, 'Masuk', 'tabungan masuk', '2024-06-16 18:51:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2120, 1, 30, 0, '2024-06-16', 20000, 'Masuk', 'tabungan masuk', '2024-06-16 18:51:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2121, 1, 112, 0, '2024-06-16', 10000, 'Masuk', 'tabungan masuk', '2024-06-16 18:52:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2122, 1, 54, 0, '2024-06-16', 300000, 'Keluar', 'tabungan keluar', '2024-06-16 18:53:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2123, 1, 37, 0, '2024-06-16', 10000, 'Masuk', 'tabungan masuk', '2024-06-16 18:54:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2124, 1, 28, 0, '2024-06-16', 30000, 'Masuk', 'tabungan masuk', '2024-06-16 18:55:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2125, 1, 29, 0, '2024-06-16', 10000, 'Masuk', 'tabungan masuk', '2024-06-16 18:55:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2126, 1, 39, 0, '2024-06-16', 30000, 'Masuk', 'tabungan masuk', '2024-06-16 18:56:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2127, 1, 163, 0, '2024-06-16', 10000, 'Masuk', 'tabungan masuk', '2024-06-16 18:56:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2128, 1, 152, 0, '2024-06-16', 50000, 'Masuk', 'tabungan masuk', '2024-06-16 18:57:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2129, 1, 31, 0, '2024-06-16', 50000, 'Masuk', 'tabungan masuk', '2024-06-16 18:58:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2130, 1, 32, 0, '2024-06-16', 10000, 'Masuk', 'tabungan masuk', '2024-06-16 18:58:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2131, 1, 24, 0, '2024-06-16', 10000, 'Masuk', 'tabungan masuk', '2024-06-16 19:51:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2132, 1, 41, 0, '2024-06-16', 2000, 'Masuk', 'tabungan masuk', '2024-06-16 19:51:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2133, 1, 69, 0, '2024-06-16', 10000, 'Masuk', 'tabungan masuk', '2024-06-16 19:59:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2134, 1, 54, 0, '2024-06-16', 30000, 'Masuk', 'tabungan masuk', '2024-06-16 20:00:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2135, 1, 117, 0, '2024-06-16', 50000, 'Masuk', 'tabungan masuk', '2024-06-16 20:01:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2136, 1, 95, 0, '2024-06-16', 15000, 'Masuk', 'tabungan masuk', '2024-06-16 20:01:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2137, 1, 102, 0, '2024-06-16', 10000, 'Masuk', 'tabungan masuk', '2024-06-16 20:02:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2138, 1, 101, 0, '2024-06-16', 100000, 'Masuk', 'tabungan masuk', '2024-06-16 20:02:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2139, 1, 150, 0, '2024-06-16', 50000, 'Masuk', 'tabungan masuk', '2024-06-16 20:03:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2140, 1, 103, 0, '2024-06-16', 5000, 'Masuk', 'tabungan masuk', '2024-06-16 20:04:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2141, 1, 118, 0, '2024-06-16', 5000, 'Masuk', 'tabungan masuk', '2024-06-16 20:04:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2142, 1, 99, 0, '2024-06-16', 100000, 'Masuk', 'tabungan masuk', '2024-06-16 20:07:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2143, 1, 21, 0, '2024-06-16', 100000, 'Masuk', 'tabungan masuk', '2024-06-16 20:08:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2144, 1, 157, 0, '2024-06-16', 40000, 'Masuk', 'tabungan masuk', '2024-06-16 20:09:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2145, 1, 22, 0, '2024-06-16', 100000, 'Masuk', 'tabungan masuk', '2024-06-16 20:10:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2146, 1, 20, 0, '2024-06-16', 20000, 'Masuk', 'tabungan masuk', '2024-06-16 20:14:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2147, 1, 94, 0, '2024-06-16', 10000, 'Masuk', 'tabungan masuk', '2024-06-16 20:22:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2148, 1, 98, 0, '2024-06-16', 10000, 'Masuk', 'tabungan masuk', '2024-06-16 20:23:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2149, 1, 135, 0, '2024-06-16', 10000, 'Masuk', 'tabungan masuk', '2024-06-16 20:24:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2150, 1, 148, 0, '2024-06-16', 5000, 'Masuk', 'tabungan masuk', '2024-06-16 20:25:52');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2151, 1, 149, 0, '2024-06-16', 5000, 'Masuk', 'tabungan masuk', '2024-06-16 20:26:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2152, 1, 58, 0, '2024-06-16', 20000, 'Masuk', 'tabungan masuk', '2024-06-16 20:27:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2153, 1, 64, 0, '2024-06-16', 5000, 'Masuk', 'tabungan masuk', '2024-06-16 20:27:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2154, 1, 57, 0, '2024-06-16', 20000, 'Masuk', 'tabungan masuk', '2024-06-16 20:28:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2155, 1, 12, 0, '2024-06-16', 30000, 'Masuk', 'tabungan masuk', '2024-06-16 20:29:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2156, 1, 16, 0, '2024-06-16', 70000, 'Masuk', 'tabungan masuk', '2024-06-16 20:29:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2157, 1, 17, 0, '2024-06-16', 10000, 'Masuk', 'tabungan masuk', '2024-06-16 20:30:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2158, 1, 61, 0, '2024-06-16', 10000, 'Masuk', 'tabungan masuk', '2024-06-16 20:32:21');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2159, 1, 108, 0, '2024-06-16', 20000, 'Masuk', 'tabungan masuk', '2024-06-16 20:33:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2160, 1, 107, 0, '2024-06-16', 20000, 'Masuk', 'tabungan masuk', '2024-06-16 20:33:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2161, 1, 119, 0, '2024-06-16', 10000, 'Masuk', 'tabungan masuk', '2024-06-16 20:34:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2162, 1, 92, 0, '2024-06-16', 20000, 'Masuk', 'tabungan masuk', '2024-06-16 20:34:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2163, 1, 9, 0, '2024-06-16', 100000, 'Masuk', 'tabungan masuk', '2024-06-16 20:35:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2164, 1, 111, 0, '2024-06-16', 50000, 'Masuk', 'tabungan masuk', '2024-06-16 20:35:52');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2165, 1, 106, 0, '2024-06-16', 50000, 'Masuk', 'tabungan masuk', '2024-06-16 20:37:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2166, 1, 131, 0, '2024-06-16', 150000, 'Masuk', 'tabungan masuk', '2024-06-16 20:38:56');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2167, 1, 133, 0, '2024-06-16', 100000, 'Masuk', 'tabungan masuk', '2024-06-16 20:40:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2168, 1, 68, 0, '2024-06-16', 350000, 'Masuk', 'tabungan masuk', '2024-06-16 20:40:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2169, 1, 126, 0, '2024-06-16', 10000, 'Masuk', 'tabungan masuk', '2024-06-16 20:41:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2170, 1, 125, 0, '2024-06-16', 20000, 'Masuk', 'tabungan masuk', '2024-06-16 20:41:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2171, 1, 124, 0, '2024-06-16', 100000, 'Masuk', 'tabungan masuk', '2024-06-16 20:42:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2172, 1, 122, 0, '2024-06-16', 10000, 'Masuk', 'tabungan masuk', '2024-06-16 20:42:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2173, 1, 137, 0, '2024-06-16', 20000, 'Masuk', 'tabungan masuk', '2024-06-16 20:43:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2174, 1, 42, 0, '2024-06-16', 10000, 'Masuk', 'tabungan masuk', '2024-06-16 20:43:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2175, 1, 129, 0, '2024-06-16', 50000, 'Masuk', 'tabungan masuk', '2024-06-16 20:44:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2177, 1, 40, 0, '2024-06-18', 20000, 'Masuk', 'tabungan masuk', '2024-06-18 16:39:58');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2178, 1, 70, 0, '2024-06-18', 60000, 'Masuk', 'tabungan masuk', '2024-06-18 16:40:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2179, 1, 23, 0, '2024-06-18', 20000, 'Masuk', 'tabungan masuk', '2024-06-18 16:41:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2180, 1, 33, 0, '2024-06-18', 10000, 'Masuk', 'tabungan masuk', '2024-06-18 16:41:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2181, 1, 46, 0, '2024-06-18', 10000, 'Masuk', 'tabungan masuk', '2024-06-18 16:44:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2182, 1, 47, 0, '2024-06-18', 50000, 'Masuk', 'tabungan masuk', '2024-06-18 16:45:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2183, 1, 35, 0, '2024-06-18', 500000, 'Masuk', 'tabungan masuk', '2024-06-18 16:46:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2184, 1, 34, 0, '2024-06-18', 10000, 'Masuk', 'tabungan masuk', '2024-06-18 16:46:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2185, 1, 168, 0, '2024-06-18', 100000, 'Masuk', 'tabungan masuk', '2024-06-18 16:47:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2186, 1, 167, 0, '2024-06-18', 50000, 'Masuk', 'tabungan masuk', '2024-06-18 16:47:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2187, 1, 162, 0, '2024-06-18', 10000, 'Masuk', 'tabungan masuk', '2024-06-18 16:49:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2188, 1, 27, 0, '2024-06-18', 30000, 'Masuk', 'tabungan masuk', '2024-06-18 16:50:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2189, 1, 48, 0, '2024-06-18', 20000, 'Masuk', 'tabungan masuk', '2024-06-18 16:50:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2190, 1, 38, 0, '2024-06-18', 10000, 'Masuk', 'tabungan masuk', '2024-06-18 16:51:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2191, 1, 25, 0, '2024-06-18', 50000, 'Masuk', 'tabungan masuk', '2024-06-18 16:51:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2192, 1, 113, 0, '2024-06-18', 50000, 'Masuk', 'tabungan masuk', '2024-06-18 16:52:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2193, 1, 30, 0, '2024-06-18', 20000, 'Masuk', 'tabungan masuk', '2024-06-18 16:53:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2194, 1, 37, 0, '2024-06-18', 10000, 'Masuk', 'tabungan masuk', '2024-06-18 16:53:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2195, 1, 28, 0, '2024-06-18', 60000, 'Masuk', 'tabungan masuk', '2024-06-18 17:00:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2196, 1, 29, 0, '2024-06-18', 5000, 'Masuk', 'tabungan masuk', '2024-06-18 17:01:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2197, 1, 39, 0, '2024-06-18', 30000, 'Masuk', 'tabungan masuk', '2024-06-18 17:02:52');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2198, 1, 163, 0, '2024-06-18', 10000, 'Masuk', 'tabungan masuk', '2024-06-18 17:03:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2199, 1, 31, 0, '2024-06-18', 50000, 'Masuk', 'tabungan masuk', '2024-06-18 17:05:43');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2200, 1, 32, 0, '2024-06-18', 10000, 'Masuk', 'tabungan masuk', '2024-06-18 17:06:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2201, 1, 24, 0, '2024-06-18', 10000, 'Masuk', 'tabungan masuk', '2024-06-18 17:06:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2202, 1, 41, 0, '2024-06-18', 2000, 'Masuk', 'tabungan masuk', '2024-06-18 17:07:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2203, 1, 69, 0, '2024-06-18', 20000, 'Masuk', 'tabungan masuk', '2024-06-18 17:10:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2204, 1, 117, 0, '2024-06-18', 50000, 'Masuk', 'tabungan masuk', '2024-06-18 17:10:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2205, 1, 54, 0, '2024-06-18', 30000, 'Masuk', 'tabungan masuk', '2024-06-18 17:11:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2206, 1, 88, 0, '2024-06-18', 10000, 'Masuk', 'tabungan masuk', '2024-06-18 17:11:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2207, 1, 11, 0, '2024-06-18', 100000, 'Masuk', 'tabungan masuk', '2024-06-18 17:12:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2208, 1, 14, 0, '2024-06-18', 50000, 'Masuk', 'tabungan masuk', '2024-06-18 17:13:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2209, 1, 15, 0, '2024-06-18', 50000, 'Masuk', 'tabungan masuk', '2024-06-18 17:13:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2210, 1, 138, 0, '2024-06-18', 15000, 'Masuk', 'tabungan masuk', '2024-06-18 17:14:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2211, 1, 98, 0, '2024-06-18', 10000, 'Masuk', 'tabungan masuk', '2024-06-18 17:14:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2212, 1, 135, 0, '2024-06-18', 10000, 'Masuk', 'tabungan masuk', '2024-06-18 17:15:20');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2213, 1, 58, 0, '2024-06-18', 20000, 'Masuk', 'tabungan masuk', '2024-06-18 17:22:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2214, 1, 64, 0, '2024-06-18', 2000, 'Masuk', 'tabungan masuk', '2024-06-18 17:24:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2215, 1, 55, 0, '2024-06-18', 10000, 'Masuk', 'tabungan masuk', '2024-06-18 17:25:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2216, 1, 56, 0, '2024-06-18', 2000, 'Masuk', 'tabungan masuk', '2024-06-18 17:25:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2217, 1, 148, 0, '2024-06-18', 5000, 'Masuk', 'tabungan masuk', '2024-06-18 17:26:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2218, 1, 57, 0, '2024-06-18', 20000, 'Masuk', 'tabungan masuk', '2024-06-18 17:27:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2219, 1, 12, 0, '2024-06-18', 30000, 'Masuk', 'tabungan masuk', '2024-06-18 17:27:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2220, 1, 158, 0, '2024-06-18', 20000, 'Masuk', 'tabungan masuk', '2024-06-18 17:28:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2221, 1, 16, 0, '2024-06-18', 70000, 'Masuk', 'tabungan masuk', '2024-06-18 17:28:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2222, 1, 18, 0, '2024-06-18', 20000, 'Masuk', 'tabungan masuk', '2024-06-18 17:29:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2223, 1, 17, 0, '2024-06-18', 10000, 'Masuk', 'tabungan masuk', '2024-06-18 17:29:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2224, 1, 60, 0, '2024-06-18', 20000, 'Masuk', 'tabungan masuk', '2024-06-18 17:30:26');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2225, 1, 153, 0, '2024-06-18', 10000, 'Masuk', 'tabungan masuk', '2024-06-18 17:30:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2226, 1, 108, 0, '2024-06-18', 20000, 'Masuk', 'tabungan masuk', '2024-06-18 17:31:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2227, 1, 107, 0, '2024-06-18', 20000, 'Masuk', 'tabungan masuk', '2024-06-18 17:32:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2228, 1, 92, 0, '2024-06-18', 20000, 'Masuk', 'tabungan masuk', '2024-06-18 17:32:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2229, 1, 7, 0, '2024-06-18', 10000, 'Masuk', 'tabungan masuk', '2024-06-18 17:33:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2230, 1, 6, 0, '2024-06-18', 10000, 'Masuk', 'tabungan masuk', '2024-06-18 17:34:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2231, 1, 42, 0, '2024-06-18', 10000, 'Masuk', 'tabungan masuk', '2024-06-18 18:21:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2232, 1, 137, 0, '2024-06-18', 20000, 'Masuk', 'tabungan masuk', '2024-06-18 18:22:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2233, 1, 124, 0, '2024-06-18', 100000, 'Masuk', 'tabungan masuk', '2024-06-18 18:22:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2234, 1, 68, 0, '2024-06-18', 100000, 'Masuk', 'tabungan masuk', '2024-06-18 18:23:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2235, 1, 133, 0, '2024-06-18', 100000, 'Masuk', 'tabungan masuk', '2024-06-18 18:23:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2236, 1, 9, 0, '2024-06-18', 40000, 'Masuk', 'tabungan masuk', '2024-06-18 18:24:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2237, 1, 91, 0, '2024-06-18', 20000, 'Masuk', 'tabungan masuk', '2024-06-18 18:24:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2238, 1, 106, 0, '2024-06-18', 40000, 'Masuk', 'tabungan masuk', '2024-06-18 18:25:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2239, 1, 152, 0, '2024-06-18', 50000, 'Masuk', 'tabungan masuk', '2024-06-18 18:26:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2240, 1, 111, 0, '2024-06-18', 50000, 'Masuk', 'tabungan masuk', '2024-06-18 18:26:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2241, 1, 99, 0, '2024-06-18', 100000, 'Masuk', 'tabungan masuk', '2024-06-18 18:27:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2242, 1, 22, 0, '2024-06-18', 100000, 'Masuk', 'tabungan masuk', '2024-06-18 18:27:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2243, 1, 21, 0, '2024-06-18', 200000, 'Masuk', 'tabungan masuk', '2024-06-18 18:28:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2244, 1, 157, 0, '2024-06-18', 20000, 'Masuk', 'tabungan masuk', '2024-06-18 18:28:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2245, 1, 101, 0, '2024-06-18', 100000, 'Masuk', 'tabungan masuk', '2024-06-18 18:29:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2246, 1, 150, 0, '2024-06-18', 50000, 'Masuk', 'tabungan masuk', '2024-06-18 18:29:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2247, 1, 102, 0, '2024-06-18', 10000, 'Masuk', 'tabungan masuk', '2024-06-18 18:30:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2248, 1, 103, 0, '2024-06-18', 5000, 'Masuk', 'tabungan masuk', '2024-06-18 18:30:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2249, 1, 118, 0, '2024-06-18', 5000, 'Masuk', 'tabungan masuk', '2024-06-18 18:31:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2250, 1, 40, 0, '2024-06-19', 20000, 'Masuk', 'tabungan masuk', '2024-06-19 17:10:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2251, 1, 70, 0, '2024-06-19', 30000, 'Masuk', 'tabungan masuk', '2024-06-19 17:11:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2252, 1, 5, 0, '2024-06-19', 2000000, 'Masuk', 'tabungan masuk', '2024-06-19 17:11:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2253, 1, 4, 0, '2024-06-19', 500000, 'Keluar', 'tabungan keluar', '2024-06-19 17:12:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2254, 1, 45, 0, '2024-06-19', 10000, 'Masuk', 'tabungan masuk', '2024-06-19 17:15:23');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2255, 1, 76, 0, '2024-06-19', 20000, 'Masuk', 'tabungan masuk', '2024-06-19 17:19:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2256, 1, 85, 0, '2024-06-19', 10000, 'Masuk', 'tabungan masuk', '2024-06-19 17:19:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2257, 1, 88, 0, '2024-06-19', 10000, 'Masuk', 'tabungan masuk', '2024-06-19 17:20:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2258, 1, 86, 0, '2024-06-19', 10000, 'Masuk', 'tabungan masuk', '2024-06-19 17:21:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2259, 1, 84, 0, '2024-06-19', 20000, 'Masuk', 'tabungan masuk', '2024-06-19 17:21:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2260, 1, 80, 0, '2024-06-19', 50000, 'Masuk', 'tabungan masuk', '2024-06-19 17:22:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2261, 1, 82, 0, '2024-06-19', 10000, 'Masuk', 'tabungan masuk', '2024-06-19 17:22:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2262, 1, 75, 0, '2024-06-19', 10000, 'Masuk', 'tabungan masuk', '2024-06-19 17:23:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2263, 1, 81, 0, '2024-06-19', 20000, 'Masuk', 'tabungan masuk', '2024-06-19 17:24:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2264, 1, 77, 0, '2024-06-19', 25000, 'Masuk', 'tabungan masuk', '2024-06-19 17:25:21');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2265, 1, 160, 0, '2024-06-19', 40000, 'Masuk', 'tabungan masuk', '2024-06-19 17:26:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2266, 1, 172, 0, '2024-06-19', 20000, 'Masuk', 'tabungan masuk', '2024-06-19 17:30:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2267, 1, 173, 0, '2024-06-19', 20000, 'Masuk', 'tabungan masuk', '2024-06-19 17:30:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2268, 1, 121, 0, '2024-06-19', 10000, 'Masuk', 'tabungan masuk', '2024-06-19 17:31:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2269, 1, 23, 0, '2024-06-19', 20000, 'Masuk', 'tabungan masuk', '2024-06-19 17:32:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2270, 1, 46, 0, '2024-06-19', 10000, 'Masuk', 'tabungan masuk', '2024-06-19 17:32:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2271, 1, 167, 0, '2024-06-19', 50000, 'Masuk', 'tabungan masuk', '2024-06-19 17:35:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2272, 1, 27, 0, '2024-06-19', 30000, 'Masuk', 'tabungan masuk', '2024-06-19 17:35:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2273, 1, 145, 0, '2024-06-19', 20000, 'Masuk', 'tabungan masuk', '2024-06-19 17:36:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2274, 1, 25, 0, '2024-06-19', 50000, 'Masuk', 'tabungan masuk', '2024-06-19 17:36:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2275, 1, 113, 0, '2024-06-19', 25000, 'Masuk', 'tabungan masuk', '2024-06-19 17:37:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2276, 1, 30, 0, '2024-06-19', 20000, 'Masuk', 'tabungan masuk', '2024-06-19 17:38:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2277, 1, 37, 0, '2024-06-19', 10000, 'Masuk', 'tabungan masuk', '2024-06-19 17:38:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2278, 1, 28, 0, '2024-06-19', 30000, 'Masuk', 'tabungan masuk', '2024-06-19 17:40:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2279, 1, 29, 0, '2024-06-19', 5000, 'Masuk', 'tabungan masuk', '2024-06-19 17:41:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2280, 1, 39, 0, '2024-06-19', 30000, 'Masuk', 'tabungan masuk', '2024-06-19 17:41:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2281, 1, 163, 0, '2024-06-19', 10000, 'Masuk', 'tabungan masuk', '2024-06-19 17:42:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2282, 1, 24, 0, '2024-06-19', 10000, 'Masuk', 'tabungan masuk', '2024-06-19 17:43:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2283, 1, 41, 0, '2024-06-19', 2000, 'Masuk', 'tabungan masuk', '2024-06-19 17:43:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2284, 1, 117, 0, '2024-06-19', 50000, 'Masuk', 'tabungan masuk', '2024-06-19 17:44:23');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2285, 1, 133, 0, '2024-06-19', 100000, 'Masuk', 'tabungan masuk', '2024-06-19 17:44:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2286, 1, 147, 0, '2024-06-19', 10000, 'Masuk', 'tabungan masuk', '2024-06-19 17:45:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2287, 1, 54, 0, '2024-06-19', 30000, 'Masuk', 'tabungan masuk', '2024-06-19 17:46:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2288, 1, 11, 0, '2024-06-19', 100000, 'Masuk', 'tabungan masuk', '2024-06-19 17:46:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2289, 1, 36, 0, '2024-06-19', 20000, 'Masuk', 'tabungan masuk', '2024-06-19 18:14:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2290, 1, 15, 0, '2024-06-19', 20000, 'Masuk', 'tabungan masuk', '2024-06-19 18:14:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2291, 1, 14, 0, '2024-06-19', 20000, 'Masuk', 'tabungan masuk', '2024-06-19 18:15:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2292, 1, 55, 0, '2024-06-19', 10000, 'Masuk', 'tabungan masuk', '2024-06-19 18:16:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2293, 1, 152, 0, '2024-06-19', 50000, 'Masuk', 'tabungan masuk', '2024-06-19 18:16:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2294, 1, 138, 0, '2024-06-19', 15000, 'Masuk', 'tabungan masuk', '2024-06-19 18:18:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2295, 1, 95, 0, '2024-06-19', 15000, 'Masuk', 'tabungan masuk', '2024-06-19 18:20:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2296, 1, 149, 0, '2024-06-19', 5000, 'Masuk', 'tabungan masuk', '2024-06-19 18:21:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2297, 1, 148, 0, '2024-06-19', 5000, 'Masuk', 'tabungan masuk', '2024-06-19 18:21:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2298, 1, 58, 0, '2024-06-19', 20000, 'Masuk', 'tabungan masuk', '2024-06-19 18:22:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2299, 1, 57, 0, '2024-06-19', 20000, 'Masuk', 'tabungan masuk', '2024-06-19 18:23:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2300, 1, 16, 0, '2024-06-19', 70000, 'Masuk', 'tabungan masuk', '2024-06-19 18:25:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2301, 1, 17, 0, '2024-06-19', 10000, 'Masuk', 'tabungan masuk', '2024-06-19 18:26:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2302, 1, 18, 0, '2024-06-19', 20000, 'Masuk', 'tabungan masuk', '2024-06-19 18:26:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2303, 1, 60, 0, '2024-06-19', 20000, 'Masuk', 'tabungan masuk', '2024-06-19 18:27:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2304, 1, 107, 0, '2024-06-19', 20000, 'Masuk', 'tabungan masuk', '2024-06-19 18:28:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2305, 1, 99, 0, '2024-06-19', 200000, 'Masuk', 'tabungan masuk', '2024-06-19 18:28:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2306, 1, 102, 0, '2024-06-19', 10000, 'Masuk', 'tabungan masuk', '2024-06-19 18:31:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2307, 1, 101, 0, '2024-06-19', 100000, 'Masuk', 'tabungan masuk', '2024-06-19 18:32:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2308, 1, 150, 0, '2024-06-19', 50000, 'Masuk', 'tabungan masuk', '2024-06-19 18:32:26');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2309, 1, 103, 0, '2024-06-19', 5000, 'Masuk', 'tabungan masuk', '2024-06-19 18:33:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2310, 1, 118, 0, '2024-06-19', 5000, 'Masuk', 'tabungan masuk', '2024-06-19 18:33:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2311, 1, 19, 0, '2024-06-19', 100000, 'Masuk', 'tabungan masuk', '2024-06-19 18:34:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2312, 1, 20, 0, '2024-06-19', 20000, 'Masuk', 'tabungan masuk', '2024-06-19 18:35:21');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2313, 1, 139, 0, '2024-06-19', 100000, 'Masuk', 'tabungan masuk', '2024-06-19 18:35:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2314, 1, 21, 0, '2024-06-19', 100000, 'Masuk', 'tabungan masuk', '2024-06-19 18:36:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2315, 1, 157, 0, '2024-06-19', 20000, 'Masuk', 'tabungan masuk', '2024-06-19 18:36:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2316, 1, 22, 0, '2024-06-19', 100000, 'Masuk', 'tabungan masuk', '2024-06-19 18:37:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2317, 1, 31, 0, '2024-06-19', 50000, 'Masuk', 'tabungan masuk', '2024-06-19 18:38:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2318, 1, 32, 0, '2024-06-19', 10000, 'Masuk', 'tabungan masuk', '2024-06-19 18:38:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2319, 1, 32, 0, '2024-06-19', 10000, 'Masuk', 'tabungan masuk', '2024-06-19 18:38:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2320, 1, 137, 0, '2024-06-19', 20000, 'Masuk', 'tabungan masuk', '2024-06-19 18:39:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2321, 1, 42, 0, '2024-06-19', 10000, 'Masuk', 'tabungan masuk', '2024-06-19 18:39:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2322, 1, 174, 0, '2024-06-19', 20000, 'Masuk', 'tabungan masuk', '2024-06-19 18:42:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2323, 1, 56, 0, '2024-06-19', 2000, 'Masuk', 'tabungan masuk', '2024-06-19 18:47:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2324, 1, 135, 0, '2024-06-19', 150000, 'Keluar', 'tabungan keluar', '2024-06-19 18:50:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2325, 1, 40, 0, '2024-06-20', 20000, 'Masuk', 'tabungan masuk', '2024-06-21 16:35:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2326, 1, 40, 0, '2024-06-21', 20000, 'Masuk', 'tabungan masuk', '2024-06-21 16:36:20');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2327, 1, 70, 0, '2024-06-21', 30000, 'Masuk', 'tabungan masuk', '2024-06-21 16:36:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2328, 1, 70, 0, '2024-06-20', 30000, 'Masuk', 'tabungan masuk', '2024-06-21 16:37:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2329, 1, 45, 0, '2024-06-20', 5000, 'Masuk', 'tabungan masuk', '2024-06-21 16:38:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2330, 1, 45, 0, '2024-06-21', 10000, 'Masuk', 'tabungan masuk', '2024-06-21 16:38:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2331, 1, 121, 0, '2024-06-20', 10000, 'Masuk', 'tabungan masuk', '2024-06-21 16:47:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2332, 1, 121, 0, '2024-06-21', 10000, 'Masuk', 'tabungan masuk', '2024-06-21 16:47:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2333, 1, 47, 0, '2024-06-21', 100000, 'Masuk', 'tabungan masuk 20 dan 21 juni 2024', '2024-06-21 16:48:56');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2334, 1, 46, 0, '2024-06-21', 20000, 'Masuk', 'tabungan masuk 20 dan 21 juni 2024', '2024-06-21 16:49:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2335, 1, 105, 0, '2024-06-20', 200000, 'Masuk', 'tabungan masuk', '2024-06-21 16:50:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2336, 1, 34, 0, '2024-06-21', 20000, 'Masuk', 'tabungan masuk 20 dan 21 juni 2024', '2024-06-21 16:51:23');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2337, 1, 167, 0, '2024-06-21', 100000, 'Masuk', 'tabungan masuk 20 dan 21 juni 2024', '2024-06-21 16:54:52');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2338, 1, 27, 0, '2024-06-20', 30000, 'Masuk', 'tabungan masuk', '2024-06-21 16:55:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2339, 1, 162, 0, '2024-06-21', 20000, 'Masuk', 'tabungan masuk 20 dan 21 juni 2024', '2024-06-21 16:56:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2340, 1, 38, 0, '2024-06-21', 20000, 'Masuk', 'tabungan masuk 20 dan 21 juni 2024', '2024-06-21 16:57:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2341, 1, 25, 0, '2024-06-21', 100000, 'Masuk', 'tabungan masuk 20 dan 21 juni 2024', '2024-06-21 16:58:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2342, 1, 113, 0, '2024-06-21', 75000, 'Masuk', 'tabungan masuk 20 dan 21 juni 2024', '2024-06-21 16:59:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2343, 1, 112, 0, '2024-06-21', 20000, 'Masuk', 'tabungan masuk 20 dan 21 juni 2024', '2024-06-21 17:00:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2344, 1, 30, 0, '2024-06-21', 40000, 'Masuk', 'tabungan masuk 20 dan 21 juni 2024', '2024-06-21 17:00:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2345, 1, 37, 0, '2024-06-21', 20000, 'Masuk', 'tabungan masuk 20 dan 21 juni 2024', '2024-06-21 17:01:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2346, 1, 39, 0, '2024-06-21', 60000, 'Masuk', 'tabungan masuk 20 dan 21 juni 2024', '2024-06-21 17:02:21');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2347, 1, 163, 0, '2024-06-21', 20000, 'Masuk', 'tabungan masuk 20 dan 21 juni 2024', '2024-06-21 17:03:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2348, 1, 69, 0, '2024-06-21', 30000, 'Masuk', 'tabungan masuk 20 dan 21 juni 2024', '2024-06-21 17:04:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2349, 1, 117, 0, '2024-06-21', 100000, 'Masuk', 'tabungan masuk 20 dan 21 juni 2024', '2024-06-21 17:04:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2350, 1, 54, 0, '2024-06-21', 60000, 'Masuk', 'tabungan masuk 20 dan 21 juni 2024', '2024-06-21 17:05:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2351, 1, 88, 0, '2024-06-20', 20000, 'Masuk', 'tabungan masuk', '2024-06-21 17:06:23');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2352, 1, 152, 0, '2024-06-21', 50000, 'Masuk', 'tabungan masuk', '2024-06-21 17:07:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2353, 1, 174, 0, '2024-06-20', 20000, 'Masuk', 'tabungan masuk', '2024-06-21 17:09:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2354, 1, 11, 0, '2024-06-21', 200000, 'Masuk', 'tabungan masuk 20 dan 21 juni 2024', '2024-06-21 17:09:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2355, 1, 28, 0, '2024-06-21', 60000, 'Masuk', 'tabungan masuk', '2024-06-21 17:12:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2356, 1, 14, 0, '2024-06-21', 60000, 'Masuk', 'tabungan masuk 20 dan 21 juni 2024', '2024-06-21 17:12:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2357, 1, 15, 0, '2024-06-21', 50000, 'Masuk', 'tabungan masuk 20 dan 21 juni 2024', '2024-06-21 17:13:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2358, 1, 94, 0, '2024-06-21', 20000, 'Masuk', 'tabungan masuk 20 dan 21 juni 2024', '2024-06-21 17:14:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2359, 1, 135, 0, '2024-06-21', 20000, 'Masuk', 'tabungan masuk 20 dan 21 juni 2024', '2024-06-21 17:14:43');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2360, 1, 148, 0, '2024-06-20', 5000, 'Masuk', 'tabungan masuk ', '2024-06-21 17:18:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2361, 1, 149, 0, '2024-06-20', 5000, 'Masuk', 'tabungan masuk', '2024-06-21 17:18:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2362, 1, 58, 0, '2024-06-21', 40000, 'Masuk', 'tabungan masuk 20 dan 21 juni 2024', '2024-06-21 17:20:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2363, 1, 64, 0, '2024-06-21', 10000, 'Masuk', 'tabungan masuk 20 dan 21 juni 2024', '2024-06-21 17:20:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2364, 1, 57, 0, '2024-06-21', 40000, 'Masuk', 'tabungan masuk 20 dan 21 juni 2024', '2024-06-21 17:21:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2365, 1, 10, 0, '2024-06-20', 20000, 'Masuk', 'tabungan masuk', '2024-06-21 17:22:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2366, 1, 158, 0, '2024-06-20', 20000, 'Masuk', 'tabungan masuk', '2024-06-21 17:25:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2367, 1, 16, 0, '2024-06-21', 140000, 'Masuk', 'tabungan masuk 20 dan 21 juni 2024', '2024-06-21 17:26:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2368, 1, 18, 0, '2024-06-21', 40000, 'Masuk', 'tabungan masuk 20 dan 21 juni 2024', '2024-06-21 17:27:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2369, 1, 17, 0, '2024-06-21', 20000, 'Masuk', 'tabungan masuk 20 dan 21 juni 2024', '2024-06-21 17:28:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2370, 1, 61, 0, '2024-06-21', 60000, 'Masuk', 'tabungan masuk 20 dan 21 juni 2024', '2024-06-21 17:28:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2371, 1, 60, 0, '2024-06-20', 20000, 'Masuk', 'tabungan masuk', '2024-06-21 17:29:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2372, 1, 108, 0, '2024-06-21', 40000, 'Masuk', 'tabungan masuk 20 dan 21 juni 2024', '2024-06-21 17:30:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2373, 1, 107, 0, '2024-06-21', 40000, 'Masuk', 'tabungan masuk 20 dan 21 juni 2024', '2024-06-21 18:21:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2374, 1, 119, 0, '2024-06-21', 20000, 'Masuk', 'tabungan masuk 20 dan 21 juni 2024', '2024-06-21 18:22:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2375, 1, 92, 0, '2024-06-21', 40000, 'Masuk', 'tabungan masuk 20 dan 21 juni 2024', '2024-06-21 18:22:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2376, 1, 4, 0, '2024-06-21', 2000000, 'Keluar', 'tabungan keluar', '2024-06-21 18:23:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2377, 1, 102, 0, '2024-06-20', 10000, 'Masuk', 'tabungan masuk', '2024-06-21 18:29:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2378, 1, 101, 0, '2024-06-20', 100000, 'Masuk', 'tabungan masuk', '2024-06-21 18:30:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2379, 1, 150, 0, '2024-06-20', 50000, 'Masuk', 'tabungan masuk', '2024-06-21 18:31:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2380, 1, 103, 0, '2024-06-20', 5000, 'Masuk', 'tabungan masuk', '2024-06-21 18:32:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2381, 1, 118, 0, '2024-06-20', 5000, 'Masuk', 'tabungan masuk', '2024-06-21 18:33:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2382, 1, 19, 0, '2024-06-20', 20000, 'Masuk', 'tabungan masuk', '2024-06-21 18:34:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2383, 1, 20, 0, '2024-06-21', 20000, 'Masuk', 'tabungan masuk', '2024-06-21 18:35:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2384, 1, 91, 0, '2024-06-21', 60000, 'Masuk', 'tabungan masuk 20 dan 21 juni 2024', '2024-06-21 18:36:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2385, 1, 13, 0, '2024-06-21', 550000, 'Masuk', 'tabungan masuk 20 dan 21 juni 2024', '2024-06-21 18:38:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2386, 1, 106, 0, '2024-06-20', 50000, 'Masuk', 'tabungan masuk', '2024-06-21 18:39:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2387, 1, 26, 0, '2024-06-20', 50000, 'Masuk', 'tabungan masuk', '2024-06-21 18:40:23');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2388, 1, 133, 0, '2024-06-20', 100000, 'Masuk', 'tabungan masuk', '2024-06-21 18:41:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2389, 1, 99, 0, '2024-06-21', 200000, 'Masuk', 'tabungan masuk 20 dan 21 juni 2024', '2024-06-21 18:41:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2390, 1, 124, 0, '2024-06-21', 150000, 'Masuk', 'tabungan masuk 20 dan 21 juni 2024', '2024-06-21 18:42:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2391, 1, 137, 0, '2024-06-21', 40000, 'Masuk', 'tabungan masuk', '2024-06-21 18:43:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2392, 1, 42, 0, '2024-06-21', 20000, 'Masuk', 'tabungan masuk 20 dan 21 juni 2024', '2024-06-21 18:43:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2393, 1, 129, 0, '2024-06-20', 50000, 'Masuk', 'tabungan masuk', '2024-06-21 18:44:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2394, 1, 33, 0, '2024-06-21', 10000, 'Masuk', 'tabungan masuk', '2024-06-21 18:45:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2395, 1, 23, 0, '2024-06-21', 20000, 'Masuk', 'tabungan masuk', '2024-06-21 18:45:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2396, 1, 115, 0, '2024-06-21', 500000, 'Masuk', 'tabungan masuk', '2024-06-21 18:46:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2397, 1, 35, 0, '2024-06-21', 500000, 'Masuk', 'tabungan masuk', '2024-06-21 18:47:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2398, 1, 36, 0, '2024-06-21', 20000, 'Masuk', 'tabungan masuk', '2024-06-21 18:48:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2399, 1, 95, 0, '2024-06-21', 10000, 'Masuk', 'tabungan masuk', '2024-06-21 18:49:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2400, 1, 26, 0, '2024-06-21', 50000, 'Masuk', 'tabungan masuk', '2024-06-21 18:49:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2401, 1, 31, 0, '2024-06-21', 50000, 'Masuk', 'tabungan masuk', '2024-06-21 18:57:26');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2402, 1, 32, 0, '2024-06-21', 10000, 'Masuk', 'tabungan masuk', '2024-06-21 18:57:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2403, 1, 24, 0, '2024-06-21', 10000, 'Masuk', 'tabungan masuk', '2024-06-21 18:58:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2404, 1, 41, 0, '2024-06-21', 2000, 'Masuk', 'tabungan masuk', '2024-06-21 18:58:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2405, 1, 98, 0, '2024-06-21', 10000, 'Masuk', 'tabungan masuk', '2024-06-21 18:59:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2406, 1, 55, 0, '2024-06-21', 10000, 'Masuk', 'tabungan masuk', '2024-06-21 19:19:26');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2407, 1, 133, 0, '2024-06-21', 100000, 'Masuk', 'tabungan masuk', '2024-06-21 19:20:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2408, 1, 127, 0, '2024-06-21', 10000, 'Masuk', 'tabungan masuk', '2024-06-21 19:20:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2409, 1, 152, 0, '2024-06-20', 50000, 'Masuk', 'tabungan masuk', '2024-06-21 19:21:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2410, 1, 174, 0, '2024-06-21', 20000, 'Masuk', 'tabungan masuk', '2024-06-21 19:24:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2411, 1, 157, 0, '2024-06-21', 20000, 'Masuk', 'tabungan masuk', '2024-06-21 19:25:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2412, 1, 21, 0, '2024-06-21', 200000, 'Masuk', 'tabungan masuk', '2024-06-21 19:26:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2413, 1, 22, 0, '2024-06-21', 200000, 'Masuk', 'tabungan masuk', '2024-06-21 19:26:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2414, 1, 111, 0, '2024-06-21', 50000, 'Masuk', 'tabungan masuk', '2024-06-21 19:27:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2415, 1, 56, 0, '2024-06-21', 2000, 'Masuk', 'tabungan masuk', '2024-06-21 19:28:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2416, 1, 40, 0, '2024-06-22', 20000, 'Masuk', 'tabungan masuk', '2024-06-22 18:42:56');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2417, 1, 70, 0, '2024-06-22', 30000, 'Masuk', 'tabungan masuk', '2024-06-22 18:43:26');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2418, 1, 45, 0, '2024-06-22', 10000, 'Masuk', 'tabungan masuk', '2024-06-22 18:44:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2419, 1, 23, 0, '2024-06-22', 20000, 'Masuk', 'tabungan masuk', '2024-06-22 18:44:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2420, 1, 33, 0, '2024-06-22', 10000, 'Masuk', 'tabungan masuk', '2024-06-22 18:45:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2421, 1, 46, 0, '2024-06-22', 10000, 'Masuk', 'tabungan masuk', '2024-06-22 18:45:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2422, 1, 47, 0, '2024-06-22', 50000, 'Masuk', 'tabungan masuk', '2024-06-22 18:46:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2423, 1, 36, 0, '2024-06-22', 20000, 'Masuk', 'tabungan masuk', '2024-06-22 18:46:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2424, 1, 35, 0, '2024-06-22', 500000, 'Masuk', 'tabungan masuk', '2024-06-22 18:47:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2425, 1, 34, 0, '2024-06-22', 10000, 'Masuk', 'tabungan masuk', '2024-06-22 18:48:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2426, 1, 167, 0, '2024-06-22', 50000, 'Masuk', 'tabungan masuk', '2024-06-22 19:24:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2427, 1, 27, 0, '2024-06-22', 30000, 'Masuk', 'tabungan masuk', '2024-06-22 19:24:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2428, 1, 162, 0, '2024-06-22', 10000, 'Masuk', 'tabungan masuk', '2024-06-22 19:25:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2429, 1, 145, 0, '2024-06-22', 20000, 'Masuk', 'tabungan masuk', '2024-06-22 19:26:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2430, 1, 113, 0, '2024-06-22', 50000, 'Masuk', 'tabungan masuk', '2024-06-22 20:27:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2431, 1, 25, 0, '2024-06-22', 50000, 'Masuk', 'tabungan masuk', '2024-06-22 20:27:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2432, 1, 112, 0, '2024-06-22', 10000, 'Masuk', 'tabungan masuk', '2024-06-22 20:28:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2433, 1, 30, 0, '2024-06-22', 20000, 'Masuk', 'tabungan masuk', '2024-06-22 20:28:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2434, 1, 37, 0, '2024-06-22', 10000, 'Masuk', 'tabungan masuk', '2024-06-22 20:29:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2435, 1, 28, 0, '2024-06-22', 50000, 'Masuk', 'tabungan masuk', '2024-06-22 20:29:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2436, 1, 29, 0, '2024-06-22', 5000, 'Masuk', 'tabungan masuk', '2024-06-22 20:30:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2437, 1, 69, 0, '2024-06-22', 10000, 'Masuk', 'tabungan masuk', '2024-06-22 20:31:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2438, 1, 163, 0, '2024-06-22', 10000, 'Masuk', 'tabungan masuk', '2024-06-22 20:35:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2439, 1, 117, 0, '2024-06-22', 50000, 'Masuk', 'tabungan masuk', '2024-06-22 20:40:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2440, 1, 147, 0, '2024-06-22', 10000, 'Masuk', 'tabungan masuk', '2024-06-22 20:40:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2441, 1, 54, 0, '2024-06-22', 30000, 'Masuk', 'tabungan masuk', '2024-06-22 20:41:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2442, 1, 85, 0, '2024-06-22', 10000, 'Masuk', 'tabungan masuk', '2024-06-22 20:42:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2443, 1, 86, 0, '2024-06-22', 10000, 'Masuk', 'tabungan masuk', '2024-06-22 20:43:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2444, 1, 88, 0, '2024-06-22', 10000, 'Masuk', 'tabungan masuk', '2024-06-22 20:48:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2445, 1, 84, 0, '2024-06-22', 20000, 'Masuk', 'tabungan masuk', '2024-06-22 20:51:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2446, 1, 159, 0, '2024-06-22', 20000, 'Masuk', 'tabungan masuk', '2024-06-22 20:51:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2447, 1, 11, 0, '2024-06-22', 100000, 'Masuk', 'tabungan masuk', '2024-06-22 20:52:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2448, 1, 15, 0, '2024-06-22', 30000, 'Masuk', 'tabungan masuk', '2024-06-22 20:58:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2449, 1, 14, 0, '2024-06-22', 30000, 'Masuk', 'tabungan masuk', '2024-06-22 20:58:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2450, 1, 139, 0, '2024-06-22', 1010000, 'Keluar', 'tabungan keluar', '2024-06-22 20:59:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2451, 1, 138, 0, '2024-06-22', 15000, 'Masuk', 'tabungan masuk', '2024-06-22 21:00:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2452, 1, 95, 0, '2024-06-22', 40000, 'Masuk', 'tabungan masuk', '2024-06-22 21:01:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2453, 1, 135, 0, '2024-06-22', 10000, 'Masuk', 'tabungan masuk', '2024-06-22 21:02:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2454, 1, 121, 0, '2024-06-22', 10000, 'Masuk', 'tabungan masuk', '2024-06-22 21:02:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2455, 1, 58, 0, '2024-06-22', 20000, 'Masuk', 'tabungan masuk', '2024-06-22 21:04:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2456, 1, 64, 0, '2024-06-22', 2000, 'Masuk', 'tabungan masuk', '2024-06-22 21:05:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2457, 1, 57, 0, '2024-06-22', 20000, 'Masuk', 'tabungan masuk', '2024-06-22 21:05:43');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2458, 1, 10, 0, '2024-06-22', 20000, 'Masuk', 'tabungan masuk', '2024-06-22 21:14:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2459, 1, 16, 0, '2024-06-22', 70000, 'Masuk', 'tabungan masuk', '2024-06-22 21:15:52');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2460, 1, 17, 0, '2024-06-22', 10000, 'Masuk', 'tabungan masuk', '2024-06-22 21:16:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2461, 1, 18, 0, '2024-06-22', 20000, 'Masuk', 'tabungan masuk', '2024-06-22 21:16:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2462, 1, 61, 0, '2024-06-22', 10000, 'Masuk', 'tabungan masuk', '2024-06-22 21:17:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2463, 1, 60, 0, '2024-06-22', 20000, 'Masuk', 'tabungan masuk', '2024-06-22 21:18:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2464, 1, 107, 0, '2024-06-22', 20000, 'Masuk', 'tabungan masuk', '2024-06-22 21:18:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2465, 1, 119, 0, '2024-06-22', 10000, 'Masuk', 'tabungan masuk', '2024-06-22 21:19:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2466, 1, 92, 0, '2024-06-22', 20000, 'Masuk', 'tabungan masuk', '2024-06-22 21:19:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2467, 1, 111, 0, '2024-06-22', 50000, 'Masuk', 'tabungan masuk', '2024-06-22 21:20:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2468, 1, 9, 0, '2024-06-22', 40000, 'Masuk', 'tabungan masuk', '2024-06-22 21:20:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2469, 1, 152, 0, '2024-06-22', 50000, 'Masuk', 'tabungan masuk', '2024-06-22 21:21:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2470, 1, 174, 0, '2024-06-22', 20000, 'Masuk', 'tabungan masuk', '2024-06-22 21:22:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2471, 1, 94, 0, '2024-06-22', 10000, 'Masuk', 'tabungan masuk', '2024-06-22 21:22:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2472, 1, 19, 0, '2024-06-22', 20000, 'Masuk', 'tabungan masuk', '2024-06-22 21:23:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2473, 1, 20, 0, '2024-06-22', 20000, 'Masuk', 'tabungan masuk', '2024-06-22 21:23:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2474, 1, 102, 0, '2024-06-22', 10000, 'Masuk', 'tabungan masuk', '2024-06-22 21:24:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2475, 1, 103, 0, '2024-06-22', 5000, 'Masuk', 'tabungan masuk', '2024-06-22 21:25:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2476, 1, 118, 0, '2024-06-22', 5000, 'Masuk', 'tabungan masuk', '2024-06-22 21:26:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2477, 1, 101, 0, '2024-06-22', 200000, 'Masuk', 'tabungan masuk', '2024-06-22 21:26:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2478, 1, 150, 0, '2024-06-22', 100000, 'Masuk', 'tabungan masuk', '2024-06-22 21:27:52');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2479, 1, 91, 0, '2024-06-22', 20000, 'Masuk', 'tabungan masuk', '2024-06-22 21:28:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2480, 1, 133, 0, '2024-06-22', 100000, 'Masuk', 'tabungan masuk', '2024-06-22 21:29:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2481, 1, 125, 0, '2024-06-22', 20000, 'Masuk', 'tabungan masuk', '2024-06-22 21:29:58');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2482, 1, 126, 0, '2024-06-22', 10000, 'Masuk', 'tabungan masuk', '2024-06-22 21:30:26');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2483, 1, 124, 0, '2024-06-22', 100000, 'Masuk', 'tabungan masuk', '2024-06-22 21:31:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2484, 1, 137, 0, '2024-06-22', 20000, 'Masuk', 'tabungan masuk', '2024-06-22 21:31:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2485, 1, 129, 0, '2024-06-22', 50000, 'Masuk', 'tabungan masuk', '2024-06-22 21:32:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2486, 1, 6, 0, '2024-06-22', 10000, 'Masuk', 'tabungan masuk', '2024-06-22 21:32:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2487, 1, 7, 0, '2024-06-22', 10000, 'Masuk', 'tabungan masuk', '2024-06-22 21:33:26');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2488, 1, 40, 0, '2024-06-23', 20000, 'Masuk', 'tabungan masuk', '2024-06-23 16:18:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2489, 1, 70, 0, '2024-06-23', 30000, 'Masuk', 'tabungan masuk', '2024-06-23 16:18:52');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2490, 1, 45, 0, '2024-06-23', 10000, 'Masuk', 'tabungan masuk', '2024-06-23 16:19:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2491, 1, 121, 0, '2024-06-23', 10000, 'Masuk', 'tabungan masuk', '2024-06-23 16:20:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2492, 1, 23, 0, '2024-06-23', 20000, 'Masuk', 'tabungan masuk', '2024-06-23 16:20:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2493, 1, 33, 0, '2024-06-23', 10000, 'Masuk', 'tabungan masuk', '2024-06-23 16:21:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2494, 1, 47, 0, '2024-06-23', 50000, 'Masuk', 'tabungan masuk', '2024-06-23 16:21:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2495, 1, 46, 0, '2024-06-23', 10000, 'Masuk', 'tabungan masuk', '2024-06-23 16:22:20');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2496, 1, 36, 0, '2024-06-23', 20000, 'Masuk', 'tabungan masuk', '2024-06-23 16:22:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2497, 1, 34, 0, '2024-06-23', 10000, 'Masuk', 'tabungan masuk', '2024-06-23 16:23:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2498, 1, 167, 0, '2024-06-23', 50000, 'Masuk', 'tabungan masuk', '2024-06-23 16:24:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2499, 1, 162, 0, '2024-06-23', 10000, 'Masuk', 'tabungan masuk', '2024-06-23 16:24:43');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2500, 1, 145, 0, '2024-06-23', 15000, 'Masuk', 'tabungan masuk', '2024-06-23 16:25:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2501, 1, 38, 0, '2024-06-23', 10000, 'Masuk', 'tabungan masuk', '2024-06-23 16:26:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2502, 1, 25, 0, '2024-06-23', 40000, 'Masuk', 'tabungan masuk', '2024-06-23 16:27:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2503, 1, 112, 0, '2024-06-23', 10000, 'Masuk', 'tabungan masuk', '2024-06-23 16:27:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2504, 1, 37, 0, '2024-06-23', 10000, 'Masuk', 'tabungan masuk', '2024-06-23 16:28:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2505, 1, 30, 0, '2024-06-23', 20000, 'Masuk', 'tabungan masuk', '2024-06-23 16:29:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2506, 1, 113, 0, '2024-06-23', 50000, 'Masuk', 'tabungan masuk', '2024-06-23 16:30:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2507, 1, 28, 0, '2024-06-23', 30000, 'Masuk', 'tabungan masuk', '2024-06-23 16:31:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2508, 1, 128, 0, '2024-06-23', 50000, 'Masuk', 'tabungan masuk', '2024-06-23 16:31:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2509, 1, 29, 0, '2024-06-23', 5000, 'Masuk', 'tabungan masuk', '2024-06-23 16:32:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2510, 1, 31, 0, '2024-06-23', 100000, 'Masuk', 'tabungan masuk', '2024-06-23 16:33:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2511, 1, 32, 0, '2024-06-23', 20000, 'Masuk', 'tabungan masuk', '2024-06-23 16:33:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2512, 1, 163, 0, '2024-06-23', 10000, 'Masuk', 'tabungan masuk', '2024-06-23 16:38:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2513, 1, 24, 0, '2024-06-23', 10000, 'Masuk', 'tabungan masuk', '2024-06-23 16:38:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2514, 1, 41, 0, '2024-06-23', 2000, 'Masuk', 'tabungan masuk', '2024-06-23 16:39:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2515, 1, 69, 0, '2024-06-23', 10000, 'Masuk', 'tabungan masuk', '2024-06-23 16:39:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2516, 1, 54, 0, '2024-06-23', 30000, 'Masuk', 'tabungan masuk', '2024-06-23 16:40:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2517, 1, 117, 0, '2024-06-23', 50000, 'Masuk', 'tabungan masuk', '2024-06-23 16:41:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2518, 1, 138, 0, '2024-06-23', 15000, 'Masuk', 'tabungan masuk', '2024-06-23 16:47:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2519, 1, 120, 0, '2024-06-23', 50000, 'Masuk', 'tabungan masuk', '2024-06-23 16:47:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2520, 1, 95, 0, '2024-06-23', 20000, 'Masuk', 'tabungan masuk', '2024-06-23 16:48:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2521, 1, 88, 0, '2024-06-23', 10000, 'Masuk', 'tabungan masuk', '2024-06-23 16:49:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2522, 1, 135, 0, '2024-06-23', 10000, 'Masuk', 'tabungan masuk', '2024-06-23 16:50:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2523, 1, 148, 0, '2024-06-23', 5000, 'Masuk', 'tabungan masuk', '2024-06-23 16:50:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2524, 1, 149, 0, '2024-06-23', 5000, 'Masuk', 'tabungan masuk', '2024-06-23 16:51:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2525, 1, 57, 0, '2024-06-23', 20000, 'Masuk', 'tabungan masuk', '2024-06-23 16:51:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2526, 1, 58, 0, '2024-06-23', 20000, 'Masuk', 'tabungan masuk', '2024-06-23 16:52:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2527, 1, 64, 0, '2024-06-23', 5000, 'Masuk', 'tabungan masuk', '2024-06-23 16:53:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2528, 1, 10, 0, '2024-06-23', 20000, 'Masuk', 'tabungan masuk', '2024-06-23 16:53:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2529, 1, 18, 0, '2024-06-23', 20000, 'Masuk', 'tabungan masuk', '2024-06-23 16:54:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2530, 1, 17, 0, '2024-06-23', 10000, 'Masuk', 'tabungan masuk', '2024-06-23 16:55:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2531, 1, 16, 0, '2024-06-23', 70000, 'Masuk', 'tabungan masuk', '2024-06-23 16:55:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2532, 1, 61, 0, '2024-06-23', 10000, 'Masuk', 'tabungan masuk', '2024-06-23 16:56:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2533, 1, 60, 0, '2024-06-23', 20000, 'Masuk', 'tabungan masuk', '2024-06-23 16:57:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2534, 1, 92, 0, '2024-06-23', 20000, 'Masuk', 'tabungan masuk', '2024-06-23 16:59:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2535, 1, 108, 0, '2024-06-23', 20000, 'Masuk', 'tabungan masuk', '2024-06-23 16:59:58');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2536, 1, 6, 0, '2024-06-23', 10000, 'Masuk', 'tabungan masuk', '2024-06-23 17:10:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2537, 1, 7, 0, '2024-06-23', 10000, 'Masuk', 'tabungan masuk', '2024-06-23 17:10:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2538, 1, 99, 0, '2024-06-23', 250000, 'Masuk', 'tabungan masuk', '2024-06-23 17:11:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2539, 1, 102, 0, '2024-06-23', 10000, 'Masuk', 'tabungan masuk', '2024-06-23 17:11:52');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2540, 1, 101, 0, '2024-06-23', 100000, 'Masuk', 'tabungan masuk', '2024-06-23 17:12:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2541, 1, 150, 0, '2024-06-23', 50000, 'Masuk', 'tabungan masuk', '2024-06-23 17:12:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2542, 1, 103, 0, '2024-06-23', 5000, 'Masuk', 'tabungan masuk', '2024-06-23 17:14:23');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2543, 1, 118, 0, '2024-06-23', 5000, 'Masuk', 'tabungan masuk', '2024-06-23 17:14:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2544, 1, 21, 0, '2024-06-23', 100000, 'Masuk', 'tabungan masuk', '2024-06-23 17:15:23');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2545, 1, 22, 0, '2024-06-23', 100000, 'Masuk', 'tabungan masuk', '2024-06-23 17:16:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2546, 1, 157, 0, '2024-06-23', 10000, 'Masuk', 'tabungan masuk', '2024-06-23 17:16:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2547, 1, 19, 0, '2024-06-23', 20000, 'Masuk', 'tabungan masuk', '2024-06-23 17:17:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2548, 1, 20, 0, '2024-06-23', 20000, 'Masuk', 'tabungan masuk', '2024-06-23 17:17:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2549, 1, 139, 0, '2024-06-23', 50000, 'Masuk', 'tabungan masuk', '2024-06-23 17:18:26');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2550, 1, 106, 0, '2024-06-23', 75000, 'Masuk', 'tabungan masuk', '2024-06-23 17:19:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2552, 1, 131, 0, '2024-06-23', 60000, 'Masuk', 'tabungan masuk', '2024-06-23 17:19:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2553, 1, 91, 0, '2024-06-23', 20000, 'Masuk', 'tabungan masuk', '2024-06-23 17:20:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2554, 1, 111, 0, '2024-06-23', 50000, 'Masuk', 'tabungan masuk', '2024-06-23 17:23:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2555, 1, 13, 0, '2024-06-23', 120000, 'Masuk', 'tabungan masuk', '2024-06-23 17:23:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2556, 1, 152, 0, '2024-06-23', 50000, 'Masuk', 'tabungan masuk', '2024-06-23 17:26:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2557, 1, 174, 0, '2024-06-23', 20000, 'Masuk', 'tabungan masuk', '2024-06-23 17:27:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2558, 1, 133, 0, '2024-06-23', 100000, 'Masuk', 'tabungan masuk', '2024-06-23 17:27:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2559, 1, 153, 0, '2024-06-23', 20000, 'Masuk', 'tabungan masuk', '2024-06-23 17:28:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2560, 1, 125, 0, '2024-06-23', 20000, 'Masuk', 'tabungan masuk', '2024-06-23 17:28:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2561, 1, 126, 0, '2024-06-23', 10000, 'Masuk', 'tabungan masuk', '2024-06-23 17:29:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2562, 1, 124, 0, '2024-06-23', 100000, 'Masuk', 'tabungan masuk', '2024-06-23 17:29:58');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2563, 1, 137, 0, '2024-06-23', 20000, 'Masuk', 'tabungan masuk', '2024-06-23 17:30:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2564, 1, 42, 0, '2024-06-23', 10000, 'Masuk', 'tabungan masuk', '2024-06-23 17:31:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2565, 1, 129, 0, '2024-06-23', 50000, 'Masuk', 'tabungan masuk', '2024-06-23 17:31:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2566, 1, 40, 0, '2024-06-24', 20000, 'Masuk', 'tabungan masuk', '2024-06-24 13:11:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2567, 1, 70, 0, '2024-06-24', 30000, 'Masuk', 'tabungan masuk', '2024-06-24 13:12:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2568, 1, 132, 0, '2024-06-24', 50000, 'Masuk', 'tabungan masuk', '2024-06-24 13:12:56');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2569, 1, 63, 0, '2024-06-24', 400000, 'Masuk', 'tabungan masuk', '2024-06-24 13:14:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2570, 1, 63, 0, '2024-06-24', 2000000, 'Keluar', 'tabungan keluar', '2024-06-24 13:15:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2571, 1, 45, 0, '2024-06-24', 5000, 'Masuk', 'tabungan masuk', '2024-06-24 16:25:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2572, 1, 121, 0, '2024-06-24', 10000, 'Masuk', 'tabungan masuk', '2024-06-24 16:25:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2573, 1, 23, 0, '2024-06-24', 20000, 'Masuk', 'tabungan masuk', '2024-06-24 16:26:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2574, 1, 33, 0, '2024-06-24', 10000, 'Masuk', 'tabungan masuk', '2024-06-24 16:27:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2575, 1, 46, 0, '2024-06-24', 10000, 'Masuk', 'tabungan masuk', '2024-06-24 16:27:43');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2576, 1, 47, 0, '2024-06-24', 50000, 'Masuk', 'tabungan masuk', '2024-06-24 16:28:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2577, 1, 136, 0, '2024-06-24', 338000, 'Masuk', 'tabungan masuk', '2024-06-24 16:28:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2578, 1, 105, 0, '2024-06-24', 200000, 'Masuk', 'tabungan masuk', '2024-06-24 16:29:26');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2579, 1, 36, 0, '2024-06-24', 20000, 'Masuk', 'tabungan masuk', '2024-06-24 16:30:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2580, 1, 167, 0, '2024-06-24', 50000, 'Masuk', 'tabungan masuk', '2024-06-24 16:30:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2581, 1, 145, 0, '2024-06-24', 20000, 'Masuk', 'tabungan masuk', '2024-06-24 16:31:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2582, 1, 38, 0, '2024-06-24', 10000, 'Masuk', 'tabungan masuk', '2024-06-24 16:31:58');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2583, 1, 25, 0, '2024-06-24', 20000, 'Masuk', 'tabungan masuk', '2024-06-24 16:32:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2584, 1, 112, 0, '2024-06-24', 10000, 'Masuk', 'tabungan masuk', '2024-06-24 16:33:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2585, 1, 113, 0, '2024-06-24', 30000, 'Masuk', 'tabungan masuk', '2024-06-24 16:33:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2586, 1, 30, 0, '2024-06-24', 20000, 'Masuk', 'tabungan masuk', '2024-06-24 16:34:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2587, 1, 37, 0, '2024-06-24', 10000, 'Masuk', 'tabungan masuk', '2024-06-24 16:45:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2588, 1, 28, 0, '2024-06-24', 30000, 'Masuk', 'tabungan masuk', '2024-06-24 16:45:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2589, 1, 29, 0, '2024-06-24', 10000, 'Masuk', 'tabungan masuk', '2024-06-24 16:46:43');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2590, 1, 163, 0, '2024-06-24', 10000, 'Masuk', 'tabungan masuk', '2024-06-24 16:47:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2591, 1, 31, 0, '2024-06-24', 50000, 'Masuk', 'tabungan masuk', '2024-06-24 16:47:56');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2592, 1, 32, 0, '2024-06-24', 10000, 'Masuk', 'tabungan masuk', '2024-06-24 16:48:23');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2593, 1, 24, 0, '2024-06-24', 10000, 'Masuk', 'tabungan masuk', '2024-06-24 16:48:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2594, 1, 41, 0, '2024-06-24', 2000, 'Masuk', 'tabungan masuk', '2024-06-24 16:49:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2595, 1, 69, 0, '2024-06-24', 10000, 'Masuk', 'tabungan masuk', '2024-06-24 16:50:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2596, 1, 117, 0, '2024-06-24', 50000, 'Masuk', 'tabungan masuk', '2024-06-24 16:50:43');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2597, 1, 133, 0, '2024-06-24', 100000, 'Masuk', 'tabungan masuk', '2024-06-24 16:51:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2598, 1, 11, 0, '2024-06-24', 100000, 'Masuk', 'tabungan masuk', '2024-06-24 16:51:56');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2599, 1, 14, 0, '2024-06-24', 50000, 'Masuk', 'tabungan masuk', '2024-06-24 16:52:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2600, 1, 13, 0, '2024-06-24', 350000, 'Masuk', 'tabungan masuk', '2024-06-24 16:53:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2601, 1, 120, 0, '2024-06-24', 50000, 'Masuk', 'tabungan masuk', '2024-06-24 16:54:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2602, 1, 98, 0, '2024-06-24', 10000, 'Masuk', 'tabungan masuk', '2024-06-24 16:55:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2603, 1, 94, 0, '2024-06-24', 10000, 'Masuk', 'tabungan masuk', '2024-06-24 16:55:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2604, 1, 135, 0, '2024-06-24', 10000, 'Masuk', 'tabungan masuk', '2024-06-24 17:04:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2605, 1, 149, 0, '2024-06-24', 5000, 'Masuk', 'tabungan masuk', '2024-06-24 17:04:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2606, 1, 58, 0, '2024-06-24', 20000, 'Masuk', 'tabungan masuk', '2024-06-24 17:05:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2607, 1, 64, 0, '2024-06-24', 5000, 'Masuk', 'tabungan masuk', '2024-06-24 17:05:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2608, 1, 57, 0, '2024-06-24', 20000, 'Masuk', 'tabungan masuk', '2024-06-24 17:06:23');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2609, 1, 55, 0, '2024-06-24', 10000, 'Masuk', 'tabungan masuk', '2024-06-24 17:06:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2610, 1, 56, 0, '2024-06-24', 2000, 'Masuk', 'tabungan masuk', '2024-06-24 17:07:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2611, 1, 15, 0, '2024-06-24', 30000, 'Masuk', 'tabungan masuk', '2024-06-24 17:07:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2612, 1, 10, 0, '2024-06-24', 20000, 'Masuk', 'tabungan masuk', '2024-06-24 17:08:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2613, 1, 158, 0, '2024-06-24', 20000, 'Masuk', 'tabungan masuk', '2024-06-24 17:10:26');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2614, 1, 16, 0, '2024-06-24', 70000, 'Masuk', 'tabungan masuk', '2024-06-24 17:11:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2615, 1, 17, 0, '2024-06-24', 10000, 'Masuk', 'tabungan masuk', '2024-06-24 17:14:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2616, 1, 18, 0, '2024-06-24', 10000, 'Masuk', 'tabungan masuk', '2024-06-24 17:14:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2617, 1, 61, 0, '2024-06-24', 10000, 'Masuk', 'tabungan masuk', '2024-06-24 17:15:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2618, 1, 60, 0, '2024-06-24', 20000, 'Masuk', 'tabungan masuk', '2024-06-24 17:16:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2619, 1, 107, 0, '2024-06-24', 20000, 'Masuk', 'tabungan masuk', '2024-06-24 17:16:52');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2620, 1, 119, 0, '2024-06-24', 10000, 'Masuk', 'tabungan masuk', '2024-06-24 17:17:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2621, 1, 92, 0, '2024-06-24', 20000, 'Masuk', 'tabungan masuk', '2024-06-24 17:18:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2622, 1, 21, 0, '2024-06-24', 100000, 'Masuk', 'tabungan masuk', '2024-06-24 17:18:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2623, 1, 157, 0, '2024-06-24', 10000, 'Masuk', 'tabungan masuk', '2024-06-24 17:19:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2624, 1, 22, 0, '2024-06-24', 100000, 'Masuk', 'tabungan masuk', '2024-06-24 17:20:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2625, 1, 20, 0, '2024-06-24', 20000, 'Masuk', 'tabungan masuk', '2024-06-24 17:20:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2626, 1, 19, 0, '2024-06-24', 20000, 'Masuk', 'tabungan masuk', '2024-06-24 17:21:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2627, 1, 91, 0, '2024-06-24', 20000, 'Masuk', 'tabungan masuk', '2024-06-24 17:22:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2628, 1, 111, 0, '2024-06-24', 50000, 'Masuk', 'tabungan masuk', '2024-06-24 17:22:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2629, 1, 54, 0, '2024-06-24', 30000, 'Masuk', 'tabungan masuk', '2024-06-24 17:23:23');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2630, 1, 124, 0, '2024-06-24', 50000, 'Masuk', 'tabungan masuk', '2024-06-24 17:24:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2631, 1, 137, 0, '2024-06-24', 20000, 'Masuk', 'tabungan masuk', '2024-06-24 17:24:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2632, 1, 42, 0, '2024-06-24', 10000, 'Masuk', 'tabungan masuk', '2024-06-24 17:25:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2633, 1, 129, 0, '2024-06-24', 50000, 'Masuk', 'tabungan masuk', '2024-06-24 17:26:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2634, 1, 97, 0, '2024-06-24', 10000, 'Masuk', 'tabungan masuk', '2024-06-24 17:26:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2635, 1, 175, 0, '2024-06-24', 20000, 'Masuk', 'tabungan masuk', '2024-06-24 17:32:43');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2636, 1, 40, 0, '2024-06-25', 20000, 'Masuk', 'tabungan masuk', '2024-06-25 15:53:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2637, 1, 70, 0, '2024-06-25', 30000, 'Masuk', 'tabungan masuk', '2024-06-25 15:53:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2638, 1, 15, 0, '2024-06-25', 20000, 'Masuk', 'tabungan masuk', '2024-06-25 15:54:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2639, 1, 11, 0, '2024-06-25', 100000, 'Masuk', 'tabungan masuk', '2024-06-25 15:55:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2640, 1, 129, 0, '2024-06-25', 50000, 'Masuk', 'tabungan masuk', '2024-06-25 15:55:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2641, 1, 6, 0, '2024-06-25', 10000, 'Masuk', 'tabungan masuk', '2024-06-25 15:56:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2642, 1, 7, 0, '2024-06-25', 10000, 'Masuk', 'tabungan masuk', '2024-06-25 15:56:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2643, 1, 153, 0, '2024-06-25', 10000, 'Masuk', 'tabungan masuk', '2024-06-25 15:57:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2644, 1, 97, 0, '2024-06-25', 10000, 'Masuk', 'tabungan masuk', '2024-06-25 15:57:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2645, 1, 42, 0, '2024-06-25', 10000, 'Masuk', 'tabungan masuk', '2024-06-25 15:58:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2646, 1, 137, 0, '2024-06-25', 20000, 'Masuk', 'tabungan masuk', '2024-06-25 15:58:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2647, 1, 124, 0, '2024-06-25', 50000, 'Masuk', 'tabungan masuk', '2024-06-25 15:59:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2648, 1, 111, 0, '2024-06-25', 50000, 'Masuk', 'tabungan masuk', '2024-06-25 15:59:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2649, 1, 91, 0, '2024-06-25', 20000, 'Masuk', 'tabungan masuk', '2024-06-25 16:00:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2650, 1, 106, 0, '2024-06-25', 40000, 'Masuk', 'tabungan masuk', '2024-06-25 16:00:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2651, 1, 22, 0, '2024-06-25', 100000, 'Masuk', 'tabungan masuk', '2024-06-25 16:01:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2652, 1, 157, 0, '2024-06-25', 10000, 'Masuk', 'tabungan masuk', '2024-06-25 16:01:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2653, 1, 21, 0, '2024-06-25', 100000, 'Masuk', 'tabungan masuk', '2024-06-25 16:01:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2654, 1, 118, 0, '2024-06-25', 5000, 'Masuk', 'tabungan masuk', '2024-06-25 16:02:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2655, 1, 103, 0, '2024-06-25', 5000, 'Masuk', 'tabungan masuk', '2024-06-25 16:02:52');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2656, 1, 152, 0, '2024-06-25', 50000, 'Masuk', 'tabungan masuk', '2024-06-25 16:03:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2657, 1, 14, 0, '2024-06-25', 30000, 'Masuk', 'tabungan masuk', '2024-06-25 16:15:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2658, 1, 54, 0, '2024-06-25', 30000, 'Masuk', 'tabungan masuk', '2024-06-25 16:15:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2659, 1, 133, 0, '2024-06-25', 100000, 'Masuk', 'tabungan masuk', '2024-06-25 16:16:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2660, 1, 151, 0, '2024-06-25', 10000, 'Masuk', 'tabungan masuk', '2024-06-25 16:16:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2661, 1, 117, 0, '2024-06-25', 50000, 'Masuk', 'tabungan masuk', '2024-06-25 16:16:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2662, 1, 69, 0, '2024-06-25', 10000, 'Masuk', 'tabungan masuk', '2024-06-25 16:17:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2663, 1, 31, 0, '2024-06-25', 50000, 'Masuk', 'tabungan masuk', '2024-06-25 16:17:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2664, 1, 32, 0, '2024-06-25', 10000, 'Masuk', 'tabungan masuk', '2024-06-25 16:18:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2665, 1, 163, 0, '2024-06-25', 10000, 'Masuk', 'tabungan masuk', '2024-06-25 16:18:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2666, 1, 29, 0, '2024-06-25', 10000, 'Masuk', 'tabungan masuk', '2024-06-25 16:19:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2667, 1, 112, 0, '2024-06-25', 10000, 'Masuk', 'tabungan masuk', '2024-06-25 16:19:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2668, 1, 128, 0, '2024-06-25', 50000, 'Masuk', 'tabungan masuk', '2024-06-25 16:20:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2669, 1, 28, 0, '2024-06-25', 30000, 'Masuk', 'tabungan masuk', '2024-06-25 16:20:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2670, 1, 37, 0, '2024-06-25', 10000, 'Masuk', 'tabungan masuk', '2024-06-25 16:21:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2671, 1, 30, 0, '2024-06-25', 20000, 'Masuk', 'tabungan masuk', '2024-06-25 16:21:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2672, 1, 25, 0, '2024-06-25', 50000, 'Masuk', 'tabungan masuk', '2024-06-25 16:22:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2673, 1, 38, 0, '2024-06-25', 10000, 'Masuk', 'tabungan masuk', '2024-06-25 16:22:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2674, 1, 88, 0, '2024-06-25', 10000, 'Masuk', 'tabungan masuk', '2024-06-25 16:23:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2675, 1, 167, 0, '2024-06-25', 50000, 'Masuk', 'tabungan masuk', '2024-06-25 16:24:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2676, 1, 27, 0, '2024-06-25', 30000, 'Masuk', 'tabungan masuk', '2024-06-25 16:25:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2677, 1, 47, 0, '2024-06-25', 50000, 'Masuk', 'tabungan masuk', '2024-06-25 16:25:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2678, 1, 46, 0, '2024-06-25', 10000, 'Masuk', 'tabungan masuk', '2024-06-25 16:26:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2679, 1, 115, 0, '2024-06-25', 500000, 'Masuk', 'tabungan masuk', '2024-06-25 16:26:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2680, 1, 33, 0, '2024-06-25', 10000, 'Masuk', 'tabungan masuk', '2024-06-25 16:26:58');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2681, 1, 23, 0, '2024-06-25', 20000, 'Masuk', 'tabungan masuk', '2024-06-25 16:27:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2682, 1, 121, 0, '2024-06-25', 10000, 'Masuk', 'tabungan masuk', '2024-06-25 16:27:56');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2683, 1, 174, 0, '2024-06-25', 40000, 'Masuk', 'tabungan masuk', '2024-06-25 16:28:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2684, 1, 13, 0, '2024-06-25', 100000, 'Masuk', 'tabungan masuk', '2024-06-25 16:28:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2685, 1, 138, 0, '2024-06-25', 15000, 'Masuk', 'tabungan masuk', '2024-06-25 16:29:26');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2686, 1, 120, 0, '2024-06-25', 50000, 'Masuk', 'tabungan masuk', '2024-06-25 16:29:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2687, 1, 95, 0, '2024-06-25', 20000, 'Masuk', 'tabungan masuk', '2024-06-25 16:30:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2688, 1, 94, 0, '2024-06-25', 10000, 'Masuk', 'tabungan masuk', '2024-06-25 16:31:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2689, 1, 135, 0, '2024-06-25', 10000, 'Masuk', 'tabungan masuk', '2024-06-25 16:32:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2690, 1, 5, 0, '2024-06-25', 300000, 'Masuk', 'tabungan masuk', '2024-06-25 16:32:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2691, 1, 148, 0, '2024-06-25', 5000, 'Masuk', 'tabungan masuk', '2024-06-25 16:34:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2692, 1, 149, 0, '2024-06-25', 5000, 'Masuk', 'tabungan masuk', '2024-06-25 16:34:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2693, 1, 55, 0, '2024-06-25', 10000, 'Masuk', 'tabungan masuk', '2024-06-25 16:35:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2694, 1, 56, 0, '2024-06-25', 2000, 'Masuk', 'tabungan masuk', '2024-06-25 16:35:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2695, 1, 58, 0, '2024-06-25', 20000, 'Masuk', 'tabungan masuk', '2024-06-25 16:36:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2696, 1, 64, 0, '2024-06-25', 2000, 'Masuk', 'tabungan masuk', '2024-06-25 16:36:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2697, 1, 57, 0, '2024-06-25', 20000, 'Masuk', 'tabungan masuk', '2024-06-25 16:37:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2698, 1, 10, 0, '2024-06-25', 20000, 'Masuk', 'tabungan masuk', '2024-06-25 16:37:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2699, 1, 158, 0, '2024-06-25', 20000, 'Masuk', 'tabungan masuk', '2024-06-25 16:38:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2700, 1, 16, 0, '2024-06-25', 70000, 'Masuk', 'tabungan masuk', '2024-06-25 16:38:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2701, 1, 17, 0, '2024-06-25', 10000, 'Masuk', 'tabungan masuk', '2024-06-25 16:39:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2702, 1, 18, 0, '2024-06-25', 10000, 'Masuk', 'tabungan masuk', '2024-06-25 16:39:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2703, 1, 107, 0, '2024-06-25', 20000, 'Masuk', 'tabungan masuk', '2024-06-25 16:40:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2704, 1, 119, 0, '2024-06-25', 10000, 'Masuk', 'tabungan masuk', '2024-06-25 16:40:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2705, 1, 92, 0, '2024-06-25', 20000, 'Masuk', 'tabungan masuk', '2024-06-25 16:41:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2706, 1, 102, 0, '2024-06-25', 10000, 'Masuk', 'tabungan masuk', '2024-06-25 16:41:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2707, 1, 101, 0, '2024-06-25', 100000, 'Masuk', 'tabungan masuk', '2024-06-25 16:41:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2708, 1, 150, 0, '2024-06-25', 50000, 'Masuk', 'tabungan masuk', '2024-06-25 16:42:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2709, 1, 176, 0, '2024-06-25', 30000, 'Masuk', 'tabungan masuk', '2024-06-25 16:44:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2710, 1, 40, 0, '2024-06-26', 20000, 'Masuk', 'tabungan masuk', '2024-06-26 12:43:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2711, 1, 70, 0, '2024-06-26', 30000, 'Masuk', 'tabungan masuk', '2024-06-26 12:44:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2712, 1, 127, 0, '2024-06-26', 10000, 'Masuk', 'tabungan masuk', '2024-06-26 12:44:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2713, 1, 4, 0, '2024-06-26', 7000000, 'Keluar', 'tabungan keluar', '2024-06-26 12:45:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2714, 1, 99, 0, '2024-06-26', 2000000, 'Keluar', 'tabungan keluar', '2024-06-26 12:46:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2715, 1, 175, 0, '2024-06-26', 5000, 'Masuk', 'tabungan masuk', '2024-06-26 15:26:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2716, 1, 45, 0, '2024-06-26', 10000, 'Masuk', 'tabungan masuk', '2024-06-26 15:26:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2717, 1, 121, 0, '2024-06-26', 10000, 'Masuk', 'tabungan masuk', '2024-06-26 15:27:21');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2718, 1, 23, 0, '2024-06-26', 20000, 'Masuk', 'tabungan masuk', '2024-06-26 15:27:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2719, 1, 33, 0, '2024-06-26', 10000, 'Masuk', 'tabungan masuk', '2024-06-26 15:28:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2720, 1, 46, 0, '2024-06-26', 10000, 'Masuk', 'tabungan masuk', '2024-06-26 15:28:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2721, 1, 47, 0, '2024-06-26', 50000, 'Masuk', 'tabungan masuk', '2024-06-26 15:29:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2722, 1, 167, 0, '2024-06-26', 50000, 'Masuk', 'tabungan masuk', '2024-06-26 15:29:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2723, 1, 162, 0, '2024-06-26', 10000, 'Masuk', 'tabungan masuk', '2024-06-26 15:30:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2724, 1, 27, 0, '2024-06-26', 30000, 'Masuk', 'tabungan masuk', '2024-06-26 15:30:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2725, 1, 145, 0, '2024-06-26', 20000, 'Masuk', 'tabungan masuk', '2024-06-26 15:31:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2726, 1, 48, 0, '2024-06-26', 10000, 'Masuk', 'tabungan masuk', '2024-06-26 15:31:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2727, 1, 38, 0, '2024-06-26', 10000, 'Masuk', 'tabungan masuk', '2024-06-26 16:20:52');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2728, 1, 25, 0, '2024-06-26', 50000, 'Masuk', 'tabungan masuk', '2024-06-26 16:22:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2729, 1, 30, 0, '2024-06-26', 20000, 'Masuk', 'tabungan masuk', '2024-06-26 16:22:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2730, 1, 37, 0, '2024-06-26', 10000, 'Masuk', 'tabungan masuk', '2024-06-26 16:23:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2731, 1, 113, 0, '2024-06-26', 35000, 'Masuk', 'tabungan masuk', '2024-06-26 16:23:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2732, 1, 28, 0, '2024-06-26', 30000, 'Masuk', 'tabungan masuk', '2024-06-26 16:24:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2733, 1, 176, 0, '2024-06-26', 30000, 'Masuk', 'tabungan masuk', '2024-06-26 16:24:43');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2734, 1, 128, 0, '2024-06-26', 50000, 'Masuk', 'tabungan masuk', '2024-06-26 16:25:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2735, 1, 29, 0, '2024-06-26', 5000, 'Keluar', 'tabungan masuk', '2024-06-26 16:25:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2736, 1, 39, 0, '2024-06-26', 20000, 'Masuk', 'tabungan masuk', '2024-06-26 16:26:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2737, 1, 163, 0, '2024-06-26', 10000, 'Masuk', 'tabungan masuk', '2024-06-26 16:26:56');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2738, 1, 69, 0, '2024-06-26', 10000, 'Masuk', 'tabungan masuk', '2024-06-26 16:27:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2739, 1, 31, 0, '2024-06-26', 50000, 'Masuk', 'tabungan masuk', '2024-06-26 16:28:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2740, 1, 32, 0, '2024-06-26', 10000, 'Masuk', 'tabungan masuk', '2024-06-26 16:28:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2741, 1, 24, 0, '2024-06-26', 10000, 'Masuk', 'tabungan masuk', '2024-06-26 16:28:56');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2742, 1, 41, 0, '2024-06-26', 2000, 'Masuk', 'tabungan masuk', '2024-06-26 16:29:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2743, 1, 117, 0, '2024-06-26', 50000, 'Masuk', 'tabungan masuk', '2024-06-26 16:30:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2744, 1, 147, 0, '2024-06-26', 10000, 'Masuk', 'tabungan masuk', '2024-06-26 16:30:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2745, 1, 54, 0, '2024-06-26', 30000, 'Masuk', 'tabungan masuk', '2024-06-26 16:31:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2746, 1, 11, 0, '2024-06-26', 100000, 'Masuk', 'tabungan masuk', '2024-06-26 16:31:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2747, 1, 15, 0, '2024-06-26', 20000, 'Masuk', 'tabungan masuk', '2024-06-26 16:32:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2748, 1, 14, 0, '2024-06-26', 30000, 'Masuk', 'tabungan masuk', '2024-06-26 16:32:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2749, 1, 13, 0, '2024-06-26', 160000, 'Masuk', 'tabungan masuk', '2024-06-26 16:33:21');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2750, 1, 93, 0, '2024-06-26', 200000, 'Masuk', 'tabungan masuk', '2024-06-26 16:33:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2751, 1, 102, 0, '2024-06-26', 10000, 'Masuk', 'tabungan masuk', '2024-06-26 16:34:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2752, 1, 101, 0, '2024-06-26', 100000, 'Masuk', 'tabungan masuk', '2024-06-26 16:34:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2753, 1, 150, 0, '2024-06-26', 50000, 'Masuk', 'tabungan masuk', '2024-06-26 16:35:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2754, 1, 103, 0, '2024-06-26', 5000, 'Masuk', 'tabungan masuk', '2024-06-26 16:35:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2755, 1, 118, 0, '2024-06-26', 5000, 'Masuk', 'tabungan masuk', '2024-06-26 16:36:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2756, 1, 21, 0, '2024-06-26', 100000, 'Masuk', 'tabungan masuk', '2024-06-26 16:36:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2757, 1, 157, 0, '2024-06-26', 10000, 'Masuk', 'tabungan masuk', '2024-06-26 16:37:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2758, 1, 22, 0, '2024-06-26', 100000, 'Masuk', 'tabungan masuk', '2024-06-26 16:37:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2759, 1, 19, 0, '2024-06-26', 40000, 'Masuk', 'tabungan masuk', '2024-06-26 16:38:26');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2760, 1, 20, 0, '2024-06-26', 20000, 'Masuk', 'tabungan masuk', '2024-06-26 16:38:52');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2761, 1, 76, 0, '2024-06-26', 20000, 'Masuk', 'tabungan masuk', '2024-06-26 16:39:21');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2762, 1, 88, 0, '2024-06-26', 10000, 'Masuk', 'tabungan masuk', '2024-06-26 16:39:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2763, 1, 82, 0, '2024-06-26', 10000, 'Masuk', 'tabungan masuk', '2024-06-26 16:40:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2764, 1, 75, 0, '2024-06-26', 10000, 'Masuk', 'tabungan masuk', '2024-06-26 16:40:56');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2765, 1, 172, 0, '2024-06-26', 50000, 'Masuk', 'tabungan masuk', '2024-06-26 17:03:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2766, 1, 165, 0, '2024-06-26', 106000, 'Masuk', 'tabungan masuk', '2024-06-26 17:04:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2767, 1, 160, 0, '2024-06-26', 30000, 'Masuk', 'tabungan masuk', '2024-06-26 17:04:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2768, 1, 71, 0, '2024-06-26', 150000, 'Masuk', 'tabungan masuk', '2024-06-26 17:05:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2769, 1, 9, 0, '2024-06-26', 100000, 'Masuk', 'tabungan masuk', '2024-06-26 17:06:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2770, 1, 59, 0, '2024-06-26', 20000, 'Masuk', 'tabungan masuk', '2024-06-26 17:06:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2771, 1, 138, 0, '2024-06-26', 15000, 'Masuk', 'tabungan masuk', '2024-06-26 17:07:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2772, 1, 120, 0, '2024-06-26', 50000, 'Masuk', 'tabungan masuk', '2024-06-26 17:07:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2773, 1, 95, 0, '2024-06-26', 15000, 'Masuk', 'tabungan masuk', '2024-06-26 17:08:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2774, 1, 98, 0, '2024-06-26', 10000, 'Masuk', 'tabungan masuk', '2024-06-26 17:08:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2775, 1, 148, 0, '2024-06-26', 5000, 'Masuk', 'tabungan masuk', '2024-06-26 17:09:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2776, 1, 149, 0, '2024-06-26', 5000, 'Masuk', 'tabungan masuk', '2024-06-26 17:09:52');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2777, 1, 58, 0, '2024-06-26', 20000, 'Masuk', 'tabungan masuk', '2024-06-26 17:10:23');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2778, 1, 64, 0, '2024-06-26', 5000, 'Masuk', 'tabungan masuk', '2024-06-26 17:10:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2779, 1, 57, 0, '2024-06-26', 20000, 'Masuk', 'tabungan masuk', '2024-06-26 17:11:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2780, 1, 12, 0, '2024-06-26', 30000, 'Masuk', 'tabungan masuk', '2024-06-26 17:12:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2781, 1, 158, 0, '2024-06-26', 20000, 'Masuk', 'tabungan masuk', '2024-06-26 17:12:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2782, 1, 16, 0, '2024-06-26', 70000, 'Masuk', 'tabungan masuk', '2024-06-26 17:13:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2783, 1, 18, 0, '2024-06-26', 10000, 'Masuk', 'tabungan masuk', '2024-06-26 17:13:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2784, 1, 17, 0, '2024-06-26', 5000, 'Masuk', 'tabungan masuk', '2024-06-26 17:14:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2785, 1, 61, 0, '2024-06-26', 10000, 'Masuk', 'tabungan masuk', '2024-06-26 17:15:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2786, 1, 107, 0, '2024-06-26', 20000, 'Masuk', 'tabungan masuk', '2024-06-26 17:15:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2787, 1, 119, 0, '2024-06-26', 10000, 'Masuk', 'tabungan masuk', '2024-06-26 17:16:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2788, 1, 108, 0, '2024-06-26', 20000, 'Masuk', 'tabungan masuk', '2024-06-26 17:16:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2789, 1, 92, 0, '2024-06-26', 20000, 'Masuk', 'tabungan masuk', '2024-06-26 17:17:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2790, 1, 91, 0, '2024-06-26', 20000, 'Masuk', 'tabungan masuk', '2024-06-26 17:17:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2791, 1, 106, 0, '2024-06-26', 50000, 'Masuk', 'tabungan masuk', '2024-06-26 17:18:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2792, 1, 111, 0, '2024-06-26', 50000, 'Masuk', 'tabungan masuk', '2024-06-26 17:18:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2793, 1, 133, 0, '2024-06-26', 100000, 'Masuk', 'tabungan masuk', '2024-06-26 17:19:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2794, 1, 151, 0, '2024-06-26', 10000, 'Masuk', 'tabungan masuk', '2024-06-26 17:19:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2795, 1, 125, 0, '2024-06-26', 20000, 'Masuk', 'tabungan masuk', '2024-06-26 17:20:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2796, 1, 126, 0, '2024-06-26', 10000, 'Masuk', 'tabungan masuk', '2024-06-26 17:21:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2797, 1, 124, 0, '2024-06-26', 100000, 'Masuk', 'tabungan masuk', '2024-06-26 17:21:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2798, 1, 7, 0, '2024-06-26', 20000, 'Masuk', 'tabungan masuk', '2024-06-26 17:22:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2799, 1, 6, 0, '2024-06-26', 10000, 'Masuk', 'tabungan masuk', '2024-06-26 17:22:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2800, 1, 137, 0, '2024-06-26', 20000, 'Masuk', 'tabungan masuk', '2024-06-26 17:23:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2801, 1, 42, 0, '2024-06-26', 5000, 'Masuk', 'tabungan masuk', '2024-06-26 17:23:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2802, 1, 8, 0, '2024-06-24', 100000, 'Keluar', 'tabungan keluar', '2024-06-27 04:02:52');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2803, 1, 101, 0, '2024-06-27', 2900000, 'Keluar', 'tabungan keluar', '2024-06-27 10:54:43');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2804, 1, 40, 0, '2024-06-27', 20000, 'Masuk', 'tabungan masuk', '2024-06-27 10:55:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2805, 1, 113, 0, '2024-06-27', 300000, 'Keluar', 'tabungan keluar', '2024-06-27 10:56:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2806, 1, 53, 0, '2024-06-27', 1000000, 'Keluar', 'tabungan keluar', '2024-06-27 12:22:56');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2807, 1, 70, 0, '2024-06-27', 30000, 'Masuk', 'tabungan masuk', '2024-06-27 12:23:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2808, 1, 23, 0, '2024-06-27', 20000, 'Masuk', 'tabungan masuk', '2024-06-27 12:25:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2809, 1, 33, 0, '2024-06-27', 10000, 'Masuk', 'tabungan masuk', '2024-06-27 12:26:26');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2810, 1, 36, 0, '2024-06-27', 20000, 'Masuk', 'tabungan masuk', '2024-06-27 12:27:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2811, 1, 129, 0, '2024-06-27', 50000, 'Masuk', 'tabungan masuk', '2024-06-27 12:27:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2812, 1, 130, 0, '2024-06-27', 10000, 'Masuk', 'tabungan masuk', '2024-06-27 12:28:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2813, 1, 42, 0, '2024-06-27', 10000, 'Masuk', 'tabungan masuk', '2024-06-27 12:28:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2814, 1, 137, 0, '2024-06-27', 20000, 'Masuk', 'tabungan masuk', '2024-06-27 13:06:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2815, 1, 6, 0, '2024-06-27', 10000, 'Masuk', 'tabungan masuk', '2024-06-27 13:06:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2816, 1, 7, 0, '2024-06-27', 20000, 'Masuk', 'tabungan masuk', '2024-06-27 13:07:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2817, 1, 13, 0, '2024-06-27', 120000, 'Masuk', 'tabungan masuk', '2024-06-27 13:07:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2818, 1, 91, 0, '2024-06-27', 20000, 'Masuk', 'tabungan masuk', '2024-06-27 13:08:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2819, 1, 19, 0, '2024-06-27', 40000, 'Masuk', 'tabungan masuk', '2024-06-27 13:08:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2820, 1, 20, 0, '2024-06-27', 20000, 'Masuk', 'tabungan masuk', '2024-06-27 13:09:20');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2821, 1, 107, 0, '2024-06-27', 20000, 'Masuk', 'tabungan masuk', '2024-06-27 13:09:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2822, 1, 119, 0, '2024-06-27', 10000, 'Masuk', 'tabungan masuk', '2024-06-27 13:10:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2823, 1, 108, 0, '2024-06-27', 20000, 'Masuk', 'tabungan masuk', '2024-06-27 13:10:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2824, 1, 61, 0, '2024-06-27', 10000, 'Masuk', 'tabungan masuk', '2024-06-27 13:11:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2825, 1, 18, 0, '2024-06-27', 10000, 'Masuk', 'tabungan masuk', '2024-06-27 13:11:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2826, 1, 17, 0, '2024-06-27', 10000, 'Masuk', 'tabungan masuk', '2024-06-27 13:12:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2827, 1, 16, 0, '2024-06-27', 70000, 'Masuk', 'tabungan masuk', '2024-06-27 13:12:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2828, 1, 158, 0, '2024-06-27', 20000, 'Masuk', 'tabungan masuk', '2024-06-27 13:13:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2829, 1, 127, 0, '2024-06-27', 10000, 'Masuk', 'tabungan masuk', '2024-06-27 13:13:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2830, 1, 12, 0, '2024-06-27', 30000, 'Masuk', 'tabungan masuk', '2024-06-27 13:14:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2831, 1, 10, 0, '2024-06-27', 20000, 'Masuk', 'tabungan masuk', '2024-06-27 13:16:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2832, 1, 57, 0, '2024-06-27', 20000, 'Masuk', 'tabungan masuk', '2024-06-27 13:17:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2833, 1, 58, 0, '2024-06-27', 20000, 'Masuk', 'tabungan masuk', '2024-06-27 13:17:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2834, 1, 64, 0, '2024-06-27', 2000, 'Masuk', 'tabungan masuk', '2024-06-27 13:18:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2835, 1, 177, 0, '2024-06-27', 10000, 'Masuk', 'tabungan masuk', '2024-06-27 15:30:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2836, 1, 135, 0, '2024-06-27', 10000, 'Masuk', 'tabungan masuk', '2024-06-27 15:31:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2837, 1, 98, 0, '2024-06-27', 10000, 'Masuk', 'tabungan masuk', '2024-06-27 15:40:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2838, 1, 95, 0, '2024-06-27', 15000, 'Masuk', 'tabungan masuk', '2024-06-27 15:41:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2839, 1, 120, 0, '2024-06-27', 50000, 'Masuk', 'tabungan masuk', '2024-06-27 15:42:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2840, 1, 138, 0, '2024-06-27', 15000, 'Masuk', 'tabungan masuk', '2024-06-27 15:43:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2841, 1, 9, 0, '2024-06-27', 100000, 'Masuk', 'tabungan masuk', '2024-06-27 15:43:58');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2842, 1, 22, 0, '2024-06-27', 100000, 'Masuk', 'tabungan masuk', '2024-06-27 15:45:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2843, 1, 118, 0, '2024-06-27', 5000, 'Masuk', 'tabungan masuk', '2024-06-27 15:45:56');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2844, 1, 103, 0, '2024-06-27', 5000, 'Masuk', 'tabungan masuk', '2024-06-27 15:46:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2845, 1, 101, 0, '2024-06-27', 100000, 'Masuk', 'tabungan masuk', '2024-06-27 15:46:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2846, 1, 150, 0, '2024-06-27', 50000, 'Masuk', 'tabungan masuk', '2024-06-27 15:47:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2847, 1, 102, 0, '2024-06-27', 10000, 'Masuk', 'tabungan masuk', '2024-06-27 15:47:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2848, 1, 174, 0, '2024-06-27', 40000, 'Masuk', 'tabungan masuk', '2024-06-27 15:49:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2849, 1, 152, 0, '2024-06-27', 50000, 'Masuk', 'tabungan masuk', '2024-06-27 15:49:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2850, 1, 14, 0, '2024-06-27', 30000, 'Masuk', 'tabungan masuk', '2024-06-27 15:50:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2851, 1, 15, 0, '2024-06-27', 30000, 'Masuk', 'tabungan masuk', '2024-06-27 15:50:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2852, 1, 11, 0, '2024-06-27', 100000, 'Masuk', 'tabungan masuk', '2024-06-27 15:51:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2853, 1, 116, 0, '2024-06-27', 75000, 'Masuk', 'tabungan masuk', '2024-06-27 15:51:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2854, 1, 38, 0, '2024-06-27', 10000, 'Masuk', 'tabungan masuk', '2024-06-27 15:52:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2855, 1, 54, 0, '2024-06-27', 30000, 'Masuk', 'tabungan masuk', '2024-06-27 15:52:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2856, 1, 133, 0, '2024-06-27', 100000, 'Masuk', 'tabungan masuk', '2024-06-27 15:53:23');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2857, 1, 117, 0, '2024-06-27', 50000, 'Masuk', 'tabungan masuk', '2024-06-27 15:53:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2858, 1, 69, 0, '2024-06-27', 10000, 'Masuk', 'tabungan masuk', '2024-06-27 15:54:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2859, 1, 24, 0, '2024-06-27', 10000, 'Masuk', 'tabungan masuk', '2024-06-27 15:54:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2860, 1, 41, 0, '2024-06-27', 2000, 'Masuk', 'tabungan masuk', '2024-06-27 15:55:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2861, 1, 31, 0, '2024-06-27', 50000, 'Masuk', 'tabungan masuk', '2024-06-27 15:56:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2862, 1, 32, 0, '2024-06-27', 10000, 'Masuk', 'tabungan masuk', '2024-06-27 15:56:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2863, 1, 163, 0, '2024-06-27', 10000, 'Masuk', 'tabungan masuk', '2024-06-27 15:57:21');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2864, 1, 39, 0, '2024-06-27', 30000, 'Masuk', 'tabungan masuk', '2024-06-27 15:57:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2865, 1, 29, 0, '2024-06-27', 5000, 'Masuk', 'tabungan masuk', '2024-06-27 15:58:20');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2866, 1, 176, 0, '2024-06-27', 50000, 'Masuk', 'tabungan masuk', '2024-06-27 15:58:56');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2867, 1, 26, 0, '2024-06-27', 50000, 'Masuk', 'tabungan masuk', '2024-06-27 15:59:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2868, 1, 28, 0, '2024-06-27', 30000, 'Masuk', 'tabungan masuk', '2024-06-27 15:59:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2869, 1, 37, 0, '2024-06-27', 10000, 'Masuk', 'tabungan masuk', '2024-06-27 16:00:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2870, 1, 113, 0, '2024-06-27', 35000, 'Masuk', 'tabungan masuk', '2024-06-27 16:00:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2871, 1, 30, 0, '2024-06-27', 20000, 'Masuk', 'tabungan masuk', '2024-06-27 16:01:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2872, 1, 112, 0, '2024-06-27', 10000, 'Masuk', 'tabungan masuk', '2024-06-27 16:01:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2873, 1, 25, 0, '2024-06-27', 90000, 'Masuk', 'tabungan masuk', '2024-06-27 16:02:20');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2874, 1, 48, 0, '2024-06-27', 10000, 'Masuk', 'tabungan masuk', '2024-06-27 16:03:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2875, 1, 27, 0, '2024-06-27', 30000, 'Masuk', 'tabungan masuk', '2024-06-27 16:03:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2876, 1, 162, 0, '2024-06-27', 10000, 'Masuk', 'tabungan masuk', '2024-06-27 16:03:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2877, 1, 116, 0, '2024-06-28', 75000, 'Masuk', 'tabungan masuk', '2024-06-28 17:27:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2878, 1, 151, 0, '2024-06-28', 10000, 'Masuk', 'tabungan masuk', '2024-06-28 17:27:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2879, 1, 40, 0, '2024-06-28', 20000, 'Masuk', 'tabungan masuk', '2024-06-28 17:28:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2880, 1, 70, 0, '2024-06-28', 30000, 'Masuk', 'tabungan masuk', '2024-06-28 17:28:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2881, 1, 132, 0, '2024-06-28', 50000, 'Masuk', 'tabungan masuk', '2024-06-28 17:29:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2882, 1, 111, 0, '2024-06-28', 300000, 'Keluar', 'tabungan keluar', '2024-06-28 17:30:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2883, 1, 167, 0, '2024-06-28', 650000, 'Keluar', 'tabungan keluar', '2024-06-28 17:33:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2884, 1, 106, 0, '2024-06-28', 700000, 'Keluar', 'tabungan keluar', '2024-06-28 17:34:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2885, 1, 21, 0, '2024-06-28', 2700000, 'Keluar', 'tabungan keluar', '2024-06-28 17:35:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2886, 1, 45, 0, '2024-06-28', 10000, 'Masuk', 'tabungan masuk', '2024-06-28 17:38:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2887, 1, 33, 0, '2024-06-28', 10000, 'Masuk', 'tabungan masuk', '2024-06-28 17:39:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2888, 1, 23, 0, '2024-06-28', 20000, 'Masuk', 'tabungan masuk', '2024-06-28 17:39:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2889, 1, 48, 0, '2024-06-28', 10000, 'Masuk', 'tabungan masuk', '2024-06-28 17:40:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2890, 1, 46, 0, '2024-06-28', 10000, 'Masuk', 'tabungan masuk', '2024-06-28 17:40:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2891, 1, 47, 0, '2024-06-28', 50000, 'Masuk', 'tabungan masuk', '2024-06-28 17:41:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2892, 1, 36, 0, '2024-06-28', 20000, 'Masuk', 'tabungan masuk', '2024-06-28 17:41:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2893, 1, 38, 0, '2024-06-28', 10000, 'Masuk', 'tabungan masuk', '2024-06-28 17:42:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2894, 1, 25, 0, '2024-06-28', 50000, 'Masuk', 'tabungan masuk', '2024-06-28 17:42:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2895, 1, 113, 0, '2024-06-28', 50000, 'Masuk', 'tabungan masuk', '2024-06-28 17:43:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2896, 1, 112, 0, '2024-06-28', 10000, 'Masuk', 'tabungan masuk', '2024-06-28 17:43:26');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2897, 1, 30, 0, '2024-06-28', 20000, 'Masuk', 'tabungan masuk', '2024-06-28 17:44:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2898, 1, 37, 0, '2024-06-28', 10000, 'Masuk', 'tabungan masuk', '2024-06-28 17:44:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2899, 1, 28, 0, '2024-06-28', 30000, 'Masuk', 'tabungan masuk', '2024-06-28 17:44:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2900, 1, 176, 0, '2024-06-28', 50000, 'Masuk', 'tabungan masuk', '2024-06-28 18:17:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2901, 1, 26, 0, '2024-06-28', 50000, 'Masuk', 'tabungan masuk', '2024-06-28 18:17:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2902, 1, 29, 0, '2024-06-28', 5000, 'Masuk', 'tabungan masuk', '2024-06-28 18:18:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2903, 1, 39, 0, '2024-06-28', 30000, 'Masuk', 'tabungan masuk', '2024-06-28 18:19:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2904, 1, 163, 0, '2024-06-28', 10000, 'Masuk', 'tabungan masuk', '2024-06-28 18:19:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2905, 1, 31, 0, '2024-06-28', 50000, 'Masuk', 'tabungan masuk', '2024-06-28 18:20:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2906, 1, 32, 0, '2024-06-28', 10000, 'Masuk', 'tabungan masuk', '2024-06-28 18:20:20');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2907, 1, 117, 0, '2024-06-28', 50000, 'Masuk', 'tabungan masuk', '2024-06-28 18:20:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2908, 1, 133, 0, '2024-06-28', 100000, 'Masuk', 'tabungan masuk', '2024-06-28 18:21:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2909, 1, 54, 0, '2024-06-28', 30000, 'Masuk', 'tabungan masuk', '2024-06-28 18:21:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2910, 1, 18, 0, '2024-06-28', 10000, 'Masuk', 'tabungan masuk', '2024-06-28 18:22:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2911, 1, 17, 0, '2024-06-28', 10000, 'Masuk', 'tabungan masuk', '2024-06-28 18:22:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2912, 1, 16, 0, '2024-06-28', 70000, 'Masuk', 'tabungan masuk', '2024-06-28 18:23:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2913, 1, 158, 0, '2024-06-28', 20000, 'Masuk', 'tabungan masuk', '2024-06-28 18:23:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2914, 1, 12, 0, '2024-06-28', 30000, 'Masuk', 'tabungan masuk', '2024-06-28 18:24:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2915, 1, 123, 0, '2024-06-28', 10000, 'Masuk', 'tabungan masuk', '2024-06-28 18:24:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2916, 1, 123, 0, '2024-06-28', 270000, 'Masuk', 'tabungan masuk sd 27/6/24', '2024-06-28 18:36:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2917, 1, 57, 0, '2024-06-28', 20000, 'Masuk', 'tabungan masuk', '2024-06-28 18:37:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2918, 1, 58, 0, '2024-06-28', 20000, 'Masuk', 'tabungan masuk', '2024-06-28 18:37:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2919, 1, 64, 0, '2024-06-28', 4000, 'Masuk', 'tabungan masuk', '2024-06-28 18:37:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2920, 1, 149, 0, '2024-06-28', 5000, 'Masuk', 'tabungan masuk', '2024-06-28 18:38:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2921, 1, 177, 0, '2024-06-28', 10000, 'Masuk', 'tabungan masuk', '2024-06-28 18:40:01');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2922, 1, 135, 0, '2024-06-28', 10000, 'Masuk', 'tabungan masuk', '2024-06-28 18:40:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2923, 1, 120, 0, '2024-06-28', 50000, 'Masuk', 'tabungan masuk', '2024-06-28 18:40:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2924, 1, 9, 0, '2024-06-28', 20000, 'Masuk', 'tabungan masuk', '2024-06-28 18:41:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2925, 1, 138, 0, '2024-06-28', 15000, 'Masuk', 'tabungan masuk', '2024-06-28 18:41:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2926, 1, 99, 0, '2024-06-28', 100000, 'Masuk', 'tabungan masuk', '2024-06-28 18:42:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2927, 1, 103, 0, '2024-06-28', 5000, 'Masuk', 'tabungan masuk', '2024-06-28 18:42:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2928, 1, 118, 0, '2024-06-28', 5000, 'Masuk', 'tabungan masuk', '2024-06-28 18:43:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2929, 1, 101, 0, '2024-06-28', 100000, 'Masuk', 'tabungan masuk', '2024-06-28 18:43:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2930, 1, 150, 0, '2024-06-28', 50000, 'Masuk', 'tabungan masuk', '2024-06-28 18:43:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2931, 1, 102, 0, '2024-06-28', 10000, 'Masuk', 'tabungan masuk', '2024-06-28 18:44:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2932, 1, 13, 0, '2024-06-28', 130000, 'Masuk', 'tabungan masuk', '2024-06-28 18:44:58');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2933, 1, 14, 0, '2024-06-28', 30000, 'Masuk', 'tabungan masuk', '2024-06-28 18:45:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2934, 1, 15, 0, '2024-06-28', 30000, 'Masuk', 'tabungan masuk', '2024-06-28 18:45:56');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2935, 1, 11, 0, '2024-06-28', 100000, 'Masuk', 'tabungan masuk', '2024-06-28 18:46:21');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2936, 1, 88, 0, '2024-06-28', 10000, 'Masuk', 'tabungan masuk', '2024-06-28 18:46:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2937, 1, 61, 0, '2024-06-28', 10000, 'Masuk', 'tabungan masuk', '2024-06-28 18:47:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2938, 1, 60, 0, '2024-06-28', 20000, 'Masuk', 'tabungan masuk', '2024-06-28 18:47:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2939, 1, 107, 0, '2024-06-28', 20000, 'Masuk', 'tabungan masuk', '2024-06-28 18:48:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2940, 1, 119, 0, '2024-06-28', 10000, 'Masuk', 'tabungan masuk', '2024-06-28 18:48:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2941, 1, 108, 0, '2024-06-28', 20000, 'Masuk', 'tabungan masuk', '2024-06-28 18:49:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2942, 1, 92, 0, '2024-06-28', 20000, 'Masuk', 'tabungan masuk', '2024-06-28 18:49:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2943, 1, 20, 0, '2024-06-28', 20000, 'Masuk', 'tabungan masuk', '2024-06-28 18:50:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2944, 1, 111, 0, '2024-06-28', 50000, 'Masuk', 'tabungan masuk', '2024-06-28 18:50:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2945, 1, 91, 0, '2024-06-28', 20000, 'Masuk', 'tabungan masuk', '2024-06-28 18:51:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2946, 1, 125, 0, '2024-06-28', 20000, 'Masuk', 'tabungan masuk', '2024-06-28 18:51:37');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2947, 1, 126, 0, '2024-06-28', 10000, 'Masuk', 'tabungan masuk', '2024-06-28 18:51:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2948, 1, 6, 0, '2024-06-28', 10000, 'Masuk', 'tabungan masuk', '2024-06-28 18:52:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2949, 1, 7, 0, '2024-06-28', 20000, 'Masuk', 'tabungan masuk', '2024-06-28 18:53:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2950, 1, 124, 0, '2024-06-28', 100000, 'Masuk', 'tabungan masuk', '2024-06-28 18:53:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2951, 1, 137, 0, '2024-06-28', 20000, 'Masuk', 'tabungan masuk', '2024-06-28 18:54:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2952, 1, 42, 0, '2024-06-28', 10000, 'Masuk', 'tabungan masuk', '2024-06-28 18:54:52');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2953, 1, 129, 0, '2024-06-28', 50000, 'Masuk', 'tabungan masuk', '2024-06-28 18:55:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2954, 1, 130, 0, '2024-06-28', 10000, 'Masuk', 'tabungan masuk', '2024-06-28 18:55:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2955, 1, 40, 0, '2024-06-29', 20000, 'Masuk', 'tabungan masuk', '2024-06-29 20:01:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2956, 1, 134, 0, '2024-06-29', 10000, 'Masuk', 'tabungan masuk', '2024-06-29 20:02:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2957, 1, 54, 0, '2024-06-29', 100000, 'Keluar', 'tabungan keluar', '2024-06-29 20:03:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2958, 1, 65, 0, '2024-06-29', 13000000, 'Keluar', 'tabungan keluar', '2024-06-29 20:10:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2959, 1, 42, 0, '2024-06-29', 10000, 'Masuk', 'tabungan masuk', '2024-06-29 20:12:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2960, 1, 137, 0, '2024-06-29', 20000, 'Masuk', 'tabungan masuk', '2024-06-29 20:12:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2961, 1, 124, 0, '2024-06-29', 100000, 'Masuk', 'tabungan masuk', '2024-06-29 20:13:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2962, 1, 126, 0, '2024-06-29', 10000, 'Masuk', 'tabungan masuk', '2024-06-29 20:13:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2963, 1, 125, 0, '2024-06-29', 10000, 'Masuk', 'tabungan masuk', '2024-06-29 20:14:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2964, 1, 133, 0, '2024-06-29', 100000, 'Masuk', 'tabungan masuk', '2024-06-29 20:14:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2965, 1, 176, 0, '2024-06-29', 50000, 'Masuk', 'tabungan masuk', '2024-06-29 20:15:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2966, 1, 26, 0, '2024-06-29', 50000, 'Masuk', 'tabungan masuk', '2024-06-29 20:15:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2967, 1, 139, 0, '2024-06-29', 100000, 'Masuk', 'tabungan masuk', '2024-06-29 20:16:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2968, 1, 19, 0, '2024-06-29', 20000, 'Masuk', 'tabungan masuk', '2024-06-29 20:16:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2969, 1, 20, 0, '2024-06-29', 20000, 'Masuk', 'tabungan masuk', '2024-06-29 20:17:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2970, 1, 91, 0, '2024-06-29', 20000, 'Masuk', 'tabungan masuk', '2024-06-29 20:17:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2971, 1, 111, 0, '2024-06-29', 50000, 'Masuk', 'tabungan masuk', '2024-06-29 20:18:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2972, 1, 101, 0, '2024-06-29', 100000, 'Masuk', 'tabungan masuk', '2024-06-29 20:18:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2973, 1, 150, 0, '2024-06-29', 50000, 'Masuk', 'tabungan masuk', '2024-06-29 20:19:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2974, 1, 118, 0, '2024-06-29', 5000, 'Masuk', 'tabungan masuk', '2024-06-30 05:06:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2975, 1, 103, 0, '2024-06-29', 5000, 'Masuk', 'tabungan masuk', '2024-06-30 05:06:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2976, 1, 102, 0, '2024-06-29', 10000, 'Masuk', 'tabungan masuk', '2024-06-30 05:07:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2977, 1, 22, 0, '2024-06-29', 200000, 'Masuk', 'tabungan masuk', '2024-06-30 05:08:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2978, 1, 21, 0, '2024-06-29', 100000, 'Masuk', 'tabungan masuk', '2024-06-30 05:08:40');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2979, 1, 157, 0, '2024-06-29', 20000, 'Masuk', 'tabungan masuk', '2024-06-30 05:09:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2980, 1, 9, 0, '2024-06-29', 20000, 'Masuk', 'tabungan masuk', '2024-06-30 05:09:33');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2981, 1, 119, 0, '2024-06-29', 10000, 'Masuk', 'tabungan masuk', '2024-06-30 05:10:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2982, 1, 108, 0, '2024-06-29', 20000, 'Masuk', 'tabungan masuk', '2024-06-30 05:10:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2983, 1, 107, 0, '2024-06-29', 20000, 'Masuk', 'tabungan masuk', '2024-06-30 05:11:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2984, 1, 6, 0, '2024-06-29', 10000, 'Masuk', 'tabungan masuk', '2024-06-30 05:11:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2985, 1, 7, 0, '2024-06-29', 50000, 'Masuk', 'tabungan masuk', '2024-06-30 05:12:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2986, 1, 61, 0, '2024-06-29', 10000, 'Masuk', 'tabungan masuk', '2024-06-30 05:12:50');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2987, 1, 55, 0, '2024-06-29', 10000, 'Masuk', 'tabungan masuk', '2024-06-30 05:13:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2988, 1, 56, 0, '2024-06-29', 2000, 'Masuk', 'tabungan masuk', '2024-06-30 05:13:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2989, 1, 58, 0, '2024-06-29', 20000, 'Masuk', 'tabungan masuk', '2024-06-30 05:14:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2990, 1, 64, 0, '2024-06-29', 2000, 'Masuk', 'tabungan masuk', '2024-06-30 05:14:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2991, 1, 57, 0, '2024-06-29', 20000, 'Masuk', 'tabungan masuk', '2024-06-30 05:15:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2992, 1, 148, 0, '2024-06-29', 5000, 'Masuk', 'tabungan masuk', '2024-06-30 05:15:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2993, 1, 177, 0, '2024-06-29', 10000, 'Masuk', 'tabungan masuk', '2024-06-30 05:16:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2994, 1, 13, 0, '2024-06-29', 200000, 'Masuk', 'tabungan masuk', '2024-06-30 05:16:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2995, 1, 120, 0, '2024-06-29', 50000, 'Masuk', 'tabungan masuk', '2024-06-30 05:17:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2996, 1, 14, 0, '2024-06-29', 30000, 'Masuk', 'tabungan masuk', '2024-06-30 05:17:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2997, 1, 15, 0, '2024-06-29', 20000, 'Masuk', 'tabungan masuk', '2024-06-30 05:18:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2998, 1, 11, 0, '2024-06-29', 100000, 'Masuk', 'tabungan masuk', '2024-06-30 05:18:43');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (2999, 1, 54, 0, '2024-06-29', 30000, 'Masuk', 'tabungan masuk', '2024-06-30 05:19:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3000, 1, 38, 0, '2024-06-29', 10000, 'Masuk', 'tabungan masuk', '2024-06-30 05:19:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3001, 1, 88, 0, '2024-06-29', 10000, 'Masuk', 'tabungan masuk', '2024-06-30 05:19:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3002, 1, 117, 0, '2024-06-29', 50000, 'Masuk', 'tabungan masuk', '2024-06-30 05:20:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3003, 1, 53, 0, '2024-06-29', 10000, 'Masuk', 'tabungan masuk', '2024-06-30 05:21:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3004, 1, 69, 0, '2024-06-29', 20000, 'Masuk', 'tabungan masuk', '2024-06-30 05:21:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3005, 1, 174, 0, '2024-06-29', 40000, 'Masuk', 'tabungan masuk', '2024-06-30 05:22:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3006, 1, 152, 0, '2024-06-29', 50000, 'Masuk', 'tabungan masuk', '2024-06-30 05:22:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3007, 1, 31, 0, '2024-06-29', 50000, 'Masuk', 'tabungan masuk', '2024-06-30 05:22:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3008, 1, 32, 0, '2024-06-29', 10000, 'Masuk', 'tabungan masuk', '2024-06-30 05:23:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3009, 1, 39, 0, '2024-06-29', 30000, 'Masuk', 'tabungan masuk', '2024-06-30 05:23:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3010, 1, 29, 0, '2024-06-29', 5000, 'Masuk', 'tabungan masuk', '2024-06-30 05:24:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3011, 1, 28, 0, '2024-06-29', 30000, 'Masuk', 'tabungan masuk', '2024-06-30 05:24:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3012, 1, 37, 0, '2024-06-29', 10000, 'Masuk', 'tabungan masuk', '2024-06-30 05:25:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3013, 1, 113, 0, '2024-06-29', 50000, 'Masuk', 'tabungan masuk', '2024-06-30 05:25:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3014, 1, 30, 0, '2024-06-29', 20000, 'Masuk', 'tabungan masuk', '2024-06-30 05:27:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3015, 1, 25, 0, '2024-06-29', 50000, 'Masuk', 'tabungan masuk', '2024-06-30 05:28:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3016, 1, 162, 0, '2024-06-29', 10000, 'Masuk', 'tabungan masuk', '2024-06-30 05:28:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3017, 1, 27, 0, '2024-06-29', 30000, 'Masuk', 'tabungan masuk', '2024-06-30 05:29:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3018, 1, 36, 0, '2024-06-29', 20000, 'Masuk', 'tabungan masuk', '2024-06-30 05:30:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3019, 1, 47, 0, '2024-06-29', 50000, 'Masuk', 'tabungan masuk', '2024-06-30 05:30:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3020, 1, 46, 0, '2024-06-29', 10000, 'Masuk', 'tabungan masuk', '2024-06-30 05:31:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3021, 1, 23, 0, '2024-06-29', 20000, 'Masuk', 'tabungan masuk', '2024-06-30 05:31:28');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3022, 1, 45, 0, '2024-06-29', 5000, 'Masuk', 'tabungan masuk', '2024-06-30 05:31:57');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3023, 1, 70, 0, '2024-06-29', 30000, 'Masuk', 'tabungan masuk', '2024-06-30 12:45:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3024, 1, 151, 0, '2024-06-29', 10000, 'Masuk', 'tabungan masuk', '2024-06-30 12:46:24');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3025, 1, 68, 0, '2024-06-30', 2000000, 'Keluar', 'tabungan keluar', '2024-06-30 12:47:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3026, 1, 162, 0, '2024-06-30', 100000, 'Keluar', 'tabungan keluar', '2024-06-30 12:47:30');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3027, 1, 40, 0, '2024-06-30', 20000, 'Masuk', 'tabungan masuk', '2024-06-30 12:47:59');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3028, 1, 70, 0, '2024-06-30', 30000, 'Masuk', 'tabungan masuk', '2024-06-30 12:48:23');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3029, 1, 45, 0, '2024-06-30', 5000, 'Masuk', 'tabungan masuk', '2024-06-30 15:40:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3030, 1, 121, 0, '2024-06-30', 10000, 'Masuk', 'tabungan masuk', '2024-06-30 15:41:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3031, 1, 169, 0, '2024-06-30', 960000, 'Masuk', 'tabungan masuk', '2024-06-30 15:41:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3032, 1, 169, 0, '2024-01-06', 440000, 'Masuk', 'tabungan masuk', '2024-06-30 15:48:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3033, 1, 169, 0, '2024-01-13', 730000, 'Masuk', 'tabungan masuk', '2024-06-30 15:49:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3034, 1, 169, 0, '2024-01-12', 1155000, 'Masuk', 'tabungan masuk', '2024-06-30 15:49:56');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3035, 1, 169, 0, '2024-02-29', 700000, 'Masuk', 'tabungan masuk', '2024-06-30 15:51:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3036, 1, 169, 0, '2024-03-24', 1650000, 'Masuk', 'tabungan masuk', '2024-06-30 15:52:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3037, 1, 132, 0, '2024-06-30', 50000, 'Masuk', 'tabungan masuk', '2024-06-30 15:54:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3038, 1, 179, 0, '2024-06-30', 40000, 'Masuk', 'tabungan masuk', '2024-06-30 15:57:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3039, 1, 180, 0, '2024-06-30', 40000, 'Masuk', 'tabungan masuk', '2024-06-30 15:59:43');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3040, 1, 181, 0, '2024-06-30', 110000, 'Masuk', 'tabungan masuk', '2024-06-30 16:02:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3041, 1, 140, 0, '2024-06-30', 700000, 'Masuk', 'tabungan masuk', '2024-06-30 16:02:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3042, 1, 162, 0, '2024-06-30', 20000, 'Masuk', 'tabungan masuk', '2024-06-30 16:04:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3043, 1, 182, 0, '2024-06-30', 400000, 'Masuk', 'tabungan masuk', '2024-06-30 16:08:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3044, 1, 33, 0, '2024-06-30', 10000, 'Masuk', 'tabungan masuk', '2024-06-30 16:09:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3045, 1, 46, 0, '2024-06-30', 10000, 'Masuk', 'tabungan masuk', '2024-06-30 16:10:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3046, 1, 36, 0, '2024-06-30', 10000, 'Masuk', 'tabungan masuk', '2024-06-30 16:10:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3047, 1, 47, 0, '2024-06-30', 50000, 'Masuk', 'tabungan masuk', '2024-06-30 16:11:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3048, 1, 38, 0, '2024-06-30', 10000, 'Masuk', 'tabungan masuk', '2024-06-30 16:12:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3049, 1, 112, 0, '2024-06-30', 10000, 'Masuk', 'tabungan masuk', '2024-06-30 16:12:43');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3050, 1, 37, 0, '2024-06-30', 10000, 'Masuk', 'tabungan masuk', '2024-06-30 16:29:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3051, 1, 28, 0, '2024-06-30', 30000, 'Masuk', 'tabungan masuk', '2024-06-30 16:29:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3052, 1, 176, 0, '2024-06-30', 50000, 'Masuk', 'tabungan masuk', '2024-06-30 16:29:53');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3053, 1, 163, 0, '2024-06-30', 10000, 'Masuk', 'tabungan masuk', '2024-06-30 16:30:26');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3054, 1, 39, 0, '2024-06-30', 30000, 'Masuk', 'tabungan masuk', '2024-06-30 16:31:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3055, 1, 174, 0, '2024-06-30', 20000, 'Masuk', 'tabungan masuk', '2024-06-30 16:32:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3056, 1, 152, 0, '2024-06-30', 50000, 'Masuk', 'tabungan masuk', '2024-06-30 16:32:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3057, 1, 117, 0, '2024-06-30', 50000, 'Masuk', 'tabungan masuk', '2024-06-30 16:33:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3058, 1, 32, 0, '2024-06-30', 10000, 'Masuk', 'tabungan masuk', '2024-06-30 16:33:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3059, 1, 31, 0, '2024-06-30', 50000, 'Masuk', 'tabungan masuk', '2024-06-30 16:34:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3060, 1, 48, 0, '2024-06-30', 20000, 'Masuk', 'tabungan masuk', '2024-06-30 16:34:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3061, 1, 133, 0, '2024-06-30', 100000, 'Masuk', 'tabungan masuk', '2024-06-30 16:37:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3062, 1, 54, 0, '2024-06-30', 30000, 'Masuk', 'tabungan masuk', '2024-06-30 16:37:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3063, 1, 88, 0, '2024-06-30', 10000, 'Masuk', 'tabungan masuk', '2024-06-30 16:38:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3064, 1, 90, 0, '2024-06-30', 70000, 'Masuk', 'tabungan masuk', '2024-06-30 16:38:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3065, 1, 95, 0, '2024-06-30', 10000, 'Masuk', 'tabungan masuk', '2024-06-30 16:39:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3066, 1, 98, 0, '2024-06-30', 10000, 'Masuk', 'tabungan masuk', '2024-06-30 16:39:47');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3067, 1, 177, 0, '2024-06-30', 10000, 'Masuk', 'tabungan masuk', '2024-06-30 16:40:17');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3068, 1, 148, 0, '2024-06-30', 5000, 'Masuk', 'tabungan masuk', '2024-06-30 16:40:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3069, 1, 149, 0, '2024-06-30', 5000, 'Masuk', 'tabungan masuk', '2024-06-30 16:41:08');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3070, 1, 58, 0, '2024-06-30', 20000, 'Masuk', 'tabungan masuk', '2024-06-30 16:43:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3071, 1, 64, 0, '2024-06-30', 2000, 'Masuk', 'tabungan masuk', '2024-06-30 16:43:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3072, 1, 57, 0, '2024-06-30', 20000, 'Masuk', 'tabungan masuk', '2024-06-30 16:44:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3073, 1, 127, 0, '2024-06-30', 10000, 'Masuk', 'tabungan masuk', '2024-06-30 16:50:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3074, 1, 158, 0, '2024-06-30', 20000, 'Masuk', 'tabungan masuk', '2024-06-30 16:51:26');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3075, 1, 61, 0, '2024-06-30', 10000, 'Masuk', 'tabungan masuk', '2024-06-30 16:51:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3076, 1, 107, 0, '2024-06-30', 20000, 'Masuk', 'tabungan masuk', '2024-06-30 16:52:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3077, 1, 108, 0, '2024-06-30', 20000, 'Masuk', 'tabungan masuk', '2024-06-30 16:52:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3078, 1, 119, 0, '2024-06-30', 10000, 'Masuk', 'tabungan masuk', '2024-06-30 16:53:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3079, 1, 92, 0, '2024-06-30', 20000, 'Masuk', 'tabungan masuk', '2024-06-30 16:53:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3080, 1, 20, 0, '2024-06-30', 20000, 'Masuk', 'tabungan masuk', '2024-06-30 16:55:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3081, 1, 19, 0, '2024-06-30', 20000, 'Masuk', 'tabungan masuk', '2024-06-30 16:55:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3082, 1, 111, 0, '2024-06-30', 50000, 'Masuk', 'tabungan masuk', '2024-06-30 16:56:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3083, 1, 106, 0, '2024-06-30', 80000, 'Masuk', 'tabungan masuk', '2024-06-30 16:56:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3084, 1, 131, 0, '2024-06-30', 10000, 'Masuk', 'tabungan masuk', '2024-06-30 16:57:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3085, 1, 106, 0, '2024-06-28', 30000, 'Masuk', 'tabungan masuk', '2024-06-30 16:59:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3086, 1, 91, 0, '2024-06-30', 20000, 'Masuk', 'tabungan masuk', '2024-06-30 17:00:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3087, 1, 11, 0, '2024-06-30', 100000, 'Masuk', 'tabungan masuk', '2024-06-30 17:01:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3088, 1, 14, 0, '2024-06-30', 30000, 'Masuk', 'tabungan masuk', '2024-06-30 17:02:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3089, 1, 15, 0, '2024-06-30', 30000, 'Masuk', 'tabungan masuk', '2024-06-30 17:02:52');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3090, 1, 59, 0, '2024-06-30', 10000, 'Masuk', 'tabungan masuk', '2024-06-30 17:03:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3091, 1, 124, 0, '2024-06-30', 100000, 'Masuk', 'tabungan masuk', '2024-06-30 17:03:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3092, 1, 7, 0, '2024-06-30', 40000, 'Masuk', 'tabungan masuk', '2024-06-30 17:04:13');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3093, 1, 6, 0, '2024-06-30', 10000, 'Masuk', 'tabungan masuk', '2024-06-30 17:04:35');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3094, 1, 42, 0, '2024-06-30', 10000, 'Masuk', 'tabungan masuk', '2024-06-30 17:05:04');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3095, 1, 129, 0, '2024-06-30', 50000, 'Masuk', 'tabungan masuk', '2024-06-30 17:05:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3096, 1, 134, 0, '2024-07-01', 15000, 'Masuk', 'tabungan masuk', '2024-07-01 12:36:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3097, 1, 183, 0, '2024-07-01', 130000, 'Masuk', 'tabungan masuk', '2024-07-01 12:38:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3098, 1, 151, 0, '2024-07-01', 10000, 'Masuk', 'tabungan masuk', '2024-07-01 12:38:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3099, 1, 40, 0, '2024-07-01', 20000, 'Masuk', 'tabungan masuk', '2024-07-01 12:39:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3100, 1, 70, 0, '2024-07-01', 30000, 'Masuk', 'tabungan masuk', '2024-07-01 12:40:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3101, 1, 116, 0, '2024-07-01', 650000, 'Masuk', 'tabungan masuk', '2024-07-01 12:41:32');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3102, 1, 127, 0, '2024-07-01', 10000, 'Masuk', 'tabungan masuk', '2024-07-01 12:42:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3103, 1, 7, 0, '2024-07-01', 50000, 'Masuk', 'tabungan masuk', '2024-07-01 12:42:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3104, 1, 6, 0, '2024-07-01', 10000, 'Masuk', 'tabungan masuk', '2024-07-01 12:43:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3105, 1, 121, 0, '2024-07-01', 20000, 'Masuk', 'tabungan masuk', '2024-07-01 15:38:42');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3106, 1, 33, 0, '2024-07-01', 10000, 'Masuk', 'tabungan masuk', '2024-07-01 15:39:38');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3107, 1, 23, 0, '2024-07-01', 20000, 'Masuk', 'tabungan masuk', '2024-07-01 15:40:20');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3108, 1, 46, 0, '2024-07-01', 10000, 'Masuk', 'tabungan masuk', '2024-07-01 15:41:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3109, 1, 47, 0, '2024-07-01', 50000, 'Masuk', 'tabungan masuk', '2024-07-01 15:42:14');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3110, 1, 36, 0, '2024-07-01', 20000, 'Masuk', 'tabungan masuk', '2024-07-01 15:43:55');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3111, 1, 162, 0, '2024-07-01', 10000, 'Masuk', 'tabungan masuk', '2024-07-01 15:44:34');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3112, 1, 145, 0, '2024-07-01', 20000, 'Masuk', 'tabungan masuk', '2024-07-01 15:45:06');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3113, 1, 115, 0, '2024-07-01', 500000, 'Masuk', 'tabungan masuk', '2024-07-01 15:45:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3114, 1, 114, 0, '2024-07-01', 5000, 'Masuk', 'tabungan masuk', '2024-07-01 15:46:12');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3115, 1, 136, 0, '2024-07-01', 230000, 'Masuk', 'tabungan masuk', '2024-07-01 15:46:41');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3116, 1, 30, 0, '2024-07-01', 20000, 'Masuk', 'tabungan masuk', '2024-07-01 15:47:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3117, 1, 113, 0, '2024-07-01', 50000, 'Masuk', 'tabungan masuk', '2024-07-01 15:47:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3118, 1, 37, 0, '2024-07-01', 10000, 'Masuk', 'tabungan masuk', '2024-07-01 15:48:05');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3119, 1, 38, 0, '2024-07-01', 10000, 'Masuk', 'tabungan masuk', '2024-07-01 15:49:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3120, 1, 39, 0, '2024-07-01', 20000, 'Masuk', 'tabungan masuk', '2024-07-01 15:53:27');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3121, 1, 163, 0, '2024-07-01', 10000, 'Masuk', 'tabungan masuk', '2024-07-01 15:53:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3122, 1, 32, 0, '2024-07-01', 10000, 'Masuk', 'tabungan masuk', '2024-07-01 15:54:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3123, 1, 31, 0, '2024-07-01', 50000, 'Masuk', 'tabungan masuk', '2024-07-01 15:54:46');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3124, 1, 41, 0, '2024-07-01', 2000, 'Masuk', 'tabungan masuk', '2024-07-01 15:55:09');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3125, 1, 24, 0, '2024-07-01', 10000, 'Masuk', 'tabungan masuk', '2024-07-01 15:55:44');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3126, 1, 69, 0, '2024-07-01', 20000, 'Masuk', 'tabungan masuk', '2024-07-01 15:56:15');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3127, 1, 53, 0, '2024-07-01', 10000, 'Masuk', 'tabungan masuk', '2024-07-01 15:56:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3128, 1, 117, 0, '2024-07-01', 50000, 'Masuk', 'tabungan masuk', '2024-07-01 15:57:03');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3129, 1, 54, 0, '2024-07-01', 30000, 'Masuk', 'tabungan masuk', '2024-07-01 15:58:22');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3130, 1, 11, 0, '2024-07-01', 100000, 'Masuk', 'tabungan masuk', '2024-07-01 15:58:51');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3131, 1, 15, 0, '2024-07-01', 20000, 'Masuk', 'tabungan masuk', '2024-07-01 15:59:21');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3132, 1, 14, 0, '2024-07-01', 30000, 'Masuk', 'tabungan masuk', '2024-07-01 15:59:49');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3133, 1, 21, 0, '2024-07-01', 200000, 'Masuk', 'tabungan masuk', '2024-07-01 16:00:18');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3134, 1, 157, 0, '2024-07-01', 10000, 'Masuk', 'tabungan masuk', '2024-07-01 16:00:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3135, 1, 129, 0, '2024-07-01', 50000, 'Masuk', 'tabungan masuk', '2024-07-01 16:01:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3136, 1, 130, 0, '2024-07-01', 10000, 'Masuk', 'tabungan masuk', '2024-07-01 16:01:31');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3137, 1, 42, 0, '2024-07-01', 10000, 'Masuk', 'tabungan masuk', '2024-07-01 16:02:00');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3138, 1, 126, 0, '2024-07-01', 10000, 'Masuk', 'tabungan masuk', '2024-07-01 16:02:39');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3139, 1, 125, 0, '2024-07-01', 20000, 'Masuk', 'tabungan masuk', '2024-07-01 16:13:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3140, 1, 137, 0, '2024-07-01', 40000, 'Masuk', 'tabungan masuk', '2024-07-01 16:14:21');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3141, 1, 133, 0, '2024-07-01', 100000, 'Masuk', 'tabungan masuk', '2024-07-01 16:14:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3142, 1, 59, 0, '2024-07-01', 10000, 'Masuk', 'tabungan masuk', '2024-07-01 16:15:20');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3143, 1, 111, 0, '2024-07-01', 50000, 'Masuk', 'tabungan masuk', '2024-07-01 16:15:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3144, 1, 92, 0, '2024-07-01', 20000, 'Masuk', 'tabungan masuk', '2024-07-01 16:16:10');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3145, 1, 119, 0, '2024-07-01', 10000, 'Masuk', 'tabungan masuk', '2024-07-01 16:16:36');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3146, 1, 107, 0, '2024-07-01', 20000, 'Masuk', 'tabungan masuk', '2024-07-01 16:17:02');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3147, 1, 108, 0, '2024-07-01', 20000, 'Masuk', 'tabungan masuk', '2024-07-01 16:17:29');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3148, 1, 60, 0, '2024-07-01', 20000, 'Masuk', 'tabungan masuk', '2024-07-01 16:17:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3149, 1, 61, 0, '2024-07-01', 10000, 'Masuk', 'tabungan masuk', '2024-07-01 16:18:19');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3150, 1, 158, 0, '2024-07-01', 20000, 'Masuk', 'tabungan masuk', '2024-07-01 16:18:52');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3151, 1, 12, 0, '2024-07-01', 60000, 'Masuk', 'tabungan masuk', '2024-07-01 16:19:25');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3152, 1, 57, 0, '2024-07-01', 20000, 'Masuk', 'tabungan masuk', '2024-07-01 16:19:56');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3153, 1, 64, 0, '2024-07-01', 2000, 'Masuk', 'tabungan masuk', '2024-07-01 16:20:21');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3154, 1, 58, 0, '2024-07-01', 20000, 'Masuk', 'tabungan masuk', '2024-07-01 16:20:45');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3155, 1, 55, 0, '2024-07-01', 10000, 'Masuk', 'tabungan masuk', '2024-07-01 16:21:23');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3156, 1, 56, 0, '2024-07-01', 2000, 'Masuk', 'tabungan masuk', '2024-07-01 16:21:48');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3157, 1, 43, 0, '2024-07-01', 10000, 'Masuk', 'tabungan masuk', '2024-07-01 16:22:11');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3158, 1, 149, 0, '2024-07-01', 5000, 'Masuk', 'tabungan masuk', '2024-07-01 16:23:07');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3159, 1, 177, 0, '2024-07-01', 10000, 'Masuk', 'tabungan masuk', '2024-07-01 16:23:54');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, `keterangan`, `terdaftar`) VALUES (3160, 1, 148, 0, '2024-07-01', 5000, 'Masuk', 'tabungan masuk', '2024-07-01 16:24:16');
INSERT INTO `tb_transaksi` (`id`, `idAdmin`, `idNasabah`, `idPotongan`, `tanggal`, `nominal`, `jenis`, 